/*
 * @Author: 阿木
 * @QQ: 65949733@qq.com
 * @Date: 2026-01-08 18:43:19
 * @Version: Auto.Js Pro
 * @Description: 
 * @LastEditors: 阿木
 * @LastEditTime: 2026-01-08 18:43:19
 */
"ui";
importClass(android.content.pm.PackageManager);

ui.layout(
    <vertical margin="10">
        <text id="tirle"/>
        <button id="btn" text="扫描二维码" />
        <ImageView id="qr_img" w="150" h="150" layout_gravity="center_horizontal" scaleType="fitXY" />
        <text id="qr_text"  textSize="21sp" textColor="#000000" padding="10" />
    </vertical>
);
ui.tirle.setText(
    "功能:\n"+
    ".点击二维码区域缩放相机\n"+
    ".支持手电筒使用\n"+
    ".支持自动对焦\n"+
    "扫描间隔为2000ms\n"
    )


ui.btn.click(() => {
    //相机权限检测
    pm = context.getPackageManager();
    permission = (PackageManager.PERMISSION_GRANTED == pm.checkPermission("android.permission.CAMERA", context.getPackageName()));
    if (permission) {
        //权限检测通过
        ExecScriptFile("/sdcard/脚本/扫一扫/res/layout/ScanActivity.js", (text, bmp) => {
            if(text!=null){
                ui.qr_img.setImageBitmap(bmp);
                ui.qr_text.setText(text);
            };
        })
    } else {
        //申请相机权限
        importClass("androidx.core.app.ActivityCompat")
        ActivityCompat.requestPermissions(activity, ["android.permission.CAMERA"], 1);
    }
});

//运行指定脚本,并添加回调
function ExecScriptFile(path, fun) {
    var eng = engines.execScriptFile(path, { path: "./" })
    setTimeout(() => {
        eng.getEngine().emit("say", fun);
    }, 200)
}


