"ui";
/**
 * 从JS源码生成快照文件
 * @param {String} srcPath - JS源码路径
 * @param {String} savePath - 快照文件生成路径
 * 使用方法如下
 * generateSnapshot("path/to/source.js", "path/to/save/snapshot");
 */
function generateSnapshot(srcPath, savePath) {
    try {
        // 获取当前上下文，如果没有则进入新的上下文
        var ctx = Packages.org.mozilla.javascript.Context.getCurrentContext() || Packages.org.mozilla.javascript.Context.enter();

        // 设置优化级别为-1（不进行优化）
        ctx.setOptimizationLevel(-1);
        // 设置语言版本为ES6
        ctx.setLanguageVersion(Packages.org.mozilla.javascript.Context.VERSION_ES6);
        // 设置不生成源代码信息
        ctx.setGeneratingSource(false);

        // 初始化标准对象作用域
        var scope = ctx.initStandardObjects();
        // 编译JS源码
        var compiledScript = ctx.compileString(files.read(srcPath), "js", 1, null);

        // 创建文件输出流
        var fileOutputStream = new java.io.FileOutputStream(savePath);
        // 使用ScriptableOutputStream进行序列化
        var scriptOutputStream = new Packages.org.mozilla.javascript.serialize.ScriptableOutputStream(fileOutputStream, scope);

        // 写入编译后的字符串（即快照）
        scriptOutputStream.writeObject(compiledScript);
        // 关闭文件输出流
        fileOutputStream.close();

        console.log("快照加密成功！");
    } catch (error) {
        console.error("快照加密失败！", error);
    }
}

/**
 * 直接加载快照文件并执行
 * @param {String} snapshotPath - 快照文件路径
 * 用法：
 * executeSnapshot("path/to/snapshot");
 */
function executeSnapshot(snapshotPath) {
    try {
        // 加载Dex文件
        runtime.loadDex("./loader.dex");
        // 使用Loader类加载并执行快照文件
        Packages.Loader.load(snapshotPath)();
    } catch (error) {
        console.error("快照文件运行失败！", error);
    }
}
