"ui";

importClass(android.net.Uri);
importClass(android.content.ContentValues);
importClass(android.provider.Settings);
importClass(android.Manifest);
importClass(android.content.pm.PackageManager);

// UI 布局
ui.layout(
    <vertical padding="16">
        <text text="短信插入测试" textSize="24sp" textStyle="bold" margin="0 0 0 16" textColor="#333333"/>
        
        <text text="手机号码" textSize="14sp" marginTop="8" textColor="#666666"/>
        <input id="phoneNumber" text="15903232555" inputType="phone" singleLine="true" />
        
        <text text="短信内容" textSize="14sp" marginTop="8" textColor="#666666"/>
        <input id="smsBody" text="我收到一条短信" singleLine="false" lines="3" gravity="top|left"/>
        
        <button id="btnInsert" text="测试插入短信" marginTop="24" style="Widget.AppCompat.Button.Colored"/>
        
        <text text="运行日志:" marginTop="24" textSize="14sp" textColor="#666666"/>
        <ScrollView>
            <text id="logView" text="" textSize="12sp" textColor="#333333" />
        </ScrollView>
    </vertical>
);

// 日志追加函数
function appendLog(msg) {
    ui.run(() => {
        let oldText = ui.logView.text();
        let time = new Date().toLocaleTimeString();
        ui.logView.setText("[" + time + "] " + msg + "\n" + oldText);
    });
}

    // 检查并请求写短信权限
function checkAndRequestPermission() {
    if (device.sdkInt >= 23) {
        if (context.checkSelfPermission(Manifest.permission.WRITE_SMS) !== PackageManager.PERMISSION_GRANTED || 
            context.checkSelfPermission(Manifest.permission.READ_SMS) !== PackageManager.PERMISSION_GRANTED) {
            appendLog("缺少短信权限，尝试申请...");
            try {
                runtime.requestPermissions([Manifest.permission.WRITE_SMS, Manifest.permission.READ_SMS]);
                appendLog("已发起权限申请，请在系统弹窗中允许。");
            } catch (e) {
                appendLog("权限申请异常: " + e);
            }
            return false;
        }
    }
    return true;
}

// 检测是否是默认短信应用
function isDefaultSmsApp() {
    if (device.sdkInt >= 19) {
        let defaultSmsPackage = Settings.Secure.getString(context.getContentResolver(), "sms_default_application");
        return defaultSmsPackage === context.getPackageName();
    }
    return true;
}

// 插入短信核心逻辑 (Root提权黑科技方式)
function insertSmsRoot(address, body) {
    let pkg = context.getPackageName();
    
    // 【终极黑科技】：利用 Root 权限强行绕过 Android 的短信安全限制
    // 1. 强制将 Auto.js 的 AppOps (写入短信) 权限设为 allow
    shell("appops set " + pkg + " WRITE_SMS allow", true);
    shell("appops set " + pkg + " READ_SMS allow", true);
    
    // 2. 尝试暴力把 Auto.js 临时设为默认短信应用 (增加在 MIUI 上的成功率)
    let oldSmsAppRes = shell("settings get secure sms_default_application", true);
    let oldSmsApp = oldSmsAppRes.code == 0 ? oldSmsAppRes.result.trim() : "";
    shell("settings put secure sms_default_application " + pkg, true);
    
    // 稍微等待系统底层刷新权限缓存
    sleep(500);

    let values = new ContentValues();
    values.put("address", address);
    values.put("body", body);
    
    let putIntMethod = null;
    let putLongMethod = null;
    let methods = values.getClass().getMethods();
    for (let i = 0; i < methods.length; i++) {
        let m = methods[i];
        if (m.getName() == "put" && m.getParameterTypes().length == 2) {
            let typeName = m.getParameterTypes()[1].getName();
            if (typeName == "java.lang.Integer") {
                putIntMethod = m;
            } else if (typeName == "java.lang.Long") {
                putLongMethod = m;
            }
        }
    }
    
    let now = java.lang.System.currentTimeMillis();
    
    if (putIntMethod) {
        putIntMethod.invoke(values, "type", new java.lang.Integer(1)); // 1 表示收件箱
        putIntMethod.invoke(values, "read", new java.lang.Integer(0));
        putIntMethod.invoke(values, "error_code", new java.lang.Integer(0));
        putIntMethod.invoke(values, "status", new java.lang.Integer(-1));
        putIntMethod.invoke(values, "protocol", new java.lang.Integer(0));
    } else {
        values.put("type", new java.lang.Integer(1)); 
        values.put("read", new java.lang.Integer(0));
    }

    if (putLongMethod) {
        putLongMethod.invoke(values, "date", new java.lang.Long(now));
        putLongMethod.invoke(values, "date_sent", new java.lang.Long(now));
    } else {
        values.put("date", new java.lang.Long(now));
    }

    // 必须首先查询对应的 thread_id (会话ID)，这在 MIUI 极其关键
    let threadId = -1;
    try {
        let ContactsContract_Threads_getOrCreateThreadId = android.provider.Telephony.Threads.getOrCreateThreadId;
        threadId = ContactsContract_Threads_getOrCreateThreadId(context, address);
    } catch(e) { }

    if (threadId != -1 && putIntMethod) {
        putIntMethod.invoke(values, "thread_id", new java.lang.Integer(threadId));
    }

    let resMsg = "";
    try {
        // 回归使用最稳定的 Java 原生插入方式，因为我们现在已经“越权”了
        let uri = Uri.parse("content://sms/inbox");
        let newUri = context.getContentResolver().insert(uri, values);
        
        if (newUri) {
            let uriStr = newUri.toString();
            // 如果 Android 底层依然拦截，会返回一个假 ID（以 /0 结尾）
            if (uriStr.endsWith("/0")) {
                resMsg = "Root提权插入失败：MIUI系统级拦截，返回了假ID (content://sms/inbox/0)。";
            } else {
                resMsg = "Root提权插入成功: " + uriStr + (threadId != -1 ? " (会话ID: " + threadId + ")" : "");
            }
        } else {
            resMsg = "插入失败：API 返回了 null";
        }
    } catch (e) {
        resMsg = "插入异常：" + e;
    }

    // 3. 收尾工作：恢复原本的默认短信应用
    if (oldSmsApp && oldSmsApp !== "null" && oldSmsApp !== pkg) {
        shell("settings put secure sms_default_application " + oldSmsApp, true);
    }
    
    // 4. 强制刷新小米短信的数据缓存
    shell('am broadcast -a android.provider.Telephony.SMS_RECEIVED', true);
    shell('am broadcast -a android.intent.action.PROVIDER_CHANGED -d content://sms', true);
    shell('am force-stop com.android.mms', true);

    return resMsg;
}

// 按钮点击事件
ui.btnInsert.click(() => {
    let phone = ui.phoneNumber.text();
    let body = ui.smsBody.text();
    
    if (!phone || !body) {
        toast("手机号或短信内容不能为空");
        return;
    }

    // 为防止阻塞 UI 主线程，开启新线程执行耗时与可能阻塞的操作
    threads.start(function() {
        appendLog("准备通过Root权限插入短信...");

        // Root方式不需要检查WRITE_SMS和是否默认应用了
        let result = insertSmsRoot(phone, body);
        appendLog(result);
        toastLog(result);
    });
});

// 脚本退出时停止所有子线程
ui.emitter.on("onDestroy", () => {
    threads.shutDownAll();
});
