let {
    ImGui
} = require("./imgui.js");

let showWindow = jArrayB(true);
let showWindow2 = jArrayB(true);
let enableFeature = jArrayB(false);
let enableSound = jArrayB(true);
let enableVibration = jArrayB(false);
let selectedOption = jArrayI(0);
let volume = jArrayF(0.5);
let brightness = jArrayF(0.8);
let color = jArrayF(0.4, 0.7, 1.0) // RGB
let clickCount = 0;


ImGui.ui(() => {
    if (showWindow[0]) {
        if (ImGui.Begin("Autojs ImGui", showWindow)) {
            ImGui.TextColored(0.2, 0.8, 1.0, 1.0, "欢迎使用Autojs ImGui!");
            ImGui.Text("这是一个demo");
            ImGui.Separator();
            ImGui.Spacing();

            // === 按钮区域 ===
            ImGui.TextColored(1.0, 0.8, 0.2, 1.0, "▼ 按钮控件");
            ImGui.Spacing();

            if (ImGui.Button("点击我!", 200.0, 40.0)) {
                clickCount++;
                toastLog("按钮被点击，次数: " + clickCount);
            }

            ImGui.SameLine();
            ImGui.Text("点击次数: " + clickCount);

            ImGui.Spacing();
            ImGui.Separator();
            ImGui.Spacing();

            // === 复选框区域 ===
            ImGui.TextColored(1.0, 0.8, 0.2, 1.0, "▼ 复选框控件");
            ImGui.Spacing();

            if (ImGui.Checkbox("启用功能", enableFeature)) {
                toastLog("功能状态: " + (enableFeature[0] ? "开启" : "关闭"));
            }
            ImGui.SameLine();
            if (ImGui.Checkbox("启用声音", enableSound)) {
                toastLog("声音状态: " + (enableSound[0] ? "开启" : "关闭"));
            }
            ImGui.SameLine();
            if (ImGui.Checkbox("启用振动", enableVibration)) {
                toastLog("振动状态: " + (enableVibration[0] ? "开启" : "关闭"));

            }

            ImGui.Spacing();
            ImGui.Separator();
            ImGui.Spacing();

            // === 单选按钮区域 ===
            ImGui.TextColored(1.0, 0.8, 0.2, 1.0, "▼ 单选按钮");
            ImGui.Spacing();

            ImGui.Text("选择模式:");
            if (ImGui.RadioButton("简单模式", selectedOption, 0)) {
                toastLog("选择了: 简单模式");
            }
            ImGui.SameLine();
            if (ImGui.RadioButton("标准模式", selectedOption, 1)) {
                toastLog("选择了: 标准模式");
            }
            ImGui.SameLine();
            if (ImGui.RadioButton("专业模式", selectedOption, 2)) {
                toastLog("选择了: 专业模式");
            }

            ImGui.Spacing();
            ImGui.Separator();
            ImGui.Spacing();

            // === 滑块区域 ===
            ImGui.TextColored(1.0, 0.8, 0.2, 1.0, "▼ 滑块控件");
            ImGui.Spacing();

            if (ImGui.SliderFloat("音量", volume, 0.0, 1.0, "%.2f", 0)) {
                toastLog("音量调整为:" + volume[0].toFixed(2));
            }

            if (ImGui.SliderFloat("亮度", brightness, 0.0, 1.0, "%.2f", 0)) {
                toastLog("亮度调整为:" + brightness[0].toFixed(2));
            }

            ImGui.Spacing();
            ImGui.Separator();
            ImGui.Spacing();

            // === 颜色选择器 ===
            ImGui.TextColored(1.0, 0.8, 0.2, 1.0, "▼ 颜色选择");
            ImGui.Spacing();

            if (ImGui.ColorEdit3("主题颜色", color)) {
                toastLog("颜色: R=" + color[0].toFixed(2) + " G=" + color[1].toFixed(2) + " B=" + color[2].toFixed(2));
            }

            ImGui.Spacing();
            ImGui.Separator();
            ImGui.Spacing();

            // === 状态显示区域 ===
            ImGui.TextColored(0.2, 1.0, 0.5, 1.0, "▼ 状态信息");
            ImGui.Spacing();

            ImGui.Text("功能状态: " + (enableFeature[0] ? "已启用" : "已禁用"));
            ImGui.Text("当前模式: " + getModeName(selectedOption[0]));

            ImGui.Spacing();

            // 底部信息
            ImGui.Separator();
            ImGui.TextColored(0.5, 0.5, 0.5, 1.0,
                "提示: 所有操作都会在 Autojs 中输出日志");
        }
        ImGui.End();

        ImGui.ShowDemoWindow()

    } else {
        ImGui.stop();
    }
})

ImGui.launch();

function getModeName(mode) {
    switch (mode) {
        case 0:
            return "简单模式";
        case 1:
            return "标准模式";
        case 2:
            return "专业模式";
        default:
            return "未知";
    }
}

function jArrayB() {
    let jArr = util.java.array(java.lang.Boolean.TYPE, arguments.length);
    for (let i = 0; i < arguments.length; i++) {
        jArr[i] = arguments[i];
    }
    return jArr;
}

function jArrayI() {
    let jArr = util.java.array(java.lang.Integer.TYPE, arguments.length);
    for (let i = 0; i < arguments.length; i++) {
        jArr[i] = arguments[i];
    }
    return jArr;
}

function jArrayF() {
    let jArr = util.java.array(java.lang.Float.TYPE, arguments.length);
    for (let i = 0; i < arguments.length; i++) {
        jArr[i] = arguments[i];
    }
    return jArr;
}