function imgui() {
    let currentPath = files.cwd()+"/"
    let dexPath = currentPath + "libs/imgui.dex";
    let soDir = currentPath + "libs/arm64-v8a/";

    let adbThread = threads.start(() => {
        let cmd =["pkill -f canvas-ui","/data/local/tmp/canvas-ui"].join(";");

        if (runtime.shizuku) {
            shizuku(cmd);
        } else {
            $shell.setDefaultOptions({
                adb: true
            });
            let r = $shell(cmd)
            log(r)
        }
    })
    
    sleep(500);

    function getDexClassLoader(dexPath, soDir) {
        let jniDir;
        let soDir;
        let dexDir = context.getDir("dex", android.app.Activity.MODE_PRIVATE).getAbsolutePath(); //  /data/user/0/org.autojs.autojspro/app_dex
        if (soDir) {
            jniDir = context.getDir("libs", android.app.Activity.MODE_PRIVATE).getAbsolutePath(); //  /data/user/0/org.autojs.autojspro/app_libs
            files.removeDir(jniDir);
            newjniDir = jniDir + "/" + Date.now() + "/"; // 转时间戳
            files.createWithDirs(newjniDir); //创建文件夹

            let soList = files.listDir(soDir, function(f) { // 遍历目录的so文件 /sdcard/脚本/ncnn//lib/arm64-v8a
                return f.endsWith(".so");
            });
            for (let i = 0; i < soList.length; i++) {
                let f1 = new java.io.File(soDir, soList[i]).getAbsolutePath(); //  /sdcard/脚本/ncnn/lib/arm64-v8a/libmx.so
                let f2 = new java.io.File(newjniDir, soList[i]).getAbsolutePath(); //  /data/user/0/org.autojs.autojspro/app_libs/1695914766343/libmx.so
                files.copy(f1, f2);
            }
        }
        let dcl = new Packages.dalvik.system.DexClassLoader(dexPath, dexDir, newjniDir, java.lang.ClassLoader.getSystemClassLoader());
        return dcl;
    }

    let dcl = getDexClassLoader(dexPath, soDir);
    let clazz = dcl.loadClass("com.llleeo.imgui.ImGui");
    let ImGui = new Packages.org.mozilla.javascript.NativeJavaClass(global, clazz).getInstance();
    ImGui.setFontPath(currentPath + "fonts/SourceHanSansSC-Regular.otf")
    return {
        ImGui
    };
}

module.exports = imgui();