auto();

if (!$images.getScreenCaptureOptions() && !requestScreenCapture()) {
    toast("请求截图失败");
    exit();
};
var imgAry=[{"name":0,"img":{"path":null,"base64":"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"},"template":null,"options":{"region":[114,17,380,120],"threshold":0.8},"p":{"x":304,"y":77}},{"name":"开始游戏","img":{"path":"./开始游戏.png","base64":null},"template":null,"options":{"region":[114,17,380,120],"threshold":0.8},"p":{"x":304,"y":77}},{"name":"选择突变者","img":{"path":"./选择突变者.png","base64":null},"template":null,"options":{"region":[1674,836,264,83],"threshold":0.8},"p":{"x":1806,"y":877}},{"name":"继续1","img":{"path":"./继续1.png","base64":null},"template":null,"options":{"region":[2096,1113,162,74],"threshold":0.8},"p":{"x":2177,"y":1150}},{"name":"继续2","img":{"path":"./继续2.png","base64":null},"template":null,"options":{"region":[2103,1117,205,80],"threshold":0.8},"p":{"x":2205,"y":1157}},{"name":"返回大厅","img":{"path":"./返回大厅.png","base64":null},"template":null,"options":{"region":[2068,1118,166,74],"threshold":0.8},"p":{"x":2151,"y":1155}}];
imgAry.forEach(function(obj){
    if(obj.img.path){
        obj.template=images.read(obj.img.path);
    };
    if(obj.img.base64){
        obj.template=images.fromBase64(obj.img.base64);
    };
});
while(1){
    let img=captureScreen();
    for(let i in imgAry){
        let obj=imgAry[i];
        let p=images.findImage(img,obj.template,obj.options);
        if(p){
            click(obj.p.x,obj.p.y);
        };
    };
    img.recycle();
};