"ui";

// 初始加载验证页面
ui.layout(
    <vertical padding="20dp" gravity="center" background="#f5f5f5">
        <text text="卡密验证中心" textSize="26sp" textColor="#333333" marginBottom="30dp" textStyle="bold"/>
        <input 
            id="keyInput" 
            hint="请输入您的卡密" 
            inputType="textPassword" 
            textSize="16sp"
            padding="12dp"
            background="#ffffff"
            radius="8dp"
            marginBottom="20dp"
            width="match_parent"
            elevation="2dp"
        />
        <button 
            id="verifyBtn" 
            text="确认验证" 
            textSize="18sp"
            textColor="#ffffff"
            background="#2196F3"
            radius="8dp"
            width="match_parent"
            height="52dp"
        />
    </vertical>
);

// 预设正确卡密（替换为你的实际卡密）
var correctKey = "your_unique_key_here";
// 同一目录下“团竞.js”的路径
var teamCompScriptPath = "团竞.js";
// 标记截图权限是否已请求
var isScreenCaptureRequested = false;

// 验证按钮点击事件
ui.verifyBtn.click(function() {
    var userKey = ui.keyInput.text();
    if (userKey === correctKey) {
        toast("✅ 验证成功，跳转中...");
        setTimeout(function() {
            // 加载脚本控制页布局
            ui.layout(
                <vertical padding="20dp" gravity="center" background="#f5f5f5">
                    <text text="脚本控制页" textSize="26sp" textColor="#333333" marginBottom="50dp" textStyle="bold"/>
                    <button 
                        id="startScriptBtn" 
                        text="启动脚本" 
                        textSize="18sp"
                        textColor="#ffffff"
                        background="#4CAF50"
                        radius="8dp"
                        width="match_parent"
                        height="56dp"
                    />
                </vertical>
            );

            // 启动脚本按钮点击事件：创建独立线程执行，且严格控制截图权限仅请求一次
            ui.startScriptBtn.click(function() {
                // 新建线程，完全避开UI线程限制
                threads.start(function() {
                    try {
                        if (!files.exists(teamCompScriptPath)) {
                            toast("❌ 未找到「团竞.js」，请确认文件在同一目录", 3000);
                            return;
                        }
                        // 严格控制截图权限仅请求一次
                        if (!isScreenCaptureRequested) {
                            if (!requestScreenCapture()) {
                                toast("❌ 截图权限请求失败", 3000);
                                return;
                            }
                            isScreenCaptureRequested = true;
                        }
                        // 读取并执行脚本
                        var scriptContent = files.read(teamCompScriptPath);
                        eval(scriptContent);
                        toast("🚀 团竞脚本已启动！", 2000);
                    } catch (e) {
                        toast("❌ 启动失败：" + e.message, 3000);
                    }
                });
            });
        }, 1000);
    } else {
        toast("❌ 卡密错误，请重试", 2000);
        ui.keyInput.setText("");
    }
});
