/**
 * 计算文字宽度
 * @param {android.graphics.Paint} paint
 * @param {string} text 文本
 * @param {number} textSize 字体大小
 * @returns
 */
const measureTextWidth = function (paint, text, textSize) {
  textSize && paint.setTextSize(textSize);
  return paint.measureText(text);
};

/**
 * 获取 Android 系统的顶部状态栏高度
 * @returns 状态栏高度（以像素为单位）
 */
const getStatusBarHeight = function () {
  // 获取应用上下文的资源对象
  let resources = context.getResources();

  // 获取状态栏高度的资源标识符
  let resourceId = resources.getIdentifier(
    "status_bar_height",
    "dimen",
    "android"
  );

  // 获取状态栏高度的像素值
  let height = resources.getDimensionPixelSize(resourceId);

  // 打印状态栏高度（可选）
  log("dbw", "Status height:" + height);

  // 返回状态栏高度
  return height;
};
/**
 * 可视化控件位置
 * @param {AutoJs.UiObject} obj
 */
const debugRect = function (obj) {
  const { Bitmap, Canvas, Paint } = android.graphics;
  const w = device.width;
  const h = device.height;
  const statusBarHeight = getStatusBarHeight();
  let debugWindow = $floaty.rawWindow(
    `
    <frame id="parent">
      <ImageView id="canvas" w="*" h="*" />
    </frame>
    `
  );
  debugWindow.setTouchable(true);
  debugWindow.setSize(w, h);
  // 自动适配状态栏
  // 获取状态栏高度
  debugWindow.setPosition(0, -statusBarHeight);
  let mBitmap = Bitmap.createBitmap(w, h, Bitmap.Config.ARGB_8888);
  let mCanvas = new Canvas(mBitmap);
  let rectPaint = new Paint(Paint.ANTI_ALIAS_FLAG);
  rectPaint.setStyle(Paint.Style.STROKE);
  rectPaint.setColor($colors.parseColor("#00ff00"));
  rectPaint.setStrokeWidth(5);
  let textPaint = new Paint();
  textPaint.setTextSize(80);
  textPaint.setColor($colors.parseColor("#ff0000"));
  mBitmap.eraseColor(0);
  if (!obj) {
    // 没有控件是显示null, 并震动提示
    device.vibrate(500);
    let tips = "没有找到控件!";
    let tipsTextWidth = measureTextWidth(textPaint, tips);
    mCanvas.drawText(tips, w / 2 - tipsTextWidth / 2, h / 2, textPaint);
  } else {
    let rect = obj.bounds();
    mCanvas.drawRect(rect, rectPaint);
  }
  ui.run(() => {
    debugWindow.canvas.setImageBitmap(mBitmap);
  });
  $events.on("exit", () => {
    mBitmap && mBitmap.recyle();
  });
};

// 测试脚本
setInterval(() => {}, 1000);
let wechatNum = textMatches(/.*微信号.*/).findOnce();
debugRect(wechatNum);
