# AutoJs-FloatButton

#### 介绍

Auto.Js 悬浮按钮模块

作者:大柒

QQ:531310591

#### 软件架构

AutoJs Pro 7.3.0-1

### 使用说明

> 将根目录下 `FloatButton`文件夹放到你的项目使用`require()`方法导入即可\

```
//导入模块
const {FloatButton} = require('./FloatButton/init');

let fb = new FloatButton();
```

#### new FloatButton();

```
//导入模块
const {FloatButton} = require('./FloatButton/init');
let fb = new FloatButton();
```

#### fb.setIcon(src)

> 设置 logo 图标\
> `src`:同 AutoJs 图片控件 src 属性一致

```
fb.setIcon('http://www.autojs.org/assets/uploads/profile/3-profileavatar.png');
```

#### fb.setTint(colorstr)

> 设置 logo 图标颜色\
> `colorstr` 16 进制颜色 默认透明

```
fb.setTint('#FFFFFF');
```

#### fb.setColor(colorstr)

> 设置 logo 图标背景色\
> `colorstr` 16 进制颜色 默认#FFFFFF

```
fb.setColor('#FFFFFF');
```

#### fb.setAllButtonSize(dp)

> 设置所有按钮大小\
> `dp` 单位:dp 默认 40dp

```
fb.setAllButtonSize(42);
```

#### fb.setAllButtonPadding(dp)

> 设置所有按钮内边距\
> `dp` 单位:dp 默认 8dp

```
fb.setAllButtonPadding(42);
```

#### fb.setMenuRadius(dp)

> 设置菜单半径\
> `dp` 单位:dp 默认 80dp

```
fb.setAllButtonPadding(80);
```

#### fb.setMenuOpen(checked)

> 设置菜单状态\
> `checked` `true:开启菜单 false:关闭菜单`

```
fb.setMenuOpen(true);
```

#### fb.setAutoCloseMenuTime(time)

> 在一定时间内无操作关闭菜单\
> `time` 单位`ms` 0:不关闭 默认 0

```
//三秒内无操作关闭菜单
fb.setAutoCloseMenuTime(3000);
```

#### fb.show()

> 显示悬浮球

```
fb.show();
```

#### fb.hide()

> 显示悬浮球

```
fb.hide();
```

### 添加按钮 addItem(name)

> 向菜单添加按钮
> `name` 按钮名字

```
fb.addItem('按钮1')
    .setIcon()//设置图标
    .setTint()//设置图标颜色
    .setColor()//设置背景色
    //开启复选框属性
    .toChecked((util)=>{
        //未选中样式
        util.icon1().tint1().color1();
        //选中样式
        util.icon2().tint2().color2();
    })
    //点击事件
    .onclick((view,name,state)=>{
        /**
         * view:视图信息
         * name:名字
         * state:状态
         */
        //返回true 保持菜单开启 返回false 关闭菜单
        return false;
    })
    .setChecked()//设置状态
    .getChecked()//获取状态
    .getView()//获取视图
```

#### .setIcon(src)

> 设置按钮图标\
> `src`

```
.setIcon()
```

#### .setTint(colorstr)

> 设置按钮图标颜色\
> `colorstr`16 进制颜色

```
.setTint()
```

#### .setColor(colorstr)

> 设置按钮背景色\
> `colorstr`16 进制颜色

```
.setColor()
```

#### .toCheckbox((util)=>{})

> 开启复选框属性\
> `util`obj\
> **未选中样式**\
> `util.icon1(src)`\
> `util.tint1(colorstr)` `colorstr` 16 进制颜色\
> `util.color1(colorstr)` `colorstr` 16 进制颜色\
> **选中样式**\
> `util.icon2(src)`\
> `util.tint2(colorstr)` `colorstr` 16 进制颜色\
> `util.color2(colorstr)` `colorstr` 16 进制颜色

```
fb.addItem('按钮1')
    .toCheckbox(util=>{
        //未选中样式
        util.icon1().tint1().color1();
        //选中样式
        util.icon2().tint2().color2();
    });
```

#### .onClick((view,name,state)=>{})

> 按钮点击事件 如果设置此方法,则不会再`item_click`事件中再次触发\
> `view` 视图信息\
> `name` 按钮名字\
> `state` 按钮状态 只有开启了`.toCheckbox()`属性才能生效 未开启则返回`null`\
> `return` 返回值 返回`true`保持菜单开启 返回`false`关闭菜单
> ``

```
fb.addItem('按钮1')
    .onClick((view,name,state)=>{
        //这里执行点击后的代码

        return false;//关闭菜单
    });

```

#### .setChecked(value)

> 设置按钮状态 只有开启了`.toCheckbox()`才会生效\
> `value` `true`or`false`

```
fb.addItem('按钮1')
    .setChecked(true)
```

#### util.getChecked()

> 获取按钮状态 只有开启了`.toCheckbox()`才会生效

```
fb.addItem('按钮1')...
let value = fb.getViewUtil('按钮1').getChecked();
```

#### util.getView()

> 获取按钮视图

```
fb.addItem('按钮1')...
let view= fb.getViewUtil('按钮1').getView();
```

### 悬浮窗事件 fb.on(eventType,eventAction)

> 悬浮窗事件\
> `eventType` 事件名称\
> `eventAction` 事件方法

#### item_click

> fb.on('item_click',(view,name,state)=>{})\
> 按钮点击事件 如果在`addItem`中添加了`onCLick()`方法则不会在这里触发\
> `view`:视图信息\
> `name`:按钮名字\
> `state`:按钮状态 只有开启了`.toCheckbox()`属性才能生效 未开启则返回`null`\
> `return` 返回值 返回`true`保持菜单开启 返回`false`关闭菜单

```
fb.on('item_click',(view,name,state)=>{
   //在此处执行代码

    return false;//关闭菜单
});
```

#### menu_state_changed

> 菜单状态改变事件\
> fb.on('menu_state_changed',(value)=>{})\
> `value` `true`开启 `false`关闭

```
fb.on('menu_state_changed',(value)=>{
    toast('菜单'+(value?'开启':'关闭'));
})
```

#### direction_changed

> 停靠方向改变事件\
> fb.on('direction_changed',(value)=>{})\
> `value` `true`右侧 `false`左侧

```
fb.on('direction_changed',(value)=>{
    toast('悬浮球停靠在'+(value?'右侧':'左侧'));
})
```

#### orientation_changed

> 停靠方向改变事件\
> fb.on('orientation_changed',(value)=>{})\
> `value` `true`横屏 `false`竖屏

```
fb.on('orientation_changed',(value)=>{
    toast('屏幕现在是'+(value?'横屏':'竖屏'));
})
```

#### show

> 悬浮窗显示事件

```
fb.on('show',(value)=>{
    toast('悬浮球显示');
})
```

#### hide

> 悬浮窗隐藏事件

```
fb.on('hide',(value)=>{
    toast('悬浮球隐藏');
})
```

### 其他方法

#### fb.getView(name)

> 获取指定按钮视图\
> `name` 按钮名字

```
let view = fb.getView('按钮1');
```

#### fb.getViewUtil(name)

> 获取指定按钮工具类 对应的`addItem()`方法\
> `name` 按钮名字

```
let viewUtil = fb.getViewUtil('按钮1');
```

#### fb.getWindow(name)

> 获取指定悬浮窗\
> `name` 按钮名字 'logo'or'menu'

```
let win = fb.getWindow('logo');
```

#### fb.getConfig()

> 获取 FloatButton 配置

```
let mConfig = fb.getConfig();
```

#### fb.getWidth()

> 返回屏幕宽度

```
let w= fb.getWidth();
```

#### fb.getHeight()

> 返回屏幕高度

```
let w= fb.getHeight();
```

### 参与贡献

1.  Fork 本仓库
2.  新建 Feat_xxx 分支
3.  提交代码
4.  新建 Pull Request

### 特技

1.  使用 Readme_XXX.md 来支持不同的语言，例如 Readme_en.md, Readme_zh.md
2.  Gitee 官方博客 [blog.gitee.com](https://blog.gitee.com)
3.  你可以 [https://gitee.com/explore](https://gitee.com/explore) 这个地址来了解 Gitee 上的优秀开源项目
4.  [GVP](https://gitee.com/gvp) 全称是 Gitee 最有价值开源项目，是综合评定出的优秀开源项目
5.  Gitee 官方提供的使用手册 [https://gitee.com/help](https://gitee.com/help)
6.  Gitee 封面人物是一档用来展示 Gitee 会员风采的栏目 [https://gitee.com/gitee-stars/](https://gitee.com/gitee-stars/)
