module.exports = {
    弹窗输入框: showInputDialog,
    生成悬浮窗拖拽: 生成悬浮窗拖拽,
    生成屏幕旋转,
    mSetInterval: mSetInterval,
    屏幕方向: 屏幕方向,
    屏幕旋转: 屏幕旋转,
    状态栏高度: 状态栏高度,
    setWindowFull: setWindowFull,
    getWindow: getWindow,
    getdeviceDpi: getdeviceDpi,
    getNavigationBarHeight: getNavigationBarHeight,
    getScreenSize: getScreenSize,
    requestScreenCapture: 获取截图权限,
    悬浮窗隐藏,
    悬浮窗显示,
    前台服务,
    deepClone,
    toAutojsfindColors,
    autoScale,
    setDevelopmentSize,
    watchProperty,
    监听属性: watchProperty,
}

function watchProperty(obj, key, callback, change) {
    let value = obj[key];
    if(change == undefined) {
        change = true
    }
    Object.defineProperty(obj, key, {
        get() {
            return value;
        },
        set(newValue) {
            const oldValue = value;
            if (oldValue !== newValue || !change) {
                value = newValue;
                callback(newValue, oldValue);
            }
        },
        enumerable: true,
        configurable: true
    });
    
    return obj;
}

/**
 * @description 反射获取原生Window示例对象
 * @param {AutoJs.FloatyWindow} window 悬浮窗
 * @return {AutoJs.FloatyWindow?} 原生Window对象
 */
function getWindow(window) {
    if (!window) return null;
    let field = window.getClass().getDeclaredField("mWindow");
    field.setAccessible(true);
    return field.get(window);
}
/**
 * @description 反射获取原生Window示例对象
 * @param {AutoJs.FloatyWindow} window 悬浮窗
 * @return {AutoJs.FloatyWindow?} 原生Window对象
 */
function setWindowFull(window) {
    const LayoutParams = android.view.WindowManager.LayoutParams;
    try {
        ui.run(() => {
            let window_root = getWindow(window).getWindowView();
            let window_params = window_root.getLayoutParams();
            window_params.flags |= LayoutParams.FLAG_FULLSCREEN | LayoutParams.FLAG_LAYOUT_IN_SCREEN | LayoutParams.FLAG_LAYOUT_NO_LIMITS;
            window_root.setLayoutParams(window_params);
        });
        return window;
    } catch (error) {
        console.log(error);
    }
}

function 状态栏高度() {
    let result = 0;
    let resId = context.getResources().getIdentifier('status_bar_height', 'dimen', 'android');
    if (resId > 0) {
        result = context.getResources().getDimensionPixelOffset(resId);
    }
    if (result <= 0) {
        result = context.getResources().getDimensionPixelOffset(R.dimen.dimen_25dp);
    }
    return result;
}

// 1. 定义开发分辨率（默认为 1080x1920）
var developmentWidth = 1080;
var developmentHeight = 1920;

/**
 * 设置开发分辨率
 * @param {number} w 宽
 * @param {number} h 高
 */
function setDevelopmentSize(w, h) {
    developmentWidth = w;
    developmentHeight = h;
}

/**
 * 自动缩放函数
 * @param {number} px  原始像素值
 * @param {number} [min] 最小限制值（可选）
 * @param {number} [max] 最大限制值（可选）
 * @returns {number} 计算后的像素值
 */
function autoScale(px, min, max) {
    // 使用 device 获取物理分辨率（包含状态栏、导航栏的完整屏幕）
    // 这样能保证 1080p 设备上运行 1080p 的脚本比例为 1.0
    var currentWidth = device.width;
    var currentHeight = device.height;

    // 智能适配：总是用“短边”除以“短边”
    // 这样无论手机是横屏还是竖屏，计算出的比例都是正确的
    var screenMin = Math.min(currentWidth, currentHeight);
    var devMin = Math.min(developmentWidth, developmentHeight);

    // 计算比例
    var scale = screenMin / devMin;
    var scaledValue = Math.round(px * scale);

    // --- 限制逻辑 ---

    // 小于最小值就设为最小值
    if (typeof min === 'number' && scaledValue < min) {
        scaledValue = min;
    }

    // 大于最大值就设为最大值
    if (typeof max === 'number' && scaledValue > max) {
        scaledValue = max;
    }

    return scaledValue;
}

var lastOrientation = null;
var isRotateMonitor = false

function 屏幕旋转(interval) {
    if (isRotateMonitor) {
        return lastOrientation
    }
    lastOrientation = 屏幕方向()
    isRotateMonitor = true
    interval = interval || 400
    var id = setInterval(() => {
        var cfg = context.getResources().getConfiguration();
        var orientation = (cfg.orientation == 1) ? "v" : "h"; // 1=竖,2=横
        if (orientation !== lastOrientation) {
            lastOrientation = orientation;
            events.emit("屏幕旋转", orientation);
        }
    }, interval);
    events.on("exit", () => {
        clearInterval(id)
    })
}

function 屏幕方向() {
    var orientation = context.getResources().getConfiguration().orientation;
    var direction = null
    if (orientation === android.content.res.Configuration.ORIENTATION_PORTRAIT) {
        direction = "v"
    }
    if (orientation === android.content.res.Configuration.ORIENTATION_LANDSCAPE) {
        direction = "h"
    }
    return direction
}

function mSetInterval(fn, delay) {
    let timer = {
        stop: false
    };
    // 当前线程
    //var thread = threads.currentThread();
    function loop() {
        if (timer.stop) return;
        fn();
        timer.id = setTimeout(loop, delay);
    }

    function start() {
        timer.id = setTimeout(loop, delay);
    }
    return {
        start() {
            timer.stop = false
            start()
        },
        stop() {
            timer.stop = true
        }
    }
}

function 生成悬浮窗拖拽(x, y, callback) {
    x = x || 0,
        y = y || 0;
    var rwW = 0,
        rwH = 0,
        rwX = 0,
        rwY = 0;
    var dx, dy;
    return function(f, event) {
        var {
            width,
            height
        } = getScreenSize()
        var statusBarHeight = 状态栏高度()

        switch (event.getAction()) {
            case event.ACTION_DOWN:
                x = event.getRawX();
                y = event.getRawY();
                var point = f.getPosition()
                rwX = point.x;
                rwY = point.y;
                rwW = f.getWidth();
                rwH = f.getHeight();

                callback("down", rwX, rwY)
                return true;
            case event.ACTION_MOVE:
                dx = event.getRawX() - x + rwX;
                dy = event.getRawY() - y + rwY;
                var minX = 0
                var minY = statusBarHeight
                if (dx < minX) dx = minX;
                if (dy < minY) dy = minY;
                if (dx > (width - rwW)) {
                    dx = width - rwW
                }
                if (dy > (height - rwH)) {
                    dy = height - rwH
                }
                f.setPosition(dx, dy);
                callback("move", dx, dy)
                return true;
            case event.ACTION_UP:
                callback("up", dx, dy)
                return true;
        }
        return false;
    }
}

function 生成屏幕旋转(f, w, h, callback) {
    var config = {}
    config.width = w || device.width
    config.height = h || device.height
    config.statusBarHeight = 状态栏高度()
    return function 屏幕旋转(reset) {
        // 获取当前悬浮窗实例
        var window = f;
        var d = utils.屏幕方向()
        if (!window) {
            console.error("悬浮窗未初始化");
            return;
        }

        // 获取当前屏幕宽高
        var oldW = config.width;
        var oldH = config.height;

        // 更新 config 宽高
        if (d === "h") {
            config.width = Math.max(device.width, device.height);
            config.height = Math.min(device.width, device.height);
        } else {
            config.width = Math.min(device.width, device.height);
            config.height = Math.max(device.width, device.height);
        }

        var statusBarHeight = config.statusBarHeight || 0;
        var ww = window.getWidth();
        var wh = window.getHeight();

        // 旋转前最大范围
        var oldMaxX = Math.max(1, oldW - ww);
        var oldMaxY = Math.max(1, oldH - wh);

        // 保存旋转前比例
        var point = window.getPosition()
        var wx = reset ? x : point.x;
        var wy = reset ? y : point.y;
        var ratioX = wx / oldMaxX;
        var ratioY = wy / oldMaxY;

        // 旋转后最大范围
        var newMaxX = Math.max(1, config.width - ww);
        var newMaxY = Math.max(1, config.height - wh);

        // 计算新坐标并限制边界
        var newx = Math.round(Math.min(newMaxX, Math.max(0, newMaxX * ratioX)));
        var newy = Math.round(Math.min(newMaxY, Math.max(config.statusBarHeight, newMaxY * ratioY)));

        window.setPosition(newx, newy);
        typeof callback == "function" && callback(newx, newy, config.width, config.height)
    }
}

function showInputDialog(callback, config) {
    config = config || {}
    var options = Object.assign({
        type: "overlay",
        inputPrefill: "",
        positive: "确定",
        negative: "取消",
        canceledOnTouchOutside: true,
        isValue: false,
    }, config);

    var isValue = config.isValue || false

    var dialog = dialogs.build(options).on("positive", (dialog) => {
        let text = dialog.getInputEditText().getText().toString();
        if (text || isValue) {
            typeof callback == "function" && callback(text)
        }
    })
    dialog.on("negative", () => {}).show();
    return dialog
}

function getdeviceDpi() {
    // 获取 DisplayMetrics
    var metrics = context.getResources().getDisplayMetrics(),
        densityDpi = metrics.densityDpi, // 获取屏幕 DPI（像素密度如 320（代表 xxhdpi）
        density = metrics.density, // 如 2.0（表示 2 倍缩放）
        scaledDensity = metrics.scaledDensity; // 字体缩放比例（通常等于 density）
    return {
        densityDpi: densityDpi,
        density: density,
        scaledDensity: scaledDensity
    };
}

function getScreenSize() {
    // 获取 WindowManager
    var wm = context.getSystemService(android.content.Context.WINDOW_SERVICE);
    // 获取 DisplayMetrics
    var metrics = new android.util.DisplayMetrics();
    wm.getDefaultDisplay().getRealMetrics(metrics);

    // 实际宽高（随屏幕方向变化）
    var realW = metrics.widthPixels;
    var realH = metrics.heightPixels;

    return {
        width: realW,
        height: realH
    };
}

function hasNavigationBar(context) {
    var res = context.getResources();
    var id = res.getIdentifier("config_showNavigationBar", "bool", "android");
    var hasNav = id > 0 && res.getBoolean(id);

    try {
        var SystemProperties = java.lang.Class.forName("android.os.SystemProperties");
        var getMethod = SystemProperties.getMethod("get", java.lang.String.class);
        var navBarOverride = getMethod.invoke(SystemProperties, "qemu.hw.mainkeys");
        if ("1".equals(navBarOverride)) {
            hasNav = false;
        } else if ("0".equals(navBarOverride)) {
            hasNav = true;
        }
    } catch (e) {
        // ignore
    }
    return hasNav;
}

function getStatusBarHeight() {
    var res = context.getResources();
    var resId = res.getIdentifier("status_bar_height", "dimen", "android");
    return resId > 0 ? res.getDimensionPixelSize(resId) : 0;
}

function getNavigationBarHeight() {
    var res = context.getResources();
    var resId = res.getIdentifier("navigation_bar_height", "dimen", "android");
    return resId > 0 ? res.getDimensionPixelSize(resId) : 0;
}

// 截图权限
function 获取截图权限() {
    if (images.getScreenCaptureOptions() != null) {
        return true
    }
    // 请求截屏权限
    if (!requestScreenCapture()) {
        return false;
    }
    return true;
}

function 悬浮窗隐藏(rw, alpha) {
    alpha = alpha || 0
    $ui.run(() => {
        try {
            rw.root_view.attr("alpha", alpha)
        } catch (e) {}
    });
    rw.setTouchable(false)
}

function 悬浮窗显示(rw, alpha) {
    alpha = alpha || 1
    $ui.run(() => {
        try {
            rw.root_view.attr("alpha", alpha)
        } catch (e) {}
    });
    rw.setTouchable(true)
}

function 前台服务(title) {
    title = title || ""
    const CHANNEL_ID = "autojs_foreground_channel";
    const CHANNEL_NAME = "Autojs 前台服务";
    const NOTIFY_ID = 1001;

    threads.start(function() {
        var context = runtime ? runtime.getContext() : $context;

        // 创建通知渠道 (Android 8+)
        var NotificationManager = context.getSystemService(android.content.Context.NOTIFICATION_SERVICE);
        if (android.os.Build.VERSION.SDK_INT >= 26) {
            var NotificationChannel = android.app.NotificationChannel;
            // 改成 IMPORTANCE_HIGH 确保优先级
            var channel = new NotificationChannel(CHANNEL_ID, CHANNEL_NAME, android.app.NotificationManager.IMPORTANCE_HIGH);
            channel.setLockscreenVisibility(android.app.Notification.VISIBILITY_PUBLIC);
            channel.enableVibration(false); // 不震动
            channel.setSound(null, null); // 不提示声音
            channel.setShowBadge(false);
            NotificationManager.createNotificationChannel(channel);
        }

        // PendingIntent：点击通知回到应用主界面
        var pm = context.getPackageManager();
        var launchIntent = pm.getLaunchIntentForPackage(context.getPackageName());
        if (!launchIntent) launchIntent = new android.content.Intent();
        launchIntent.setFlags(android.content.Intent.FLAG_ACTIVITY_NEW_TASK | android.content.Intent.FLAG_ACTIVITY_CLEAR_TOP);
        var pendingIntent = android.app.PendingIntent.getActivity(context, 0, launchIntent, android.app.PendingIntent.FLAG_IMMUTABLE | android.app.PendingIntent.FLAG_UPDATE_CURRENT);

        // Notification builder
        var builder;
        if (android.os.Build.VERSION.SDK_INT >= 26) {
            builder = new android.app.Notification.Builder(context, CHANNEL_ID);
        } else {
            builder = new android.app.Notification.Builder(context);
        }
        builder.setContentTitle(title + " 前台服务")
            .setContentText("脚本正在运行")
            .setSmallIcon(context.getApplicationInfo().icon || android.R.drawable.sym_def_app_icon)
            .setContentIntent(pendingIntent)
            .setWhen(java.lang.System.currentTimeMillis())
            .setOngoing(true)
            .setAutoCancel(false)
            .setPriority(android.app.Notification.PRIORITY_MAX); // 高优先级

        var notification = builder.build();

        // 回退方式：显示常驻通知
        try {
            NotificationManager.notify(NOTIFY_ID, notification);
            log("已使用 NotificationManager.notify 显示高优先级常驻通知");
        } catch (e) {
            log("NotificationManager.notify 失败:", e);
        }

        // 心跳保持
        while (true) {
            log("heartbeat", new Date().toLocaleString());
            sleep(10 * 1000);
        }
    });
}

// 转成autojs需要的多点格式
function toAutojsfindColors(colors) {
    var result = [];
    var first = colors[0].hex.replace("#", "#ff")
    for (var i = 1; i < colors.length; i++) {
        result.push([colors[i].x - colors[0].x, colors[i].y - colors[0].y, colors[i].hex.replace("#", "#ff")])
    }
    return [first, result]
}


function deepClone(obj, map) {
    if (obj === null || typeof obj !== 'object') return obj;
    map = map || new WeakMap(); // 可选：若不支持 WeakMap，换成普通数组记录

    if (map.has && map.has(obj)) return map.get(obj);

    var clone;
    if (Object.prototype.toString.call(obj) === '[object Array]') {
        clone = [];
    } else if (Object.prototype.toString.call(obj) === '[object Date]') {
        clone = new Date(obj.getTime());
    } else if (Object.prototype.toString.call(obj) === '[object RegExp]') {
        clone = new RegExp(obj.source, obj.flags || '');
    } else {
        clone = {};
    }

    if (map.set) map.set(obj, clone);

    for (var key in obj) {
        if (obj.hasOwnProperty(key)) {
            clone[key] = deepClone(obj[key], map);
        }
    }
    return clone;
}