var xml =
    <frame id="root_view">
    <vertical>
        <frame w="*" h="*">
            <androidx.core.widget.NestedScrollView padding="12 0 12 50" w="*" h="*">
                <vertical>
                    <horizontal gravity="left|center" h="60" marginTop="10">
                        <text text="目标色" textColor="#333333"/>
                        <text visibility="gone" id="color_bg" w="20" h="20" />
                        <button visibility="gone" id="color_btn" text="设置" style="Widget.AppCompat.Button.Colored" w="auto"
                        backgroundTint="#EAEAEA" textColor="#333333"/>
                        <button visibility="gone" id="color_btn2" text="设置" style="Widget.AppCompat.Button.Colored" w="auto"
                        backgroundTint="#EAEAEA" textColor="#333333"/>
                    </horizontal>
                    <horizontal gravity="left|center" h="60" marginTop="10">
                        <text text="替换色" textColor="#333333"/>
                        <text visibility="gone" id="change_color_bg" w="20" h="20" />
                        <button visibility="gone" id="change_color_btn" text="设置" style="Widget.AppCompat.Button.Colored" w="auto"
                        backgroundTint="#EAEAEA" textColor="#333333"/>
                        <button visibility="gone" id="change_color_btn2" text="设置" style="Widget.AppCompat.Button.Colored" w="auto"
                        backgroundTint="#EAEAEA" textColor="#333333"/>
                    </horizontal>
                    <horizontal gravity="left|center" h="60">
                        <text text="相似度" textColor="#333333"/>
                        <seekbar progress="90" id="similarity_seekbar" layout_weight="1" />
                        <text gravity="center" id="input_seekbar" w="35" text="90" textColor="#333333"/>
                        <text text="%" textColor="#333333"/>
                    </horizontal>
                </vertical>
            </androidx.core.widget.NestedScrollView>
            <vertical w="*" h="50" layout_gravity="bottom" >
                <text w="*" h="1px" bg="#333333" />
                <horizontal h="*" gravity="center">
                    <text layout_weight="1" id="cancel_btn" text="取消"
                    w="0" h="*" gravity="center" backgroundTint="#EAEAEA" textColor="#333333"/>
                    <text w="1px" h="*" bg="#333333" />
                    <text layout_weight="1" id="confirm_btn" text="确认"
                    w="0" h="*" gravity="center" backgroundTint="#EAEAEA" textColor="#333333"/>
                </horizontal>
            </vertical>
        </frame>
    </vertical>
</frame>

var utils = require(files.join(files.cwd(), "utils.js"))
var 获取颜色 = require("./获取颜色.js");
var dialogsFloaty = require("./dialogsFloaty.js")
var bladeMenu = require("./bladeMenu.js");
var dropUpMenu = require("./dropUpMenu.js");
var 取色盘 = require("./取色盘.js")
var singArr = []
var mappingF = {}
var callback = {}
var redrawFun = {}


var testConfig = {}
var clipImgFile = files.join(files.cwd(), "clip/clipImgFile.png")
files.ensureDir(clipImgFile)
var storageClip = storages.create("clip")
var cacheFile = files.join(files.cwd(), "cache/")

var 设置Ui = function(title, data) {
    var rw = dialogsFloaty(xml)
    // 悬浮窗关闭处理事件
    rw.closed = function() {
        rw.cancel_btn.click()
    }
    rw.hide()
    rw.setRadius(25)
    //rw.setOverflowHide(true)
    init(rw, title, data)
    return rw
}

function ui居中(title) {
    var rw = mappingF[title]
    var screen = utils.getScreenSize()
    var width = screen.width
    var height = screen.height
    ui.post(() => {
        // 按屏幕比例算宽高
        var newW = Math.floor(width * 0.8)
        var newH = Math.floor(height * 0.8)

        // 最小限制
        var minW = 400
        var minH = 400
        if (newW < minW) newW = minW
        if (newH < minH) newH = minH

        // 最大限制
        var maxW = 1000
        var maxH = 1000
        if (newW > maxW) newW = maxW
        //if (newH > maxH) newH = maxH
        var fH = rw.getSize().height
        if (fH > newH) {
            fH = newH
        }
        rw.setSize(newW, fH)

        // 居中
        // var x = Math.floor((width - newW) / 2)
        // var y = Math.floor((height - fH) / 2)
        // rw.setPosition(x, y)
        rw.center()
        rw.show()
    })
}
// 生成处理
function generateHandle(name) {
    var result = copyCode[testConfig.type][name](testConfig)
    模板列表.close("生成")
}

function init(rw, title, data) {
    // 取消
    rw.cancel_btn.on("click", () => {
        rw.close()
        callbackHandle(title, "cancel", null)
        singArr = singArr.filter(e => e != title)
        events.removeListener("屏幕旋转", redrawFun[title])
    })
    // 确认
    rw.confirm_btn.on("click", () => {
        if (!testConfig.find) {
            toast("没有颜色")
            return
        }
        // 先执行回调
        callbackHandle(title, "confirm", {
            find: testConfig.find,
            change: testConfig.change,
            similarity: testConfig.similarity / 100
        })

        // 再关闭悬浮窗
        try {
            rw.cancel_btn.click()
        } catch (e) {
            console.error("关闭悬浮窗失败:", e)
        }
    })
    // 点击颜色设置按钮
    rw.color_btn.on("click", () => {
        设置颜色(rw)
    })
    // 点击颜色设置按钮
    rw.change_color_btn.on("click", () => {
        替换的色(rw)
    })
    //长按颜色
    function pasteColors(view) {
        var clipJson = storageClip.get("clip")
        try {
            var clip = JSON.parse(clipJson)
            if (clip.type != "color") throw "no color"
            if (view == "find") {
                testConfig.find = clip.content
                rw.color_btn2.attr("visibility", "gone")
                rw.color_btn.attr("visibility", "visible")
                rw.color_bg.attr("bg", clip.content)
                rw.color_bg.attr("visibility", "visible")
            } else {
                testConfig.change = clip.content
                rw.change_color_btn2.attr("visibility", "gone")
                rw.change_color_btn.attr("visibility", "visible")
                rw.change_color_bg.attr("bg", clip.content)
                rw.change_color_bg.attr("visibility", "visible")
            }
        } catch (e) {
            toast("不符合")
        }
    }
    rw.color_btn.on("long_click", (event, view) => {
        event.consumed = true
        bladeMenu.create(view, [{
                name: "复制",
                event: function() {
                    storageClip.put("clip", JSON.stringify({
                        type: "color",
                        content: testConfig.find,
                    }))
                }
            },
            {
                name: "粘贴",
                event: function() {
                    pasteColors("find")
                }
            }
        ])
    })
    rw.change_color_btn.on("long_click", (event, view) => {
        event.consumed = true
        bladeMenu.create(view, [{
                name: "复制",
                event: function() {
                    storageClip.put("clip", JSON.stringify({
                        type: "color",
                        content: testConfig.change,
                    }))
                }
            },
            {
                name: "粘贴",
                event: function() {
                    pasteColors("change")
                }
            },
            {
                name: "删除",
                event: function() {
                    testConfig.change = ""
                rw.change_color_btn2.attr("visibility", "visible")
                rw.change_color_btn.attr("visibility", "gone")
                rw.change_color_bg.attr("visibility", "gone")
                }
            }
        ])
    })
    //长按图片按钮
    rw.color_btn2.on("long_click", (event, view) => {
        event.consumed = true
        bladeMenu.create(view, [{
            name: "粘贴",
            event: function() {
                pasteColors("find")
            }
        }])
    })
    rw.change_color_btn2.on("long_click", (event, view) => {
        event.consumed = true
        bladeMenu.create(view, [{
            name: "粘贴",
            event: function() {
                pasteColors("change")
            }
        }])
    })

    // 点击图片按钮
    rw.color_btn2.on("click", () => {
        设置颜色(rw)
    })
    rw.change_color_btn2.on("click", () => {
        替换的色(rw)
    })
    // 相似度滑动
    rw.similarity_seekbar.setOnSeekBarChangeListener({
        onProgressChanged: (seekbar, progress, fromUser) => {
            rw.input_seekbar.attr("text", progress)
            testConfig.similarity = progress
        },
    });

    rw.input_seekbar.on("click", () => {
        utils.弹窗输入框(function(value) {
            if (/[^\d]/g.test(value)) {
                toast("请输入纯数字")
                return
            }
            if (value > 100) value = 100
            if (value < 0) value = 0
            rw.input_seekbar.attr("text", value)
            rw.similarity_seekbar.attr("progress", value)
            testConfig.similarity = value
        }, {
            title: "输入相似度",
            inputHint: "0-100"
        })
    })
}

function 设置颜色(rw) {
    var screenSize = utils.getScreenSize();
    var img_select_config = {
        direction: utils.屏幕方向() == "v" ? 1 : 0,
        width: screenSize.width,
        height: screenSize.height,
        type: "color",
        colors: testConfig.colors,
        rect: testConfig.rect ? testConfig.rect : [],
        callback: function(type, data) {
            //悬浮窗显示
            rw.show()
            if (type == "cancel") return
            if (type == "confirm" && data && data[0]) {
                testConfig.find = data[0].hex
                rw.color_btn2.attr("visibility", "gone")
                rw.color_btn.attr("visibility", "visible")
                rw.color_bg.attr("bg", data[0].hex)
                rw.color_bg.attr("visibility", "visible")

            } else {
                testConfig.find = ""
                rw.color_btn2.attr("visibility", "visible")
                rw.color_btn.attr("visibility", "gone")
                rw.color_bg.attr("visibility", "gone")
            }
        }
    };
    //悬浮窗隐藏
    rw.hide()
    setTimeout(() => {
        获取颜色.selectColor(img_select_config)
    }, 250)
}

function 替换的色(rw) {
    rw.hide()
    取色盘.create("取色盘", {
        callback(type, data) {
            rw.show()
            if (type == "cancel") return
            if (type == "confirm" && data) {
                testConfig.change = data
                rw.change_color_btn2.attr("visibility", "gone")
                rw.change_color_btn.attr("visibility", "visible")
                rw.change_color_bg.attr("bg", data)
                rw.change_color_bg.attr("visibility", "visible")
            } else {
                testConfig.change = data
                rw.change_color_btn2.attr("visibility", "visible")
                rw.change_color_btn.attr("visibility", "gone")
                rw.change_color_bg.attr("visibility", "gone")
            }
        }
    })
}

function create(title, data) {

    var singI = singArr.indexOf(title)
    if (singI != -1 || !data) return
    var rw = 设置Ui(title, data)
    singArr.push(title)
    mappingF[title] = rw
    callback[title] = data.callback
    ui居中(title)
    testConfig = {
        similarity: 90,
        find: "",
        change: ""
    }
    Object.assign(testConfig, utils.deepClone(data))
    if (testConfig.similarity < 1) {
        testConfig.similarity = testConfig.similarity * 100
    }
    ui.run(() => {
        if (data.find) {
            rw.color_bg.attr("bg", data.find)
            rw.color_btn.attr("visibility", "visible")
            rw.color_bg.attr("visibility", "visible")

        } else {
            rw.color_btn2.attr("visibility", "visible")
        }
        if (data.change) {
            rw.change_color_bg.attr("bg", data.find)
            rw.change_color_btn.attr("visibility", "visible")
            rw.change_color_bg.attr("visibility", "visible")

        } else {
            rw.change_color_btn2.attr("visibility", "visible")
        }
        rw.similarity_seekbar.attr("progress", testConfig.similarity)
    })
    redrawFun[title] = ((title, data) => {
        return function() {
            singArr.splice(singI, 1)
            ui.run(() => {
                close(title)
            })
            //create(title, data)
        }
    })(title, data)
    events.on("屏幕旋转", redrawFun[title])
    return rw
}

function callbackHandle(title, eventType, data) {
    if (typeof callback[title] != "function") {
        return
    }
    callback[title](eventType, data)
}

function close(title) {
    if (mappingF[title]) {
        mappingF[title].cancel_btn.click()
        delete mappingF[title]
    }
}

/*
utils.requestScreenCapture()
var r = create("颜色替换", {
    find: "#008c8c",
    similarity: 0.95,
    callback(type, data) {
        if (type == "confirm") {
            log(data)
        }
    }
})
*/


module.exports = {
    create,
    close,
    center: ui居中
}
