importClass(android.graphics.Color);
importClass(android.graphics.drawable.GradientDrawable);
importPackage(android.graphics);
importClass(android.animation.ObjectAnimator);
importClass(android.animation.AnimatorSet);
importClass(android.view.MotionEvent);

var utils = require(files.join(files.cwd(), "utils.js"));
var dialogsFloaty = require("./dialogsFloaty.js")
var showColorListDialog = require("./showColorListDialog.js")
var 状态栏h = utils.状态栏高度();
var 按键栏h = utils.getNavigationBarHeight();
var dpi = utils.getdeviceDpi().density;
utils.屏幕旋转(); // 初始化方向监听

// 放大镜相关常量
var MAGNIFIER_SIZE = 150 * dpi; // 放大镜大小
var MAGNIFIER_SCALE = 8; // 放大倍数

// 存储每个窗口的菜单动画状态
var menuStates = new WeakMap();

// 计算颜色亮度 (0-255)
function getColorBrightness(color) {
    var r = (color >> 16) & 0xFF;
    var g = (color >> 8) & 0xFF;
    var b = color & 0xFF;
    // 使用感知亮度公式（人眼对绿色最敏感）
    return (r * 0.299 + g * 0.587 + b * 0.114);
}

// 根据背景色获取合适的文字颜色
function getTextColor(backgroundColor) {
    var brightness = getColorBrightness(backgroundColor);
    // 亮度大于128使用黑色，否则使用白色
    return brightness > 128 ? Color.BLACK : Color.WHITE;
}

function selectColor(config, img) {
    if (!config) throw new Error("请传入设备信息对象");
    if (!utils.requestScreenCapture()) {
        throw new Error("请求截图失败，可能是权限被拒绝");
    }

    img = img || captureScreen();

    // 转换为 Android Bitmap
    var androidBitmap = img.getBitmap();

    //返回选中的颜色
    var returnSelectColors = utils.deepClone(config.colors) || []

    var w = config.width,
        h = config.height;

    // 当前选中的颜色和坐标
    var currentColor = 0;
    var currentX = w / 2;
    var currentY = h / 2;
    var isTouching = false;
    var isDraggingInMagnifier = false; // 是否在放大镜内拖动
    var isTapOnColorRing = false; // 点击第二圈
    var isMove = false

    // 状态
    var tapTime = 0,
        tapX = 0,
        tapY = 0;

    // 获取指定坐标的颜色
    function getColorAt(x, y) {
        if (x < 0 || x >= w || y < 0 || y >= h) return 0;
        return images.pixel(img, Math.round(x), Math.round(y));
    }

    // 颜色转换函数
    function colorToHex(color) {
        var r = (color >> 16) & 0xFF;
        var g = (color >> 8) & 0xFF;
        var b = color & 0xFF;
        return "#" +
            ("0" + r.toString(16)).slice(-2).toUpperCase() +
            ("0" + g.toString(16)).slice(-2).toUpperCase() +
            ("0" + b.toString(16)).slice(-2).toUpperCase();
    }

    function colorToRGB(color) {
        var r = (color >> 16) & 0xFF;
        var g = (color >> 8) & 0xFF;
        var b = color & 0xFF;
        return "RGB(" + r + ", " + g + ", " + b + ")";
    }

    // 创建悬浮窗
    var win = createWindow(config);
    var cv = win.board;

    颜色列表是否可见(win.colors, returnSelectColors)

    // 初始化颜色信息
    currentColor = getColorAt(currentX, currentY);

    var magnifierX = 0;
    var magnifierY = 0;

    // 绘制函数
    cv.on("draw", function(canvas) {
        try {
            // 清空画布
            canvas.drawColor(Color.TRANSPARENT, PorterDuff.Mode.CLEAR);

            // 绘制背景截图
            var bmpPaint = new Paint();
            bmpPaint.setFilterBitmap(true);
            canvas.drawBitmap(androidBitmap, 0, 0, bmpPaint);

            // 绘制当前位置的十字线
            var crossPaint = new Paint();
            crossPaint.setStyle(Paint.Style.STROKE);
            crossPaint.setARGB(200, 255, 0, 255);
            crossPaint.setStrokeWidth(2 * dpi);
            var crossSize = 20 * dpi;

            canvas.drawLine(currentX - crossSize, currentY, currentX + crossSize, currentY, crossPaint);
            canvas.drawLine(currentX, currentY - crossSize, currentX, currentY + crossSize, crossPaint);

            // 放大镜一直显示，位置跟随选中点
            // 计算放大镜位置（避免遮挡）

            // 定义统一的偏移距离
            var offsetDistance = MAGNIFIER_SIZE / 2 + 50 * dpi;

            // 定义边界阈值
            var topBoundary = MAGNIFIER_SIZE / 2 + 40 * dpi;
            var bottomBoundary = h - MAGNIFIER_SIZE / 2 - 40 * dpi;

            // 默认放在上方
            var targetY = currentY - offsetDistance;

            // 检查是否到达或超过顶部边界
            if (targetY < topBoundary) {
                // 到达或超过顶部边界，换到下方（使用相同的偏移距离）
                targetY = currentY + offsetDistance;
            }

            // 检查是否到达或超过底部边界
            if (targetY > bottomBoundary) {
                // 到达或超过底部边界，换到上方
                targetY = currentY - offsetDistance;

                // 如果上方也不够空间，则强制在可视范围内
                if (targetY < topBoundary) {
                    targetY = topBoundary;
                }
            }

            magnifierY = targetY;
            magnifierX = currentX;

            // X轴边界调整
            if (magnifierX < MAGNIFIER_SIZE / 2 + 20 * dpi) {
                magnifierX = MAGNIFIER_SIZE / 2 + 20 * dpi;
            }
            if (magnifierX > w - MAGNIFIER_SIZE / 2 - 20 * dpi) {
                magnifierX = w - MAGNIFIER_SIZE / 2 - 20 * dpi;
            }

            // 绘制放大镜 - 三层圆圈结构
            // 1. 最外层：白色粗边框
            var outerBorderPaint = new Paint();
            outerBorderPaint.setStyle(Paint.Style.STROKE);
            outerBorderPaint.setARGB(255, 200, 200, 200);
            outerBorderPaint.setStrokeWidth(2);
            outerBorderPaint.setAntiAlias(true);
            var outerRadius = MAGNIFIER_SIZE / 2 + 15 * dpi;
            canvas.drawCircle(magnifierX, magnifierY, outerRadius, outerBorderPaint);

            // 2. 中间层：显示选中的颜色（填充）
            var middleRingPaint = new Paint();
            middleRingPaint.setStyle(Paint.Style.FILL);
            middleRingPaint.setColor(currentColor); // 使用当前选中的颜色
            middleRingPaint.setAntiAlias(true);
            canvas.drawCircle(magnifierX, magnifierY, outerRadius - 2 * dpi, middleRingPaint);

            // 3. 内层白色背景（放大镜显示区域的背景）
            var innerBgPaint = new Paint();
            innerBgPaint.setStyle(Paint.Style.FILL);
            innerBgPaint.setARGB(255, 255, 255, 255);
            innerBgPaint.setAntiAlias(true);
            canvas.drawCircle(magnifierX, magnifierY, MAGNIFIER_SIZE / 2, innerBgPaint);

            // 保存画布并裁剪为圆形
            canvas.save();
            var path = new android.graphics.Path();
            path.addCircle(magnifierX, magnifierY, MAGNIFIER_SIZE / 2, android.graphics.Path.Direction.CW);
            canvas.clipPath(path);

            // 计算源区域并放大绘制
            var srcSize = MAGNIFIER_SIZE / MAGNIFIER_SCALE;
            var srcX = Math.max(0, Math.min(currentX - srcSize / 2, w - srcSize));
            var srcY = Math.max(0, Math.min(currentY - srcSize / 2, h - srcSize));

            var srcRect = new android.graphics.Rect(
                Math.round(srcX),
                Math.round(srcY),
                Math.round(srcX + srcSize),
                Math.round(srcY + srcSize)
            );
            var dstRect = new android.graphics.RectF(
                magnifierX - MAGNIFIER_SIZE / 2,
                magnifierY - MAGNIFIER_SIZE / 2,
                magnifierX + MAGNIFIER_SIZE / 2,
                magnifierY + MAGNIFIER_SIZE / 2
            );

            var magPaint = new Paint();
            magPaint.setFilterBitmap(true);
            magPaint.setAntiAlias(true);
            canvas.drawBitmap(androidBitmap, srcRect, dstRect, magPaint);

            // 绘制网格
            var gridPaint = new Paint();
            gridPaint.setStyle(Paint.Style.STROKE);
            gridPaint.setARGB(120, 200, 200, 200);
            gridPaint.setStrokeWidth(2);
            var gridSize = MAGNIFIER_SIZE / MAGNIFIER_SCALE;

            for (var i = 0; i <= MAGNIFIER_SCALE; i++) {
                var x = magnifierX - MAGNIFIER_SIZE / 2 + i * gridSize;
                canvas.drawLine(x, magnifierY - MAGNIFIER_SIZE / 2, x, magnifierY + MAGNIFIER_SIZE / 2, gridPaint);
            }
            for (var i = 0; i <= MAGNIFIER_SCALE; i++) {
                var y = magnifierY - MAGNIFIER_SIZE / 2 + i * gridSize;
                canvas.drawLine(magnifierX - MAGNIFIER_SIZE / 2, y, magnifierX + MAGNIFIER_SIZE / 2, y, gridPaint);
            }

            // 高亮中心网格
            var centerGridPaint = new Paint();
            centerGridPaint.setStyle(Paint.Style.STROKE);
            centerGridPaint.setARGB(200, 100, 100, 100);
            centerGridPaint.setStrokeWidth(2);
            var halfGrid = gridSize / 2;
            canvas.drawRect(
                magnifierX - halfGrid,
                magnifierY - halfGrid,
                magnifierX + halfGrid,
                magnifierY + halfGrid,
                centerGridPaint
            );

            canvas.restore();

            // ===== 关键修改：根据背景颜色自动选择文字颜色 =====
            var textPaint = new Paint();
            // 根据当前选中的颜色决定文字颜色（黑色或白色）
            var adaptiveTextColor = getTextColor(currentColor);
            textPaint.setColor(adaptiveTextColor);
            textPaint.setTextSize(12 * dpi);
            textPaint.setAntiAlias(true);
            // 添加描边使文字更清晰
            textPaint.setStyle(Paint.Style.FILL_AND_STROKE);
            textPaint.setStrokeWidth(0.5 * dpi);

            // 文字路径半径（在颜色环的中间）
            var textRadius = MAGNIFIER_SIZE / 2 + 2.5 * dpi;

            // 左上角文字路径（颜色值）
            var leftPath = new android.graphics.Path();
            leftPath.addArc(
                magnifierX - textRadius,
                magnifierY - textRadius,
                magnifierX + textRadius,
                magnifierY + textRadius, -165, // 起始角度（左上）
                75 // 扫描角度
            );

            var hexColor = colorToHex(currentColor);
            textPaint.setTextAlign(Paint.Align.LEFT);
            canvas.drawTextOnPath(hexColor, leftPath, 0, 0, textPaint);

            // 右上角文字路径（坐标）
            var rightPath = new android.graphics.Path();
            rightPath.addArc(
                magnifierX - textRadius,
                magnifierY - textRadius,
                magnifierX + textRadius,
                magnifierY + textRadius, -90, // 起始角度（右上）
                75 // 扫描角度
            );

            var coordText = Math.round(currentX) + "," + Math.round(currentY);
            textPaint.setTextAlign(Paint.Align.RIGHT);
            canvas.drawTextOnPath(coordText, rightPath, 0, 0, textPaint);

            // 绘制内圈灰色边框（在文字之后绘制，形成分隔）
            var innerBorderPaint = new Paint();
            innerBorderPaint.setStyle(Paint.Style.STROKE);
            innerBorderPaint.setARGB(255, 200, 200, 200);
            innerBorderPaint.setStrokeWidth(2);
            innerBorderPaint.setAntiAlias(true);
            canvas.drawCircle(magnifierX, magnifierY, MAGNIFIER_SIZE / 2, innerBorderPaint);

            // 绘制中心小方块（表示当前选中像素）
            var centerDotPaint = new Paint();
            centerDotPaint.setStyle(Paint.Style.FILL);
            // 根据当前颜色选择对比色
            var centerDotColor = getTextColor(currentColor);
            centerDotPaint.setColor(centerDotColor);
            var dotSize = 3 * dpi;
            canvas.drawRect(
                magnifierX - dotSize,
                magnifierY - dotSize,
                magnifierX + dotSize,
                magnifierY + dotSize,
                centerDotPaint
            );
        } catch (e) {
            toast("绘制错误: " + e);
            log("绘制错误: " + e + "\n" + e.stack);
        }
    });

    // 判断点是否在放大镜圆内（需要在绘制时动态计算放大镜位置）
    function isInMagnifier(x, y) {
        var dx = x - magnifierX;
        var dy = y - magnifierY;
        var distance = Math.sqrt(dx * dx + dy * dy);
        return distance <= MAGNIFIER_SIZE / 2;
    }

    // 判断点是否在第二圈（颜色环）上
    function isInColorRing(x, y) {
        var dx = x - magnifierX;
        var dy = y - magnifierY;
        var distance = Math.sqrt(dx * dx + dy * dy);
        var outerRadius = MAGNIFIER_SIZE / 2 + 15 * dpi;
        var innerRadius = MAGNIFIER_SIZE / 2;
        return distance > innerRadius && distance <= outerRadius;
    }

    // 触摸事件处理
    ui.run(function() {
        cv.setOnTouchListener(new android.view.View.OnTouchListener({
            onTouch: function(view, event) {
                var x = event.getX();
                var y = event.getY();
                switch (event.getAction()) {

                    case MotionEvent.ACTION_DOWN:
                        tapTime = Date.now();
                        tapX = x;
                        tapY = y;
                        isTouching = true;

                        // 判断是否在第二圈（颜色环）上
                        isTapOnColorRing = isInColorRing(x, y);

                        // 判断是否在放大镜内
                        isDraggingInMagnifier = isInMagnifier(x, y);

                        if (!isDraggingInMagnifier && !isTapOnColorRing) {
                            currentX = Math.max(0, Math.min(x, w - 1));
                            currentY = Math.max(0, Math.min(y, h - 1));
                        }

                        currentColor = getColorAt(currentX, currentY);
                        cv.invalidate();
                        break;

                    case MotionEvent.ACTION_MOVE:
                        if (isTouching) {
                            if (isDraggingInMagnifier) {
                                // 在放大镜内拖动：计算像素级移动
                                var dx = x - tapX;
                                var dy = y - tapY;

                                // 每移动 gridSize 距离，选中点移动 1 像素
                                var gridSize = MAGNIFIER_SIZE / MAGNIFIER_SCALE;
                                var pixelMoveX = Math.round(dx / gridSize);
                                var pixelMoveY = Math.round(dy / gridSize);

                                if (pixelMoveX != 0 || pixelMoveY != 0) {
                                    // 从当前实际选中点开始计算
                                    var newX = currentX + pixelMoveX;
                                    var newY = currentY + pixelMoveY;

                                    // 边界限制
                                    currentX = Math.max(0, Math.min(newX, w - 1));
                                    currentY = Math.max(0, Math.min(newY, h - 1));

                                    // 更新起始点，避免累积误差
                                    tapX = x;
                                    tapY = y;

                                    currentColor = getColorAt(currentX, currentY);
                                    cv.invalidate();
                                }
                            } else if (!isTapOnColorRing) {
                                // 在放大镜外拖动：跟随手指
                                currentX = Math.max(0, Math.min(x, w - 1));
                                currentY = Math.max(0, Math.min(y, h - 1));
                                currentColor = getColorAt(currentX, currentY);
                                cv.invalidate();
                            }

                            if (!isTapOnColorRing && !isMove) {
                                isMove = true
                                animation_menu(win, "hide");
                            }
                        }
                        break;

                    case MotionEvent.ACTION_UP:
                        if (isTapOnColorRing) {
                            // 点击第二圈（颜色环），传出当前颜色值
                            returnSelectColors.push({
                                x: Math.round(currentX),
                                y: Math.round(currentY),
                                color: currentColor,
                                hex: colorToHex(currentColor),
                                rgb: colorToRGB(currentColor)
                            });
                            颜色列表是否可见(win.colors, returnSelectColors)
                            utils.showToast("取色成功")
                            return true;
                        }
                    case MotionEvent.ACTION_CANCEL:
                        if (isMove) {
                            animation_menu(win, "show");
                            isMove = false
                        }
                        isTouching = false;
                        isDraggingInMagnifier = false;
                        isTapOnColorRing = false
                        cv.invalidate();
                        break;
                }
                return true;
            }
        }));
    });
    //颜色列表
    win.colors.on('click', function() {
        if (returnSelectColors.length === 0) {
            utils.showToast("暂无选中的颜色");
            return;
        }
        showColorListDialog.create("颜色列表", {
            colors: returnSelectColors,
            callback: function(type, selectedItem) {
                if (type == "select") {
                    // 定位到选中的坐标
                    currentX = selectedItem.x;
                    currentY = selectedItem.y;
                    currentColor = selectedItem.color;
                    cv.invalidate();
                } else if (type == "clear") {
                    win.colors.attr("visibility", "invisible")
                }
            }
        })
    });

    // 取消
    win.cancel.on('click', function() {
        win.close();
        events.removeListener("屏幕旋转", 屏幕旋转);
        typeof config.callback == "function" && config.callback("cancel", null);
    });
    //确定
    win.confirm.on('click', function() {
        win.cancel.click();
        typeof config.callback == "function" && config.callback("confirm", returnSelectColors);
    });

    setupRotationListener(win, config, function(data) {
        w = data.width;
        h = data.height;
        img = captureScreen();
        androidBitmap = img.getBitmap();
        cv.invalidate();
    });
}

function createWindow(config) {
    var paddingBottomHight = config.direction ? 按键栏h : 0
    var win = dialogsFloaty(
        <frame id="container" w="*" h="*">
            <canvas id="board" w="*" h="*" />
            <vertical id="title" w="*" h="auto" paddingTop={状态栏h+"px"} layout_gravity="top" bg="#88000000">
                <text text="点击圆圈取色" textColor="#FFFFFF" textSize="12dp" gravity="center"/>
            </vertical>
            <horizontal id="menu" paddingBottom={paddingBottomHight+"px"}  w="*" h="auto" layout_gravity="bottom" bg="#88000000">
                <button id="cancel" gravity="center" layout_weight="1" text="取消" textColor="#FF65A9" textSize="16dp"/>
                <button id="colors" gravity="center" layout_weight="1" text="颜色列表" textColor="#008BFF" textSize="16dp"/>
                <button id="confirm" gravity="center" layout_weight="1" text="确定" textColor="#008BFF" textSize="16dp"/>
            </horizontal>
        </frame>
    );

    win.hide()
    win.setPosition(0, 0);
    win.setSize(config.width, config.height);
    win.setBG("#00000000")
    win.setDimBehind(false)
    win.closed = function() {
        win.cancel.click()
    }

    var drawable = new GradientDrawable();
    drawable.setShape(GradientDrawable.RECTANGLE);
    drawable.setColor(Color.TRANSPARENT);
    drawable.setCornerRadius(8);
    win.confirm.setBackground(drawable);
    win.cancel.setBackground(drawable);
    win.show()
    return win;
}

function animation_menu(win, flag) {
    var state = menuStates.get(win);

    if (!state) {
        state = {
            animating: false,
            expanded: true
        };
        menuStates.set(win, state);
    } else {
        if (flag == "show" && state.expanded == true) return
        if (flag == "hide" && state.expanded == false) return

    }
    if (state.animating) return;
    state.animating = true;

    var anims = [];
    if (state.expanded) {
        anims[0] = ObjectAnimator.ofFloat(win.menu, "translationY", 0, win.menu.getHeight());
        anims[1] = ObjectAnimator.ofFloat(win.title, "translationY", 0, -win.title.getHeight());
    } else {
        anims[0] = ObjectAnimator.ofFloat(win.menu, "translationY", win.menu.getHeight(), 0);
        anims[1] = ObjectAnimator.ofFloat(win.title, "translationY", -win.title.getHeight(), 0);
    }

    var set = new AnimatorSet();
    set.playTogether(anims);
    set.setDuration(300);
    set.start();

    setTimeout(function() {
        state.animating = false;
        state.expanded = !state.expanded;
    }, 300);
}

function 颜色列表是否可见(view, list) {
    ui.run(() => {
        view.attr("visibility", list.length > 0 ? "visible" : "invisible")
    })
}

function 屏幕旋转处理(d, win, config, onRotate) {
    var screenSize = utils.getScreenSize();
    var data = {
        direction: d == "v" ? 1 : 0,
        width: screenSize.width,
        height: screenSize.height
    };
    config.direction = data.direction;
    config.width = data.width;
    config.height = data.height;

    ui.run(function() {
        win.setSize(data.width, data.height);
        win.container.attr("w", data.width + "px");
        win.container.attr("h", data.height + "px");
    });

    setTimeout(function() {
        if (typeof onRotate === "function") onRotate(data);
    }, 120);
}

function setupRotationListener(win, config, onRotate) {
    屏幕旋转.param = {
        win,
        config,
        onRotate
    };
    events.on("屏幕旋转", 屏幕旋转);
}

function 屏幕旋转(d) {
    var param = 屏幕旋转.param
    ui.run(() => {
        param.win.cancel.click()
    })
    //屏幕旋转处理(d, param.win, param.config, param.onRotate);
}

module.exports = {
    selectColor: selectColor
};