// 完整脚本：去掉选中区域蒙层版

importClass(android.graphics.drawable.GradientDrawable);
importPackage(android.graphics);
importClass(android.animation.ObjectAnimator);
importClass(android.animation.AnimatorSet);
importClass(android.view.MotionEvent);

var utils = require(files.join(files.cwd(), "utils.js"));
var dialogsFloaty = require("./dialogsFloaty.js")
var 状态栏h = utils.状态栏高度();
var 按键栏h = utils.getNavigationBarHeight();
var dpi = utils.getdeviceDpi().density;
utils.屏幕旋转(); // 初始化方向监听

var USE_DASH = false;
var USE_SCALED_BG = false;
var CLICK_TOLERANCE = 15 * dpi;
var menuStates = new WeakMap();

function testImg(config, img, arr) {
    if (!config) throw new Error("请传入设备信息对象");
    if (!utils.requestScreenCapture()) throw new Error("请求截图失败");
    if (!Array.isArray(arr)) throw new Error("请传入有效坐标数组");
    // arr.forEach(function(c) {
    //     if (!Array.isArray(c.coords) || c.coords.length !== 4) {
    //         throw new Error("每个元素必须是包含4个坐标值的数组");
    //     }
    // });

    img = img || captureScreen();
    var w = config.width,
        h = config.height;
    // 区域列表
    var regions = arr.map(function(item, i) {
        var coords = item.coords
        return {
            id: i,
            x1: coords[0],
            y1: coords[1],
            x2: coords[2],
            y2: coords[3],
            similarity: item.similarity
        };
    });
    var selectedRegionId = 0; // 默认选中第一个区域
    var lastInfo = {
        selectedId: -1
    };
    var infoUpdateTimer = null;

    // 绘制工具
    var L = Math.round(20 * dpi);
    var mtx = new Matrix();

    var maskPaint = new Paint();
    maskPaint.setStyle(Paint.Style.FILL);
    maskPaint.setARGB(150, 0, 0, 0);

    var borderPaint = new Paint();
    borderPaint.setStyle(Paint.Style.STROKE);
    borderPaint.setARGB(255, 255, 255, 255);
    borderPaint.setStrokeWidth(1 * dpi);
    if (USE_DASH) {
        borderPaint.setPathEffect(new android.graphics.DashPathEffect([10 * dpi, 6 * dpi], 0));
    }

    var rectPaint = new Paint();
    rectPaint.setStyle(Paint.Style.STROKE);
    rectPaint.setARGB(50, 255, 255, 255);
    rectPaint.setStrokeWidth(1 * dpi);
    rectPaint.setPathEffect(new android.graphics.DashPathEffect([5 * dpi, 2 * dpi], 0));

    var selectedBorderPaint = new Paint();
    selectedBorderPaint.setStyle(Paint.Style.STROKE);
    selectedBorderPaint.setARGB(255, 0, 99, 99);
    selectedBorderPaint.setStrokeWidth(1 * dpi);
    if (USE_DASH) {
        selectedBorderPaint.setPathEffect(new android.graphics.DashPathEffect([8 * dpi, 4 * dpi], 0));
    }

    var cornerPaint = new Paint();
    cornerPaint.setStyle(Paint.Style.STROKE);
    cornerPaint.setARGB(255, 255, 255, 255);
    cornerPaint.setStrokeWidth(1 * dpi);

    var selectedCornerPaint = new Paint();
    selectedCornerPaint.setStyle(Paint.Style.STROKE);
    selectedCornerPaint.setARGB(255, 0, 255, 255);
    selectedCornerPaint.setStrokeWidth(2 * dpi);

    var bmpPaint = new Paint();
    bmpPaint.setFilterBitmap(true);

    // 创建悬浮窗
    var win = createWindow(config);
    var cv = win.board;
    // 硬件加速
    cv.setLayerType(android.view.View.LAYER_TYPE_HARDWARE, null);
    cv.setMaxFps(60);
    // 背景处理
    var bg = img,
        bgMatrix = mtx;
    if (USE_SCALED_BG) {
        var scaled = images.resize(img, [w, h]);
        bg = scaled;
        bgMatrix = null;
    }

    var repaintFrame = null;

    function requestRepaint() {
        if (repaintFrame) return;
        repaintFrame = ui.post(function() {
            repaintFrame = null;
            cv.invalidate();
        }, 16);
    }

    function scheduleInfoUpdate() {

        infoUpdateTimer && clearTimeout(infoUpdateTimer);
        infoUpdateTimer = setTimeout(function() {
            infoUpdateTimer = null;
            if (selectedRegionId !== lastInfo.selectedId) {
                ui.run(function() {
                    if (selectedRegionId >= 0) {
                        var r = regions[selectedRegionId];
                        if (regions.length) {
                            win.Area.setText((selectedRegionId + 1) + "/" + regions.length);
                            win.Area.attr("visibility", "visible")
                        } else {
                            win.Area.setText("无");
                            win.Area.attr("visibility", "visible")
                        }
                        if (regions[selectedRegionId] && regions[selectedRegionId].similarity) {
                            win.coordinate.setText("" + regions[selectedRegionId].similarity + "%");
                            win.coordinate.attr("visibility", "visible")
                        } else {
                            win.coordinate.setText("");
                            win.coordinate.attr("visibility", "gone")
                        }

                    } else {
                        win.Area.setText("共" + regions.length + "个，点击选择");
                        win.coordinate.setText("『未选中任何区域』");
                        win.coordinate.attr("visibility", "visible")
                    }
                });
                lastInfo.selectedId = selectedRegionId;
            }
        }, 50);
    }
    scheduleInfoUpdate();
    requestRepaint()
    cv.on("draw", function(canvas) {
        canvas.drawColor(0, PorterDuff.Mode.CLEAR);

        // 背景
        if (bgMatrix) {
            canvas.drawImage(bg, bgMatrix, bmpPaint);
        } else {
            canvas.drawImage(bg, null, bmpPaint);
        }


        // 如果有选中，则只绘制边框和角线（完全去掉蒙层效果）
        if (selectedRegionId >= 0) {
            var r = regions[selectedRegionId] || {};
            var x1 = r.x1 | 0,
                y1 = r.y1 | 0,
                x2 = r.x2 | 0,
                y2 = r.y2 | 0;

            // 整体遮罩 - 不再使用，因为不需要蒙层效果
            canvas.save();
            canvas.clipRect(x1, y1, x2, y2, Region.Op.DIFFERENCE);
            canvas.drawPaint(maskPaint);
            canvas.restore();


            // 只绘制边框和角线，完全去掉蒙层和高亮
            canvas.drawRect(x1, y1, x2, y2, selectedBorderPaint);

            var cw = x2 - x1,
                ch = y2 - y1;
            var cornerL = Math.min(L, cw / 3, ch / 3);
            if (cornerL > 2 * dpi) {
                var p = selectedCornerPaint;
                // 左上
                canvas.drawLine(x1, y1, x1 + cornerL, y1, p);
                canvas.drawLine(x1, y1, x1, y1 + cornerL, p);
                // 右上
                canvas.drawLine(x2, y1, x2 - cornerL, y1, p);
                canvas.drawLine(x2, y1, x2, y1 + cornerL, p);
                // 右下
                canvas.drawLine(x2, y2, x2 - cornerL, y2, p);
                canvas.drawLine(x2, y2, x2, y2 - cornerL, p);
                // 左下
                canvas.drawLine(x1, y2, x1 + cornerL, y2, p);
                canvas.drawLine(x1, y2, x1, y2 - cornerL, p);
            }
        }

        // 绘制未选中区域的白色边框
        regions.forEach(function(r, i) {
            if (i === selectedRegionId) return;
            canvas.drawRect(r.x1, r.y1, r.x2, r.y2, borderPaint);
        });
        // 画限制区域
        if (Array.isArray(config.rect) && config.rect.length == 4) {
            var rect = config.rect
            canvas.drawRect(rect[0], rect[1], rect[0] + rect[2], rect[1] + rect[3], rectPaint);
        }
    });

    function getRegionAt(x, y) {
        return regions.findIndex(function(r) {
            return x >= r.x1 - CLICK_TOLERANCE &&
                x <= r.x2 + CLICK_TOLERANCE &&
                y >= r.y1 - CLICK_TOLERANCE &&
                y <= r.y2 + CLICK_TOLERANCE;
        });
    }

    cv.setOnTouchListener(function(view, ev) {
        if (ev.getAction() === MotionEvent.ACTION_UP) {
            var id = getRegionAt(ev.getRawX(), ev.getRawY());
            if (id >= 0) {
                if (selectedRegionId !== id) {
                    selectedRegionId = id;
                    scheduleInfoUpdate();
                    requestRepaint();
                }
            } else {
                animation_menu(win);
            }
        }
        return true;
    });

    win.cancel.on("click", function() {
        win.close();
        events.removeListener("屏幕旋转", 屏幕旋转);
        typeof config.callback === "function" && config.callback(null);
    });

    win.confirm.on("click", function() {
        if (USE_SCALED_BG && bg !== img) bg.recycle();
        win.cancel.click();
        typeof config.callback === "function" && config.callback();
    });

    win.prev.on("click", () => {
        selectedRegionId--;
        if (selectedRegionId < 0) {
            selectedRegionId = regions.length - 1
        }
        scheduleInfoUpdate();
        requestRepaint();
    })

    win.next.on("click", () => {
        selectedRegionId++;
        if (selectedRegionId > regions.length - 1) {
            selectedRegionId = 0
        }
        scheduleInfoUpdate();
        requestRepaint();
    })

    setupRotationListener(win, config, function(data) {
        w = data.width;
        h = data.height;
        if (USE_SCALED_BG) {
            if (bg && bg !== img) bg.recycle();
            img = captureScreen();
            bg = images.resize(img, [w, h]);
            bgMatrix = null;
        }
        requestRepaint();
    });
}

function createWindow(config) {
    var paddingBottomHight = config.direction ? 按键栏h : 0
    var win = dialogsFloaty(
        <frame id="container" w="*" h="*">
            <canvas id="board" w="*" h="*" />
            <vertical id="title" w="*" h="auto" paddingTop={状态栏h+"px"} layout_gravity="top" bg="#88000000">
                <text text="识别结果" textColor="#FFFFFF" textSize="12dp" gravity="center"/>
            </vertical>
            <horizontal id="menu" paddingBottom={paddingBottomHight+"px"}  w="*" h="auto" layout_gravity="bottom" bg="#88000000">
                <button id="cancel" layout_weight="1" text="取消" textColor="#FF65A9" textSize="16dp"/>
                <img id="prev" tint="#ffffff" layout_gravity="center" src="@drawable/ic_keyboard_arrow_left_black_48dp" />
                <vertical layout_gravity="center" id="input_btn" layout_weight="3" gravity="center">
                    <text visibility="gone" text="" id="Area" textColor="#FFFFFF" textSize="12dp" gravity="center"/>
                    <text visibility="gone" text="" id="coordinate" textColor="#FFFFFF" textSize="12dp" gravity="center"/>
                </vertical>
                <img id="next" tint="#ffffff" layout_gravity="center" src="@drawable/ic_keyboard_arrow_right_black_48dp" />
                <button id="confirm" layout_weight="1" text="确定" textColor="#008BFF" textSize="16dp"/>
            </horizontal>
        </frame>
    );
    win.hide()
    win.setPosition(0, 0);
    win.setSize(config.width, config.height);
    win.setBG("#00000000")
    win.setDimBehind(false)
    win.closed = function() {
        win.cancel.click()
    }
    var drawable = new GradientDrawable();
    drawable.setShape(GradientDrawable.RECTANGLE);
    drawable.setColor(Color.TRANSPARENT);
    drawable.setCornerRadius(8);
    win.confirm.setBackground(drawable);
    win.cancel.setBackground(drawable);
    win.show()
    return win;
}

function animation_menu(win) {
    var state = menuStates.get(win) || {
        animating: false,
        expanded: true
    };
    if (state.animating) return;
    state.animating = true;
    menuStates.set(win, state);
    var anims = [];
    if (state.expanded) {
        anims[0] = ObjectAnimator.ofFloat(win.menu, "translationY", 0, win.menu.getHeight());
        anims[1] = ObjectAnimator.ofFloat(win.title, "translationY", 0, -win.title.getHeight());
    } else {
        anims[0] = ObjectAnimator.ofFloat(win.menu, "translationY", win.menu.getHeight(), 0);
        anims[1] = ObjectAnimator.ofFloat(win.title, "translationY", -win.title.getHeight(), 0);
    }
    var set = new AnimatorSet();
    set.playTogether(anims);
    set.setDuration(300);
    set.start();
    setTimeout(function() {
        state.animating = false;
        state.expanded = !state.expanded;
    }, 300);
}

function 屏幕旋转处理(d, win, config, onRotate) {
    var screenSize = utils.getScreenSize();
    var data = {
        direction: d === "v" ? 1 : 0,
        width: screenSize.width,
        height: screenSize.height
    };
    config.direction = data.direction;
    config.width = data.width;
    config.height = data.height;
    ui.post(function() {
        win.setSize(data.width, data.height);
        win.container.attr("w", data.width + "px");
        win.container.attr("h", data.height + "px");
        win.title.attr("h", Math.round((data.direction ? 1 : 0.5) * 状态栏h / dpi) + 20);
        win.menu.attr("h", Math.round((data.direction ? 1 : 0.3) * 按键栏h / dpi) + 30);
    }, 16);
    setTimeout(function() {
        onRotate && onRotate(data);
    }, 120);
}

function setupRotationListener(win, config, onRotate) {
    屏幕旋转.param = {
        win,
        config,
        onRotate
    };
    events.on("屏幕旋转", 屏幕旋转);
}

function 屏幕旋转(d) {
    var p = 屏幕旋转.param;
    // 旋转时关闭
    ui.post(() => {
        p.win.cancel.click();
    })
    // 如果要保持重绘可注释上行并启用以下行
    //屏幕旋转处理(d, p.win, p.config, p.onRotate);
}
/*
// 使用示例
var config = {
    width: 1080,
    height: 2374,
    type: "img",
};
var coordinatesArray = [{
        coords: [100, 200, 300, 400],
        similarity: 90
    },
    {
        coords: [500, 600, 700, 800],
        similarity: 80
    },
    {
        coords: [200, 900, 400, 1100],

    }
];
utils.requestScreenCapture()
sleep(1000)
selectImg(config, null, coordinatesArray);
*/

module.exports = testImg