var xml =
    <frame id="root_view"> <!-- 浅灰背景 -->
    <vertical padding="12 12 12 50" w="*" h="*">
        <vertical >
            <!-- 顶部标题栏 -->
            <frame w="*" h="50" bg="#3F51B5"> <!-- 靛蓝主色 -->
                <text id="title" text="设置" textColor="#ffffff" textSize="18sp"
                gravity="center" layout_gravity="center"/>
            </frame>
            
            <frame w="*" layout_weight="1">
                <list w="*" id="list">
                    <vertical w="*">
                        <text text="{{name}}" margin="0 8" gravity="center" padding="8 6"
                        w="*" h="48" textSize="16sp" textColor="#333333"
                        bg="#E8EAF6"/> <!-- 浅蓝灰背景 -->
                    </vertical>
                </list>
            </frame>
        </vertical>
    </vertical>
    <frame w="*" h="auto" layout_gravity="bottom">
        <vertical w="*" h="50" layout_gravity="bottom" bg="#FFFFFF">
            <text w="*" h="1px" bg="#333333" />
            <horizontal h="*" gravity="center">
                <text layout_weight="1" id="cancel_btn" text="返回"
                w="0" h="*" gravity="center" backgroundTint="#EAEAEA" textColor="#333333"/>
            </horizontal>
        </vertical>
    </frame>
</frame>

var utils = require(files.join(files.cwd(), "utils.js"))
var dialogsFloaty = require(files.join(files.cwd(), "ui/dialogsFloaty.js"));

var singArr = [];
var mappingF = {}
var maxHeight = 0

var 设置Ui = function(title) {
    var rw = dialogsFloaty(xml)
    // 悬浮窗关闭处理事件
    rw.closed = function() {
        // 清理映射和数组
        singArr = singArr.filter(e => e != title)
        delete mappingF[title]
        // 先执行回调
        rw.close()
    }
    rw.hide()
    rw.setRadius(25)
    rw.setOverflowHide(true)
    init(rw, title)
    return rw
}

function ui居中(title) {
    var rw = mappingF[title]
    if (!rw) {
        console.error("未找到窗口: " + title)
        return
    }

    var screen = utils.getScreenSize()
    var width = screen.width
    var height = screen.height

    ui.post(() => {
        try {
            // 按屏幕比例算宽高
            var newW = Math.floor(width * 0.8)
            var newH = Math.floor(height * 0.8)

            // 最小限制
            var minW = 400
            var minH = 400
            if (newW < minW) newW = minW
            if (newH < minH) newH = minH

            // 最大限制
            var maxW = 1000
            var maxH = 1000
            if (newW > maxW) newW = maxW
            //if (newH > maxH) newH = maxH
            var fH = rw.getSize().height
            if (fH > newH) {
                fH = newH
            }
            rw.setSize(newW, fH)
            maxHeight = fH
            // 居中
            // var x = Math.floor((width - newW) / 2)
            // var y = Math.floor((height - fH) / 2)
            // rw.setPosition(x, y)
            rw.center()
            rw.show()
        } catch (e) {
            console.error("居中窗口失败: " + e)
        }
    })
}

function init(rw, title) {
    // 添加空数据检查
    if (!rw.list) {
        console.error("list组件未找到")
        return
    }

    rw.list.on("item_click", function(item, i, itemView, listView) {
        try {
            if (item && typeof item.event == "function") {
                item.event(item, i, itemView, listView, function() {
                    ui.post(() => {
                        let measuredHeight = rw.root_view.getMeasuredHeight();
                        if (measuredHeight < rw.getHeight()) {
                            rw.setSize(rw.getWidth(), -2)
                        } else if (measuredHeight > maxHeight) {
                            rw.setSize(rw.getWidth(), maxHeight)
                        }
                    })
                })
            }
        } catch (e) {
            console.error("点击事件执行失败: " + e)
        }
    });

    // 取消
    rw.cancel_btn.on("click", () => {
        try {
            singArr = singArr.filter(e => e != title)
            delete mappingF[title]
            rw.close()
        } catch (e) {
            console.error("关闭窗口失败: " + e)
        }
    })
}

function create(title, arr) {
    // 如果已存在，先关闭旧的
    if (singArr.indexOf(title) != -1) {
        close(title)
    }

    try {
        var rw = 设置Ui(title)
        singArr.push(title)
        mappingF[title] = rw

        if (rw.title) {
            rw.title.attr("text", title)
        }

        if (rw.list && arr) {
            rw.list.setDataSource(arr, false)
        }

        ui居中(title)
        return rw
    } catch (e) {
        console.error("创建窗口失败: " + e)
        // 清理
        singArr = singArr.filter(e => e != title)
        delete mappingF[title]
        return null
    }
}

function close(title) {
    try {
        if (mappingF[title]) {
            var rw = mappingF[title]
            singArr = singArr.filter(e => e != title)
            delete mappingF[title]
            rw.close()
        }
    } catch (e) {
        console.error("关闭窗口失败: " + e)
    }
}

module.exports = {
    create,
    close,
    center: ui居中
}