var xml =
    <frame id="root_view">
    <vertical>
        
        <frame w="*" h="60" padding="12">
            <button h="50" layout_gravity="left|center" id="generate_btn" text="生成"
            style="Widget.AppCompat.Button.Colored" w="auto" backgroundTint="#EAEAEA" textColor="#333333"/>
            
            <button h="50" layout_gravity="right|center" id="test_btn" text="测试"
            style="Widget.AppCompat.Button.Colored" w="auto" backgroundTint="#EAEAEA" textColor="#333333"/>
        </frame>
        
        <frame w="*" h="*">
            <androidx.core.widget.NestedScrollView padding="12 0 12 50" w="*" h="*">
                <vertical>
                    <horizontal gravity="left|center" h="60" marginTop="10">
                        <text text="图片" textColor="#333333"/>
                        <img visibility="gone" h="*" w="60" id="img_btn" borderWidth="1px" borderColor="#CCCCCC" />
                        <button visibility="gone" id="img_btn2" text="设置" style="Widget.AppCompat.Button.Colored" w="auto"
                        backgroundTint="#EAEAEA" textColor="#333333"/>
                    </horizontal>
                    <horizontal gravity="left|center" h="60">
                        <text text="限制区域" textColor="#333333"/>
                        <button id="rect_btn" style="Widget.AppCompat.Button.Colored" w="auto" text="选择"
                        backgroundTint="#EAEAEA" textColor="#333333"/>
                    </horizontal>
                    <horizontal gravity="left|center" h="60">
                        <text text="相似度" textColor="#333333"/>
                        <seekbar progress="90" id="similarity_seekbar" layout_weight="1" />
                        <text gravity="center" id="input_seekbar" w="35" text="90" textColor="#333333"/>
                        <text text="%" textColor="#333333"/>
                    </horizontal>
                    <horizontal gravity="left|center" h="60">
                        <text text="测试对象" textColor="#333333"/>
                        <button id="test_img" text="屏幕" style="Widget.AppCompat.Button.Colored" w="auto"
                        backgroundTint="#EAEAEA" textColor="#333333"/>
                    </horizontal>
                    <horizontal gravity="left|center" h="60">
                        <text text="测试方法" textColor="#333333"/>
                        <button id="test_fun" text="模板" style="Widget.AppCompat.Button.Colored" w="auto"
                        backgroundTint="#EAEAEA" textColor="#333333"/>
                    </horizontal>
                    <horizontal gravity="left|center" h="60">
                        <text text="滤镜" textColor="#333333"/>
                        <button id="filter_img" text="设置" style="Widget.AppCompat.Button.Colored" w="auto"
                        backgroundTint="#EAEAEA" textColor="#333333"/>
                    </horizontal>
                </vertical>
            </androidx.core.widget.NestedScrollView>
            <vertical w="*" h="50" layout_gravity="bottom" >
                <text w="*" h="1px" bg="#333333" />
                <horizontal h="*" gravity="center">
                    <text layout_weight="1" id="cancel_btn" text="取消"
                    w="0" h="*" gravity="center" backgroundTint="#EAEAEA" textColor="#333333"/>
                    <text w="1px" h="*" bg="#333333" />
                    <text layout_weight="1" id="confirm_btn" text="确认"
                    w="0" h="*" gravity="center" backgroundTint="#EAEAEA" textColor="#333333"/>
                </horizontal>
            </vertical>
        </frame>
        
    </vertical>
</frame>

var utils = require(files.join(files.cwd(), "utils.js"))
// 选择文件
var selectFile = require(files.join(files.cwd(), "./ui/selectFile.js"))
var 获取图片 = require(files.join(files.cwd(), "/ui/获取图片.js"));
var 测试图片 = require(files.join(files.cwd(), "/ui/测试图片.js"));
var 滤镜设置 = require(files.join(files.cwd(), "/ui/滤镜设置.js"));
var testFun = require(files.join(files.cwd(), "/js/testImgFun.js"));
var dialogsFloaty = require(files.join(files.cwd(), "ui/dialogsFloaty.js"))
var {
    滤镜流水线
} = require(files.join(files.cwd(), "/js/filterFun.js"));
var bladeMenu = require(files.join(files.cwd(), "/ui/bladeMenu.js"));
var dropUpMenu = require(files.join(files.cwd(), "/ui/dropUpMenu.js"));
var copyCode = require(files.join(files.cwd(), "./js/copyCode.js"))
var singArr = []
var mappingF = {}
var callback = {}
var redrawFun = {}


var testConfig = {}
var clipImgFile = files.join(files.cwd(), "clip/clipImgFile.png")
files.ensureDir(clipImgFile)
var storageClip = storages.create("clip")
var cacheFile = files.join(files.cwd(), "cache/")

var 设置Ui = function(title, data) {
    var rw = dialogsFloaty(xml)
    // 悬浮窗关闭处理事件
    rw.closed = function() {
        rw.cancel_btn.click()
    }
    rw.hide()
    rw.setRadius(25)
    rw.setSize(-2, -2)
    //rw.setOverflowHide(true)
    init(rw, title, data)
    return rw
}

function ui居中(title) {
    var rw = mappingF[title]
    var screen = utils.getScreenSize()
    var width = screen.width
    var height = screen.height
    ui.post(() => {
        // 按屏幕比例算宽高
        var newW = Math.floor(width * 0.8)
        var newH = Math.floor(height * 0.8)

        // 最小限制
        var minW = 400
        var minH = 400
        if (newW < minW) newW = minW
        if (newH < minH) newH = minH

        // 最大限制
        var maxW = 1000
        var maxH = 1000
        if (newW > maxW) newW = maxW
        //if (newH > maxH) newH = maxH
        var fH = rw.getSize().height
        if (fH > newH) {
            fH = newH
        }
        rw.setSize(newW, fH)

        // 居中
        // var x = Math.floor((width - newW) / 2)
        // var y = Math.floor((height - fH) / 2)
        // rw.setPosition(x, y)
        rw.center()
        rw.show()
    })
}
// 生成处理
function generateHandle(name) {
    var result = copyCode[testConfig.type][name](testConfig)
    模板列表.close("生成")
}

function init(rw, title, data) {
    // 生成代码
    rw.generate_btn.on("click", () => {
        var templatePath = testConfig.imgPath || data.path
        if (!templatePath) {
            toast("不符合")
            return
        }
        // 还没有名字
        if (testConfig.name == undefined) {
            var name = "取图" + new Date().getTime();
            utils.弹窗输入框(function(value) {
                value = value.replace(/[/\\?%*:|"<>]/g, "_");
                if (value) name = value;
                testConfig.name = name
            }, {
                title: "保存的名字",
                inputHint: name.toString(),
                isValue: true
            });
            return
        }
        var arr = Object.keys(copyCode[data.type])
        arr = arr.map(e => {
            return {
                name: e,
                event: function(item) {
                    generateHandle(item.name)
                }
            }
        })
        模板列表.create("生成", arr)
    })
    // 测试图片
    rw.test_btn.on("click", () => {
        var templatePath = testConfig.imgPath || data.path

        if (!templatePath) {
            toast("不符合")
            return
        }
        //识别的图片
        var targetImg = images.read(templatePath)
        // 识别的图片滤镜后
        var template
        var bigTmp
        var screenSize = utils.getScreenSize();
        var img_select_config = {
            direction: utils.屏幕方向() == "v" ? 1 : 0,
            width: screenSize.width,
            height: screenSize.height,
            type: "test_img",
            rect: testConfig.identifyArea || [],
            callback: function(data) {
                try {
                    ui.post(() => {
                        bigTmp.recycle()
                        targetImg.recycle()
                    })
                    //悬浮窗显示
                    rw.show()
                } catch (e) {}
            }
        }
        if (testConfig.testFun == "模板") {
            // 识别参数
            template = 滤镜流水线(targetImg, testConfig.filters)
            var options = {
                max: 50,
                threshold: testConfig.similarity / 100
            }
            if (testConfig.identifyArea.length) {
                var identifyArea = testConfig.identifyArea
                options.region = [identifyArea[0], identifyArea[1], identifyArea[2], identifyArea[3]]
            }
        } else if (testConfig.testFun == "轮廓") {
            var options = {
                max: 50,
                threshold: testConfig.similarity / 100
            }
            if (testConfig.identifyArea.length) {
                var identifyArea = testConfig.identifyArea
                options.region = [identifyArea[0], identifyArea[1], identifyArea[2], identifyArea[3]]
            }
            template = 滤镜流水线(targetImg, testConfig.filters, "mat")
        }

        //悬浮窗隐藏
        rw.hide()
        setTimeout(() => {
            try {
                if (!testFun[testConfig.testFun]) {
                    throw 函数不存在
                }
                var img = captureScreen()
                var arr
                if (testConfig.testFun == "模板") {
                    bigTmp = 滤镜流水线(img, testConfig.filters)
                    var time = Date.now()
                    var result = testFun[testConfig.testFun](bigTmp, template, options)
                    var templateW = template.getWidth()
                    var templateH = template.getHeight()
                    template.recycle()
                    result.matches.sort((a, b) => {
                        return a.point.y > b.point.y
                    })
                    arr = result.matches.map(match => {
                        var x1 = match.point.x
                        var y1 = match.point.y
                        var x2 = match.point.x + templateW
                        var y2 = match.point.y + templateH
                        similarity = parseInt(match.similarity * 100)
                        return {
                            coords: [x1, y1, x2, y2],
                            similarity
                        }
                    });
                } else if (testConfig.testFun == "轮廓") {

                    var bigMat = 滤镜流水线(img, testConfig.filters, "mat")
                    var result = testFun[testConfig.testFun](bigMat, template, options)
                    bigTmp = 滤镜流水线(bigMat, null, "img")
                    bigMat.recycle && bigMat.recycle()
                    bigMat.release && bigMat.release()
                    arr = result.map((e) => {
                        return {
                            coords: [e.x, e.y, e.x + e.width, e.y + e.height],
                            similarity: e.percentage
                        }
                        
                    })

                }

                测试图片(img_select_config, bigTmp, arr)
            } catch (e) {
                log(e)
                //悬浮窗显示
                rw.show()
                if (template) {
                    template.recycle && template.recycle()
                    template.release && template.release()
                    bigTmp.recycle && bigTmp.recycle()
                    bigTmp.release && bigTmp.release()
                    targetImg.recycle()
                }
            }
        }, 250)
    })
    // 取消
    rw.cancel_btn.on("click", () => {
        rw.close()
        callbackHandle(title, "cancel", null)
        singArr = singArr.filter(e => e != title)
        events.removeListener("屏幕旋转", redrawFun[title])
    })
    // 确认
    rw.confirm_btn.on("click", () => {
        if (!rw.img_btn.attr("src")) {
            toast("没有图片")
            return
        }
        // 新创建
        if (!data.path) {
            var name = testConfig.name || "取图" + new Date().getTime();
            utils.弹窗输入框(function(value) {
                value = value.replace(/[/\\?%*:|"<>]/g, "_");
                if (value) name = value;
                var result = {
                    name,
                    similarity: testConfig.similarity,
                    rect: testConfig.rect,
                    imgPath: testConfig.imgPath,
                    identifyArea: testConfig.identifyArea,
                    ext: testConfig.ext,
                    type: data.type,
                    filters: testConfig.filters
                }
                callbackHandle(title, "create", result)
            }, {
                title: "保存的名字",
                inputHint: name.toString(),
                isValue: true
            });
        } else {
            var result = {
                name: data.name,
                similarity: testConfig.similarity,
                rect: testConfig.rect,
                imgPath: testConfig.imgPath,
                identifyArea: testConfig.identifyArea,
                ext: testConfig.ext,
                type: data.type,
                filters: testConfig.filters
            }
            callbackHandle(title, "updata", result)

        }
    })
    // 点击图片
    rw.img_btn.on("click", () => {
        设置图片(rw)
    })
    //长按图片
    function pasteImg() {
        var clipJson = storageClip.get("clip")
        try {
            var clip = JSON.parse(clipJson)
            if (clip.type != "img") throw "no img"
            testConfig.imgPath = clip.content
            testConfig.rect = clip.rect
            rw.img_btn.attr("src", "file://" + clip.content)
            rw.img_btn.attr("visibility", "visible")
            rw.img_btn2.attr("visibility", "gone")

        } catch (e) {
            toast("不符合")
        }
    }
    rw.img_btn.on("long_click", (event, view) => {
        event.consumed = true
        bladeMenu.create(view, [{
                name: "复制",
                event: function() {
                    var path = testConfig.imgPath || testConfig.path
                    storageClip.put("clip", JSON.stringify({
                        type: "img",
                        content: clipImgFile,
                        rect: testConfig.rect
                    }))
                    files.copy(path, clipImgFile)
                }
            },
            {
                name: "粘贴",
                event: function() {
                    pasteImg()
                }
            }
        ])
    })

    //长按图片按钮
    rw.img_btn2.on("long_click", (event, view) => {
        event.consumed = true
        bladeMenu.create(view, [{
            name: "粘贴",
            event: function() {
                pasteImg()
            }
        }])
    })

    // 点击图片按钮
    rw.img_btn2.on("click", () => {
        设置图片(rw)
    })
    // 长按限制区域
    rw.rect_btn.on("long_click", (event, view) => {
        event.consumed = true
        var arr = [{
            name: "粘贴",
            event: function() {
                var clipJson = storageClip.get("clip")
                try {
                    var clip = JSON.parse(clipJson)
                    if (clip.type != "area") throw "no area"
                    testConfig.identifyArea = clip.content
                    rw.rect_btn.attr("text", clip.content.length ? clip.content : "选择")
                } catch (e) {
                    toast("不符合")
                }
            }
        }]
        if (testConfig.identifyArea.length) {
            arr.unshift({
                name: "复制",
                event: function() {
                    setClip(JSON.stringify(testConfig.identifyArea))
                    storageClip.put("clip", JSON.stringify({
                        type: "area",
                        content: testConfig.identifyArea
                    }))
                }
            })
            arr.push({
                name: "删除",
                event: function() {
                    rw.rect_btn.attr("text", "选择")
                    testConfig.identifyArea = []
                }
            })
        }
        bladeMenu.create(view, arr)
    })
    // 点击限制区域
    rw.rect_btn.on("click", () => {
        设置区域(rw)
    })
    // 相似度滑动
    rw.similarity_seekbar.setOnSeekBarChangeListener({
        onProgressChanged: (seekbar, progress, fromUser) => {
            rw.input_seekbar.attr("text", progress)
            testConfig.similarity = progress
        },
    });

    rw.input_seekbar.on("click", () => {
        utils.弹窗输入框(function(value) {
            if (/[^\d]/g.test(value)) {
                toast("请输入纯数字")
                return
            }
            if (value > 100) value = 100
            if (value < 0) value = 0
            rw.input_seekbar.attr("text", value)
            rw.similarity_seekbar.attr("progress", value)
            testConfig.similarity = value
        }, {
            title: "输入相似度",
            inputHint: "0-100"
        })
    })
    //测试来源
    rw.test_img.on("click", (view) => {
        var items = [{
            name: "屏幕",
            event: function() {
                testConfig.testImg = "屏幕"
                rw.test_img.attr("text", "屏幕")
            }
        }, {
            name: "选择",
            event: function() {
                testConfig.testImg = "选择"
                rw.test_img.attr("text", "选择")

            }
        }]
        dropUpMenu.create(view, items)

    })

    function testFunHandel(type) {
        testConfig.testFun = type
        rw.test_fun.attr("text", type)
    }
    //测试方法
    rw.test_fun.on("click", (view) => {
        var items = Object.keys(testFun).map(name => {
            return {
                name,
                event: testFunHandel
            }
        })
        dropUpMenu.create(view, items)
    })
    //滤镜设置
    rw.filter_img.on("click", () => {
        //悬浮窗隐藏
        rw.hide()
        var params = {
            filterList: testConfig.filters || [],
            callback(type, data) {
                //悬浮窗显示
                rw.show()
                if (type == "cancel" || !data) {
                    //testConfig.filters = []
                    //log("不保存")
                    return
                }
                testConfig.filters = data
                rw.filter_img.attr("text", testConfig.filters.length ? "已设置" : "未设置")
            }
        }

        滤镜设置.create("滤镜设置", params)
    })
    // 长按滤镜
    rw.filter_img.on("long_click", (event, view) => {
        event.consumed = true
        var arr = [{
            name: "粘贴",
            event: function() {
                var clipJson = storageClip.get("clip")
                try {
                    var clip = JSON.parse(clipJson)
                    if (clip.type != "filters") throw "no filters"
                    testConfig.filters = clip.content
                    rw.filter_img.attr("text", clip.content.length ? "已设置" : "未设置")
                } catch (e) {
                    toast("不符合")
                }
            }
        }]
        if (testConfig.filters.length) {
            arr.unshift({
                name: "复制",
                event: function() {
                    setClip(JSON.stringify(testConfig.identifyArea))
                    storageClip.put("clip", JSON.stringify({
                        type: "filters",
                        content: testConfig.filters
                    }))
                }
            })
            arr.push({
                name: "删除",
                event: function() {
                    rw.filter_img.attr("text", "未设置")
                    testConfig.filters = []
                }
            })
        }
        bladeMenu.create(view, arr)
    })
}

function 设置区域(rw) {
    var screenSize = utils.getScreenSize();
    var img_select_config = {
        direction: utils.屏幕方向() == "v" ? 1 : 0,
        width: screenSize.width,
        height: screenSize.height,
        type: "area",
        rect: testConfig.identifyArea ? testConfig.identifyArea : [],
        callback: function(data) {
            try {
                //悬浮窗显示
                rw.show()
                if (data) {
                    rw.rect_btn.attr("text", data.rect)
                    testConfig.identifyArea = data.rect
                }
            } catch (e) {}
        }
    }
    //悬浮窗隐藏
    rw.hide()
    setTimeout(() => {
        获取图片.selectImg(img_select_config)
    }, 250)
}

function 设置图片(rw) {
    var screenSize = utils.getScreenSize();
    var img_select_config = {
        direction: utils.屏幕方向() == "v" ? 1 : 0,
        width: screenSize.width,
        height: screenSize.height,
        type: "img",
        rect: testConfig.rect ? testConfig.rect : [],
        saveDir: cacheFile,
        callback: function(data) {
            //悬浮窗显示
            rw.show()
            if (data) {
                rw.img_btn2.attr("visibility", "gone")
                rw.img_btn.attr("visibility", "visible")
                testConfig.imgPath = files.join(cacheFile, data.name + data.ext)
                rw.img_btn.attr("src", "file://" + testConfig.imgPath)
                testConfig.rect = data.rect
                testConfig.ext = data.ext
            }
        }
    };
    //悬浮窗隐藏
    rw.hide()
    setTimeout(() => {
        获取图片.selectImg(img_select_config)
    }, 250)
}

function create(title, data) {
    try {
        files.removeDir(cacheFile)
    } catch (e) {}
    var singI = singArr.indexOf(title)
    if (singI != -1 || !data) return
    var rw = 设置Ui(title, data)
    singArr.push(title)
    mappingF[title] = rw
    callback[title] = data.callback
    ui居中(title)
    testConfig = {
        similarity: 90,
        identifyArea: [],
        testFun: "模板",
        testImg: "屏幕",
        filters: []
    }
    Object.assign(testConfig, utils.deepClone(data))
    ui.run(() => {
        if (files.exists(data.path)) {
            rw.img_btn.attr("src", "file://" + data.path)
            rw.img_btn.attr("visibility", "visible")
        } else {
            rw.img_btn2.attr("visibility", "visible")
        }
        rw.rect_btn.attr("text", data.identifyArea && data.identifyArea.length ? data.identifyArea : "选择")
        rw.filter_img.attr("text", data.filters && data.filters.length ? "已设置" : "未设置")
        rw.similarity_seekbar.attr("progress", testConfig.similarity)
    })
    redrawFun[title] = ((title, data) => {
        return function() {
            singArr.splice(singI, 1)
            ui.run(() => {
                close(title)
            })
            //create(title, data)
        }
    })(title, data)
    events.on("屏幕旋转", redrawFun[title])
    return rw
}

function callbackHandle(title, eventType, data) {
    if (typeof callback[title] != "function") {
        toast("请传入处理函数")
        return
    }
    callback[title](eventType, data)
}

function close(title) {
    if (mappingF[title]) {
        mappingF[title].cancel_btn.click()
        delete mappingF[title]
    }
}

/*
utils.requestScreenCapture()
var r = create("图片详情", {
    path: "/storage/emulated/0/图色工具/测试/images/测试.png"
})
*/


module.exports = {
    create,
    close,
    center: ui居中
}