var xml =
    <frame id="root_view">
    <vertical>
        <frame w="*" h="auto">
            <vertical padding="12 12 12 62" h="auto">
                <list id="list" minWidth="500">
                    <card margin="5" cardBackgroundColor="#F0F3E8" cardCornerRadius="8"
                    w="*" contentPadding="0 8">
                    <horizontal layout_gravity="center">
                        <horizontal layout_gravity="center" layout_weight="1">
                            <text id="item" margin="5 0" w="20" h="20" bg="{{hex}}" />
                            <text id="hex" margin="5 0" textSize="16sp" textColor="#000000" text="{{hex}}" />
                            <text id="point" margin="5 0" textSize="16sp" textColor="#000000" text="{{`[${x},${y}]`}}" />
                        </horizontal>
                        <text gravity="center" w="40" h="30" margin="5 0" bg="#FE5E08" textColor="#ffffff" padding="10 5" id="deleteItem" text="删除" />
                    </horizontal>
                </card>
            </list>
        </vertical>
        <vertical w="*" h="50" layout_gravity="bottom" >
            <text w="*" h="1px" bg="#333333" />
            <horizontal h="*" gravity="center">
                <text layout_weight="1" id="cancel_btn" text="返回"
                w="0" h="*" gravity="center" backgroundTint="#EAEAEA" textColor="#333333"/>
                <text w="1px" h="*" bg="#333333" />
                <text layout_weight="1" id="clear_btn" text="清空"
                w="0" h="*" gravity="center" backgroundTint="#EAEAEA" textColor="#333333"/>
            </horizontal>
        </vertical>
    </frame>
    
</vertical>
</frame>

var utils = require(files.join(files.cwd(), "utils.js"))
var dialogsFloaty = require("./dialogsFloaty.js");
var showToast = require("./showToast.js")
var singArr = []
var mappingF = {}
var callback = {}
var redrawFun = {}
//限制的高度
var restrictionHeight = 0;

var colorsMap = {}

var filterEdit = null

var storageClip = storages.create("clip")
var cacheFile = files.join(files.cwd(), "cache/")

var 设置Ui = function(title, data) {
    var rw = dialogsFloaty(xml)
    // 悬浮窗关闭处理事件
    rw.closed = function() {
        // 先执行回调
        callbackHandle(title, "cancel", null)

        cleanup(title)
    }
    rw.hide()
    rw.setRadius(25)
    //rw.setOverflowHide(true)
    colorsMap[title] = data.colors || [];
    rw.list.setDataSource(colorsMap[title], false);

    init(rw, title, data)
    return rw
}

function ui居中(title) {
    var rw = mappingF[title]
    var screen = utils.getScreenSize()
    var width = screen.width
    var height = screen.height
    ui.post(() => {
        // 按屏幕比例算宽高
        var newW = Math.floor(width * 0.8)
        var newH = Math.floor(height * 0.8)

        // 最小限制
        var minW = 400
        var minH = 400
        if (newW < minW) newW = minW
        if (newH < minH) newH = minH

        // 最大限制
        var maxW = 1000
        var maxH = 1000
        if (newW > maxW) newW = maxW
        //if (newH > maxH) newH = maxH
        var fH = rw.getSize().height
        if (fH > newH) {
            fH = newH
        }
        restrictionHeight = newH
        rw.setSize(newW, fH)
        // 居中
        // var x = Math.floor((width - newW) / 2)
        // var y = Math.floor((height - fH) / 2)
        // rw.setPosition(x, y)
        rw.center()
        rw.show()
    })
}

// 清理资源的统一函数
function cleanup(title) {
    // 移除屏幕旋转监听
    if (redrawFun[title]) {
        events.removeListener("屏幕旋转", redrawFun[title])
        delete redrawFun[title]
    }

    // 从数组中移除
    let index = singArr.indexOf(title)
    if (index !== -1) {
        singArr.splice(index, 1)
    }

    // 清理映射
    delete mappingF[title]
    delete callback[title]
}

function init(rw, title, data) {
    // 点击颜色项
    // rw.list.on("item_click", function(item, i, itemView, listView) {
    //     callbackHandle(title, "select", item)
    //     rw.close()
    // });
    // 设置颜色项事件
    rw.list.on("item_bind", function(itemView, itemHolder) {
        var delText = itemView.deleteItem
        var drawable = new android.graphics.drawable.GradientDrawable();
        drawable.setColor(android.graphics.Color.parseColor("#FE5E08")); // 背景色
        drawable.setCornerRadius(8); // 圆角半径
        delText.setBackground(drawable);
        delText.setTextColor(android.graphics.Color.WHITE);
        delText.setPadding(10, 5, 10, 5);

        itemView.deleteItem.on("click", function() {
            let item = itemHolder.item;
            colorsMap[title].splice(itemHolder.position, 1);
            // 手动通知列表在该位置有一条数据删除
            rw.list.adapter.notifyItemRemoved(itemHolder.position);
            rw.setSize(rw.getWidth(), -2)
            ui.post(() => {
                if (rw.getHeight() > restrictionHeight) {
                    rw.setSize(rw.getWidth(), restrictionHeight)
                }
            })
            if (colorsMap[title].length <= 0) {
                // 先执行回调
                callbackHandle(title, "clear", null)

                cleanup(title)
                rw.close()
            }
        });

        itemView.item.on("click", function() {
            let item = itemHolder.item;
            callbackHandle(title, "select", item)
            rw.close()
        })

        itemView.hex.on("click", () => {
            let item = itemHolder.item;
            showToast("复制成功")
            setClip(item.hex)
        })

        itemView.point.on("click", () => {
            let item = itemHolder.item;
            utils.showToast("复制成功")
            setClip(`{x:${item.x},y:${item.y}}`)
        })
    });

    // 取消
    rw.cancel_btn.on("click", () => {
        // 先执行回调
        callbackHandle(title, "cancel", null)

        // 再关闭悬浮窗（这会触发 closed 事件，从而调用 cleanup）
        try {
            rw.close()
        } catch (e) {
            console.error("关闭悬浮窗失败:", e)
            // 如果关闭失败，手动清理
            cleanup(title)
        }
    })

    // 清空
    rw.clear_btn.on("click", () => {
        var len = colorsMap[title].length
        colorsMap[title].splice(0, len)
        rw.list.adapter.notifyItemRangeRemoved(0, len);

        // 先执行回调
        callbackHandle(title, "clear", [])

        // 再关闭悬浮窗
        try {
            rw.close()
            cleanup(title)
        } catch (e) {
            console.error("关闭悬浮窗失败:", e)
            cleanup(title)
        }
    })
}


function create(title, data) {
    var singI = singArr.indexOf(title)
    if (singI != -1 || !data) return

    var rw = 设置Ui(title, data)

    singArr.push(title)
    mappingF[title] = rw
    callback[title] = data.callback

    ui居中(title)

    // 屏幕旋转处理函数 - 只关闭窗口，不重新创建
    redrawFun[title] = function() {
        if (mappingF[title]) {
            try {
                mappingF[title].close()
            } catch (e) {
                console.error("屏幕旋转关闭悬浮窗失败:", e)
                cleanup(title)
            }
        }
    }

    events.on("屏幕旋转", redrawFun[title])
    return rw
}

function callbackHandle(title, eventType, data) {
    if (typeof callback[title] != "function") {
        return
    }
    callback[title](eventType, data)
}

function close(title) {
    if (mappingF[title]) {
        try {
            mappingF[title].close()
        } catch (e) {
            console.error("关闭悬浮窗失败:", e)
            cleanup(title)
        }
    }
}

module.exports = {
    create,
    close,
    center: ui居中
}