var dialogsFloaty = require("./dialogsFloaty.js")
var toast = require("./showToast.js")
//上次选中的文件
var oldFile = []
var oldView = []
var oldItem = []

var storage = storages.create("selectFile")

function isImageFile(path) {
    if (!path) return false;
    return (/\.jpg|\.jpeg|\.png|\.gif|\.bmp|\.webp/).test(path);
}
var baseFile = "/sdcard"
var normalColor = "#FAFAFA"; // 默认背景色
var pressedColor = "#DDDDDD"; // 按下时背景色
var selectColor = "#65C0DF" // 选中颜色

// 缓存已经判断的图片
var cacheImageValid = {}

function getFileIcon(ext) {
    var icon, bg
    switch (ext) {
        case "img":
            icon = "@drawable/ic_insert_photo_black_48dp";
            bg = "#3860AF";
            break;
        case "mp3":
        case "wav":
        case "ogg":
            icon = "@drawable/ic_audiotrack_black_48dp";
            bg = "#E53935";
            break;
        case "mp4":
        case "avi":
            icon = "@drawable/ic_movie_black_48dp";
            bg = "#3860AF"
            break;
        case "zip":
            icon = "@drawable/ic_archive_black_48dp";
            bg = "#795548";
            break;
        case "jar":
        case "java":
            icon = "file://./assets/jar.png";
            bg = "#795548";
            break;
        case "pdf":
            icon = "file://./assets/pdf.png";
            bg = "#D81E06";
            break;
        case "csv":
        case "xls":
        case "xlsx":
            icon = "@drawable/ic_insert_chart_black_48dp";
            bg = "#6D9B00";
            break;
        case "txt":
        case "json":
            icon = "@drawable/ic_description_black_48dp";
            bg = "#3860AF";
            break;
        case "dir":
            icon = "@drawable/ic_folder_black_48dp";
            bg = "#000000";
            break;
        case "apk":
            icon = "@drawable/ic_android_black_48dp";
            bg = "#000000";
            break;
        default:
            icon = "@drawable/ic_insert_drive_file_black_48dp";
            bg = "#000000";
    }
    return {
        icon,
        bg
    }
}

function Item() {}

Item.prototype.isImageValid = function(path) {
    var regexp = /(^file:\/\/)/
    if (!regexp.test(path)) {
        return path
    }
    if (cacheImageValid[path]) {
        return cacheImageValid[path]
    }
    var tempPatn = path
    try {
        let opts = new android.graphics.BitmapFactory.Options();
        opts.inJustDecodeBounds = true; // 只解析尺寸，不加载像素
        android.graphics.BitmapFactory.decodeFile(path.replace(regexp, ""), opts);
        if (!(opts.outWidth > 0 && opts.outHeight > 0)) {
            path = getFileIcon("file").icon;
        }
    } catch (e) {
        path = getFileIcon("file").icon;
    }
    cacheImageValid[tempPatn] = path
    return path
}
/**
 *exts: ["png", "jpg"]
 *file: false
 *dir
 * filter: function (item) {}
 */
function getCurrentDir(options) {
    options = options || {};
    var path = options.path || storage.get("path")
    if (!files.exists(path)) {
        path = baseFile
    }
    // 参数结构化
    var filterFn = options.filter || null; // 自定义过滤函数
    var includeDirs = options.dir !== false; // 默认包含目录
    var includeFiles = options.file !== false; // 默认包含文件
    var exts = options.exts || null; // 指定扩展名数组，如 ["jpg","png"]

    if (exts && !Array.isArray(exts)) {
        exts = [exts]
    }

    var dirs = files.listDir(path);
    if (!dirs) return {
        path,
        list: []
    };

    var list = dirs.map(f => {
        var fullPath = files.join(path, f);
        var item = new Item();

        if (files.isDir(fullPath)) {
            item.type = "dir";
            item.name = f;
            item.icon = getFileIcon("dir").icon;
        } else {
            var ext = files.getExtension(fullPath);
            var iconAndBG = getFileIcon(ext);
            var icon = iconAndBG.icon;
            if (isImageFile(fullPath)) {
                icon = "file://" + fullPath;
            }
            item.type = "file";
            item.ext = ext;
            item.name = f;
            item.icon = icon;
        }
        item.wrapperBG = normalColor;
        item.path = fullPath;
        return item;
    });

    // 过滤逻辑
    list = list.filter(item => {
        if (filterFn && !filterFn(item)) return false;
        if (item.type === "dir" && !includeDirs) return false;
        if (item.type === "file" && !includeFiles) return false;
        if (exts && item.type === "file" && !exts.includes(item.ext)) return false;
        return true;
    });

    list.sort((a, b) => {
        // 1. 目录优先
        if (a.type !== b.type) {
            return a.type === "dir" ? -1 : 1;
        }

        // 2. 提取数字进行数值比较
        const numA = parseInt(a.name) || 0;
        const numB = parseInt(b.name) || 0;

        if (numA !== numB) {
            return numA - numB;
        }

        // 3. 数字相同时按字符串比较（处理 "1a", "1b" 等情况）
        return a.name.localeCompare(b.name, 'en', {
            sensitivity: 'base'
        });
    });
    return {
        path,
        list
    };
}

function selectFile(callback, options) {
    if (typeof callback != "function") {
        callback = function() {}
    }
    options = options || {}
    //重置缓存
    cacheImageValid = {}
    var currentList = {
        path: "加载中...",
        list: []
    }
    // 列表位置记录
    var listPosition = {
        path: null,
        item: null
    }
    var rw = dialogsFloaty(
        <frame h="*" w="*" >
            <vertical padding="0 0 0 50">
                <horizontal gravity="center" h="30">
                    <text maxLines="1" ellipsize="start" w="0" layout_weight="1" id="currentDir" padding="10 5" />
                </horizontal>
                <text w="*" h="1" bg="#008c8c" />
                <list id="list">
                    <horizontal w="*" bg="{{wrapperBG}}" id="wrapper" gravity="left|center" padding="10" h="50">
                        <img id="img" w="30" h="30" marginRight="10" scaleType="fitCenter" src="{{isImageValid(icon)}}" />
                        <vertical>
                            <text
                            textSize="12"
                            text="{{name}}"
                            maxLines="2"
                            ellipsize="end"
                            singleLine="false"
                            layout_weight="1"
                            />
                        </vertical>
                    </horizontal>
                </list>
            </vertical>
            <vertical w="*" h="50" layout_gravity="bottom" >
                <text w="*" h="1px" bg="#008c8c" />
                <horizontal h="*" gravity="center">
                    <text layout_weight="1" id="cancel_btn" text="取消"
                    w="0" h="*" gravity="center" backgroundTint="#EAEAEA" textColor="#333333"/>
                    <text w="1px" h="*" bg="#008c8c" />
                    <text layout_weight="1" id="confirm_btn" text="确认"
                    w="0" h="*" gravity="center" backgroundTint="#EAEAEA" textColor="#333333"/>
                </horizontal>
            </vertical>
            <ProgressBar  layout_gravity="center" gravity="center" w="50" h="50" visibility="gone" id="load" />
        </frame>
    );
    rw.setSize(-1, -1)
    rw.setFullScreen(false)
    rw.setPosition(0, 0)
    rw.show()
    var items = currentList.list
    ui.run(() => {
        rw.list.setDataSource(items, false);
        rw.currentDir.attr("text", currentList.path)
        rw.load.setVisibility(0)
    })
    // 先让UI渲染再加载数据
    ui.post(() => {
        currentList = getCurrentDir(options)
        items.splice(0, items.length)
        currentList.list.forEach(item => items.push(item))
        rw.list.adapter.notifyDataSetChanged()
        rw.currentDir.attr("text", currentList.path)
        changeBack()
        rw.load.setVisibility(8)
    }, 16)
    rw.list.on("item_bind", function(itemView, itemHolder) {
        // 设置触摸监听
        itemView.wrapper.setOnTouchListener(new android.view.View.OnTouchListener({
            onTouch: function(v, event) {
                if (oldFile.includes(itemHolder.item.name)) {
                    return false
                }
                switch (event.getAction()) {
                    case android.view.MotionEvent.ACTION_DOWN: // 按下
                        v.setBackgroundColor(android.graphics.Color.parseColor(pressedColor));
                        break;
                    case android.view.MotionEvent.ACTION_UP: // 抬起
                    case android.view.MotionEvent.ACTION_CANCEL: // 手指移出
                        v.setBackgroundColor(android.graphics.Color.parseColor(normalColor));
                        break;
                }
                return false; // 让点击事件继续传递
            }
        }));
    });

    rw.list.on("item_click", function(item, i, itemView, listView) {
        //文件
        if (item.type == "file") {
            // 取消选择
            for (var i = 0; i < oldFile.length; i++) {
                if (oldFile[i] == item.name) {
                    oldItem[i].wrapperBG = normalColor
                    oldView.splice(i, 1)
                    oldFile.splice(i, 1)
                    oldItem.splice(i, 1)
                    rw.list.adapter.notifyDataSetChanged()
                    return true
                }
            }

            //限制个数
            if (options.mult && options.max) {
                if (oldFile.length >= options.max) {
                    toast("已达到数量限制")
                    return
                }
            }
            // 单个,已有选择先删掉
            if (oldItem.length && !options.mult) {
                oldItem[0].wrapperBG = normalColor
            }
            // 多选
            if (options.mult) {
                oldView.push(itemView)
                oldFile.push(item.name)
                oldItem.push(item)
            } else {
                // 单个
                oldView[0] = itemView
                oldFile[0] = item.name
                oldItem[0] = item
            }
            item.wrapperBG = selectColor
            rw.list.adapter.notifyDataSetChanged()
        }
        //文件夹
        else {
            // 已选择文件，先去除
            去除选中文件()
            listPosition = {
                path: currentList.path,
                item: getListScrollState(listView)
            }
            var newPath = files.join(currentList.path, item.name)
            options.path = newPath
            rw.load.setVisibility(0)
            setTimeout(() => {
                currentList = getCurrentDir(options)
                changeBack(rw, currentList)
                items.splice(0, items.length)
                currentList.list.forEach(item => items.push(item))
                rw.currentDir.attr("text", currentList.path)
                listView.adapter.notifyDataSetChanged()
                listView.scrollToPosition(0);
                rw.load.setVisibility(8)
            }, 0)
        }
    });

    // 设置目录路径触摸监听
    rw.currentDir.setOnTouchListener(new android.view.View.OnTouchListener({
        onTouch: function(v, event) {

            switch (event.getAction()) {
                case android.view.MotionEvent.ACTION_DOWN: // 按下
                    v.setBackgroundColor(android.graphics.Color.parseColor(pressedColor));
                    break;
                case android.view.MotionEvent.ACTION_UP: // 抬起
                case android.view.MotionEvent.ACTION_CANCEL: // 手指移出
                    v.setBackgroundColor(android.graphics.Color.parseColor(normalColor));
                    updateFile()
                    break;
            }
            return true; // 让点击事件继续传递
        }
    }));

    // 取消
    rw.cancel_btn.on("click", () => {
        rw.close()
        //callback("cancel", null)
    })
    // 确认
    rw.confirm_btn.on("click", () => {
        // 文件：文件不能为空
        if (options.type) {
            if (options.type == "file") {
                if (!oldFile || oldFile.length == 0) {
                    toast("请选择文件")
                    return
                }
            }
            // 文件：最小个数
            if (options.type == "file" && options.min && oldFile.length < options.min) {
                toast("没有达到数量要求")
                return
            }
        }

        rw.close()
        // 文件：多选
        if (options.type == "file" && options.mult) {
            var paths = []
            oldFile.forEach((file) => {
                paths.push(files.join(currentList.path, file))
            })
            callback("confirm", paths)
            return
        }
        // 目录/文件单选
        var path = files.join(currentList.path, oldFile[0] || "")
        storage.put("path", currentList.path)
        callback("confirm", path)
    })

    // 获取列表位置
    function getListScrollState(list) {
        let rv = list; // list 即 RecyclerView
        let lm = rv.getLayoutManager();

        let firstPos = lm.findFirstVisibleItemPosition();
        let firstView = lm.findViewByPosition(firstPos);
        let offset = firstView ? firstView.getTop() : 0;

        return {
            pos: firstPos,
            offset: offset
        };
    }
    // 设置列表位置
    function restoreListScroll(list, state) {
        let lm = list.getLayoutManager();
        lm.scrollToPositionWithOffset(state.pos, state.offset);
    }

    // 更新目录
    function updateFile() {
        去除选中文件()
        rw.load.setVisibility(0)
        setTimeout(() => {
            var newPath = currentList.path.replace(/\/[^/]+$/, "");
            if (!newPath.includes(baseFile)) {
                newPath = baseFile
            }
            options.path = newPath
            currentList = getCurrentDir(options)
            changeBack(rw, currentList)
            items.splice(0, items.length)
            currentList.list.forEach(item => items.push(item))
            rw.list.adapter.notifyDataSetChanged()
            rw.currentDir.attr("text", currentList.path)
            if (options.path == listPosition.path) {
                restoreListScroll(rw.list, listPosition.item)
            }
            rw.load.setVisibility(8)
        }, 16)
    }

    function 去除选中文件() {
        if (oldFile.length > 0) {
            oldItem.forEach(item => {
                item.wrapperBG = normalColor
            })
            oldView = []
            oldFile = []
            oldItem = []
        }
    }

    // 安装或移除返回键监听，currentList/items/rw 在外部作用域可访问
    function changeBack() {
        // 先移除已有监听（若存在），以免重复
        try {
            if (rw && rw.getDialog && rw._backKeyListenerInstalled) {
                try {
                    rw.getDialog().setOnKeyListener(null);
                } catch (e) {}
                rw._backKeyListenerInstalled = false;
                rw._backKeyListenerRef = null;
            }
        } catch (e) {}

        // 子目录（深度大于 2）时拦截返回键并返回上级
        if (currentList.path.split("/").length > 2) {
            rw.setCancelable(false);
            try {
                // 创建 listener 对象并保存引用，便于后续移除
                var backListener = new android.content.DialogInterface.OnKeyListener({
                    onKey: function(dialog, keyCode, event) {
                        if (event.getAction() === android.view.KeyEvent.ACTION_UP) {
                            if (keyCode === android.view.KeyEvent.KEYCODE_BACK || keyCode === 4) {
                                // 你的返回上级逻辑：更新列表并刷新 UI
                                updateFile(); // 保持你已有的函数调用
                                return true; // 消费事件，阻止对话框关闭
                            }
                        }
                        return false;
                    }
                });
                // 安装并记录状态
                rw.getDialog().setOnKeyListener(backListener);
                rw._backKeyListenerInstalled = true;
                rw._backKeyListenerRef = backListener;
            } catch (e) {
                // 若环境不支持 getDialog().setOnKeyListener，可按需降级处理
            }
            return;
        }

        // 根目录允许取消，确保监听已移除
        rw.setCancelable(true);
        try {
            if (rw && rw.getDialog && rw._backKeyListenerInstalled) {
                rw.getDialog().setOnKeyListener(null);
                rw._backKeyListenerInstalled = false;
                rw._backKeyListenerRef = null;
            }
        } catch (e) {}
    }

    // 可在其他地方显式调用以移除监听并允许返回关闭
    function removeBackListener() {
        try {
            if (rw && rw.getDialog && rw._backKeyListenerInstalled) {
                rw.getDialog().setOnKeyListener(null);
                rw._backKeyListenerInstalled = false;
                rw._backKeyListenerRef = null;
            }
            // 同时确保对话框可取消
            if (rw) rw.setCancelable(true);
        } catch (e) {}
    }
}

/*
selectFile((type, data) => {
    log(type, data)
}, {
    type: "file", //选择的类型dir/file
    exts: ["txt"], // 只要符合的后缀名
    file: true, // 显示文件true/false
    dir: true, // 显示目录true/false
    mult: true, // 文件多选true/false
    max: 5, // 文件选择最大数
    min: 3, // 文件选择最小数
    //filter: function (item) {}
})

*/
module.exports = {
    create: selectFile,
}
