"ui";
ui.layout(
    <vertical>
        <canvas id="canvas" layout_weight="1"/>
        <horizontal w="*" gravity="center">
            <vertical layout_weight="1">
                <button text="N" id="butA" textSize="40sp"layout_weight="1" textColor="#000000"/>
                <button text="P" id="butB" textSize="40sp"  layout_weight="1" textColor="#000000"/>
            </vertical>
            <vertical layout_weight="3">
                <horizontal layout_weight="1">
                    <button text="↹" id="but1" textSize="24sp" layout_weight="1" textColor="#000000"/>
                    <button text="W" id="but2" textSize="24sp" layout_weight="1"textColor="#000000"/>
                    <button text="▽" id="but3" textSize="24sp"  layout_weight="1" textColor="#000000"/>
                </horizontal>
                <horizontal layout_weight="1">
                    <button text="A" id="but4" textSize="24sp" layout_weight="1" textColor="#000000"/>
                    <button text="♢" id="but5" textSize="24sp" layout_weight="1" textColor="#ff0000"/>
                    <button text="D" id="but6" textSize="24sp"layout_weight="1" textColor="#000000"/>
                </horizontal>
                <horizontal layout_weight="1">
                    <button text="☆" id="but7" textSize="24sp"  layout_weight="1" textColor="#000000"/>
                    <button text="S" id="but8" textSize="24sp"  layout_weight="1"textColor="#000000"/>
                    <button text="△" id="but9" textSize="24sp"  layout_weight="1"textColor="#000000"/>
                </horizontal>
            </vertical>
            <vertical layout_weight="1">
                <button text="B" id="butC" textSize="40sp" layout_weight="1" textColor="#000000"/>
                <button text="E" id="butD" textSize="40sp"  layout_weight="1"textColor="#000000"/>
            </vertical>
        </horizontal>
    </vertical>
);

function TouchListener(view, event) {
    var I = Math.floor(event.getAction() / 256);
    var ID = event.getPointerId(I);
    var X = event.getX(I);
    var Y = event.getY(I);
    var T = view.getText();
    log(T);
    switch (event.getActionMasked()) {
        case event.ACTION_DOWN:
            keydown({
                keyCode: keyboard[T]
            });

            break;
        case event.ACTION_UP:
            keyup({
                keyCode: keyboard[T]
            });

            break;
    };
    return true;
};



ui.but2.setOnTouchListener(TouchListener);
ui.but8.setOnTouchListener(TouchListener);
ui.but4.setOnTouchListener(TouchListener);
ui.but6.setOnTouchListener(TouchListener);
ui.butA.setOnTouchListener(TouchListener);
ui.butB.setOnTouchListener(TouchListener);
ui.butC.setOnTouchListener(TouchListener);
ui.butD.setOnTouchListener(TouchListener);




var soundPool = new android.media.SoundPool(10, 3, 0);

function Audio(path) {
    path=files.path(path);
    this.id = soundPool.load(path, 1);
    this.play = function() {
        soundPool.play(this.id, 1, 1, 0, 0, 1);
    };
};
events.on('exit', function() {
    soundPool.release();
});

function Image() {
    this.img;
    this.read = function(path) {
        if (!this.img) {
            this.img = images.read(path);
        };
    };
};


function myCanvas(width, height) {
    this.width = width;
    this.height = height;
    this.bitmap = android.graphics.Bitmap.createBitmap(this.width || 1, this.height || 1, android.graphics.Bitmap.Config.ARGB_8888);
    this.canvas = new Canvas(this.bitmap);
    this.save=function(){};//this.canvas.save;
    this.restore=function(){};//this.canvas.restore;
    this.paint = new android.graphics.Paint;

    this.setColor = function(color) {
        this.paint.setColor(colors.parseColor(color));
    };
    this.drawImage = function(imageobj, Ax, Ay, Aw, Ah, Bx, By, Bw, Bh) {
        this.paint.setXfermode(new android.graphics.PorterDuffXfermode(android.graphics.PorterDuff.Mode.SRC));
        //imageobj.read();
        if(arguments.length==9){
        this.canvas.drawImage(imageobj.img, Ax, Ay, Aw, Ah, Bx, By, Bw, Bh, this.paint);
        }else{
        this.canvas.drawImage(imageobj.img, Ax, Ay, this.paint);
        };
    };
    this.clearRect = function(Ax, Ay, Aw, Ah) {
        this.paint.setXfermode(new android.graphics.PorterDuffXfermode(android.graphics.PorterDuff.Mode.CLEAR));
        this.canvas.drawRect(Ax, Ay, Ax + Aw, Ay + Ah, this.paint);
    };
    this.fillRect = function(Ax, Ay, Aw, Ah) {
        this.paint.setStyle(Paint.Style.FILL);
        this.paint.setXfermode(new android.graphics.PorterDuffXfermode(android.graphics.PorterDuff.Mode.SRC));
        this.canvas.drawRect(Ax, Ay, Ax + Aw, Ay + Ah, this.paint);
    };
};


/**
 * 数组删除某个元素
 * @param arg 元素
 * @returns
 */
Array.prototype.remove = function(arg) {
    var i = 0,
        n = 0;
    var arrSize = this.length;
    for (i = 0; i < arrSize; i++) {
        if (this[i] != arg) {
            this[n++] = this[i];
        }
    }
    if (n < i) {
        this.length = n;
    }
};

/**
 * 数组根据下标删除元素
 * @param index 元素下标
 * @returns
 */
Array.prototype.removeByIndex = function(index) {
    var i = 0,
        n = 0;
    var arrSize = this.length;
    for (i = 0; i < arrSize; i++) {
        if (this[i] != this[index]) {
            this[n++] = this[i];
        }
    }
    if (n < i) {
        this.length = n;
    }
};

/**
 * 数组是否包含某个元素
 * @param arg 元素
 * @returns
 */
Array.prototype.contain = function(arg) {
    var i = 0;
    var arrSize = this.length;
    for (i = 0; i < arrSize; i++) {
        if (this[i] == arg) {
            return true;
        }
    }
    return false;
};
/**
 * 键盘按钮
 */

var Keyboard = function() {

    this.UP = 38;
    this.DOWN = 40;
    this.RIGHT = 39;
    this.LEFT = 37;

    this.SPACE = 32;
    this.TAB = 9;
    this.ENTER = 13;
    this.CTRL = 17;
    this.ALT = 18;

    this.Num0 = 48;
    this.Num1 = 49;
    this.Num2 = 50;
    this.Num3 = 51;
    this.Num4 = 52;
    this.Num5 = 53;
    this.Num6 = 54;
    this.Num7 = 55;
    this.Num8 = 56;
    this.Num9 = 57;

    this.A = 65;
    this.B = 66;
    this.C = 67;
    this.D = 68;
    this.E = 69;
    this.F = 70;
    this.G = 71;
    this.H = 72;
    this.I = 73;
    this.J = 74;
    this.K = 75;
    this.L = 76;
    this.M = 77;
    this.N = 78;
    this.O = 79;
    this.P = 80;
    this.Q = 81;
    this.R = 82;
    this.S = 83;
    this.T = 84;
    this.U = 85;
    this.V = 86;
    this.W = 87;
    this.X = 88;
    this.Y = 89;
    this.Z = 90;

};

var keyboard = new Keyboard();
/**
 * 静态变量
 */

var SCREEN_WIDTH = 512; //屏幕宽
var SCREEN_HEIGHT = 448;//屏幕高


/**************图片资源*****************/
var MENU_IMAGE = new Image();
MENU_IMAGE.read("./images/menu.gif");
var RESOURCE_IMAGE = new Image();
RESOURCE_IMAGE.read("./images/tankAll.gif");


/**************各个图块在图片中的位置*****************/
var POS = new Array();
POS["selectTank"] = [128,96];
POS["stageLevel"] = [396,96];
POS["num"] = [256,96];
POS["map"] = [0,96];
POS["home"] = [256,0];
POS["score"] = [0,112];
POS["player"] = [0,0];
POS["protected"] = [160,96];
POS["enemyBefore"] = [256,32];
POS["enemy1"] = [0,32];
POS["enemy2"] = [128,32];
POS["enemy3"] = [0,64];
POS["bullet"] = [80,96];
POS["tankBomb"] = [0,160];
POS["bulletBomb"] = [320,0];
POS["over"] = [384,64];
POS["prop"] = [256,110];

/**************声音资源*****************/
var START_AUDIO = new Audio("./audio/start.mp3");
var BULLET_DESTROY_AUDIO = new Audio("./audio/bulletCrack.mp3");
var TANK_DESTROY_AUDIO = new Audio("./audio/tankCrack.mp3");
var PLAYER_DESTROY_AUDIO = new Audio("./audio/playerCrack.mp3");
var MOVE_AUDIO = new Audio("./audio/move.mp3");
var ATTACK_AUDIO = new Audio("./audio/attack.mp3");
var PROP_AUDIO = new Audio("./audio/prop.mp3");


/**************游戏状态*****************/
var GAME_STATE_MENU = 0;
var GAME_STATE_INIT = 1;
var GAME_STATE_START = 2;
var GAME_STATE_OVER = 3;
var GAME_STATE_WIN = 4;

/**************地图块*****************/
var WALL = 1;
var GRID = 2;
var GRASS = 3;
var WATER = 4;
var ICE = 5;
var HOME = 9;
var ANOTHREHOME = 8;

/**************坦克及子弹的四个方向*****************/
var UP = 0;
var DOWN = 1;
var LEFT = 2;
var RIGHT = 3;

/**************坦克及子弹的四个方向*****************/
var ENEMY_LOCATION = [192,0,384]; //相对与主游戏区

/**************子弹类型*****************/
var BULLET_TYPE_PLAYER = 1;
var BULLET_TYPE_ENEMY = 2;
/**************爆炸类型****************/
var CRACK_TYPE_TANK = "tank";
var CRACK_TYPE_BULLET = "bullet";





/**
 * 地图数组
 * 1：水泥墙 2：铁墙 3：草 4：水 5：冰 9：家
 */
var map1 = 
[
	[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
	[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
	[0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0],
	[0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0],
	[0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0],
	[0,0,1,1,0,0,1,1,0,0,1,1,2,2,1,1,0,0,1,1,0,0,1,1,0,0],
	[0,0,1,1,0,0,1,1,0,0,1,1,2,2,1,1,0,0,1,1,0,0,1,1,0,0],
	[0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0],
	[0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0],
	[0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0],
	[0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0],
	[0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0],
	[1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1],
	[2,2,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,2,2],
	[0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0],
	[0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0],
	[0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0],
	[0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0],
	[0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0],
	[0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0],
	[0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0],
	[0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0],
	[0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0],
	[0,0,1,1,0,0,1,1,0,0,0,1,1,1,1,0,0,0,1,1,0,0,1,1,0,0],
	[0,0,0,0,0,0,0,0,0,0,0,1,9,8,1,0,0,0,0,0,0,0,0,0,0,0],
	[0,0,0,0,0,0,0,0,0,0,0,1,8,8,1,0,0,0,0,0,0,0,0,0,0,0],
];

var map2 = 
[
	[0,0,0,0,0,0,2,2,0,0,0,0,0,0,2,2,0,0,0,0,0,0,0,0,0,0],
	[0,0,0,0,0,0,2,2,0,0,0,0,0,0,2,2,0,0,0,0,0,0,0,0,0,0],
	[0,0,1,1,0,0,2,2,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0],
	[0,0,1,1,0,0,2,2,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0],
	[0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,2,2,1,1,0,0],
	[0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,2,2,1,1,0,0],
	[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,0,0,0,0],
	[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,0,0,0,0],
	[3,3,0,0,0,0,0,0,0,0,0,0,2,2,0,0,0,0,1,1,3,3,1,1,2,2],
	[3,3,0,0,0,0,0,0,0,0,0,0,2,2,0,0,0,0,1,1,3,3,1,1,2,2],
	[3,3,3,3,0,0,0,0,0,0,1,1,0,0,0,0,2,2,0,0,3,3,0,0,0,0],
	[3,3,3,3,0,0,0,0,0,0,1,1,0,0,0,0,2,2,0,0,3,3,0,0,0,0],
	[0,0,1,1,1,1,1,1,3,3,3,3,3,3,2,2,0,0,0,0,3,3,1,1,0,0],
	[0,0,1,1,1,1,1,1,3,3,3,3,3,3,2,2,0,0,0,0,3,3,1,1,0,0],
	[0,0,0,0,0,0,2,2,3,3,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0],
	[0,0,0,0,0,0,2,2,3,3,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0],
	[2,2,1,1,0,0,2,2,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0],
	[2,2,1,1,0,0,2,2,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0],
	[0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,2,2,1,1,0,0],
	[0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,2,2,1,1,0,0],
	[0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0],
	[0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0],
	[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0],
	[0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,1,1,0,0,1,1,0,0],
	[0,0,1,1,0,0,1,1,0,0,0,1,9,8,1,0,0,0,1,1,1,1,1,1,0,0],
	[0,0,1,1,0,0,1,1,0,0,0,1,8,8,1,0,0,0,1,1,1,1,1,1,0,0],
];
var map3 = 
[
	[0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0],
	[0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0],
	[0,0,3,3,3,3,3,3,1,1,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2],
	[0,0,3,3,3,3,3,3,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
	[1,1,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
	[1,1,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,0],
	[3,3,3,3,3,3,3,3,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,0],
	[3,3,3,3,3,3,3,3,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,1,0,0],
	[3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,1,0,0],
	[3,3,3,3,3,3,3,3,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,1,0,0],
	[3,3,3,3,3,3,3,3,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,1,0,0],
	[3,3,3,3,3,3,3,3,0,0,0,0,2,2,2,2,2,2,0,0,0,0,3,3,0,0],
	[0,0,3,3,0,0,0,0,0,0,0,0,2,2,2,2,2,2,0,0,0,0,3,3,0,0],
	[0,0,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3],
	[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3],
	[0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3],
	[1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3],
	[1,1,1,0,0,1,1,1,1,0,0,1,0,0,0,0,0,0,3,3,3,3,3,3,3,3],
	[0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,3,3,3,3,3,3,3,3],
	[0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,3,3,3,3,3,3,3,3],
	[1,1,0,0,0,0,2,0,0,0,0,0,0,0,1,1,1,1,3,3,3,3,3,3,0,0],
	[1,1,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,0,0],
	[1,1,1,1,0,0,2,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,0,0],
	[1,1,1,1,0,0,2,0,0,0,0,1,1,1,1,0,0,0,3,3,3,3,3,3,0,0],
	[2,2,1,1,1,1,0,0,0,0,0,1,9,8,1,0,0,0,1,1,0,0,0,0,0,0],
	[2,2,1,1,1,1,0,0,0,0,0,1,8,8,1,0,0,0,1,1,0,0,0,0,0,0],
];

var map4 = 
[
	[0,0,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,0,0],
	[0,0,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,0,0],
	[3,3,3,3,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,3,3],
	[3,3,3,3,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,3,3],
	[3,3,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,2,2],
	[3,3,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0],
	[2,2,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0],
	[0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0],
	[0,0,0,0,0,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,0,0,0],
	[0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,0,0,0],
	[4,4,0,0,0,1,0,0,2,0,0,0,2,0,0,0,1,1,1,0,0,0,0,0,0,0],
	[4,4,0,0,0,1,0,0,2,0,0,0,2,0,0,0,1,1,1,0,0,0,0,0,0,0],
	[0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,4,4,4,4],
	[0,0,0,0,1,1,0,0,1,1,1,0,0,0,0,1,1,1,1,0,0,0,4,4,4,4],
	[0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0],
	[0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0],
	[0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0],
	[0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0],
	[0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0],
	[0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0],
	[0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,3,3],
	[0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,3,3],
	[3,3,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,3,3,3,3],
	[3,3,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,3,3,3,3],
	[2,2,3,3,0,0,0,0,0,0,0,1,9,8,1,0,0,0,0,0,3,3,3,3,2,2],
	[2,2,3,3,0,0,0,0,0,0,0,1,8,8,1,0,0,0,0,0,3,3,3,3,2,0],
];

var map5 = 
[
	[0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
	[0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
	[0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,2,2,2,2,2,2,0,0,0,0],
	[2,2,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,2,2,0,0,0,0],
	[2,2,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
	[2,2,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0],
	[1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,4,4,4,4,0,0,4,4],
	[1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,4,4,4,4,0,0,4,4],
	[1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,4,4,0,0,0,0,0,0],
	[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,0,0,0,0,0,0],
	[0,0,0,0,0,0,0,0,4,4,4,4,0,0,4,4,4,4,4,4,0,0,1,1,1,1],
	[0,0,0,0,0,0,0,0,4,4,4,4,0,0,4,4,4,4,4,4,0,0,1,1,1,1],
	[0,0,0,0,1,1,0,0,4,4,1,1,0,0,1,1,1,0,0,0,0,0,0,0,0,0],
	[1,1,1,1,0,0,0,0,4,4,1,1,0,0,1,1,1,0,0,0,0,0,0,0,0,0],
	[0,0,0,0,0,0,0,0,4,4,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,0],
	[0,0,0,0,0,0,0,0,4,4,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,0],
	[4,4,4,4,4,4,0,0,4,4,0,0,2,2,0,0,1,1,0,0,0,2,0,0,0,0],
	[4,4,4,4,4,4,0,0,4,4,0,0,2,2,0,0,1,1,0,0,0,2,0,0,0,0],
	[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,1,1,1,1],
	[0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,2,1,1,1,1],
	[0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0],
	[0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0],
	[1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0],
	[1,1,1,1,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,1,1,0,0,0,0],
	[1,1,0,0,0,0,0,0,0,0,0,1,9,8,1,0,0,0,0,0,0,0,0,0,0,0],
	[0,0,0,0,0,0,0,0,0,0,0,1,8,8,1,0,0,0,0,0,0,0,0,0,0,0],
];



var map6 = 
[
	[0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,3,3,3,3,0,0,0,0,0,0],
	[0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,3,3,3,3,0,0,0,0,0,0],
	[0,0,1,0,0,2,0,0,1,0,0,0,0,0,0,0,0,1,3,3,1,0,0,1,3,3],
	[0,0,1,0,0,2,0,0,1,0,0,0,0,0,0,0,0,1,3,3,1,0,0,1,3,3],
	[0,0,1,0,0,2,0,0,1,0,0,0,1,1,0,0,0,1,3,3,1,0,0,1,3,3],
	[0,0,1,0,0,2,0,0,1,0,0,0,1,1,0,0,0,1,3,3,1,0,0,1,3,3],
	[0,0,1,1,0,0,0,0,1,1,0,0,2,2,0,0,1,1,3,3,0,0,1,1,3,3],
	[0,0,1,1,0,0,0,0,1,1,0,0,2,2,0,0,1,1,3,3,0,0,1,1,3,3],
	[0,0,0,0,0,0,0,1,2,2,0,0,1,1,0,0,1,1,2,0,0,0,3,3,3,3],
	[0,0,0,0,0,0,0,1,0,0,0,0,1,1,0,0,0,0,2,0,0,0,3,3,3,3],
	[1,1,1,1,1,0,0,0,0,0,3,3,1,1,3,3,0,0,0,0,0,1,1,1,1,1],
	[1,1,1,1,1,0,0,0,0,0,3,3,1,1,3,3,0,0,0,0,0,1,1,1,1,1],
	[0,0,0,0,0,0,0,0,0,1,3,3,3,3,3,3,1,0,0,0,0,0,0,0,0,0],
	[0,0,0,0,0,0,0,0,0,1,3,3,3,3,3,3,1,0,0,0,0,0,0,0,0,0],
	[2,2,1,1,1,1,0,0,1,1,3,3,3,3,3,3,1,1,0,1,1,1,1,1,2,2],
	[2,2,1,1,1,1,0,0,0,0,3,3,3,3,3,3,0,0,0,1,1,1,1,1,2,2],
	[2,2,2,2,2,2,0,0,0,0,0,0,3,3,0,0,0,0,0,0,2,2,2,2,2,2],
	[0,0,0,0,0,0,0,0,1,1,0,0,3,3,0,0,1,1,0,0,0,0,0,0,0,0],
	[0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0],
	[0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0],
	[0,0,1,1,1,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,1,1,1,3,3],
	[0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,3,3],
	[0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3],
	[0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,3,3,3,3,3,3],
	[0,0,0,0,0,0,0,0,0,0,0,1,9,8,1,0,0,0,0,0,0,0,3,3,3,3],
	[0,0,0,0,1,1,0,0,0,0,0,1,8,8,1,0,0,0,0,0,1,1,3,3,3,3],
];

var map7 = 
[
	[0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0],
	[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
	[0,0,0,0,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,2,2,0,0,0,0],
	[0,0,0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,0,0],
	[0,0,0,0,2,2,0,0,0,0,0,0,3,3,0,0,2,2,2,2,2,2,0,0,0,0],
	[0,0,0,0,2,2,0,0,0,0,0,0,3,3,0,0,0,0,2,2,2,2,0,0,0,0],
	[0,0,2,2,0,0,0,0,0,0,3,3,2,2,0,0,0,0,0,0,2,2,0,0,0,0],
	[0,0,2,2,0,0,0,0,0,0,3,3,2,2,0,0,0,0,0,0,2,2,0,0,0,0],
	[0,0,0,0,0,0,0,0,3,3,2,2,2,2,0,0,0,0,0,0,2,2,2,2,0,0],
	[0,0,0,0,0,0,0,0,3,3,2,2,2,2,0,0,0,0,0,0,0,0,2,2,0,0],
	[0,0,2,2,0,0,3,3,2,2,2,2,2,2,0,0,2,2,0,0,0,0,0,0,0,0],
	[0,0,2,2,0,0,3,3,2,2,2,2,2,2,0,0,2,2,0,0,0,0,0,0,0,0],
	[0,0,0,2,0,0,2,2,2,2,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0],
	[0,0,0,2,0,0,2,2,2,2,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0],
	[2,0,0,0,0,0,0,0,2,2,0,0,2,2,2,2,2,2,0,0,0,0,0,2,0,0],
	[2,0,0,0,0,0,0,0,2,2,0,0,2,2,2,2,2,2,0,0,0,0,0,2,0,0],
	[0,0,0,2,2,2,0,0,0,0,0,0,2,2,2,2,3,3,0,0,0,0,2,2,0,0],
	[0,0,0,2,2,2,0,0,0,0,0,0,2,2,2,2,3,3,0,0,0,0,2,2,0,0],
	[0,0,2,2,0,0,0,0,0,0,0,0,2,2,3,3,0,0,0,0,2,2,2,2,0,0],
	[0,0,2,2,0,0,0,0,0,0,0,0,2,2,3,3,0,0,0,0,2,2,2,2,0,0],
	[0,0,2,2,2,2,2,2,0,0,0,0,3,3,0,0,0,0,2,2,0,0,0,0,0,0],
	[0,0,0,0,0,0,2,2,0,0,0,0,3,3,0,0,0,0,2,2,0,0,0,0,0,0],
	[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,0,0,2,2],
	[0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,2,2,2,2],
	[0,0,0,0,0,0,0,0,0,0,0,1,9,8,1,0,0,0,0,0,0,0,0,0,0,0],
	[2,2,2,2,0,0,0,0,0,0,0,1,8,8,1,0,0,0,0,0,0,0,0,0,0,0],
];


var map8 = 
[
	[0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0],
	[0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0],
	[3,3,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,0,0,0,0,0],
	[3,3,1,1,1,1,1,1,0,0,1,1,0,0,2,2,0,0,1,1,1,0,0,0,0,0],
	[3,3,3,3,3,3,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,1,1,0],
	[3,3,3,3,3,3,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,1,0],
	[3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,4,4],
	[3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,4,4],
	[0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
	[0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0],
	[0,0,0,0,1,1,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2],
	[0,0,0,0,1,1,0,0,0,0,0,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0],
	[1,1,1,1,0,0,1,1,0,0,0,1,1,1,1,1,3,3,1,1,0,0,0,0,1,1],
	[1,1,1,1,0,0,1,1,0,0,0,1,1,1,1,1,3,3,1,1,2,2,2,2,1,1],
	[0,0,0,0,0,0,2,2,0,0,0,0,0,0,3,3,3,3,3,3,3,3,0,0,0,0],
	[0,0,0,0,0,0,2,2,0,0,2,2,0,0,3,3,3,3,3,3,3,3,0,0,0,0],
	[4,4,4,4,0,0,4,4,4,4,4,4,4,4,4,4,0,0,4,4,4,4,4,4,4,4],
	[4,4,4,4,0,0,4,4,4,4,4,4,4,4,4,4,0,0,4,4,4,4,4,4,4,4],
	[3,3,3,3,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
	[3,3,3,3,0,0,0,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0],
	[3,3,3,3,1,1,0,0,1,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0],
	[3,3,3,3,1,1,0,0,1,0,0,0,0,0,0,1,0,0,2,2,1,1,1,1,0,0],
	[3,3,0,0,1,1,0,0,1,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0],
	[3,3,2,2,1,1,0,0,1,0,0,1,1,1,1,0,0,0,0,0,0,0,1,1,0,0],
	[0,0,0,0,0,0,0,0,0,0,0,1,9,8,1,0,0,0,0,0,0,0,1,1,0,0],
	[0,0,0,0,0,0,0,0,0,0,0,1,8,8,1,0,0,0,1,1,0,0,0,0,0,0],
];

var map9 = 
[
	[0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,3,3,0,0,0,0],
	[0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,2,2,3,3,0,0,0,0],
	[1,1,0,0,0,0,0,0,0,0,0,0,0,0,3,3,0,2,2,2,2,0,0,0,1,1],
	[1,1,0,0,0,0,0,0,0,0,0,0,2,2,3,3,0,2,2,2,2,0,0,0,1,1],
	[0,0,0,0,0,0,0,0,3,3,0,2,2,2,2,0,0,0,2,2,3,3,0,0,0,0],
	[0,0,0,0,0,0,2,2,3,3,0,2,2,2,2,0,0,0,0,0,3,3,0,0,0,0],
	[0,0,0,0,0,2,2,2,2,0,0,0,2,2,3,3,0,0,0,0,0,0,0,0,0,0],
	[0,0,0,0,0,2,2,2,2,0,0,0,0,0,3,3,0,0,0,0,0,0,0,0,0,0],
	[0,0,0,0,0,0,2,2,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
	[0,0,0,0,0,0,0,0,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
	[0,0,0,0,0,0,3,3,0,0,3,3,0,0,3,3,0,0,3,3,0,0,0,0,0,0],
	[0,0,0,0,0,0,3,3,2,2,3,3,0,0,3,3,2,2,3,3,0,0,0,0,0,0],
	[2,2,1,1,0,0,0,2,2,2,2,0,0,0,0,2,2,2,2,0,0,0,3,3,2,2],
	[2,2,1,1,0,0,0,2,2,2,2,0,0,0,0,2,2,2,2,0,0,0,3,3,2,2],
	[0,0,0,0,0,0,3,3,2,2,3,3,0,0,3,3,2,2,3,3,0,0,0,0,0,0],
	[0,0,0,0,0,0,3,3,0,0,3,3,0,0,3,3,0,0,3,3,0,0,0,0,0,0],
	[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
	[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,0,0,0,0,0,0],
	[1,1,0,0,0,0,0,2,2,2,2,0,0,0,0,2,2,2,2,0,0,0,0,0,1,1],
	[1,1,0,0,0,0,0,2,2,2,2,0,0,0,0,2,2,2,2,0,0,0,0,0,1,1],
	[1,1,0,0,0,0,3,3,2,2,3,3,0,0,3,3,2,2,3,3,0,0,0,0,1,1],
	[1,1,0,0,0,0,3,3,2,2,3,3,0,0,3,3,0,0,3,3,0,0,0,0,1,1],
	[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
	[0,0,0,0,1,1,0,0,0,0,0,1,1,1,1,0,0,0,0,0,1,1,0,0,0,0],
	[0,0,0,0,1,1,1,1,0,0,0,1,9,8,1,0,0,0,1,1,1,1,0,0,0,0],
	[0,0,0,0,1,1,1,1,0,0,0,1,8,8,1,0,0,0,1,1,1,1,0,0,0,0],
];


var map10 = 
[
	[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
	[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
	[0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0],
	[0,0,0,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,0],
	[0,1,1,1,0,0,0,0,1,1,0,0,3,3,3,3,0,0,1,1,0,0,0,0,0,1],
	[0,1,0,0,0,0,0,0,1,1,0,0,3,3,3,3,0,0,1,1,0,0,0,0,0,1],
	[1,1,0,0,0,0,0,0,1,1,3,3,3,3,3,3,3,3,1,1,0,0,0,0,0,1],
	[1,1,0,0,0,0,0,0,1,1,3,3,3,3,3,3,3,3,1,1,0,0,0,0,0,1],
	[1,1,0,0,0,0,0,1,1,1,3,3,2,2,2,2,3,3,1,1,1,0,0,0,1,1],
	[1,1,0,0,0,0,0,1,1,1,3,3,2,2,2,2,3,3,1,1,1,0,0,0,1,1],
	[0,1,0,0,0,0,1,1,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1],
	[0,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1],
	[0,0,1,1,1,1,1,1,2,2,2,2,1,1,2,2,2,2,1,1,1,1,1,1,1,0],
	[0,0,1,1,1,1,1,1,2,2,2,2,1,1,2,2,2,2,1,1,1,1,1,1,1,0],
	[0,0,0,0,1,1,1,1,2,2,0,0,1,1,0,0,2,2,1,1,1,1,1,0,0,0],
	[0,0,0,0,1,1,1,1,2,2,0,0,1,1,0,0,2,2,1,1,1,1,1,0,0,0],
	[0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0],
	[0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0],
	[1,1,3,3,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,3,3,1,1],
	[1,1,3,3,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,3,3,1,1],
	[1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1],
	[1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1],
	[0,0,0,0,3,3,3,3,3,3,0,0,0,0,0,0,3,3,3,3,3,3,3,3,0,0],
	[0,0,0,0,3,3,3,3,3,3,0,1,1,1,1,0,3,3,3,3,3,3,3,3,0,0],
	[0,0,0,0,0,0,1,0,0,0,0,1,9,8,1,0,0,0,0,0,1,0,0,0,0,0],
	[0,0,0,0,0,0,1,0,0,0,0,1,8,8,1,0,0,0,0,0,1,0,0,0,0,0],
];

var map11 = 
[
	[0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,0,0,1,1,1,1,0,0,0,0],
	[0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,0,0,1,1,1,1,0,0,0,0],
	[0,0,0,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0],
	[0,0,0,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0],
	[0,0,0,0,0,0,1,0,0,0,1,1,0,0,1,1,1,1,0,0,3,3,3,3,3,3],
	[0,0,0,0,0,0,1,0,0,0,1,1,0,0,1,1,1,1,0,0,3,3,3,3,3,3],
	[0,0,0,1,0,0,0,0,0,0,0,0,0,0,3,3,0,0,3,3,3,3,3,3,3,3],
	[0,0,0,1,0,0,0,0,0,0,0,0,0,0,3,3,0,0,3,3,3,3,3,3,3,3],
	[0,0,0,1,0,0,1,1,1,1,1,1,2,2,1,1,1,1,3,3,3,3,1,1,2,2],
	[0,0,0,1,0,0,1,1,1,1,1,1,2,2,1,1,1,1,3,3,3,3,0,0,2,2],
	[0,0,1,1,1,1,1,1,2,2,0,0,0,0,1,1,0,0,3,3,3,3,0,0,0,1],
	[0,0,0,0,0,0,0,0,2,2,0,0,0,0,1,1,0,0,3,3,3,3,0,0,0,1],
	[0,0,1,1,1,1,1,1,0,0,2,2,3,3,3,3,3,3,3,3,3,3,0,0,0,0],
	[0,0,1,1,1,1,1,1,0,0,2,2,3,3,3,3,3,3,3,3,3,3,0,0,0,0],
	[0,0,0,0,0,0,2,2,0,0,0,0,3,3,3,3,3,3,3,3,3,3,1,1,0,0],
	[0,0,0,0,0,0,2,2,0,0,0,0,3,3,3,3,3,3,3,3,3,3,1,1,0,0],
	[2,2,1,1,0,0,3,3,3,3,3,3,3,3,2,2,3,3,3,3,3,3,1,1,0,0],
	[2,2,1,1,0,0,3,3,3,3,3,3,3,3,2,2,3,3,3,3,3,3,1,1,0,0],
	[0,1,4,4,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,1,1,0,0],
	[0,1,4,4,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,1,1,0,0],
	[0,0,4,4,3,3,3,3,0,0,0,0,0,0,0,0,2,2,1,1,1,1,1,1,0,0],
	[0,0,4,4,3,3,3,3,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0],
	[0,0,0,0,3,3,3,3,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0],
	[0,0,0,0,3,3,3,3,0,0,0,1,1,1,1,0,0,0,1,1,0,0,0,1,0,0],
	[0,0,0,0,3,3,3,3,0,0,0,1,9,8,1,0,0,0,0,0,0,0,0,0,0,0],
	[0,0,1,1,3,3,3,3,0,0,0,1,8,8,1,0,0,0,0,0,0,0,0,0,0,0],
];

var map12 = 
[
	[0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0],
	[0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0],
	[0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0],
	[0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0],
	[0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1],
	[0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1],
	[0,0,4,4,4,4,4,4,4,4,4,4,0,0,1,1,1,0,0,0,0,0,1,1,0,0],
	[0,0,4,4,4,4,4,4,4,4,4,4,0,0,1,1,1,0,0,0,0,0,1,1,0,0],
	[0,0,0,0,0,0,0,0,0,0,4,4,0,0,1,1,0,0,2,2,2,0,1,1,0,0],
	[0,0,0,0,2,2,2,2,2,2,4,4,0,0,1,1,0,0,2,2,2,0,1,1,0,0],
	[1,0,0,0,1,1,1,1,1,1,4,4,4,4,4,4,0,0,4,4,1,1,1,1,0,0],
	[1,1,0,0,1,1,1,1,1,1,4,4,4,4,4,4,0,0,4,4,1,1,1,1,0,0],
	[0,0,0,0,0,0,0,0,2,2,4,4,0,0,0,0,0,0,4,4,2,2,0,0,0,0],
	[0,0,0,0,0,0,0,0,2,2,4,4,0,0,0,0,0,0,4,4,0,0,0,0,0,0],
	[4,4,4,4,4,4,0,0,4,4,4,4,1,1,1,1,0,0,4,4,0,0,0,0,0,0],
	[4,4,4,4,4,4,0,0,4,4,4,4,1,1,1,1,0,0,4,4,0,0,0,0,0,0],
	[0,0,0,0,0,0,0,0,0,0,1,1,2,2,2,2,0,0,4,4,0,0,0,0,0,0],
	[0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,4,4,4,4,4,4,0,0],
	[1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,0,0],
	[1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
	[0,0,0,0,1,1,0,0,2,2,2,2,0,0,0,0,0,0,1,1,1,1,0,0,0,1],
	[0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,1],
	[1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1],
	[1,1,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,1,1,0,0,0,0,1,1],
	[0,0,0,0,0,0,0,0,0,0,0,1,9,8,1,0,0,0,0,0,0,0,0,0,0,0],
	[0,0,0,0,0,0,0,0,0,0,0,1,8,8,1,0,0,0,0,0,0,0,0,0,0,0]
];

var map13 = 
[
	[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
	[0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0],
	[0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0],
	[0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0],
	[0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,2,2,0,0],
	[0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0],
	[0,0,2,2,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1],
	[0,0,2,2,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1],
	[0,0,1,1,0,0,1,0,3,3,0,0,2,2,0,0,3,3,0,1,0,0,2,2,1,1],
	[0,0,1,1,0,0,0,0,3,3,2,2,2,2,2,2,3,3,0,1,0,0,2,2,1,1],
	[0,0,1,1,0,0,0,0,3,3,3,3,3,3,3,3,3,3,0,0,0,0,2,2,1,1],
	[0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,1,1],
	[1,1,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,1,1],
	[1,1,2,2,0,0,0,0,3,3,3,3,3,3,3,3,3,3,0,0,0,0,1,1,1,1],
	[1,1,2,2,0,0,1,0,3,3,2,2,2,2,2,2,3,3,0,1,0,0,1,1,0,0],
	[1,1,2,2,0,0,1,0,3,3,0,0,2,2,0,0,3,3,0,1,0,0,1,1,0,0],
	[1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,2,2,0,0],
	[1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,2,2,0,0],
	[1,1,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0],
	[1,1,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0],
	[1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,2,2,2,2],
	[1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,2,2,2,2],
	[1,1,1,1,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0],
	[1,1,1,1,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,1,1,0,0],
	[1,1,1,1,0,0,0,0,0,0,0,1,9,8,1,0,0,0,0,0,0,0,0,0,0,0],
	[1,1,1,1,0,0,0,0,0,0,0,1,8,8,1,0,0,0,0,0,0,0,0,0,0,0]
];
var map14 = 
[
	[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
	[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
	[3,3,3,3,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,3,3,3,3],
	[3,3,3,3,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,3,3,3,3],
	[3,3,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,3,3],
	[3,3,0,0,0,0,0,1,1,1,3,3,1,1,3,3,1,1,1,0,0,0,0,0,3,3],
	[0,0,0,0,0,0,1,1,1,1,3,3,1,1,3,3,1,1,1,1,0,0,0,0,0,0],
	[0,0,0,0,0,0,1,1,3,3,3,3,1,1,3,3,3,3,1,1,0,0,0,0,0,0],
	[0,0,0,0,0,0,1,1,3,3,3,3,1,1,3,3,3,3,1,1,0,0,0,0,0,0],
	[0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0],
	[3,3,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,3,3],
	[3,3,0,0,0,0,1,1,1,1,3,3,1,1,3,3,1,1,1,1,0,0,0,0,3,3],
	[3,3,3,3,0,0,0,0,1,1,3,3,1,1,3,3,1,1,0,0,0,0,3,3,3,3],
	[3,3,3,3,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,3,3,3,3],
	[4,4,4,4,4,4,0,0,1,1,1,1,1,1,1,1,1,1,0,0,4,4,4,4,4,4],
	[4,4,4,4,4,4,0,0,1,1,1,1,1,1,1,1,1,1,0,0,4,4,4,4,4,4],
	[0,0,0,0,0,0,0,0,0,1,0,1,0,1,0,1,0,1,0,0,0,0,0,0,0,0],
	[0,0,0,0,0,0,0,0,0,1,0,1,0,1,0,1,0,1,0,0,0,0,0,0,0,0],
	[0,0,0,0,0,0,0,0,1,1,1,0,1,0,1,0,1,0,0,0,0,0,0,0,0,0],
	[0,0,0,0,0,0,0,0,1,0,1,0,1,0,1,0,1,0,0,0,0,0,0,0,0,0],
	[0,2,0,2,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,2,0,2,0],
	[0,2,0,2,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,2,0,2,0],
	[1,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,1],
	[1,0,1,0,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,0,1,0,1],
	[2,0,2,0,2,0,0,2,0,0,0,1,9,8,1,0,0,0,2,0,0,2,0,2,0,2],
	[2,0,2,0,2,0,0,2,0,0,0,1,8,8,1,0,0,0,2,0,0,2,0,2,0,2]
];
var map15 = 
[
	[0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0],
	[0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0],
	[0,0,3,3,3,3,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0],
	[0,0,3,3,3,3,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0],
	[3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,0,0,0,0,0,0],
	[3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,0,0,0,0,0,0],
	[3,3,2,2,1,1,3,3,1,1,1,1,1,1,3,3,3,3,3,3,3,3,1,1,2,2],
	[3,3,0,0,1,1,3,3,1,1,1,1,1,1,3,3,3,3,3,3,3,3,1,1,2,2],
	[3,3,3,3,1,1,3,3,3,3,3,3,2,2,3,3,3,3,1,1,2,0,1,1,0,0],
	[3,3,3,3,1,1,3,3,3,3,3,3,0,0,3,3,3,3,1,1,0,0,1,1,0,0],
	[0,0,3,3,3,3,1,1,0,0,3,3,3,3,3,3,3,3,1,1,0,0,1,1,0,0],
	[0,0,3,3,3,3,1,1,2,2,3,3,3,3,3,3,3,3,1,1,0,0,1,1,0,0],
	[0,0,1,1,1,1,1,1,1,1,1,1,3,3,3,3,1,1,1,1,1,0,1,1,0,0],
	[0,0,1,1,1,1,1,1,1,1,1,1,3,3,3,3,1,1,1,1,1,0,3,3,3,3],
	[0,2,2,2,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,3,3,3,3],
	[0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,3,3],
	[0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,3,3,3,3,1,1,1,0,3,3],
	[0,0,1,1,0,0,1,1,0,0,2,2,1,1,0,0,3,3,3,3,1,1,1,0,3,3],
	[0,0,1,1,0,0,0,0,0,1,1,1,1,1,3,3,3,3,1,1,0,0,0,0,3,3],
	[0,0,1,1,0,0,0,0,0,1,1,1,0,0,3,3,3,3,1,1,0,0,0,0,3,3],
	[0,0,1,1,1,1,1,0,0,1,1,1,3,3,3,3,1,1,3,3,1,1,3,3,3,3],
	[0,0,1,1,1,1,1,0,0,1,0,0,3,3,3,3,1,1,3,3,1,1,3,3,3,3],
	[0,0,0,0,1,1,0,0,3,3,0,0,0,0,0,0,1,1,3,3,1,1,3,3,0,0],
	[0,0,0,0,1,1,0,0,3,3,0,1,1,1,1,0,1,1,3,3,0,0,3,3,0,0],
	[0,0,0,0,1,1,0,0,0,0,0,1,9,8,1,0,0,0,3,3,3,3,3,3,0,0],
	[0,0,0,0,0,0,0,0,0,0,0,1,8,8,1,0,0,0,3,3,3,3,3,3,0,0]
];

var map16 = 
[
	[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
	[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
	[0,0,0,0,2,2,3,3,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
	[0,0,0,0,2,2,3,3,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
	[0,0,0,0,0,0,3,3,0,0,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
	[0,0,0,0,0,0,3,3,0,0,3,3,2,2,0,0,0,0,0,0,0,0,0,0,0,0],
	[0,0,3,3,0,0,0,0,0,0,0,0,3,3,0,0,0,0,0,0,0,0,0,0,0,0],
	[0,0,3,3,0,0,0,0,0,0,0,0,3,3,1,1,0,0,0,0,0,0,0,0,0,0],
	[0,0,3,3,3,3,0,0,0,0,3,3,0,0,3,3,0,0,0,0,0,0,0,0,0,0],
	[0,0,3,3,3,3,0,0,0,0,3,3,0,0,3,3,2,2,0,0,0,0,0,0,0,0],
	[0,0,3,3,0,0,3,3,0,0,3,3,0,0,0,0,3,3,0,0,0,0,0,0,0,0],
	[0,0,3,3,0,0,3,3,0,0,3,3,0,0,0,0,3,3,1,1,0,0,0,0,0,0],
	[0,0,3,3,0,0,0,0,3,3,0,0,0,0,0,0,3,3,3,3,0,0,0,0,0,0],
	[0,0,3,3,0,0,0,0,3,3,0,0,0,0,0,0,3,3,3,3,2,2,0,0,0,0],
	[0,0,0,0,3,3,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,0,0,0,0],
	[0,0,0,0,3,3,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,1,1,0,0],
	[0,0,0,0,0,0,3,3,0,0,0,0,3,3,0,0,3,3,3,3,3,3,3,3,0,0],
	[0,0,0,0,0,0,3,3,0,0,0,0,3,3,0,0,3,3,3,3,3,3,3,3,0,0],
	[1,1,0,0,0,0,0,0,0,0,0,0,3,3,0,0,0,0,3,3,3,3,3,3,2,2],
	[1,1,0,0,0,0,0,0,0,0,0,0,3,3,0,0,0,0,3,3,3,3,3,3,2,2],
	[1,1,1,1,0,0,0,0,0,0,0,0,0,0,3,3,0,0,3,3,3,3,3,3,3,3],
	[1,1,1,1,0,0,0,0,0,0,0,0,0,0,3,3,0,0,3,3,3,3,3,3,3,3],
	[2,2,1,1,1,1,0,0,0,0,0,0,0,0,0,0,3,3,0,0,3,3,3,3,3,3],
	[2,2,1,1,1,1,0,0,0,0,0,1,1,1,1,0,3,3,0,0,3,3,3,3,3,3],
	[2,2,2,2,1,1,1,1,0,0,0,1,9,8,1,0,3,3,0,0,0,0,3,3,3,3],
	[2,2,2,2,1,1,1,1,0,0,0,1,8,8,1,0,3,3,0,0,0,0,3,3,3,3]
];
var map17 = 
[
	[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
	[0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0],
	[0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0],
	[0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0],
	[0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,0,0,0,0],
	[0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,0,0,0,0],
	[3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,1,1,1,1,0,0],
	[3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,1,1,1,1,0,0],
	[3,3,0,0,2,2,0,0,0,0,2,2,0,0,0,0,0,0,3,3,3,3,3,3,0,0],
	[3,3,0,0,2,2,0,0,0,0,2,2,0,0,0,0,0,0,3,3,3,3,3,3,0,0],
	[3,3,0,0,2,2,0,0,0,0,2,2,0,0,0,0,0,0,3,3,3,3,3,3,0,0],
	[3,3,0,0,2,2,0,0,0,0,2,2,0,0,0,0,0,0,3,3,3,3,3,3,0,0],
	[3,3,0,0,0,0,3,3,0,0,0,0,0,0,0,0,3,3,3,3,1,1,1,1,1,0],
	[3,3,0,0,0,0,3,3,0,0,0,0,0,0,0,0,3,3,3,3,1,1,1,1,1,0],
	[3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,0],
	[3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,0],
	[1,1,3,3,3,3,1,1,1,1,3,3,3,3,3,3,1,1,1,1,1,1,1,1,0,0],
	[1,1,3,3,3,3,1,1,1,1,3,3,3,3,3,3,1,1,1,1,1,1,1,1,0,0],
	[0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,2,2],
	[0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,2,2],
	[2,2,0,0,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,2,2],
	[2,2,0,0,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2],
	[0,0,2,2,1,1,1,1,2,2,0,0,0,0,0,0,1,1,1,1,2,2,2,2,2,0],
	[0,0,2,2,1,1,0,0,2,2,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0],
	[0,0,0,0,0,0,0,0,0,0,0,1,9,8,1,0,0,0,0,0,0,0,0,0,0,0],
	[0,0,0,0,0,0,0,0,0,0,0,1,8,8,1,0,0,0,0,0,0,0,0,0,0,0]
];

var map18 = 
[
	[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,3,3,0,0],
	[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,3,3,0,0],
	[0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,0,0,2,2,0,0],
	[0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,0,0,2,2,0,0],
	[1,1,3,3,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,2,2,0,0],
	[1,1,3,3,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,2,2,0,0],
	[0,0,1,1,3,3,1,1,0,0,0,0,1,1,0,0,3,3,1,1,2,2,2,2,0,0],
	[0,0,1,1,3,3,1,1,0,0,0,0,1,1,0,0,3,3,1,1,2,2,2,2,0,0],
	[0,0,0,0,1,1,0,0,3,3,2,2,1,1,3,3,0,0,1,1,0,0,0,0,0,0],
	[0,0,0,0,1,1,0,0,3,3,2,2,1,1,3,3,0,0,1,1,0,0,0,0,0,0],
	[0,0,0,0,0,0,0,0,2,2,0,0,1,1,2,2,1,1,1,1,0,0,0,0,0,0],
	[0,0,0,0,0,0,0,0,2,2,0,0,1,1,2,2,1,1,1,1,0,0,0,0,0,0],
	[0,0,0,0,1,1,1,1,2,2,1,1,0,0,2,2,0,0,0,0,0,0,0,0,0,0],
	[0,0,0,0,1,1,1,1,2,2,1,1,0,0,2,2,0,0,0,0,0,0,0,0,0,0],
	[0,0,0,0,1,1,0,0,3,3,1,1,2,2,3,3,0,0,0,0,0,0,0,0,0,0],
	[0,0,0,0,1,1,0,0,3,3,1,1,2,2,3,3,0,0,0,0,0,0,0,0,0,0],
	[2,2,2,2,2,2,3,3,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0],
	[2,2,2,2,2,2,3,3,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0],
	[2,2,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,2,2,2,2,0,0,0,0],
	[2,2,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,2,2,2,2,0,0,0,0],
	[2,2,0,0,0,0,2,2,0,0,0,0,0,0,0,0,0,0,2,2,1,1,1,1,0,0],
	[2,2,0,0,0,0,2,2,0,0,0,0,0,0,0,0,0,0,2,2,1,1,1,1,0,0],
	[3,3,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,1,1,2,2,2,2],
	[3,3,2,2,2,2,2,2,0,0,0,1,1,1,1,0,0,0,0,0,1,1,2,2,2,2],
	[0,0,0,0,0,0,0,0,0,0,0,1,9,8,1,0,0,0,0,0,0,0,2,2,2,2],
	[0,0,0,0,0,0,0,0,0,0,0,1,8,8,1,0,0,0,0,0,0,0,2,2,2,2]
];

var map19 = 
[
	[0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0],
	[0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0],
	[0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0],
	[0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0],
	[0,0,2,2,0,0,2,2,0,0,2,2,0,0,2,2,0,0,2,2,0,0,2,2,0,0],
	[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
	[0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0],
	[1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1],
	[1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1],
	[1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1],
	[2,2,0,0,2,2,0,0,2,2,0,0,2,2,0,0,2,2,0,0,2,2,0,0,2,2],
	[0,0,0,0,0,0,0,0,2,2,0,0,3,3,0,0,2,2,0,0,0,0,0,0,0,0],
	[3,3,3,3,0,0,0,0,1,1,0,0,3,3,0,0,1,1,0,0,0,0,3,3,3,3],
	[3,3,3,3,0,0,0,0,1,1,0,0,3,3,0,0,1,1,0,0,0,0,3,3,3,3],
	[3,3,3,3,3,3,3,3,1,1,1,1,3,3,1,1,1,1,3,3,3,3,3,3,3,3],
	[3,3,3,3,3,3,3,3,1,1,0,0,3,3,0,0,1,1,3,3,3,3,3,3,3,3],
	[3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3],
	[3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3],
	[0,0,0,0,0,0,0,0,1,1,0,0,3,3,0,0,1,1,0,0,0,0,0,0,0,0],
	[1,1,0,0,1,1,0,0,1,1,0,0,3,3,0,0,1,1,0,0,1,1,0,0,1,1],
	[0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0],
	[0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0],
	[0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0],
	[0,0,1,1,0,0,1,1,0,0,0,1,1,1,1,0,0,0,1,1,0,0,1,1,0,0],
	[0,0,1,1,0,0,1,1,0,0,0,1,9,8,1,0,0,0,1,1,0,0,1,1,0,0],
	[0,0,0,0,0,0,0,0,0,0,0,1,8,8,1,0,0,0,0,0,0,0,0,0,0,0]
];

var map20 = 
[
	[0,0,0,0,0,0,4,4,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0],
	[0,0,0,0,0,0,4,4,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0],
	[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,2,2,0,0,0,0],
	[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,2,2,0,0,0,0],
	[0,0,0,0,0,0,4,4,0,0,0,0,2,2,0,0,1,1,0,0,1,1,0,0,0,0],
	[0,0,0,0,0,0,4,4,0,0,1,1,2,2,0,0,1,1,0,0,1,1,0,0,0,0],
	[2,2,0,0,1,1,4,4,0,0,2,2,0,0,0,0,1,1,0,0,1,1,0,0,0,0],
	[0,0,0,0,1,1,4,4,0,0,2,2,0,0,1,1,0,0,0,0,1,1,0,0,0,0],
	[0,0,0,0,1,1,4,4,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0],
	[0,0,0,0,1,1,4,4,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0],
	[1,1,0,0,1,1,4,4,4,4,0,0,4,4,4,4,4,4,4,4,0,0,0,0,1,1],
	[1,1,0,0,1,1,4,4,4,4,0,0,4,4,4,4,4,4,4,4,0,0,0,0,1,1],
	[0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,0,0,4,4,0,0,2,2,2,2],
	[0,0,0,0,0,0,1,1,0,0,0,0,0,0,3,3,0,0,4,4,0,0,0,0,0,0],
	[1,1,1,1,0,1,1,1,0,0,2,2,3,3,3,3,3,3,4,4,0,0,0,0,0,0],
	[1,1,1,1,0,1,1,1,0,0,2,2,3,3,3,3,3,3,4,4,0,0,1,1,1,1],
	[1,1,0,0,0,1,0,0,0,0,1,1,3,3,3,3,3,3,4,4,0,0,1,1,0,0],
	[0,0,0,0,0,1,0,0,0,0,1,1,3,3,3,3,3,3,4,4,0,0,1,1,0,0],
	[0,0,0,0,0,0,0,0,0,0,1,1,0,0,3,3,0,0,4,4,0,0,3,3,0,0],
	[0,0,2,2,0,0,0,0,0,0,1,1,0,0,3,3,0,0,4,4,0,0,3,3,0,0],
	[0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,3,3,3,3,3,3],
	[0,0,1,1,0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3],
	[0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,4,4,3,3,3,3,3,3],
	[0,0,1,1,0,0,1,1,0,0,0,1,1,1,1,0,0,0,4,4,3,3,3,3,3,3],
	[0,0,0,0,0,0,0,0,0,0,0,1,9,8,1,0,0,0,4,4,0,0,3,3,0,0],
	[0,0,0,0,0,0,0,0,0,0,0,1,8,8,1,0,0,0,4,4,0,0,3,3,0,0]
];
var map21 = 
[
	[0,0,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3],
	[4,4,4,4,0,0,4,4,4,4,4,4,0,0,2,4,4,4,4,0,0,0,0,0,0,3],
	[4,0,2,4,1,1,4,1,3,3,3,4,3,0,2,4,2,2,4,0,0,0,3,3,3,3],
	[4,0,2,4,4,4,4,0,3,0,0,4,4,4,4,4,0,0,4,4,4,4,3,2,0,0],
	[4,0,2,0,3,3,3,3,3,2,2,2,3,2,2,5,5,5,5,5,0,4,3,2,0,0],
	[4,4,4,0,3,0,0,0,2,0,0,0,3,0,0,5,0,1,0,0,0,4,3,2,0,4],
	[0,0,4,0,3,0,0,0,2,4,4,4,4,4,3,5,3,3,3,0,0,4,3,2,0,4],
	[0,0,4,1,3,0,0,0,2,4,0,5,5,5,5,5,1,1,3,0,0,4,4,4,4,4],
	[0,3,4,3,3,1,0,0,3,4,3,5,3,4,0,0,1,1,3,3,3,3,3,2,0,4],
	[0,3,4,0,1,0,1,0,3,4,0,5,3,4,4,4,4,3,3,3,1,1,0,2,0,4],
	[4,4,4,0,1,4,4,4,4,4,0,5,1,1,0,0,4,1,0,3,1,1,0,2,4,4],
	[4,3,2,0,1,0,1,0,5,5,5,5,1,0,1,2,4,3,3,3,3,3,2,2,4,0],
	[4,3,2,1,1,1,0,0,5,1,1,3,1,1,0,2,4,1,0,3,1,3,0,0,4,0],
	[4,3,2,1,1,0,0,0,5,0,1,3,1,0,4,4,4,3,4,4,4,3,0,0,4,0],
	[4,3,3,3,3,3,0,0,5,3,3,3,1,0,4,3,0,1,4,0,4,4,4,3,4,0],
	[4,0,2,0,1,5,5,5,5,4,4,0,1,0,4,3,2,2,4,2,0,1,4,3,4,4],
	[4,0,2,1,1,5,4,1,3,1,4,1,1,1,4,3,0,1,4,2,0,1,4,3,0,4],
	[4,4,4,4,1,5,4,0,3,3,4,3,3,3,4,3,0,1,4,2,0,1,4,3,0,4],
	[0,0,2,4,1,5,4,0,3,0,4,4,4,4,4,0,0,1,4,2,0,1,4,4,3,4],
	[0,1,5,5,5,5,4,3,3,1,1,1,1,1,1,1,0,1,4,3,3,3,3,4,0,4],
	[0,0,5,4,4,4,4,3,3,0,0,0,3,3,3,3,3,1,4,4,4,0,3,4,0,4],
	[0,0,5,0,1,3,5,0,3,0,0,0,3,1,1,1,3,1,0,3,4,0,3,4,3,4],
	[5,5,5,0,1,3,5,0,3,0,2,2,3,2,2,0,3,0,0,3,4,0,0,4,4,4],
	[0,0,1,1,0,0,1,1,0,0,0,1,1,1,1,0,0,0,4,4,3,3,3,3,3,3],
	[0,0,0,0,0,0,0,0,0,0,0,1,9,8,1,0,0,0,4,4,0,0,3,3,0,0],
	[0,0,0,0,0,0,0,0,0,0,0,1,8,8,1,0,0,0,4,4,0,0,3,3,0,0]
];
/*
*裂纹动画。
*/
var CrackAnimation = function(type, context, crackObj) {
    //裂纹动画
    this.times = 0;
    this.ctx = context;
    this.frame = 0;
    this.x = 0;
    this.y = 0;
    this.posName = "";
    this.size = 0;
    this.isOver = false;
    this.tempDir = 1;
    this.owner = crackObj;

    if (type == CRACK_TYPE_TANK) {
        this.posName = "tankBomb";//坦克爆炸。
        this.size = 66;
        this.frame = 4;
    } else {
        this.posName = "bulletBomb";//子弹爆炸。
        this.size = 32;
        this.frame = 3;
    }
    this.x = crackObj.x + (parseInt(crackObj.size - this.size) / 2);
    this.y = crackObj.y + (parseInt(crackObj.size - this.size) / 2);

    this.draw = function() {
        var gaptime = 3;
        var temp = parseInt(this.times / gaptime);
        this.ctx.drawImage(RESOURCE_IMAGE, POS[this.posName][0] + temp * this.size, POS[this.posName][1], this.size, this.size, this.x, this.y, this.size, this.size);
        this.times += this.tempDir;
        if (this.times > this.frame * gaptime - parseInt(gaptime / 2)) {
            this.tempDir = -1;
        }
        if (this.times <= 0) {
            this.isOver = true;
        }
    };
};




var Prop = function(context) {
    this.x = 0;
    this.y = 0;
    this.duration = 600;
    this.type = 0;
    this.hit = false;
    this.width = 30;
    this.height = 28;
    this.ctx = context;
    this.isDestroyed = false;
    this.size = 28;

    this.init = function() {
        this.ctx.clearRect(this.x, this.y, this.width, this.height);
        this.duration = 600;
        this.type = parseInt(Math.random() * 6);
        this.x = parseInt(Math.random() * 384) + map.offsetX;
        this.y = parseInt(Math.random() * 384) + map.offsetY;
        this.isDestroyed = false;
    };

    this.draw = function() {
        if (this.duration > 0 && !this.isDestroyed) {
            this.ctx.drawImage(RESOURCE_IMAGE, POS["prop"][0] + this.type * this.width, POS["prop"][1], this.width, this.height, this.x, this.y, this.width, this.height);
            this.duration--;
            this.isHit();
        } else {
            this.ctx.clearRect(this.x, this.y, this.width, this.height);
            this.isDestroyed = true;
        }
    };

    this.isHit = function() {
        var player = null;
        if (player1.lives > 0 && CheckIntersect(this, player1, 0)) {
            this.hit = true;
            player = player1;
        } else if (player2.lives > 0 && CheckIntersect(this, player2, 0)) {
            this.hit = true;
            player = player2;
        }
        if (this.hit) {
            PROP_AUDIO.play();
            this.isDestroyed = true;
            this.ctx.clearRect(this.x, this.y, this.width, this.height);
            switch (this.type) {
                case 0:
                    player.lives++;
                    break;
                case 1:
                    emenyStopTime = 500;
                    break;
                case 2:
                    var mapChangeIndex = [
                        [23, 11],
                        [23, 12],
                        [23, 13],
                        [23, 14],
                        [24, 11],
                        [24, 14],
                        [25, 11],
                        [25, 14]
                    ];
                    map.updateMap(mapChangeIndex, GRID);
                    homeProtectedTime = 500;
                    break;
                case 3:
                    if (enemyArray != null || enemyArray.length > 0) {
                        for (var i = 0; i < enemyArray.length; i++) {
                            var enemyObj = enemyArray[i];
                            enemyObj.distroy();
                        }
                    }
                    break;
                case 4:
                    break;
                case 5:
                    player.isProtected = true;
                    player.protectedTime = 500;
                    break;

            }
        }


    };



};
var Bullet = function(context, owner, type, dir) {
    //子弹。
    this.ctx = context;
    this.x = 0;
    this.y = 0;
    this.owner = owner; //子弹的所属者
    this.type = type; //1、玩家  2、敌方
    this.dir = dir;//方向。
    this.speed = 3;//速度。
    this.size = 6;//大小。
    this.hit = false;//撞击。
    this.isDestroyed = false;

    this.draw = function() {
        this.ctx.drawImage(RESOURCE_IMAGE, POS["bullet"][0] + this.dir * this.size, POS["bullet"][1], this.size, this.size, this.x, this.y, this.size, this.size);
        this.move();
    };

    this.move = function() {
        if (this.dir == UP) {
            this.y -= this.speed;
        } else if (this.dir == DOWN) {
            this.y += this.speed;
        } else if (this.dir == RIGHT) {
            this.x += this.speed;
        } else if (this.dir == LEFT) {
            this.x -= this.speed;
        }

        this.isHit();
    };

    /**
     * 碰撞检测
     */
    this.isHit = function() {
        if (this.isDestroyed) {
            return;
        }
        //临界检测
        if (this.x < map.offsetX) {
            this.x = map.offsetX;
            this.hit = true;
        } else if (this.x > map.offsetX + map.mapWidth - this.size) {
            this.x = map.offsetX + map.mapWidth - this.size;
            this.hit = true;
        }
        if (this.y < map.offsetY) {
            this.y = map.offsetY;
            this.hit = true;
        } else if (this.y > map.offsetY + map.mapHeight - this.size) {
            this.y = map.offsetY + map.mapHeight - this.size;
            this.hit = true;
        }
        //子弹是否碰撞了其他子弹
        if (!this.hit) {
            if (bulletArray != null && bulletArray.length > 0) {
                for (var i = 0; i < bulletArray.length; i++) {
                    if (bulletArray[i] != this && this.owner.isAI != bulletArray[i].owner.isAI && bulletArray[i].hit == false && CheckIntersect(bulletArray[i], this, 0)) {
                        this.hit = true;
                        bulletArray[i].hit = true;
                        break;
                    }
                }
            }
        }

        if (!this.hit) {
            //地图检测
            if (bulletMapCollision(this, map)) {
                this.hit = true;
            }
            //是否击中坦克
            if (this.type == BULLET_TYPE_PLAYER) {
                //子弹属于我方坦克。
                if (enemyArray != null || enemyArray.length > 0) {
                    //有敌人。
                    for (var i = 0; i < enemyArray.length; i++) {
                        var enemyObj = enemyArray[i];
                        if (!enemyObj.isDestroyed && CheckIntersect(this, enemyObj, 0)) {
                            CheckIntersect(this, enemyObj, 0);
                            //碰撞检测。
                            if (enemyObj.lives > 1) {
                                //生命值。
                                enemyObj.lives--;
                            } else {
                                enemyObj.distroy();
                                //消亡
                            }
                            this.hit = true;
                            break;
                        }
                    }
                }
            } else if (this.type == BULLET_TYPE_ENEMY) {
                //子弹属于敌方坦克。
                if (player1.lives > 0 && CheckIntersect(this, player1, 0)) {
                    if (!player1.isProtected && !player1.isDestroyed) {
                        //1号玩家没有护盾，没有破坏。
                        player1.distroy();
                        //1号玩家破坏。
                    }
                    this.hit = true;
                } else if (player2.lives > 0 && CheckIntersect(this, player2, 0)) {
                    if (!player2.isProtected && !player2.isDestroyed) {
                        player2.distroy();
                    }
                    this.hit = true;
                }
            }
        }


        if (this.hit) {
            this.distroy();
        }
    };

    /**
     * 销毁
     */
    this.distroy = function() {
        this.isDestroyed = true;
        crackArray.push(new CrackAnimation(CRACK_TYPE_BULLET, this.ctx, this));
        //添加裂纹动画,裂纹类型子弹。
        if (!this.owner.isAI) {
            //播放子弹销毁的声音。
            BULLET_DESTROY_AUDIO.play();
        }
    };


};
/**
 * 坦克基类
 * @returns
 */
var Tank = function() {
    this.x = 0;
    this.y = 0;
    this.size = 32; //坦克的大小
    this.dir = UP; //方向0：上 1：下 2：左3：右
    this.speed = 1; //坦克的速度
    this.frame = 0; //控制敌方坦克切换方向的时间
    this.hit = false; //是否碰到墙或者坦克
    this.isAI = false; //是否自动
    this.isShooting = false; //子弹是否在运行中
    this.bullet = null; //子弹
    this.shootRate = 0.6; //射击的概率
    this.isDestroyed = false;
    this.tempX = 0;
    this.tempY = 0;

    this.move = function() {
        //如果是AI坦克，在一定时间或者碰撞之后切换方法

        if (this.isAI && emenyStopTime > 0) {
            return;
        }

        this.tempX = this.x;
        this.tempY = this.y;

        if (this.isAI) {
            this.frame++;
            if (this.frame % 100 == 0 || this.hit) {
                this.dir = parseInt(Math.random() * 4); //随机一个方向
                this.hit = false;
                this.frame = 0;
            }
        }
        if (this.dir == UP) {
            this.tempY -= this.speed;
        } else if (this.dir == DOWN) {
            this.tempY += this.speed;
        } else if (this.dir == RIGHT) {
            this.tempX += this.speed;
        } else if (this.dir == LEFT) {
            this.tempX -= this.speed;
        }
        this.isHit();
        if (!this.hit) {
            this.x = this.tempX;
            this.y = this.tempY;
        }
    };

    /**
     * 碰撞检测
     */
    this.isHit = function() {
        //临界检测
        if (this.dir == LEFT) {
            if (this.x <= map.offsetX) {
                this.x = map.offsetX;
                this.hit = true;
            }
        } else if (this.dir == RIGHT) {
            if (this.x >= map.offsetX + map.mapWidth - this.size) {
                this.x = map.offsetX + map.mapWidth - this.size;
                this.hit = true;
            }
        } else if (this.dir == UP) {
            if (this.y <= map.offsetY) {
                this.y = map.offsetY;
                this.hit = true;
            }
        } else if (this.dir == DOWN) {
            if (this.y >= map.offsetY + map.mapHeight - this.size) {
                this.y = map.offsetY + map.mapHeight - this.size;
                this.hit = true;
            }
        }
        if (!this.hit) {
            //地图检测
            if (tankMapCollision(this, map)) {
                this.hit = true;
            }
        }
        //坦克检测
        /*
        if (enemyArray != null && enemyArray.length > 0) {
            var enemySize = enemyArray.length;
            for (var i = 0; i < enemySize; i++) {
                if (enemyArray[i] != this && CheckIntersect(enemyArray[i], this, 0)) {
                    this.hit = true;
                    break;
                }
            }
        }
        */
    };

    /**
     * 是否被击中
     */
    this.isShot = function() {

    };
    /**
     * 射击
     */
    this.shoot = function(type) {
        if (this.isAI && emenyStopTime > 0) {
            return;
        }
        if (this.isShooting) {
            return;
        } else {
            var tempX = this.x;
            var tempY = this.y;
            this.bullet = new Bullet(this.ctx, this, type, this.dir);
            if (this.dir == UP) {
                tempX = this.x + parseInt(this.size / 2) - parseInt(this.bullet.size / 2);
                tempY = this.y - this.bullet.size;
            } else if (this.dir == DOWN) {
                tempX = this.x + parseInt(this.size / 2) - parseInt(this.bullet.size / 2);
                tempY = this.y + this.size;
            } else if (this.dir == LEFT) {
                tempX = this.x - this.bullet.size;
                tempY = this.y + parseInt(this.size / 2) - parseInt(this.bullet.size / 2);
            } else if (this.dir == RIGHT) {
                tempX = this.x + this.size;
                tempY = this.y + parseInt(this.size / 2) - parseInt(this.bullet.size / 2);
            }
            this.bullet.x = tempX;
            this.bullet.y = tempY;
            if (!this.isAI) {
                ATTACK_AUDIO.play();
            }
            this.bullet.draw();
            //将子弹加入的子弹数组中
            bulletArray.push(this.bullet);
            this.isShooting = true;
        }
    };

    /**
     * 坦克被击毁
     */
    this.distroy = function() {
        this.isDestroyed = true;
        crackArray.push(new CrackAnimation(CRACK_TYPE_TANK, this.ctx, this));
        TANK_DESTROY_AUDIO.play();
    };



};

/**
 * 菜单选择坦克
 * @returns
 */
var SelectTank = function() {
    this.ys = [250, 281]; //两个Y坐标，分别对应1p和2p
    this.x = 140;
    this.size = 27;
};

SelectTank.prototype = new Tank();

/**
 * 玩家坦克
 * @param context 画坦克的画布
 * @returns
 */
var PlayTank = function(context) {
    this.ctx = context;
    this.lives = 3; //生命值
    this.isProtected = true; //是否受保护
    this.protectedTime = 500; //保护时间
    this.offsetX = 0; //坦克2与坦克1的距离
    this.speed = 2; //坦克的速度

    this.draw = function() {
        this.hit = false;
        this.ctx.drawImage(RESOURCE_IMAGE, POS["player"][0] + this.offsetX + this.dir * this.size, POS["player"][1], this.size, this.size, this.x, this.y, this.size, this.size);
        if (this.isProtected) {
            var temp = parseInt((500 - this.protectedTime) / 5) % 2;
            this.ctx.drawImage(RESOURCE_IMAGE, POS["protected"][0], POS["protected"][1] + 32 * temp, 32, 32, this.x, this.y, 32, 32);
            this.protectedTime--;
            if (this.protectedTime == 0) {
                this.isProtected = false;
            }
        }

    };

    this.distroy = function() {
        this.isDestroyed = true;
        crackArray.push(new CrackAnimation(CRACK_TYPE_TANK, this.ctx, this));
        PLAYER_DESTROY_AUDIO.play();
    };

    this.renascenc = function(player) {
        this.lives--;
        this.dir = UP;
        this.isProtected = true;
        this.protectedTime = 500;
        this.isDestroyed = false;
        var temp = 0;
        if (player == 1) {
            temp = 129;
        } else {
            temp = 256;
        }
        this.x = temp + map.offsetX;
        this.y = 385 + map.offsetY;
    };

};
PlayTank.prototype = new Tank();

/**
 * 敌方坦克1
 * @param context 画坦克的画布
 * @returns
 */
var EnemyOne = function(context) {
    this.ctx = context;
    this.isAppear = false;
    this.times = 0;
    this.lives = 1;
    this.isAI = true;
    this.speed = 1.5;

    this.draw = function() {
        this.times++;
        if (!this.isAppear) {
            var temp = parseInt(this.times / 5) % 7;
            this.ctx.drawImage(RESOURCE_IMAGE, POS["enemyBefore"][0] + temp * 32, POS["enemyBefore"][1], 32, 32, this.x, this.y, 32, 32);
            if (this.times == 34) {
                this.isAppear = true;
                this.times = 0;
                this.shoot(2);
            }
        } else {
            this.ctx.drawImage(RESOURCE_IMAGE, POS["enemy1"][0] + this.dir * this.size, POS["enemy1"][1], 32, 32, this.x, this.y, 32, 32);

            //以一定的概率射击
            if (this.times % 50 == 0) {
                var ra = Math.random();
                if (ra < this.shootRate) {
                    this.shoot(2);
                }
                this.times = 0;
            }
            this.move();


        }

    };

};
EnemyOne.prototype = new Tank();


/**
 * 敌方坦克2
 * @param context 画坦克的画布
 * @returns
 */
var EnemyTwo = function(context) {
    this.ctx = context;
    this.isAppear = false;
    this.times = 0;
    this.lives = 2;
    this.isAI = true;
    this.speed = 1;

    this.draw = function() {
        this.times++;
        if (!this.isAppear) {
            var temp = parseInt(this.times / 5) % 7;
            this.ctx.drawImage(RESOURCE_IMAGE, POS["enemyBefore"][0] + temp * 32, POS["enemyBefore"][1], 32, 32, this.x, this.y, 32, 32);
            if (this.times == 35) {
                this.isAppear = true;
                this.times = 0;
                this.shoot(2);
            }
        } else {
            this.ctx.drawImage(RESOURCE_IMAGE, POS["enemy2"][0] + this.dir * this.size, POS["enemy2"][1], 32, 32, this.x, this.y, 32, 32);
            //以一定的概率射击
            if (this.times % 50 == 0) {
                var ra = Math.random();
                if (ra < this.shootRate) {
                    this.shoot(2);
                }
                this.times = 0;
            }
            this.move();
        }
    };

};
EnemyTwo.prototype = new Tank();



/**
 * 敌方坦克3
 * @param context 画坦克的画布
 * @returns
 */
var EnemyThree = function(context) {
    this.ctx = context;
    this.isAppear = false;
    this.times = 0;
    this.lives = 3;
    this.isAI = true;
    this.speed = 0.5;

    this.draw = function() {
        this.times++;
        if (!this.isAppear) {
            var temp = parseInt(this.times / 5) % 7;
            this.ctx.drawImage(RESOURCE_IMAGE, POS["enemyBefore"][0] + temp * 32, POS["enemyBefore"][1], 32, 32, this.x, this.y, 32, 32);
            if (this.times == 35) {
                this.isAppear = true;
                this.times = 0;
                this.shoot(2);
            }
        } else {
            this.ctx.drawImage(RESOURCE_IMAGE, POS["enemy3"][0] + this.dir * this.size + (3 - this.lives) * this.size * 4, POS["enemy3"][1], 32, 32, this.x, this.y, 32, 32);
            //以一定的概率射击
            if (this.times % 50 == 0) {
                var ra = Math.random();
                if (ra < this.shootRate) {
                    this.shoot(2);
                }
                this.times = 0;
            }
            this.move();
        }

    };

};
EnemyThree.prototype = new Tank();
var Num = function(context) {
    this.ctx = context;
    this.size = 14;

    this.draw = function(num, x, y) {
        var tempX = x;
        var tempY = y;
        var tempNumArray = [];
        if (num == 0) {
            tempNumArray.push(0);
        } else {
            while (num > 0) {
                tempNumArray.push(num % 10);
                num = parseInt(num / 10);
            }
        }
        for (var i = tempNumArray.length - 1; i >= 0; i--) {
            tempX = x + (tempNumArray.length - i - 1) * this.size;
            this.ctx.drawImage(RESOURCE_IMAGE, POS["num"][0] + tempNumArray[i] * 14, POS["num"][1], this.size, this.size, tempX, tempY, this.size, this.size);

        }
    };

};
/**
 * 游戏开始菜单
 **/

var Menu = function(context) {
    this.ctx = context;
    this.x = 0;
    this.y = -SCREEN_HEIGHT;
    this.selectTank = new SelectTank();
    this.playNum = 1;
    this.times = 0;

    /**
     * 画菜单
     */
    this.draw = function() {

        this.times++;
        var temp = 0;
        if (parseInt(this.times / 6) % 2 == 0) {
            temp = 0;
        } else {
            temp = this.selectTank.size;
        }
        if (this.y >= 0) {
            this.y = 0;
        } else {
            this.y += 5;
        }
        this.ctx.clearRect(0, 0, SCREEN_WIDTH, SCREEN_HEIGHT);
        this.ctx.save();
        //画背景
        this.ctx.drawImage(MENU_IMAGE, this.x, this.y);
            log(MENU_IMAGE,this.x,this.y);
        //画选择坦克
        this.ctx.drawImage(RESOURCE_IMAGE, POS["selectTank"][0], POS["selectTank"][1] + temp, this.selectTank.size, this.selectTank.size,
            this.selectTank.x, this.y + this.selectTank.ys[this.playNum - 1], this.selectTank.size, this.selectTank.size);
        this.ctx.restore();
    };

    /**
     * 选择坦克上下移动
     */
    this.next = function(n) {
        this.playNum += n;
        if (this.playNum > 2) {
            this.playNum = 1;
        } else if (this.playNum < 1) {
            this.playNum = 2;
        }
    };
};
var Map = function(wCtx, gCtx) {
    this.level = 1;
    this.mapLevel = null;
    this.wallCtx = wCtx;
    this.grassCtx = gCtx;

    this.offsetX = 32; //主游戏区的X偏移量
    this.offsetY = 16; //主游戏区的Y偏移量
    this.wTileCount = 26; //主游戏区的宽度地图块数
    this.HTileCount = 26; //主游戏区的高度地图块数
    this.tileSize = 16; //地图块的大小
    this.homeSize = 32; //家图标的大小
    this.num = new Num(this.wallCtx);
    this.mapWidth = 416;
    this.mapHeight = 416;

    this.setMapLevel = function(level) {
        this.level = level;
        var tempMap = eval("map" + this.level);
        this.mapLevel = new Array();
        for (var i = 0; i < tempMap.length; i++) {
            this.mapLevel[i] = new Array();
            for (var j = 0; j < tempMap[i].length; j++) {
                this.mapLevel[i][j] = tempMap[i][j];
            }

        }
    };

    /**
     * 绘制地图
     */
    this.draw = function() {
        this.wallCtx.setColor("#7f7f7f");
        this.wallCtx.fillRect(0, 0, SCREEN_WIDTH, SCREEN_HEIGHT);
        this.wallCtx.setColor("#000000");
        this.wallCtx.fillRect(this.offsetX, this.offsetY, this.mapWidth, this.mapHeight); //主游戏区

        this.grassCtx.clearRect(0, 0, SCREEN_WIDTH, SCREEN_HEIGHT);

        for (var i = 0; i < this.HTileCount; i++) {
            for (var j = 0; j < this.wTileCount; j++) {
                if (this.mapLevel[i][j] == WALL || this.mapLevel[i][j] == GRID || this.mapLevel[i][j] == WATER || this.mapLevel[i][j] == ICE) {
                    this.wallCtx.drawImage(RESOURCE_IMAGE, this.tileSize * (this.mapLevel[i][j] - 1) + POS["map"][0], POS["map"][1], this.tileSize, this.tileSize, j * this.tileSize + this.offsetX, i * this.tileSize + this.offsetY, this.tileSize, this.tileSize);
                } else if (this.mapLevel[i][j] == GRASS) {
                    this.grassCtx.drawImage(RESOURCE_IMAGE, this.tileSize * (this.mapLevel[i][j] - 1) + POS["map"][0], POS["map"][1], this.tileSize, this.tileSize, j * this.tileSize + this.offsetX, i * this.tileSize + this.offsetY, this.tileSize, this.tileSize);
                } else if (this.mapLevel[i][j] == HOME) {
                    this.wallCtx.drawImage(RESOURCE_IMAGE, POS["home"][0], POS["home"][1], this.homeSize, this.homeSize, j * this.tileSize + this.offsetX, i * this.tileSize + this.offsetY, this.homeSize, this.homeSize);
                }
            }
        }
        this.drawNoChange();
        this.drawEnemyNum(maxEnemy);
        this.drawLevel();
        this.drawLives(0, 1);
        this.drawLives(0, 2);
    };

    /**
     * 画固定不变的部分
     */
    this.drawNoChange = function() {
        this.wallCtx.drawImage(RESOURCE_IMAGE, POS["score"][0], POS["score"][1], 30, 32, 464, 256, 30, 32); //player1

        this.wallCtx.drawImage(RESOURCE_IMAGE, 30 + POS["score"][0], POS["score"][1], 30, 32, 464, 304, 30, 32); //player2
        //30,32旗帜的size, 464, 352旗帜在canvas中位置
        this.wallCtx.drawImage(RESOURCE_IMAGE, 60 + POS["score"][0], POS["score"][1], 30, 32, 464, 352, 32, 30); //画旗帜
    };

    /**
     * 画关卡数
     */
    this.drawLevel = function() {
        this.num.draw(this.level, 468, 384);
    };

    /**
     * 画右侧敌方坦克数
     * @param enemyNum 地方坦克总数
     */
    this.drawEnemyNum = function(enemyNum) {
        var x = 466;
        var y = 34;
        var enemySize = 16;
        for (var i = 1; i <= enemyNum; i++) {
            var tempX = x;
            var tempY = y + parseInt((i + 1) / 2) * enemySize;
            if (i % 2 == 0) {
                tempX = x + enemySize;
            }
            this.wallCtx.drawImage(RESOURCE_IMAGE, 92 + POS["score"][0], POS["score"][1], 14, 14, tempX, tempY, 14, 14);
        }
    };

    /**
     * 清除右侧敌方坦克数，从最下面开始清楚
     * @param totolEnemyNum 敌方坦克的总数
     * @param enemyNum 已出现的敌方坦克数
     */
    this.clearEnemyNum = function(totolEnemyNum, enemyNum) {
        var x = 466;
        var y = 34 + this.offsetY;
        if (enemyNum <= 0) {
            return;
        }
        var enemySize = 16;
        this.wallCtx.setColor("#7f7f7f");
        var tempX = x + (enemyNum % 2) * enemySize;
        var tempY = y + (Math.ceil(totolEnemyNum / 2) - 1) * enemySize - (parseInt((enemyNum - 1) / 2)) * enemySize;
        this.wallCtx.fillRect(tempX, tempY, 14, 14);
    };

    /**
     * 画坦克的生命数
     * @param lives 生命数
     * @param which 坦克索引，1、代表玩家1  2、代表玩家2
     */
    this.drawLives = function(lives, which) {
        var x = 482;
        var y = 272;
        if (which == 2) {
            y = 320;
        }
        this.wallCtx.setColor("#7f7f7f");
        this.wallCtx.fillRect(x, y, this.num.size, this.num.size);
        this.num.draw(lives, x, y);
        //this.wallCtx.drawImage(RESOURCE_IMAGE,POS["num"][0]+lives*14,POS["num"][1],14, 14,x, y,14, 14);
    };

    /**
     * 更新地图
     * @param indexArr 需要更新的地图索引数组，二维数组，如[[1,1],[2,2]]
     * @param target 更新之后的数值
     */
    this.updateMap = function(indexArr, target) {
        if (indexArr != null && indexArr.length > 0) {
            var indexSize = indexArr.length;
            for (var i = 0; i < indexSize; i++) {
                var index = indexArr[i];
                this.mapLevel[index[0]][index[1]] = target;
                if (target > 0) {
                    this.wallCtx.drawImage(RESOURCE_IMAGE, this.tileSize * (target - 1) + POS["map"][0], POS["map"][1], this.tileSize, this.tileSize, index[1] * this.tileSize + this.offsetX, index[0] * this.tileSize + this.offsetY, this.tileSize, this.tileSize);
                } else {
                    this.wallCtx.setColor("#000000");
                    this.wallCtx.fillRect(index[1] * this.tileSize + this.offsetX, index[0] * this.tileSize + this.offsetY, this.tileSize, this.tileSize);
                }
            }
        }
    };

    this.homeHit = function() {
        this.wallCtx.drawImage(RESOURCE_IMAGE, POS["home"][0] + this.homeSize, POS["home"][1], this.homeSize, this.homeSize, 12 * this.tileSize + this.offsetX, 24 * this.tileSize + this.offsetY, this.homeSize, this.homeSize);
    };
};
/**
 * 检测2个物体是否碰撞
 * @param object1 物体1
 * @param object2 物体2
 * @param overlap 允许重叠的大小
 * @returns {Boolean} 如果碰撞了，返回true
 */
function CheckIntersect(object1, object2, overlap) {
    //    x-轴                      x-轴
    //  A1------>B1 C1              A2------>B2 C2
    //  +--------+   ^              +--------+   ^
    //  | object1|   | y-轴         | object2|   | y-轴
    //  |        |   |              |        |   |
    //  +--------+  D1              +--------+  D2
    //
    //overlap是重叠的区域值
    A1 = object1.x + overlap;
    B1 = object1.x + object1.size - overlap;
    C1 = object1.y + overlap;
    D1 = object1.y + object1.size - overlap;

    A2 = object2.x + overlap;
    B2 = object2.x + object2.size - overlap;
    C2 = object2.y + overlap;
    D2 = object2.y + object2.size - overlap;

    //假如他们在x-轴重叠
    if (A1 >= A2 && A1 <= B2 || B1 >= A2 && B1 <= B2) {
        //判断y-轴重叠
        if (C1 >= C2 && C1 <= D2 || D1 >= C2 && D1 <= D2) {
            return true;
        }
    }
    return false;
}

/**
 * 坦克与地图块碰撞
 * @param tank 坦克对象
 * @param mapobj 地图对象
 * @returns {Boolean} 如果碰撞，返回true
 */
function tankMapCollision(tank, mapobj) {
    //移动检测，记录最后一次的移动方向，根据方向判断+-overlap,
    var tileNum = 0; //需要检测的tile数
    var rowIndex = 0; //map中的行索引
    var colIndex = 0; //map中的列索引
    var overlap = 3; //允许重叠的大小

    //根据tank的x、y计算出map中的row和col
    if (tank.dir == UP) {
        rowIndex = parseInt((tank.tempY + overlap - mapobj.offsetY) / mapobj.tileSize);
        colIndex = parseInt((tank.tempX + overlap - mapobj.offsetX) / mapobj.tileSize);
    } else if (tank.dir == DOWN) {
        //向下，即dir==1的时候，行索引的计算需要+tank.Height
        rowIndex = parseInt((tank.tempY - overlap - mapobj.offsetY + tank.size) / mapobj.tileSize);
        colIndex = parseInt((tank.tempX + overlap - mapobj.offsetX) / mapobj.tileSize);
    } else if (tank.dir == LEFT) {
        rowIndex = parseInt((tank.tempY + overlap - mapobj.offsetY) / mapobj.tileSize);
        colIndex = parseInt((tank.tempX + overlap - mapobj.offsetX) / mapobj.tileSize);
    } else if (tank.dir == RIGHT) {
        rowIndex = parseInt((tank.tempY + overlap - mapobj.offsetY) / mapobj.tileSize);
        //向右，即dir==3的时候，列索引的计算需要+tank.Height
        colIndex = parseInt((tank.tempX - overlap - mapobj.offsetX + tank.size) / mapobj.tileSize);
    }
    if (rowIndex >= mapobj.HTileCount || rowIndex < 0 || colIndex >= mapobj.wTileCount || colIndex < 0) {
        return true;
    }
    if (tank.dir == UP || tank.dir == DOWN) {
        var tempWidth = parseInt(tank.tempX - map.offsetX - (colIndex) * mapobj.tileSize + tank.size - overlap); //去除重叠部分
        if (tempWidth % mapobj.tileSize == 0) {
            tileNum = parseInt(tempWidth / mapobj.tileSize);
        } else {
            tileNum = parseInt(tempWidth / mapobj.tileSize) + 1;
        }
        for (var i = 0; i < tileNum && colIndex + i < mapobj.wTileCount; i++) {
            var mapContent = mapobj.mapLevel[rowIndex][colIndex + i];
            if (mapContent == WALL || mapContent == GRID || mapContent == WATER || mapContent == HOME || mapContent == ANOTHREHOME) {
                if (tank.dir == UP) {
                    tank.y = mapobj.offsetY + rowIndex * mapobj.tileSize + mapobj.tileSize - overlap;
                } else if (tank.dir == DOWN) {
                    tank.y = mapobj.offsetY + rowIndex * mapobj.tileSize - tank.size + overlap;
                }
                return true;
            }
        }
    } else {
        var tempHeight = parseInt(tank.tempY - map.offsetY - (rowIndex) * mapobj.tileSize + tank.size - overlap); //去除重叠部分
        if (tempHeight % mapobj.tileSize == 0) {
            tileNum = parseInt(tempHeight / mapobj.tileSize);
        } else {
            tileNum = parseInt(tempHeight / mapobj.tileSize) + 1;
        }
        for (var i = 0; i < tileNum && rowIndex + i < mapobj.HTileCount; i++) {
            var mapContent = mapobj.mapLevel[rowIndex + i][colIndex];
            if (mapContent == WALL || mapContent == GRID || mapContent == WATER || mapContent == HOME || mapContent == ANOTHREHOME) {
                if (tank.dir == LEFT) {
                    tank.x = mapobj.offsetX + colIndex * mapobj.tileSize + mapobj.tileSize - overlap;
                } else if (tank.dir == RIGHT) {
                    tank.x = mapobj.offsetX + colIndex * mapobj.tileSize - tank.size + overlap;
                }
                return true;
            }
        }
    }
    return false;
}

/**
 * 子弹与地图块的碰撞
 * @param bullet 子弹对象
 * @param mapobj 地图对象
 */
function bulletMapCollision(bullet, mapobj) {
    var tileNum = 0; //需要检测的tile数
    var rowIndex = 0; //map中的行索引
    var colIndex = 0; //map中的列索引
    var mapChangeIndex = []; //map中需要更新的索引数组
    var result = false; //是否碰撞
    //根据bullet的x、y计算出map中的row和col
    if (bullet.dir == UP) {
        rowIndex = parseInt((bullet.y - mapobj.offsetY) / mapobj.tileSize);
        colIndex = parseInt((bullet.x - mapobj.offsetX) / mapobj.tileSize);
    } else if (bullet.dir == DOWN) {
        //向下，即dir==1的时候，行索引的计算需要+bullet.Height
        rowIndex = parseInt((bullet.y - mapobj.offsetY + bullet.size) / mapobj.tileSize);
        colIndex = parseInt((bullet.x - mapobj.offsetX) / mapobj.tileSize);
    } else if (bullet.dir == LEFT) {
        rowIndex = parseInt((bullet.y - mapobj.offsetY) / mapobj.tileSize);
        colIndex = parseInt((bullet.x - mapobj.offsetX) / mapobj.tileSize);
    } else if (bullet.dir == RIGHT) {
        rowIndex = parseInt((bullet.y - mapobj.offsetY) / mapobj.tileSize);
        //向右，即dir==3的时候，列索引的计算需要+bullet.Height
        colIndex = parseInt((bullet.x - mapobj.offsetX + bullet.size) / mapobj.tileSize);
    }
    if (rowIndex >= mapobj.HTileCount || rowIndex < 0 || colIndex >= mapobj.wTileCount || colIndex < 0) {
        return true;
    }

    if (bullet.dir == UP || bullet.dir == DOWN) {
        var tempWidth = parseInt(bullet.x - map.offsetX - (colIndex) * mapobj.tileSize + bullet.size);
        if (tempWidth % mapobj.tileSize == 0) {
            tileNum = parseInt(tempWidth / mapobj.tileSize);
        } else {
            tileNum = parseInt(tempWidth / mapobj.tileSize) + 1;
        }
        for (var i = 0; i < tileNum && colIndex + i < mapobj.wTileCount; i++) {
            var mapContent = mapobj.mapLevel[rowIndex][colIndex + i];
            if (mapContent == WALL || mapContent == GRID || mapContent == HOME || mapContent == ANOTHREHOME) {
                //bullet.distroy();
                result = true;
                if (mapContent == WALL) {
                    //墙被打掉
                    mapChangeIndex.push([rowIndex, colIndex + i]);
                } else if (mapContent == GRID) {

                } else {
                    isGameOver = true;
                    break;
                }
            }
        }
    } else {
        var tempHeight = parseInt(bullet.y - map.offsetY - (rowIndex) * mapobj.tileSize + bullet.size);
        if (tempHeight % mapobj.tileSize == 0) {
            tileNum = parseInt(tempHeight / mapobj.tileSize);
        } else {
            tileNum = parseInt(tempHeight / mapobj.tileSize) + 1;
        }
        for (var i = 0; i < tileNum && rowIndex + i < mapobj.HTileCount; i++) {
            var mapContent = mapobj.mapLevel[rowIndex + i][colIndex];
            if (mapContent == WALL || mapContent == GRID || mapContent == HOME || mapContent == ANOTHREHOME) {
                //bullet.distroy();
                result = true;
                if (mapContent == WALL) {
                    //墙被打掉
                    mapChangeIndex.push([rowIndex + i, colIndex]);
                } else if (mapContent == GRID) {

                } else {
                    isGameOver = true;
                    break;
                }
            }
        }
    }
    //更新地图
    map.updateMap(mapChangeIndex, 0);
    return result;
}


var Stage = function(context, l) {
    this.ctx = context;
    this.ctx.setColor("#7f7f7f");
    this.drawHeigth = 15;
    this.level = l;
    this.temp = 0;
    this.dir = 1; //中间切换的方向，1：合上，2：展开
    this.isReady = false; //标识地图是否已经画好
    this.levelNum = new Num(context);

    this.init = function(level) {
        this.dir = 1;
        this.isReady = false;
        this.level = level;
        this.temp = 0;
    };

    this.draw = function() {
        if (this.dir == 1) {

            //temp = 15*15 灰色屏幕已经画完
            if (this.temp == 225) {
                //78,14为STAGE字样在图片资源中的宽和高，194,208为canvas中的位置
                this.ctx.drawImage(RESOURCE_IMAGE, POS["stageLevel"][0], POS["stageLevel"][1], 78, 14, 194, 208, 78, 14);
                //14为数字的宽和高，308, 208为canvas中的位置
                this.levelNum.draw(this.level, 308, 208);
                this.ctx.drawImage(RESOURCE_IMAGE,POS["num"][0]+this.level*14,POS["num"][1],14, 14,308, 208,14, 14);
                //绘制地图,调用main里面的方法
                initMap();

            } else if (this.temp == 225 + 600) {
                //600即调用了600/15次，主要用来停顿
                this.temp = 225;
                this.dir = -1;
                START_AUDIO.play();
            } else {
                this.ctx.fillRect(0, this.temp, 512, this.drawHeigth);
                this.ctx.fillRect(0, 448 - this.temp - this.drawHeigth, 512, this.drawHeigth);
            }
        } else {
            if (this.temp >= 0) {
                this.ctx.clearRect(0, this.temp, 512, this.drawHeigth);
                this.ctx.clearRect(0, 448 - this.temp - this.drawHeigth, 512, this.drawHeigth);
            } else {
                this.isReady = true;
            }
        }
        this.temp += this.drawHeigth * this.dir;
    };
};
var ctx; //2d画布
var wallCtx; //地图画布
var grassCtx; //草地画布
var tankCtx; //坦克画布
var overCtx; //结束画布
var menu = null; //菜单
var stage = null; //舞台
var map = null; //地图
var player1 = null; //玩家1
var player2 = null; //玩家2
var prop = null;
var enemyArray = []; //敌方坦克
var bulletArray = []; //子弹数组
var keys = []; //记录按下的按键
var crackArray = []; //爆炸数组

var gameState = GAME_STATE_MENU; //默认菜单状态
var level = 1;
var maxEnemy = 20; //敌方坦克总数
var maxAppearEnemy = 5; //屏幕上一起出现的最大数
var appearEnemy = 0; //已出现的敌方坦克
var mainframe = 0;
var isGameOver = false;
var overX = 176;
var overY = 384;
var emenyStopTime = 0;
var homeProtectedTime = -1;
var propTime = 300;

initScreen();
initObject();

setInterval(()=>{gameLoop();}, 20);

function initScreen() {
    ctx = new myCanvas(SCREEN_WIDTH*2, SCREEN_HEIGHT*2); //2d画布
    wallCtx = new myCanvas(SCREEN_WIDTH*2, SCREEN_HEIGHT*2); //地图画布
    grassCtx = new myCanvas(SCREEN_WIDTH*2, SCREEN_HEIGHT*2); //草地画布
    tankCtx = new myCanvas(SCREEN_WIDTH*2, SCREEN_HEIGHT*2); //坦克画布
    overCtx = new myCanvas(SCREEN_WIDTH*2, SCREEN_HEIGHT*2); //结束画布
}

function initObject() {
    menu = new Menu(ctx);
    stage = new Stage(ctx, level);
    map = new Map(wallCtx, grassCtx);
    player1 = new PlayTank(tankCtx);
    player1.x = 129 + map.offsetX;
    player1.y = 385 + map.offsetY;
    player2 = new PlayTank(tankCtx);
    player2.offsetX = 128; //player2的图片x与图片1相距128
    player2.x = 256 + map.offsetX;
    player2.y = 385 + map.offsetY;
    appearEnemy = 0; //已出现的敌方坦克
    enemyArray = []; //敌方坦克
    bulletArray = []; //子弹数组
    keys = []; //记录按下的按键
    crackArray = []; //爆炸数组
    isGameOver = false;
    overX = 176;
    overY = 384;
    overCtx.clearRect(0, 0, SCREEN_WIDTH, SCREEN_HEIGHT);
    emenyStopTime = 0;
    homeProtectedTime = -1;
    propTime = 1000;
}

function gameLoop() {
    switch (gameState) {

        case GAME_STATE_MENU:
            menu.draw();
            break;
        case GAME_STATE_INIT:
            stage.draw();
            if (stage.isReady == true) {
                gameState = GAME_STATE_START;
            }
            break;
        case GAME_STATE_START:
            drawAll();
            if (isGameOver || (player1.lives <= 0 && player2.lives <= 0)) {
                gameState = GAME_STATE_OVER;
                map.homeHit();
                PLAYER_DESTROY_AUDIO.play();
            }
            if (appearEnemy == maxEnemy && enemyArray.length == 0) {
                gameState = GAME_STATE_WIN;
            }
            break;
        case GAME_STATE_WIN:
            nextLevel();
            break;
        case GAME_STATE_OVER:
            gameOver();
            break;
    }
}

function keydown(e) {
    switch (gameState) {
        case GAME_STATE_MENU:
            if (e.keyCode == keyboard.E) {
                gameState = GAME_STATE_INIT;
                //只有一个玩家
                if (menu.playNum == 1) {
                    player2.lives = 0;
                }
            } else {
                var n = 0;
                if (e.keyCode == keyboard.DOWN) {
                    n = 1;
                } else if (e.keyCode == keyboard.UP) {
                    n = -1;
                }
                menu.next(n);
            }
            break;
        case GAME_STATE_START:
            if (!keys.contain(e.keyCode)) {
                keys.push(e.keyCode);
            }
            //射击
            if (e.keyCode == keyboard.B && player1.lives > 0) {
                player1.shoot(BULLET_TYPE_PLAYER);
            } else if (e.keyCode == keyboard.E && player2.lives > 0) {
                player2.shoot(BULLET_TYPE_ENEMY);
            } else if (e.keyCode == keyboard.N) {
                nextLevel();
            } else if (e.keyCode == keyboard.P) {
                preLevel();
            }
            break;
    }
};

function keyup(e) {
    keys.remove(e.keyCode);
};

function initMap() {
    map.setMapLevel(level);;
    map.draw();
    drawLives();
}

function drawLives() {
    map.drawLives(player1.lives, 1);
    map.drawLives(player2.lives, 2);
}

function drawBullet() {
    if (bulletArray != null && bulletArray.length > 0) {
        for (var i = 0; i < bulletArray.length; i++) {
            var bulletObj = bulletArray[i];
            if (bulletObj.isDestroyed) {
                bulletObj.owner.isShooting = false;
                bulletArray.removeByIndex(i);
                i--;
            } else {
                bulletObj.draw();
            }
        }
    }
}

function keyEvent() {
    if (keys.contain(keyboard.W)) {
        player1.dir = UP;
        player1.hit = false;
        player1.move();
    } else if (keys.contain(keyboard.S)) {
        player1.dir = DOWN;
        player1.hit = false;
        player1.move();
    } else if (keys.contain(keyboard.A)) {
        player1.dir = LEFT;
        player1.hit = false;
        player1.move();
    } else if (keys.contain(keyboard.D)) {
        player1.dir = RIGHT;
        player1.hit = false;
        player1.move();
    }

    if (keys.contain(keyboard.UP)) {
        player2.dir = UP;
        player2.hit = false;
        player2.move();
    } else if (keys.contain(keyboard.DOWN)) {
        player2.dir = DOWN;
        player2.hit = false;
        player2.move();
    } else if (keys.contain(keyboard.LEFT)) {
        player2.dir = LEFT;
        player2.hit = false;
        player2.move();
    } else if (keys.contain(keyboard.RIGHT)) {
        player2.dir = RIGHT;
        player2.hit = false;
        player2.move();
    }

}

function addEnemyTank() {
    if (enemyArray == null || enemyArray.length >= maxAppearEnemy || maxEnemy == 0) {
        return;
    }
    appearEnemy++;
    var rand = parseInt(Math.random() * 3);
    var obj = null;
    if (rand == 0) {
        obj = new EnemyOne(tankCtx);
    } else if (rand == 1) {
        obj = new EnemyTwo(tankCtx);
    } else if (rand == 2) {
        obj = new EnemyThree(tankCtx);
    }
    obj.x = ENEMY_LOCATION[parseInt(Math.random() * 3)] + map.offsetX;
    obj.y = map.offsetY;
    obj.dir = DOWN;
    enemyArray[enemyArray.length] = obj;
    //更新地图右侧坦克数
    map.clearEnemyNum(maxEnemy, appearEnemy);
}

function drawEnemyTanks() {
    if (enemyArray != null || enemyArray.length > 0) {
        for (var i = 0; i < enemyArray.length; i++) {
            var enemyObj = enemyArray[i];
            if (enemyObj.isDestroyed) {
                enemyArray.removeByIndex(i);
                i--;
            } else {
                enemyObj.draw();
            }
        }
    }
    if (emenyStopTime > 0) {
        emenyStopTime--;
    }
}

function drawAll() {
    tankCtx.clearRect(0, 0, SCREEN_WIDTH, SCREEN_HEIGHT);
    if (player1.lives > 0) {
        player1.draw();
    }
    if (player2.lives > 0) {
        player2.draw();
    }
    drawLives();
    if (appearEnemy < maxEnemy) {
        if (mainframe % 100 == 0) {
            addEnemyTank();
            mainframe = 0;
        }
        mainframe++;
    }
    drawEnemyTanks();
    drawBullet();
    drawCrack();
    keyEvent();
    if (propTime <= 0) {
        drawProp();
    } else {
        propTime--;
    }
    if (homeProtectedTime > 0) {
        homeProtectedTime--;
    } else if (homeProtectedTime == 0) {
        homeProtectedTime = -1;
        homeNoProtected();
    }
}

function drawCrack() {
    if (crackArray != null && crackArray.length > 0) {
        for (var i = 0; i < crackArray.length; i++) {
            var crackObj = crackArray[i];
            if (crackObj.isOver) {
                crackArray.removeByIndex(i);
                i--;
                if (crackObj.owner == player1) {
                    player1.renascenc(1);
                } else if (crackObj.owner == player2) {
                    player2.renascenc(2);
                }
            } else {
                crackObj.draw();
            }
        }
    }
}


function gameOver() {
    overCtx.clearRect(0, 0, SCREEN_WIDTH, SCREEN_HEIGHT);
    overCtx.drawImage(RESOURCE_IMAGE, POS["over"][0], POS["over"][1], 64, 32, overX + map.offsetX, overY + map.offsetY, 64, 32);
    overY -= 2;
    if (overY <= parseInt(map.mapHeight / 2)) {
        initObject();
        //只有一个玩家
        if (menu.playNum == 1) {
            player2.lives = 0;
        }
        gameState = GAME_STATE_MENU;
    }
}

function nextLevel() {
    level++;
    if (level == 22) {
        level = 1;
    }
    initObject();
    //只有一个玩家
    if (menu.playNum == 1) {
        player2.lives = 0;
    }
    stage.init(level);
    gameState = GAME_STATE_INIT;
}

function preLevel() {
    level--;
    if (level == 0) {
        level = 21;
    }
    initObject();
    //只有一个玩家
    if (menu.playNum == 1) {
        player2.lives = 0;
    }
    stage.init(level);
    gameState = GAME_STATE_INIT;
}

function drawProp() {
    var rand = Math.random();
    if (rand < 0.4 && prop == null) {
        prop = new Prop(overCtx);
        prop.init();
    }
    if (prop != null) {
        prop.draw();
        if (prop.isDestroyed) {
            prop = null;
            propTime = 1000;
        }
    }
}

function homeNoProtected() {
    var mapChangeIndex = [
        [23, 11],
        [23, 12],
        [23, 13],
        [23, 14],
        [24, 11],
        [24, 14],
        [25, 11],
        [25, 14]
    ];
    map.updateMap(mapChangeIndex, WALL);
};




var paint = new Paint;
var matrix=new android.graphics.Matrix();
var gameRect=new android.graphics.RectF(0,0,SCREEN_WIDTH,SCREEN_HEIGHT);
var canvasRect=new android.graphics.RectF(0,0,device.width,device.width*(SCREEN_HEIGHT/SCREEN_WIDTH));
matrix.setRectToRect(gameRect,canvasRect, android.graphics.Matrix.ScaleToFit.CENTER);
var ASX = new XYToMatrix(matrix, 3);

ui.canvas.on("draw", function(canvas) {
    var w = canvas.getWidth();
    var h = canvas.getHeight();
    canvas.drawARGB(255, 127, 127, 127)
    //canvas.setMatrix(matrix);
    canvas.setMatrix(ASX.matrix);

    canvas.drawBitmap(wallCtx.bitmap, 0, 0, paint);
    canvas.drawBitmap(tankCtx.bitmap, 0, 0, paint);
    canvas.drawBitmap(grassCtx.bitmap, 0, 0, paint);
    canvas.drawBitmap(overCtx.bitmap, 0, 0, paint);
    canvas.drawBitmap(ctx.bitmap, 0, 0, paint);

    //canvas.drawPath(path, paint1);
    //canvas.drawCircle(0,0,5, paint);

});

ui.canvas.setOnTouchListener(ASX.touchListener);


function RToxy(R) {
    var x = Math.cos(R);
    var y = Math.sin(R);
    return [x, y];
};

function weiyi(ary) {
    var sum = 0;
    for (var i = 0; i < ary.length; i++) {
        sum += Math.pow(ary[i], 2);
    };
    return Math.sqrt(sum);
};

function getsd(s, ary) {
    var sum = weiyi(ary);
    var S = s / sum;
    for (var i = 0; i < ary.length; i++) {
        ary[i] = ary[i] * S;
    };
    return ary;
};



function XYToMatrix(matrix, maxPoints) {
    this.matrix = matrix || new android.graphics.Matrix;
    this.invertMatrix = new android.graphics.Matrix;
    this.matrix.invert(this.invertMatrix);
    this.getScaling = function(ary) {
        ary = Array.isArray(ary) ? ary : [0, 0, 100, 100];
        try {
            var Ary = this.matrixPoints(this.matrix, ary);
            return this.weiyi([Ary[2] - Ary[0], Ary[3] - Ary[1]]) / this.weiyi(ary);
        } catch (e) {
            toastLog(e);
        };
    };
    this.maxPoints = maxPoints || 2;
    this.maxPointsListener = () => {};
    this.Touch = {
        Matrix: this.matrix,
        PointStart: new Array,
        PointCurrent: new Array,

    };
    this.touchListener = new android.view.View.OnTouchListener((view, event) => {
        try {
            var W = view.getWidth();
            var H = view.getHeight();
            var PC = event.getPointerCount();
            switch (event.getActionMasked()) {
                case event.ACTION_MOVE:
                    try {
                        for (let i = 0; i < PC; i++) {
                            let id = event.getPointerId(i);
                            let x = event.getX(i);
                            let y = event.getY(i);
                            this.Touch.PointCurrent[i * 2] = x;
                            this.Touch.PointCurrent[i * 2 + 1] = y;
                        };

                        //记录当前各手指坐标信息。
                        if (PC > this.maxPoints) { //手指数大于4个虽然记录坐标信息，但是不进行矩阵操作。
                            this.maxPointsListener(view, event);
                            break;
                        };

                        var Matrix = new android.graphics.Matrix();
                        Matrix.setPolyToPoly(this.Touch.PointStart, 0, this.Touch.PointCurrent, 0, PC > 4 ? 4 : PC);
                        this.matrix = new android.graphics.Matrix();
                        this.matrix.setConcat(Matrix, this.Touch.Matrix);
                        //进行矩阵运算并刷新矩阵。
                        this.matrix.invert(this.invertMatrix);
                        //反矩阵
                    } catch (e) {
                        throw "MOVE " + e;
                    };


                    break;
                case event.ACTION_CANCEL:
                    //log("CANCEL");
                    this.Touch.PointStart = new Array;
                    this.Touch.PointCurrent = new Array;

                    break;
                case event.ACTION_OUTSIDE:
                    //log("OUTSIDE");

                    break;
                default:
                    var I = Math.floor(event.getAction() / 256);
                    var ID = event.getPointerId(I);
                    var X = event.getX(I);
                    var Y = event.getY(I);
                    switch (event.getActionMasked()) {
                        case event.ACTION_DOWN:
                            try {
                                log("down");
                                //当有新的手指按下时使坐标差为零。//开始新的多指矩阵运算方式
                                this.Touch.PointStart.splice(I * 2, 0, X, Y);
                                this.Touch.PointCurrent.splice(I * 2, 0, X, Y);
                                this.Touch.Matrix = this.matrix;
                                //log(this.Touch.Matrix);
                            } catch (e) {
                                throw "DOWN " + e;
                            };
                            break;
                        case event.ACTION_UP:
                            //最后一个手指抬起。
                            log("up");
                            this.Touch.PointStart = new Array;
                            this.Touch.PointCurrent = new Array;

                            break;
                        case event.ACTION_POINTER_DOWN:
                            log("POINTER_DOWN");
                            try {
                                //当有新的手指按下时使坐标差为零。//开始新的多指矩阵运算方式
                                this.Touch.PointStart.splice(I * 2, 0, X, Y);
                                this.Touch.PointCurrent.splice(I * 2, 0, X, Y);
                                //获取点的总数量。
                                this.Touch.Matrix = this.matrix;
                                for (let i = 0; i < PC; i++) {
                                    this.Touch.PointStart[i * 2] = this.Touch.PointCurrent[i * 2];
                                    this.Touch.PointStart[i * 2 + 1] = this.Touch.PointCurrent[i * 2 + 1];
                                };
                                //保存坐标的数组。
                                if (PC > this.maxPoints) { //手指数大于4个化为原始矩阵虽然记录坐标信息，但是不进行矩阵操作。
                                    this.maxPointsListener(view, event);
                                    break;
                                };

                                var Matrix = new android.graphics.Matrix();
                                Matrix.setPolyToPoly(this.Touch.PointStart, 0, this.Touch.PointCurrent, 0, PC > 4 ? 4 : PC);
                                this.matrix = new android.graphics.Matrix();
                                this.matrix.setConcat(Matrix, this.Touch.Matrix);
                                //进行矩阵运算并刷新矩阵。
                                this.matrix.invert(this.invertMatrix);
                                //反矩阵
                            } catch (e) {
                                throw "P_DOWN " + e;
                            };

                            break;
                        case event.ACTION_POINTER_UP:
                            log("POINTER_UP");
                            try {
                                this.Touch.Matrix = this.matrix;
                                for (let i = 0; i < PC; i++) {
                                    this.Touch.PointStart[i * 2] = this.Touch.PointCurrent[i * 2];
                                    this.Touch.PointStart[i * 2 + 1] = this.Touch.PointCurrent[i * 2 + 1];
                                };
                                this.Touch.PointStart.splice(I * 2, 2);
                                this.Touch.PointCurrent.splice(I * 2, 2);

                            } catch (e) {
                                throw "P_UP " + e;
                            };
                            break;
                    };
            };
        } catch (e) {
            throw "imgTouch: " + e;
        };

        return true;

    });

    this.matrixPoints = function(matrix, ary) {
        //通过矩阵运算坐标数组。但是需要转换为浮点数组。
        var ary = this.toJavaArray("float", ary);
        matrix.mapPoints(ary);
        return this.toJsArray(ary);
    };
    this.toJavaArray = function(type, ary) {
        //var Ary = java.lang.reflect.Array.newInstance(		java.lang.Float.TYPE, 4);
        var Ary = util.java.array(type, ary.length);
        for (let i in ary) {
            Ary[i] = ary[i];
        };
        return Ary;
    };
    this.toJsArray = function(ary) {
        var Ary = new Array(ary.length);
        for (let i in ary) {
            Ary[i] = ary[i];
        };
        return Ary;
    };
    this.getsd = (s, ary) => {
        var sum = this.weiyi(ary);
        var S = (s / sum) || 0;
        for (var i = 0; i < ary.length; i++) {
            ary[i] = ary[i] * S;
        };
        return ary;
    };
    this.weiyi = function(ary) {
        var sum = 0;
        for (var i = 0; i < ary.length; i++) {
            sum += Math.pow(ary[i], 2);
        };
        return Math.sqrt(sum);
    };
    this.kdfx = function(Y) {
        var x = Math.cos(Y % 360 / 360 * 2 * Math.PI);
        var y = Math.sin(Y % 360 / 360 * 2 * Math.PI);
        return [x, y];
    };
    this.ydfx = (ary) => {
        var ary = this.getsd(1, ary);
        var x = ary[0],
            y = ary[1];
        var Y = Math.asin(y) / (2 * Math.PI) * 360;
        if (x < 0) {
            Y = 180 - Y;
        };
        return Y;
    };


};