/*
 * Decompiled with CFR 0.152.
 */
package com.stericson.RootToolsTests;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.StrictMode;
import android.view.View;
import android.widget.ScrollView;
import android.widget.TextView;
import com.stericson.RootTools.RootTools;
import com.stericson.RootTools.containers.Permissions;
import com.stericson.RootTools.exceptions.RootDeniedException;
import com.stericson.RootTools.execution.CommandCapture;
import com.stericson.RootTools.execution.JavaCommandCapture;
import com.stericson.RootTools.execution.Shell;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeoutException;

public class SanityCheckRootTools
extends Activity {
    private ScrollView mScrollView;
    private TextView mTextView;
    private ProgressDialog mPDialog;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)new StrictMode.ThreadPolicy.Builder().detectDiskReads().detectDiskWrites().detectNetwork().penaltyLog().build());
        StrictMode.setVmPolicy((StrictMode.VmPolicy)new StrictMode.VmPolicy.Builder().detectLeakedSqlLiteObjects().detectLeakedClosableObjects().penaltyLog().penaltyDeath().build());
        RootTools.debugMode = true;
        this.mTextView = new TextView((Context)this);
        this.mTextView.setText((CharSequence)"");
        this.mScrollView = new ScrollView((Context)this);
        this.mScrollView.addView((View)this.mTextView);
        this.setContentView((View)this.mScrollView);
        String version = "?";
        try {
            PackageInfo packageInfo = this.getPackageManager().getPackageInfo(this.getPackageName(), 0);
            version = packageInfo.versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            // empty catch block
        }
        this.print("SanityCheckRootTools v " + version + "\n\n");
        if (RootTools.isRootAvailable()) {
            this.print("Root found.\n");
        } else {
            this.print("Root not found");
        }
        try {
            Shell.startRootShell();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        catch (TimeoutException e) {
            this.print("[ TIMEOUT EXCEPTION! ]\n");
            e.printStackTrace();
        }
        catch (RootDeniedException e) {
            this.print("[ ROOT DENIED EXCEPTION! ]\n");
            e.printStackTrace();
        }
        try {
            if (!RootTools.isAccessGiven()) {
                this.print("ERROR: No root access to this device.\n");
                return;
            }
        }
        catch (Exception e) {
            this.print("ERROR: could not determine root access to this device.\n");
            return;
        }
        this.mPDialog = new ProgressDialog((Context)this);
        this.mPDialog.setCancelable(false);
        this.mPDialog.setProgressStyle(0);
        new SanityCheckThread((Context)this, new TestHandler()).start();
    }

    protected void print(CharSequence text) {
        this.mTextView.append(text);
        this.mScrollView.post(new Runnable(){

            @Override
            public void run() {
                SanityCheckRootTools.this.mScrollView.fullScroll(130);
            }
        });
    }

    private class TestHandler
    extends Handler {
        public static final String ACTION = "action";
        public static final int ACTION_SHOW = 1;
        public static final int ACTION_HIDE = 2;
        public static final int ACTION_DISPLAY = 3;
        public static final int ACTION_PDISPLAY = 4;
        public static final String TEXT = "text";

        private TestHandler() {
        }

        public void handleMessage(Message msg) {
            int action = msg.getData().getInt(ACTION);
            String text = msg.getData().getString(TEXT);
            switch (action) {
                case 1: {
                    SanityCheckRootTools.this.mPDialog.show();
                    SanityCheckRootTools.this.mPDialog.setMessage((CharSequence)"Running Root Library Tests...");
                    break;
                }
                case 2: {
                    if (null != text) {
                        SanityCheckRootTools.this.print(text);
                    }
                    SanityCheckRootTools.this.mPDialog.hide();
                    break;
                }
                case 3: {
                    SanityCheckRootTools.this.print(text);
                    break;
                }
                case 4: {
                    SanityCheckRootTools.this.mPDialog.setMessage((CharSequence)text);
                }
            }
        }
    }

    private class SanityCheckThread
    extends Thread {
        private Handler mHandler;

        public SanityCheckThread(Context context, Handler handler) {
            this.mHandler = handler;
        }

        @Override
        public void run() {
            Shell shell;
            this.visualUpdate(1, null);
            this.visualUpdate(4, "Testing getPath");
            this.visualUpdate(3, "[ getPath ]\n");
            try {
                List<String> paths = RootTools.getPath();
                for (String path : paths) {
                    this.visualUpdate(3, path + " k\n\n");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.visualUpdate(4, "Testing A ton of commands");
            this.visualUpdate(3, "[ Ton of Commands ]\n");
            for (int i = 0; i < 100; ++i) {
                RootTools.exists("/system/xbin/busybox");
            }
            this.visualUpdate(4, "Testing Find Binary");
            boolean result = RootTools.isRootAvailable();
            this.visualUpdate(3, "[ Checking Root ]\n");
            this.visualUpdate(3, result + " k\n\n");
            this.visualUpdate(4, "Testing file exists");
            this.visualUpdate(3, "[ Checking Exists() ]\n");
            this.visualUpdate(3, RootTools.exists("/system/sbin/[") + " k\n\n");
            this.visualUpdate(4, "Testing Is Access Given");
            result = RootTools.isAccessGiven();
            this.visualUpdate(3, "[ Checking for Access to Root ]\n");
            this.visualUpdate(3, result + " k\n\n");
            this.visualUpdate(4, "Testing Remount");
            result = RootTools.remount("/system", "rw");
            this.visualUpdate(3, "[ Remounting System as RW ]\n");
            this.visualUpdate(3, result + " k\n\n");
            this.visualUpdate(4, "Testing CheckUtil");
            this.visualUpdate(3, "[ Checking busybox is setup ]\n");
            this.visualUpdate(3, RootTools.checkUtil("busybox") + " k\n\n");
            this.visualUpdate(4, "Testing getBusyBoxVersion");
            this.visualUpdate(3, "[ Checking busybox version ]\n");
            this.visualUpdate(3, RootTools.getBusyBoxVersion("/system/bin/") + " k\n\n");
            try {
                this.visualUpdate(4, "Testing fixUtils");
                this.visualUpdate(3, "[ Checking Utils ]\n");
                this.visualUpdate(3, RootTools.fixUtils(new String[]{"ls", "rm", "ln", "dd", "chmod", "mount"}) + " k\n\n");
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            try {
                this.visualUpdate(4, "Testing getSymlink");
                this.visualUpdate(3, "[ Checking [[ for symlink ]\n");
                this.visualUpdate(3, RootTools.getSymlink("/system/bin/[[") + " k\n\n");
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            this.visualUpdate(4, "Testing getInode");
            this.visualUpdate(3, "[ Checking Inodes ]\n");
            this.visualUpdate(3, RootTools.getInode("/system/bin/busybox") + " k\n\n");
            this.visualUpdate(4, "Testing GetBusyBoxapplets");
            try {
                this.visualUpdate(3, "[ Getting all available Busybox applets ]\n");
                for (String applet : RootTools.getBusyBoxApplets("/data/data/stericson.busybox.donate/files/bb")) {
                    this.visualUpdate(3, applet + " k\n\n");
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            this.visualUpdate(4, "Testing getFilePermissionsSymlinks");
            Permissions permissions = RootTools.getFilePermissionsSymlinks("/system/bin/busybox");
            this.visualUpdate(3, "[ Checking busybox permissions and symlink ]\n");
            if (permissions != null) {
                this.visualUpdate(3, "Symlink: " + permissions.getSymlink() + " k\n\n");
                this.visualUpdate(3, "Group Permissions: " + permissions.getGroupPermissions() + " k\n\n");
                this.visualUpdate(3, "Owner Permissions: " + permissions.getOtherPermissions() + " k\n\n");
                this.visualUpdate(3, "Permissions: " + permissions.getPermissions() + " k\n\n");
                this.visualUpdate(3, "Type: " + permissions.getType() + " k\n\n");
                this.visualUpdate(3, "User Permissions: " + permissions.getUserPermissions() + " k\n\n");
            } else {
                this.visualUpdate(3, "Permissions == null k\n\n");
            }
            this.visualUpdate(4, "JAVA");
            this.visualUpdate(3, "[ Running some Java code ]\n");
            try {
                shell = RootTools.getShell(true);
                JavaCommandCapture cmd = new JavaCommandCapture(43, false, (Context)SanityCheckRootTools.this, new String[]{"com.stericson.RootToolsTests.NativeJavaClass"}){

                    @Override
                    public void commandOutput(int id, String line) {
                        super.commandOutput(id, line);
                        SanityCheckThread.this.visualUpdate(3, line + "\n");
                    }
                };
                shell.add(cmd);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.visualUpdate(4, "Testing df");
            long spaceValue = RootTools.getSpace("/data");
            this.visualUpdate(3, "[ Checking /data partition size]\n");
            this.visualUpdate(3, spaceValue + "k\n\n");
            try {
                shell = RootTools.getShell(true);
                CommandCapture cmd = new CommandCapture(42, false, new String[]{"find /"}){
                    boolean _catch;
                    {
                        this._catch = false;
                    }

                    @Override
                    public void commandOutput(int id, String line) {
                        super.commandOutput(id, line);
                        if (this._catch) {
                            RootTools.log("CAUGHT!!!");
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void commandTerminated(int id, String reason) {
                        SanityCheckRootTools sanityCheckRootTools = SanityCheckRootTools.this;
                        synchronized (sanityCheckRootTools) {
                            this._catch = true;
                            SanityCheckThread.this.visualUpdate(4, "All tests complete.");
                            SanityCheckThread.this.visualUpdate(2, null);
                            try {
                                RootTools.closeAllShells();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void commandCompleted(int id, int exitCode) {
                        SanityCheckRootTools sanityCheckRootTools = SanityCheckRootTools.this;
                        synchronized (sanityCheckRootTools) {
                            this._catch = true;
                            SanityCheckThread.this.visualUpdate(4, "All tests complete.");
                            SanityCheckThread.this.visualUpdate(2, null);
                            try {
                                RootTools.closeAllShells();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                };
                shell.add(cmd);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private void visualUpdate(int action, String text) {
            Message msg = this.mHandler.obtainMessage();
            Bundle bundle = new Bundle();
            bundle.putInt("action", action);
            bundle.putString("text", text);
            msg.setData(bundle);
            this.mHandler.sendMessage(msg);
        }
    }
}

