/*
 * Decompiled with CFR 0.152.
 */
package com.stericson.RootTools.internal;

import com.stericson.RootTools.RootTools;
import com.stericson.RootTools.containers.Mount;
import com.stericson.RootTools.execution.Command;
import com.stericson.RootTools.execution.CommandCapture;
import com.stericson.RootTools.execution.Shell;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class Remounter {
    public boolean remount(String file, String mountType) {
        if (file.endsWith("/") && !file.equals("/")) {
            file = file.substring(0, file.lastIndexOf("/"));
        }
        boolean foundMount = false;
        while (!foundMount) {
            try {
                for (Mount mount : RootTools.getMounts()) {
                    RootTools.log(mount.getMountPoint().toString());
                    if (!file.equals(mount.getMountPoint().toString())) continue;
                    foundMount = true;
                    break;
                }
            }
            catch (Exception e) {
                if (RootTools.debugMode) {
                    e.printStackTrace();
                }
                return false;
            }
            if (foundMount) continue;
            try {
                file = new File(file).getParent();
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        Mount mountPoint = this.findMountPointRecursive(file);
        if (mountPoint != null) {
            RootTools.log("RootTools v3.4", "Remounting " + mountPoint.getMountPoint().getAbsolutePath() + " as " + mountType.toLowerCase());
            boolean isMountMode = mountPoint.getFlags().contains(mountType.toLowerCase());
            if (!isMountMode) {
                try {
                    CommandCapture command = new CommandCapture(0, true, "busybox mount -o remount," + mountType.toLowerCase() + " " + mountPoint.getDevice().getAbsolutePath() + " " + mountPoint.getMountPoint().getAbsolutePath(), "toolbox mount -o remount," + mountType.toLowerCase() + " " + mountPoint.getDevice().getAbsolutePath() + " " + mountPoint.getMountPoint().getAbsolutePath(), "mount -o remount," + mountType.toLowerCase() + " " + mountPoint.getDevice().getAbsolutePath() + " " + mountPoint.getMountPoint().getAbsolutePath(), "/system/bin/toolbox mount -o remount," + mountType.toLowerCase() + " " + mountPoint.getDevice().getAbsolutePath() + " " + mountPoint.getMountPoint().getAbsolutePath());
                    Shell.startRootShell().add(command);
                    this.commandWait(command);
                }
                catch (Exception e) {
                    // empty catch block
                }
                mountPoint = this.findMountPointRecursive(file);
            }
            if (mountPoint != null) {
                RootTools.log("RootTools v3.4", mountPoint.getFlags() + " AND " + mountType.toLowerCase());
                if (mountPoint.getFlags().contains(mountType.toLowerCase())) {
                    RootTools.log(mountPoint.getFlags().toString());
                    return true;
                }
                RootTools.log(mountPoint.getFlags().toString());
                return false;
            }
            RootTools.log("mount is null, file was: " + file + " mountType was: " + mountType);
        } else {
            RootTools.log("mount is null, file was: " + file + " mountType was: " + mountType);
        }
        return false;
    }

    private Mount findMountPointRecursive(String file) {
        block6: {
            try {
                ArrayList<Mount> mounts = RootTools.getMounts();
                File path = new File(file);
                while (path != null) {
                    for (Mount mount : mounts) {
                        if (!mount.getMountPoint().equals(path)) continue;
                        return mount;
                    }
                }
                return null;
            }
            catch (IOException e) {
                if (RootTools.debugMode) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                if (!RootTools.debugMode) break block6;
                e.printStackTrace();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commandWait(Command cmd) {
        Command command = cmd;
        synchronized (command) {
            try {
                if (!cmd.isFinished()) {
                    cmd.wait(2000L);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

