/*
 * Decompiled with CFR 0.152.
 */
package com.stericson.RootTools.internal;

import android.content.Context;
import android.util.Log;
import com.stericson.RootTools.RootTools;
import com.stericson.RootTools.execution.Command;
import com.stericson.RootTools.execution.CommandCapture;
import com.stericson.RootTools.execution.Shell;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

class Installer {
    static final String LOG_TAG = "RootTools::Installer";
    static final String BOGUS_FILE_NAME = "bogus";
    Context context;
    String filesPath;

    public Installer(Context context) throws IOException {
        this.context = context;
        this.filesPath = context.getFilesDir().getCanonicalPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean installBinary(int sourceId, String destName, String mode) {
        File mf = new File(this.filesPath + File.separator + destName);
        if (!mf.exists() || !this.getFileSignature(mf).equals(this.getStreamSignature(this.context.getResources().openRawResource(sourceId)))) {
            Log.e((String)LOG_TAG, (String)("Installing a new version of binary: " + destName));
            try {
                FileInputStream fis = this.context.openFileInput(BOGUS_FILE_NAME);
                fis.close();
            }
            catch (FileNotFoundException e) {
                FileOutputStream fos = null;
                try {
                    fos = this.context.openFileOutput(BOGUS_FILE_NAME, 0);
                    fos.write("justcreatedfilesdirectory".getBytes());
                }
                catch (Exception ex) {
                    if (RootTools.debugMode) {
                        Log.e((String)LOG_TAG, (String)ex.toString());
                    }
                    boolean bl = false;
                    return bl;
                }
                finally {
                    if (null != fos) {
                        try {
                            fos.close();
                            this.context.deleteFile(BOGUS_FILE_NAME);
                        }
                        catch (IOException e1) {}
                    }
                }
            }
            catch (IOException ex) {
                if (RootTools.debugMode) {
                    Log.e((String)LOG_TAG, (String)ex.toString());
                }
                return false;
            }
            InputStream iss = this.context.getResources().openRawResource(sourceId);
            ReadableByteChannel rfc = Channels.newChannel(iss);
            FileOutputStream oss = null;
            try {
                oss = new FileOutputStream(mf);
                FileChannel ofc = oss.getChannel();
                long pos = 0L;
                try {
                    long size = iss.available();
                    while ((pos += ofc.transferFrom(rfc, pos, size - pos)) < size) {
                    }
                }
                catch (IOException ex) {
                    if (RootTools.debugMode) {
                        Log.e((String)LOG_TAG, (String)ex.toString());
                    }
                    boolean bl = false;
                    if (oss != null) {
                        try {
                            oss.flush();
                            oss.getFD().sync();
                            oss.close();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    return bl;
                }
            }
            catch (FileNotFoundException ex) {
                if (RootTools.debugMode) {
                    Log.e((String)LOG_TAG, (String)ex.toString());
                }
                boolean bl = false;
                return bl;
            }
            finally {
                if (oss != null) {
                    try {
                        oss.flush();
                        oss.getFD().sync();
                        oss.close();
                    }
                    catch (Exception e) {}
                }
            }
            try {
                iss.close();
            }
            catch (IOException ex) {
                if (RootTools.debugMode) {
                    Log.e((String)LOG_TAG, (String)ex.toString());
                }
                return false;
            }
            try {
                CommandCapture command = new CommandCapture(0, false, "chmod " + mode + " " + this.filesPath + File.separator + destName);
                Shell.startRootShell().add(command);
                this.commandWait(command);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return true;
    }

    protected boolean isBinaryInstalled(String destName) {
        boolean installed = false;
        File mf = new File(this.filesPath + File.separator + destName);
        if (mf.exists()) {
            installed = true;
        }
        return installed;
    }

    protected String getFileSignature(File f) {
        String signature = "";
        try {
            signature = this.getStreamSignature(new FileInputStream(f));
        }
        catch (FileNotFoundException ex) {
            Log.e((String)LOG_TAG, (String)ex.toString());
        }
        return signature;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getStreamSignature(InputStream is) {
        String signature = "";
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            DigestInputStream dis = new DigestInputStream(is, md);
            byte[] buffer = new byte[4096];
            while (-1 != dis.read(buffer)) {
            }
            byte[] digest = md.digest();
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < digest.length; ++i) {
                sb.append(Integer.toHexString(digest[i] & 0xFF));
            }
            signature = sb.toString();
        }
        catch (IOException ex) {
            Log.e((String)LOG_TAG, (String)ex.toString());
        }
        catch (NoSuchAlgorithmException ex) {
            Log.e((String)LOG_TAG, (String)ex.toString());
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {}
        }
        return signature;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commandWait(Command cmd) {
        Command command = cmd;
        synchronized (command) {
            try {
                if (!cmd.isFinished()) {
                    cmd.wait(2000L);
                }
            }
            catch (InterruptedException ex) {
                Log.e((String)LOG_TAG, (String)ex.toString());
            }
        }
    }
}

