/*
 * Decompiled with CFR 0.152.
 */
package com.stericson.RootTools.execution;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.stericson.RootTools.RootTools;
import com.stericson.RootTools.execution.Shell;
import java.io.IOException;

public abstract class Command {
    ExecutionMonitor executionMonitor = null;
    Handler mHandler = null;
    boolean executing = false;
    String[] command = new String[0];
    boolean javaCommand = false;
    Context context = null;
    boolean finished = false;
    boolean terminated = false;
    boolean handlerEnabled = true;
    int exitCode = -1;
    int id = 0;
    int timeout = RootTools.default_Command_Timeout;

    public abstract void commandOutput(int var1, String var2);

    public abstract void commandTerminated(int var1, String var2);

    public abstract void commandCompleted(int var1, int var2);

    public Command(int id, String ... command) {
        this.command = command;
        this.id = id;
        this.createHandler(RootTools.handlerEnabled);
    }

    public Command(int id, boolean handlerEnabled, String ... command) {
        this.command = command;
        this.id = id;
        this.createHandler(handlerEnabled);
    }

    public Command(int id, int timeout, String ... command) {
        this.command = command;
        this.id = id;
        this.timeout = timeout;
        this.createHandler(RootTools.handlerEnabled);
    }

    public Command(int id, boolean javaCommand, Context context, String ... command) {
        this(id, command);
        this.javaCommand = javaCommand;
        this.context = context;
    }

    public Command(int id, boolean handlerEnabled, boolean javaCommand, Context context, String ... command) {
        this(id, handlerEnabled, command);
        this.javaCommand = javaCommand;
        this.context = context;
    }

    public Command(int id, int timeout, boolean javaCommand, Context context, String ... command) {
        this(id, timeout, command);
        this.javaCommand = javaCommand;
        this.context = context;
    }

    protected void finishCommand() {
        this.executing = false;
        this.finished = true;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void commandFinished() {
        if (!this.terminated) {
            Command command = this;
            synchronized (command) {
                if (this.mHandler != null && this.handlerEnabled) {
                    Message msg = this.mHandler.obtainMessage();
                    Bundle bundle = new Bundle();
                    bundle.putInt("action", 2);
                    msg.setData(bundle);
                    this.mHandler.sendMessage(msg);
                } else {
                    this.commandCompleted(this.id, this.exitCode);
                }
                RootTools.log("Command " + this.id + " finished.");
                this.finishCommand();
            }
        }
    }

    private void createHandler(boolean handlerEnabled) {
        this.handlerEnabled = handlerEnabled;
        if (Looper.myLooper() != null && handlerEnabled) {
            RootTools.log("CommandHandler created");
            this.mHandler = new CommandHandler();
        } else {
            RootTools.log("CommandHandler not created");
        }
    }

    public String getCommand() {
        StringBuilder sb = new StringBuilder();
        if (this.javaCommand) {
            String filePath = this.context.getFilesDir().getPath();
            for (int i = 0; i < this.command.length; ++i) {
                sb.append("dalvikvm -cp " + filePath + "/anbuild.dex" + " com.android.internal.util.WithFramework" + " com.stericson.RootTools.containers.RootClass " + this.command[i]);
                sb.append('\n');
            }
        } else {
            for (int i = 0; i < this.command.length; ++i) {
                sb.append(this.command[i]);
                sb.append('\n');
            }
        }
        return sb.toString();
    }

    public boolean isExecuting() {
        return this.executing;
    }

    public boolean isHandlerEnabled() {
        return this.handlerEnabled;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public int getExitCode() {
        return this.exitCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setExitCode(int code) {
        Command command = this;
        synchronized (command) {
            this.exitCode = code;
        }
    }

    protected void startExecution() {
        this.executionMonitor = new ExecutionMonitor();
        this.executionMonitor.setPriority(1);
        this.executionMonitor.start();
        this.executing = true;
    }

    public void terminate(String reason) {
        try {
            Shell.closeAll();
            RootTools.log("Terminating all shells.");
            this.terminated(reason);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void terminated(String reason) {
        Command command = this;
        synchronized (command) {
            if (this.mHandler != null && this.handlerEnabled) {
                Message msg = this.mHandler.obtainMessage();
                Bundle bundle = new Bundle();
                bundle.putInt("action", 3);
                bundle.putString("text", reason);
                msg.setData(bundle);
                this.mHandler.sendMessage(msg);
            } else {
                this.commandTerminated(this.id, reason);
            }
            RootTools.log("Command " + this.id + " did not finish because it was terminated. Termination reason: " + reason);
            this.setExitCode(-1);
            this.terminated = true;
            this.finishCommand();
        }
    }

    protected void output(int id, String line) {
        if (this.mHandler != null && this.handlerEnabled) {
            Message msg = this.mHandler.obtainMessage();
            Bundle bundle = new Bundle();
            bundle.putInt("action", 1);
            bundle.putString("text", line);
            msg.setData(bundle);
            this.mHandler.sendMessage(msg);
        } else {
            this.commandOutput(id, line);
        }
    }

    private class CommandHandler
    extends Handler {
        public static final String ACTION = "action";
        public static final String TEXT = "text";
        public static final int COMMAND_OUTPUT = 1;
        public static final int COMMAND_COMPLETED = 2;
        public static final int COMMAND_TERMINATED = 3;

        private CommandHandler() {
        }

        public void handleMessage(Message msg) {
            int action = msg.getData().getInt(ACTION);
            String text = msg.getData().getString(TEXT);
            switch (action) {
                case 1: {
                    Command.this.commandOutput(Command.this.id, text);
                    break;
                }
                case 2: {
                    Command.this.commandCompleted(Command.this.id, Command.this.exitCode);
                    break;
                }
                case 3: {
                    Command.this.commandTerminated(Command.this.id, text);
                }
            }
        }
    }

    private class ExecutionMonitor
    extends Thread {
        private ExecutionMonitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!Command.this.finished) {
                Command command = Command.this;
                synchronized (command) {
                    try {
                        Command.this.wait(Command.this.timeout);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (Command.this.finished) continue;
                RootTools.log("Timeout Exception has occurred.");
                Command.this.terminate("Timeout Exception");
            }
        }
    }
}

