/*
 * Decompiled with CFR 0.152.
 */
package com.stericson.RootTools.containers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RootClass {
    static String PATH_TO_DX = "/Users/Chris/Projects/android-sdk-macosx/build-tools/18.0.1/dx";

    public RootClass(String[] args) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        String className = args[0];
        RootArgs actualArgs = new RootArgs();
        actualArgs.args = new String[args.length - 1];
        System.arraycopy(args, 1, actualArgs.args, 0, args.length - 1);
        Class<?> classHandler = Class.forName(className);
        Constructor<?> classConstructor = classHandler.getConstructor(RootArgs.class);
        classConstructor.newInstance(actualArgs);
    }

    static void displayError(Exception e) {
        System.out.println("##ERR##" + e.getMessage() + "##");
        e.printStackTrace();
    }

    public static void main(String[] args) {
        try {
            if (args.length == 0) {
                new AnnotationsFinder();
            } else {
                new RootClass(args);
            }
        }
        catch (Exception e) {
            RootClass.displayError(e);
        }
    }

    public static class AnnotationsFinder {
        private final String AVOIDDIRPATH = "stericson" + File.separator + "RootTools" + File.separator;
        private List<File> classFiles;

        public AnnotationsFinder() throws IOException {
            System.out.println("Discovering root class annotations...");
            this.classFiles = new ArrayList<File>();
            this.lookup(new File("src"), this.classFiles);
            System.out.println("Done discovering annotations. Building jar file.");
            File builtPath = this.getBuiltPath();
            if (null != builtPath) {
                String[] cmd;
                boolean onWindows;
                String rc1 = "com" + File.separator + "stericson" + File.separator + "RootTools" + File.separator + "containers" + File.separator + "RootClass.class";
                String rc2 = "com" + File.separator + "stericson" + File.separator + "RootTools" + File.separator + "containers" + File.separator + "RootClass$RootArgs.class";
                String rc3 = "com" + File.separator + "stericson" + File.separator + "RootTools" + File.separator + "containers" + File.separator + "RootClass$AnnotationsFinder.class";
                String rc4 = "com" + File.separator + "stericson" + File.separator + "RootTools" + File.separator + "containers" + File.separator + "RootClass$AnnotationsFinder$1.class";
                String rc5 = "com" + File.separator + "stericson" + File.separator + "RootTools" + File.separator + "containers" + File.separator + "RootClass$AnnotationsFinder$2.class";
                boolean bl = onWindows = -1 != System.getProperty("os.name").toLowerCase().indexOf("win");
                if (onWindows) {
                    StringBuilder sb = new StringBuilder(" " + rc1 + " " + rc2 + " " + rc3 + " " + rc4 + " " + rc5);
                    for (File file : this.classFiles) {
                        sb.append(" " + file.getPath());
                    }
                    cmd = new String[]{"cmd", "/C", "jar cvf anbuild.jar" + sb.toString()};
                } else {
                    ArrayList<String> al = new ArrayList<String>();
                    al.add("jar");
                    al.add("cf");
                    al.add("anbuild.jar");
                    al.add(rc1);
                    al.add(rc2);
                    al.add(rc3);
                    al.add(rc4);
                    al.add(rc5);
                    for (File file : this.classFiles) {
                        al.add(file.getPath());
                    }
                    cmd = al.toArray(new String[al.size()]);
                }
                ProcessBuilder jarBuilder = new ProcessBuilder(cmd);
                jarBuilder.directory(builtPath);
                try {
                    jarBuilder.start().waitFor();
                }
                catch (IOException e) {
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                System.out.println("Done building jar file. Creating dex file.");
                cmd = onWindows ? new String[]{"cmd", "/C", "dx --dex --output=res/raw/anbuild.dex " + builtPath + File.separator + "anbuild.jar"} : new String[]{this.getPathToDx(), "--dex", "--output=res/raw/anbuild.dex", builtPath + File.separator + "anbuild.jar"};
                ProcessBuilder dexBuilder = new ProcessBuilder(cmd);
                try {
                    dexBuilder.start().waitFor();
                }
                catch (IOException e) {
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            System.out.println("All done. ::: anbuild.dex should now be in your project's res/raw/ folder :::");
        }

        protected void lookup(File path, List<File> fileList) {
            File[] files;
            String desourcedPath = path.toString().replace("src/", "");
            for (File file : files = path.listFiles()) {
                File[] classAndInnerClassFiles;
                if (file.isDirectory()) {
                    if (-1 != file.getAbsolutePath().indexOf(this.AVOIDDIRPATH)) continue;
                    this.lookup(file, fileList);
                    continue;
                }
                if (!file.getName().endsWith(".java") || !this.hasClassAnnotation(file)) continue;
                final String fileNamePrefix = file.getName().replace(".java", "");
                File compiledPath = new File(this.getBuiltPath().toString() + File.separator + desourcedPath);
                for (File matchingFile : classAndInnerClassFiles = compiledPath.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String filename) {
                        return filename.startsWith(fileNamePrefix);
                    }
                })) {
                    fileList.add(new File(desourcedPath + File.separator + matchingFile.getName()));
                }
            }
        }

        protected boolean hasClassAnnotation(File file) {
            READ_STATE readState = READ_STATE.STARTING;
            Pattern p = Pattern.compile(" class ([A-Za-z0-9_]+)");
            try {
                String line;
                BufferedReader reader = new BufferedReader(new FileReader(file));
                while (null != (line = reader.readLine())) {
                    switch (readState) {
                        case STARTING: {
                            if (-1 >= line.indexOf("@RootClass.Candidate")) break;
                            readState = READ_STATE.FOUND_ANNOTATION;
                            break;
                        }
                        case FOUND_ANNOTATION: {
                            Matcher m = p.matcher(line);
                            if (m.find()) {
                                System.out.println(" Found annotated class: " + m.group(0));
                                return true;
                            }
                            System.err.println("Error: unmatched annotation in " + file.getAbsolutePath());
                            readState = READ_STATE.STARTING;
                        }
                    }
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return false;
        }

        protected String getPathToDx() throws IOException {
            String androidHome = System.getenv("ANDROID_HOME");
            if (null == androidHome) {
                throw new IOException("Error: you need to set $ANDROID_HOME globally");
            }
            String dxPath = null;
            File[] files = new File(androidHome + File.separator + "build-tools").listFiles();
            int recentSdkVersion = 0;
            for (File file : files) {
                String tentativePath;
                String[] sdkVersionBits = file.getName().split("[.]");
                int sdkVersion = Integer.parseInt(sdkVersionBits[0]) * 10000;
                if (sdkVersionBits.length > 1) {
                    sdkVersion += Integer.parseInt(sdkVersionBits[1]) * 100;
                    if (sdkVersionBits.length > 2) {
                        sdkVersion += Integer.parseInt(sdkVersionBits[2]);
                    }
                }
                if (sdkVersion <= recentSdkVersion || !new File(tentativePath = file.getAbsolutePath() + File.separator + "dx").exists()) continue;
                recentSdkVersion = sdkVersion;
                dxPath = tentativePath;
            }
            if (dxPath == null) {
                throw new IOException("Error: unable to find dx binary in $ANDROID_HOME");
            }
            return dxPath;
        }

        protected File getBuiltPath() {
            File eclipsePath;
            File[] children;
            File foundPath = null;
            File ideaPath = new File("out" + File.separator + "production");
            if (ideaPath.isDirectory() && (children = ideaPath.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isDirectory();
                }
            })).length > 0) {
                foundPath = new File(ideaPath.getAbsolutePath() + File.separator + children[0].getName());
            }
            if (null == foundPath && (eclipsePath = new File("bin" + File.separator + "classes")).isDirectory()) {
                foundPath = eclipsePath;
            }
            return foundPath;
        }
    }

    public class RootArgs {
        public String[] args;
    }

    public static @interface Candidate {
    }

    static enum READ_STATE {
        STARTING,
        FOUND_ANNOTATION;

    }
}

