/*
 * Decompiled with CFR 0.152.
 */
package com.stericson.RootTools;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.util.Log;
import com.stericson.RootTools.containers.Mount;
import com.stericson.RootTools.containers.Permissions;
import com.stericson.RootTools.containers.Symlink;
import com.stericson.RootTools.exceptions.RootDeniedException;
import com.stericson.RootTools.execution.Command;
import com.stericson.RootTools.execution.Shell;
import com.stericson.RootTools.internal.Remounter;
import com.stericson.RootTools.internal.RootToolsInternalMethods;
import com.stericson.RootTools.internal.Runner;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeoutException;

public final class RootTools {
    private static RootToolsInternalMethods rim = null;
    public static boolean debugMode = false;
    public static List<String> lastFoundBinaryPaths = new ArrayList<String>();
    public static String utilPath;
    public static boolean handlerEnabled;
    public static int default_Command_Timeout;

    public static void setRim(RootToolsInternalMethods rim) {
        RootTools.rim = rim;
    }

    private static final RootToolsInternalMethods getInternals() {
        if (rim == null) {
            RootToolsInternalMethods.getInstance();
            return rim;
        }
        return rim;
    }

    public static boolean checkUtil(String util) {
        return RootTools.getInternals().checkUtil(util);
    }

    public static void closeAllShells() throws IOException {
        Shell.closeAll();
    }

    public static void closeCustomShell() throws IOException {
        Shell.closeCustomShell();
    }

    public static void closeShell(boolean root) throws IOException {
        if (root) {
            Shell.closeRootShell();
        } else {
            Shell.closeShell();
        }
    }

    public static boolean copyFile(String source, String destination, boolean remountAsRw, boolean preserveFileAttributes) {
        return RootTools.getInternals().copyFile(source, destination, remountAsRw, preserveFileAttributes);
    }

    public static boolean deleteFileOrDirectory(String target, boolean remountAsRw) {
        return RootTools.getInternals().deleteFileOrDirectory(target, remountAsRw);
    }

    public static boolean exists(String file) {
        return RootTools.getInternals().exists(file);
    }

    public static void fixUtil(String util, String utilPath) {
        RootTools.getInternals().fixUtil(util, utilPath);
    }

    public static boolean fixUtils(String[] utils) throws Exception {
        return RootTools.getInternals().fixUtils(utils);
    }

    public static boolean findBinary(String binaryName) {
        return RootTools.getInternals().findBinary(binaryName);
    }

    public static String getBusyBoxVersion(String path) {
        return RootTools.getInternals().getBusyBoxVersion(path);
    }

    public static String getBusyBoxVersion() {
        return RootTools.getBusyBoxVersion("");
    }

    public static List<String> getBusyBoxApplets() throws Exception {
        return RootTools.getBusyBoxApplets("");
    }

    public static List<String> getBusyBoxApplets(String path) throws Exception {
        return RootTools.getInternals().getBusyBoxApplets(path);
    }

    public static Shell getCustomShell(String shellPath, int timeout) throws IOException, TimeoutException, RootDeniedException {
        return Shell.startCustomShell(shellPath, timeout);
    }

    public static Shell getCustomShell(String shellPath) throws IOException, TimeoutException, RootDeniedException {
        return RootTools.getCustomShell(shellPath, 10000);
    }

    public static Permissions getFilePermissionsSymlinks(String file) {
        return RootTools.getInternals().getFilePermissionsSymlinks(file);
    }

    public static String getInode(String file) {
        return RootTools.getInternals().getInode(file);
    }

    public static ArrayList<Mount> getMounts() throws Exception {
        return RootTools.getInternals().getMounts();
    }

    public static String getMountedAs(String path) throws Exception {
        return RootTools.getInternals().getMountedAs(path);
    }

    public static List<String> getPath() {
        return Arrays.asList(System.getenv("PATH").split(":"));
    }

    public static Shell getShell(boolean root, int timeout, int retry) throws IOException, TimeoutException, RootDeniedException {
        if (root) {
            return Shell.startRootShell(timeout);
        }
        return Shell.startShell(timeout);
    }

    public static Shell getShell(boolean root, int timeout) throws IOException, TimeoutException, RootDeniedException {
        return RootTools.getShell(root, timeout, 3);
    }

    public static Shell getShell(boolean root) throws IOException, TimeoutException, RootDeniedException {
        return RootTools.getShell(root, 25000);
    }

    public static long getSpace(String path) {
        return RootTools.getInternals().getSpace(path);
    }

    public static String getSymlink(String file) {
        return RootTools.getInternals().getSymlink(file);
    }

    public static ArrayList<Symlink> getSymlinks(String path) throws Exception {
        return RootTools.getInternals().getSymlinks(path);
    }

    public static String getWorkingToolbox() {
        return RootTools.getInternals().getWorkingToolbox();
    }

    public static boolean hasEnoughSpaceOnSdCard(long updateSize) {
        return RootTools.getInternals().hasEnoughSpaceOnSdCard(updateSize);
    }

    public static boolean hasUtil(String util, String box) {
        return RootTools.getInternals().hasUtil(util, box);
    }

    public static boolean installBinary(Context context, int sourceId, String destName, String mode) {
        return RootTools.getInternals().installBinary(context, sourceId, destName, mode);
    }

    public static boolean installBinary(Context context, int sourceId, String binaryName) {
        return RootTools.installBinary(context, sourceId, binaryName, "700");
    }

    public static boolean hasBinary(Context context, String binaryName) {
        return RootTools.getInternals().isBinaryAvailable(context, binaryName);
    }

    public static boolean isAppletAvailable(String applet, String path) {
        return RootTools.getInternals().isAppletAvailable(applet, path);
    }

    public static boolean isAppletAvailable(String applet) {
        return RootTools.isAppletAvailable(applet, "");
    }

    public static boolean isAccessGiven() {
        return RootTools.getInternals().isAccessGiven();
    }

    public static boolean isBusyboxAvailable() {
        return RootTools.findBinary("busybox");
    }

    public static boolean isNativeToolsReady(int nativeToolsId, Context context) {
        return RootTools.getInternals().isNativeToolsReady(nativeToolsId, context);
    }

    public static boolean isProcessRunning(String processName) {
        return RootTools.getInternals().isProcessRunning(processName);
    }

    public static boolean isRootAvailable() {
        return RootTools.findBinary("su");
    }

    public static boolean killProcess(String processName) {
        return RootTools.getInternals().killProcess(processName);
    }

    public static void offerBusyBox(Activity activity) {
        RootTools.getInternals().offerBusyBox(activity);
    }

    public static Intent offerBusyBox(Activity activity, int requestCode) {
        return RootTools.getInternals().offerBusyBox(activity, requestCode);
    }

    public static void offerSuperUser(Activity activity) {
        RootTools.getInternals().offerSuperUser(activity);
    }

    public static Intent offerSuperUser(Activity activity, int requestCode) {
        return RootTools.getInternals().offerSuperUser(activity, requestCode);
    }

    public static boolean remount(String file, String mountType) {
        Remounter remounter = new Remounter();
        return remounter.remount(file, mountType);
    }

    public static void restartAndroid() {
        RootTools.log("Restart Android");
        RootTools.killProcess("zygote");
    }

    public static void runBinary(Context context, String binaryName, String parameter) {
        Runner runner = new Runner(context, binaryName, parameter);
        runner.start();
    }

    public static void runShellCommand(Shell shell, Command command) throws IOException {
        shell.add(command);
    }

    public static void log(String msg) {
        RootTools.log(null, msg, 3, null);
    }

    public static void log(String TAG, String msg) {
        RootTools.log(TAG, msg, 3, null);
    }

    public static void log(String msg, int type, Exception e) {
        RootTools.log(null, msg, type, e);
    }

    public static boolean islog() {
        return debugMode;
    }

    public static void log(String TAG, String msg, int type, Exception e) {
        if (msg != null && !msg.equals("") && debugMode) {
            if (TAG == null) {
                TAG = "RootTools v3.4";
            }
            switch (type) {
                case 1: {
                    Log.v((String)TAG, (String)msg);
                    break;
                }
                case 2: {
                    Log.e((String)TAG, (String)msg, (Throwable)e);
                    break;
                }
                case 3: {
                    Log.d((String)TAG, (String)msg);
                }
            }
        }
    }

    static {
        handlerEnabled = true;
        default_Command_Timeout = 20000;
    }
}

