"ui";
importClass(android.content.pm.ActivityInfo);
importClass(android.view.WindowManager);

ui.layout(
    <frame>
        <canvas id="board" layout_weight="1"/>
        <button id="but" alpha="0.5" w="100" h="100" text="前进" layout_gravity="left|center_vertical"/>
    </frame>
);
ui.run(() => {
    //横屏
    activity.getWindow().setFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN, WindowManager.LayoutParams.FLAG_FULLSCREEN); //设置成全屏模式
    activity.setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_LANDSCAPE); //强制为横屏
    /*
        //竖屏
        activity.getWindow().setFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN, WindowManager.LayoutParams.FLAG_FULLSCREEN);//设置成全屏模式
        activity.setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_PORTRAIT);//竖屏
    */
});


var W = 128;

var paint = new Paint();
//paint.setColor(colors.WHITE);
//paint.setColor(colors.BLACK);
paint.setARGB(255, 64, 64, 64);
paint.setStrokeWidth(10);
paint.setTextSize(75);
//paint.setStyle(Paint.Style.STROKE);
//paint.setStrokeCap(Paint.Cap.ROUND);
//paint.setShader(new android.graphics.RadialGradient(0,200,50,200,colors.RED,colors.GREEN,android.graphics.Shader.TileMode.REPEAT));
var paint1 = new Paint();
//paint1.setColor(colors.BLACK);
paint1.setARGB(255, 127, 127, 127);
paint1.setStrokeWidth(5)
paint1.setStrokeCap(Paint.Cap.ROUND);
//paint1.setShader(new android.graphics.RadialGradient(0,200,50,200,colors.RED,colors.GREEN,android.graphics.Shader.TileMode.REPEAT));
paint1.setXfermode(new android.graphics.PorterDuffXfermode(android.graphics.PorterDuff.Mode.XOR));
var mbitmap = android.graphics.Bitmap.createBitmap(W, W, android.graphics.Bitmap.Config.ARGB_8888);

var mcanvas = new Canvas(mbitmap);
var rainbowColor = [-65536, -23296, -256, -16711936, -16744449, -16776961, -7667457];

var xyz = [{ //x
    x: 0,
    y: 0,
    x1: 10,
    y1: 0,
}, { //y
    x: 0,
    y: 0,
    x1: 0,
    y1: 10,
}, { //x
    x: 0,
    y: 0,
    x1: -10,
    y1: 0,
}, { //y
    x: 0,
    y: 0,
    x1: 0,
    y1: -10,
}];




var player = {
    x: 0,
    y: 0,
    Y: 225, //平面360度。
    YW: 120,
};


var Suum = 0;




var ASX = new XYToMatrix(null, 4);

//ui.board.setMaxFps(60);
ui.board.on("draw", function(canvas) {
    let w = canvas.getWidth();
    let h = canvas.getHeight();
    //canvas.translate(w / 2, h / 2);
    let matrix = canvas.getMatrix();
    //绘制背景色
    //canvas.drawColor(colors.argb(25, 0, 0, 0));
    canvas.drawARGB(255, 127, 127, 127);
    matrix.postConcat(ASX.matrix);
    canvas.setMatrix(matrix);
    //paint.setColor(rainbowColor[random(0,rainbowColor.length-1)]);
    //canvas.drawBitmap(mbitmap, 0, 0, paint);
    var Yw1 = player.YW / 2;

    var minY = player.Y - Yw1;
    var maxY = player.Y + Yw1;
    //log(maxY, minY);

    paint.setARGB(255, 0, 255, 0);
    paint.setStrokeWidth(3);
    //canvas.drawLine(0, h / 2, w, h / 2, paint);
    canvas.drawPoint(player.x * 10 + (w - 200), player.y * 10 + 200, paint);
    var xy = getsd(10 * 10, kdfx(player.Y));
    canvas.drawLine(player.x * 10 + (w - 200), player.y * 10 + 200, player.x * 10 + (w - 200) + xy[0], player.y * 10 + 200 + xy[1], paint);
    var xy = getsd(20 * 10, kdfx(player.Y + Yw1));
    canvas.drawLine(player.x * 10 + (w - 200), player.y * 10 + 200, player.x * 10 + (w - 200) + xy[0], player.y * 10 + 200 + xy[1], paint);
    var xy = getsd(20 * 10, kdfx(player.Y - Yw1));
    canvas.drawLine(player.x * 10 + (w - 200), player.y * 10 + 200, player.x * 10 + (w - 200) + xy[0], player.y * 10 + 200 + xy[1], paint);

    paint.setARGB(255, 0, 0, 0);

    paint.setStrokeWidth(10);

    for (var i = 0; i < xyz.length; i++) {
        var obj = xyz[i];
        var S = weiyi([obj.x1 - player.x, obj.y1 - player.y]);
        if (S < 2) {
            Suum++;
            do {
                obj.x1 = random(-15, 15);
                obj.y1 = random(-15, 15);
            } while (weiyi([obj.x1 - player.x, obj.y1 - player.y]) < 2);
            obj.c = rainbowColor[random(0, rainbowColor.length)];
            //continue;
        };
        if (obj.c) {
            paint.setColor(obj.c);
        };
        canvas.drawPoint(obj.x1 * 10 + (w - 200), obj.y1 * 10 + 200, paint);

        var Y = ydfx([obj.x1 - player.x, obj.y1 - player.y]);
        // log(Y);
        while (Y >= -Yw1) {
            Y -= 360;
        };
        while (Y < 360 + Yw1) {
            Y += 360;
            //if (minY <= Y && Y <= maxY) {
            //  log("OK");
            var bl = (maxY - Y) / (maxY - minY);
            var bx = w - w * bl;
            //  log(bx);
            canvas.drawCircle(bx, h / 2, 1000 / S, paint);
            // };
        };
    };

    if (isRun) {
        Sds += 0.05;
        var xy = getsd(Sds, kdfx(player.Y));
        player.x += xy[0];
        player.y += xy[1];
        xyz = xyz.sort(function(A, B) {
            var S = weiyi([A.x1 - player.x, A.y1 - player.y]);
            var S1 = weiyi([B.x1 - player.x, B.y1 - player.y]);

            return S1 - S;
        });
    } else if (Sds > 0) {
        Sds -= 0.2;
        if (Sds < 0) {
            Sds = 0;
        };
        var xy = getsd(Sds, kdfx(player.Y));
        player.x += xy[0];
        player.y += xy[1];
        xyz = xyz.sort(function(A, B) {
            var S = weiyi([A.x1 - player.x, A.y1 - player.y]);
            var S1 = weiyi([B.x1 - player.x, B.y1 - player.y]);

            return S1 - S;
        });
    };


    paint.setARGB(255, 0, 0, 0);
    canvas.drawText("当前分数" + Suum, w / 2, h / 10, paint);


});


//ui.board.setOnTouchListener(ASX.touchListener);
var py = player.Y;
var mLastX, mLastY;
ui.board.setOnTouchListener(new android.view.View.OnTouchListener({
    onTouch: function(view, event) {
        var x = event.getX();
        var y = event.getY();
        switch (event.getAction()) {
            case android.view.MotionEvent.ACTION_DOWN:
                mLastX = x;
                mLastY = y;
                py = player.Y;
                break;
            case android.view.MotionEvent.ACTION_MOVE:

                var Yr = py + (x - mLastX) / 5;
                while (Yr < 0) {
                    Yr += 360;
                };
                while (Yr >= 360) {
                    Yr -= 360;
                };
                player.Y = Yr;
                break;
            case android.view.MotionEvent.ACTION_UP:
                var Yr = py + (x - mLastX) / 5;
                while (Yr < 0) {
                    Yr += 360;
                };
                while (Yr >= 360) {
                    Yr -= 360;
                };
                player.Y = Yr;
                break;
        }
        return true;
    }
}));

var isRun = false;
var Sds = 0;
ui.but.setOnTouchListener(new android.view.View.OnTouchListener({
    onTouch: function(view, event) {
        switch (event.getAction()) {
            case android.view.MotionEvent.ACTION_DOWN:
                isRun = true;
                break;
            case android.view.MotionEvent.ACTION_MOVE:

                break;
            case android.view.MotionEvent.ACTION_UP:
                isRun = false;
                break;
        }
        return true;
    }
}));




function RToxy(R) {
    var x = Math.cos(R);
    var y = Math.sin(R);
    return [x, y];
};

function weiyi(ary) {
    var sum = 0;
    for (var i = 0; i < ary.length; i++) {
        sum += Math.pow(ary[i], 2);
    };
    return Math.sqrt(sum);
};

function kdfx(Y) {
    var x = Math.cos(Y % 360 / 360 * 2 * Math.PI);
    var y = Math.sin(Y % 360 / 360 * 2 * Math.PI);
    return [x, y];
};

function getsd(s, ary) {
    var sum = weiyi(ary);
    var S = s / sum;
    for (var i = 0; i < ary.length; i++) {
        ary[i] = ary[i] * S;
    };
    return ary;
};


function ydfx(ary) {
    var ary = getsd(1, ary);
    var x = ary[0],
        y = ary[1];
    var Y = Math.asin(y) / (2 * Math.PI) * 360;
    if (x < 0) {
        Y = 180 - Y;
    };
    return Y;
};



function XYToMatrix(matrix, maxPoints) {
    this.matrix = matrix || new android.graphics.Matrix;
    this.invertMatrix = new android.graphics.Matrix;
    this.matrix.invert(this.invertMatrix);
    this.getScaling = function(ary) {
        ary = Array.isArray(ary) ? ary : [0, 0, 100, 100];
        try {
            var Ary = this.matrixPoints(this.matrix, ary);
            return this.weiyi([Ary[2] - Ary[0], Ary[3] - Ary[1]]) / this.weiyi(ary);
        } catch (e) {
            toastLog(e);
        };
    };
    this.maxPoints = maxPoints || 2;
    this.maxPointsListener = () => {};
    this.Touch = {
        Matrix: this.matrix,
        PointStart: new Array,
        PointCurrent: new Array,

    };
    this.touchListener = new android.view.View.OnTouchListener((view, event) => {
        try {
            var W = view.getWidth();
            var H = view.getHeight();
            var PC = event.getPointerCount();
            switch (event.getActionMasked()) {
                case event.ACTION_MOVE:
                    try {
                        for (let i = 0; i < PC; i++) {
                            let id = event.getPointerId(i);
                            let x = event.getX(i);
                            let y = event.getY(i);
                            this.Touch.PointCurrent[i * 2] = x;
                            this.Touch.PointCurrent[i * 2 + 1] = y;
                        };

                        //记录当前各手指坐标信息。
                        if (PC > this.maxPoints) { //手指数大于4个虽然记录坐标信息，但是不进行矩阵操作。
                            this.maxPointsListener(view, event);
                            break;
                        };

                        var Matrix = new android.graphics.Matrix();
                        Matrix.setPolyToPoly(this.Touch.PointStart, 0, this.Touch.PointCurrent, 0, PC > 4 ? 4 : PC);
                        this.matrix = new android.graphics.Matrix();
                        this.matrix.setConcat(Matrix, this.Touch.Matrix);
                        //进行矩阵运算并刷新矩阵。
                        this.matrix.invert(this.invertMatrix);
                        //反矩阵
                    } catch (e) {
                        throw "MOVE " + e;
                    };


                    break;
                case event.ACTION_CANCEL:
                    //log("CANCEL");
                    this.Touch.PointStart = new Array;
                    this.Touch.PointCurrent = new Array;

                    break;
                case event.ACTION_OUTSIDE:
                    //log("OUTSIDE");

                    break;
                default:
                    var I = Math.floor(event.getAction() / 256);
                    var ID = event.getPointerId(I);
                    var X = event.getX(I);
                    var Y = event.getY(I);
                    switch (event.getActionMasked()) {
                        case event.ACTION_DOWN:
                            try {
                                log("down");
                                //当有新的手指按下时使坐标差为零。//开始新的多指矩阵运算方式
                                this.Touch.PointStart.splice(I * 2, 0, X, Y);
                                this.Touch.PointCurrent.splice(I * 2, 0, X, Y);
                                this.Touch.Matrix = this.matrix;
                                //log(this.Touch.Matrix);
                            } catch (e) {
                                throw "DOWN " + e;
                            };
                            break;
                        case event.ACTION_UP:
                            //最后一个手指抬起。
                            log("up");
                            this.Touch.PointStart = new Array;
                            this.Touch.PointCurrent = new Array;

                            break;
                        case event.ACTION_POINTER_DOWN:
                            log("POINTER_DOWN");
                            try {
                                //当有新的手指按下时使坐标差为零。//开始新的多指矩阵运算方式
                                this.Touch.PointStart.splice(I * 2, 0, X, Y);
                                this.Touch.PointCurrent.splice(I * 2, 0, X, Y);
                                //获取点的总数量。
                                this.Touch.Matrix = this.matrix;
                                for (let i = 0; i < PC; i++) {
                                    this.Touch.PointStart[i * 2] = this.Touch.PointCurrent[i * 2];
                                    this.Touch.PointStart[i * 2 + 1] = this.Touch.PointCurrent[i * 2 + 1];
                                };
                                //保存坐标的数组。
                                if (PC > this.maxPoints) { //手指数大于4个化为原始矩阵虽然记录坐标信息，但是不进行矩阵操作。
                                    this.maxPointsListener(view, event);
                                    break;
                                };

                                var Matrix = new android.graphics.Matrix();
                                Matrix.setPolyToPoly(this.Touch.PointStart, 0, this.Touch.PointCurrent, 0, PC > 4 ? 4 : PC);
                                this.matrix = new android.graphics.Matrix();
                                this.matrix.setConcat(Matrix, this.Touch.Matrix);
                                //进行矩阵运算并刷新矩阵。
                                this.matrix.invert(this.invertMatrix);
                                //反矩阵
                            } catch (e) {
                                throw "P_DOWN " + e;
                            };

                            break;
                        case event.ACTION_POINTER_UP:
                            log("POINTER_UP");
                            try {
                                this.Touch.Matrix = this.matrix;
                                for (let i = 0; i < PC; i++) {
                                    this.Touch.PointStart[i * 2] = this.Touch.PointCurrent[i * 2];
                                    this.Touch.PointStart[i * 2 + 1] = this.Touch.PointCurrent[i * 2 + 1];
                                };
                                this.Touch.PointStart.splice(I * 2, 2);
                                this.Touch.PointCurrent.splice(I * 2, 2);

                            } catch (e) {
                                throw "P_UP " + e;
                            };
                            break;
                    };
            };
        } catch (e) {
            throw "imgTouch: " + e;
        };

        return true;

    });

    this.matrixPoints = function(matrix, ary) {
        //通过矩阵运算坐标数组。但是需要转换为浮点数组。
        var ary = this.toJavaArray("float", ary);
        matrix.mapPoints(ary);
        return this.toJsArray(ary);
    };
    this.toJavaArray = function(type, ary) {
        //var Ary = java.lang.reflect.Array.newInstance(		java.lang.Float.TYPE, 4);
        var Ary = util.java.array(type, ary.length);
        for (let i in ary) {
            Ary[i] = ary[i];
        };
        return Ary;
    };
    this.toJsArray = function(ary) {
        var Ary = new Array(ary.length);
        for (let i in ary) {
            Ary[i] = ary[i];
        };
        return Ary;
    };
    this.getsd = (s, ary) => {
        var sum = this.weiyi(ary);
        var S = (s / sum) || 0;
        for (var i = 0; i < ary.length; i++) {
            ary[i] = ary[i] * S;
        };
        return ary;
    };
    this.weiyi = function(ary) {
        var sum = 0;
        for (var i = 0; i < ary.length; i++) {
            sum += Math.pow(ary[i], 2);
        };
        return Math.sqrt(sum);
    };
    this.kdfx = function(Y) {
        var x = Math.cos(Y % 360 / 360 * 2 * Math.PI);
        var y = Math.sin(Y % 360 / 360 * 2 * Math.PI);
        return [x, y];
    };
    this.ydfx = (ary) => {
        var ary = this.getsd(1, ary);
        var x = ary[0],
            y = ary[1];
        var Y = Math.asin(y) / (2 * Math.PI) * 360;
        if (x < 0) {
            Y = 180 - Y;
        };
        return Y;
    };


};