// 新建一个WebSocket
// 指定web socket的事件回调在当前线程（好处是没有多线程问题要处理，坏处是不能阻塞当前线程，包括死循环）
// 不加后面的参数则回调在IO线程


let ws = web.newWebSocket("wss://xxx.com", { //添加一个不存在的
    eventThread: 'this'
});
ws.onExit(); //先结束上一条连接，也许是，多余操作



//===================以下代码为设置请求头部分==================[]
//引入 okhttp3 库
let okhttp3 = Packages["okhttp3"];
//创建一个新的 Request.Builder 实例
let request = new okhttp3.Request.Builder()
    .url("wss://echo.websocket.events")
    // 设置请求头
    .header("User-Agent", "Your User Agent")
    // 构建请求
    .build();

//获取 ws 类的 mListener 字段
let mListener = ws.getClass().getDeclaredField("mListener");
//设置 mListener 可访问
mListener.setAccessible(true);
//获取 ws 类的 mWebSocket 字段
let mWebSocket = ws.getClass().getDeclaredField("mWebSocket");
//设置 mWebSocket 可访问
mWebSocket.setAccessible(true);
//创建一个新的 WebSocket 实例
let webSocket = new okhttp3.OkHttpClient().newWebSocket(request, mListener.get(ws));
//将 mWebSocket 字段设置为新创建的 WebSocket 实例
mWebSocket.set(ws, webSocket);

// by 悠远 qq:2668649792,接 逆向工程,逆算法,脚本开发,疑难杂症解决

//===================以下代码为设置请求头部分==================



console.show();


// 监听他的各种事件
ws.on("open", (res, ws) => {
    log("WebSocket已连接");
}).on("failure", (err, res, ws) => {
    log("WebSocket连接失败");
    console.error(err);
}).on("closing", (code, reason, ws) => {
    log("WebSocket关闭中");
}).on("text", (text, ws) => {
    console.info("收到文本消息: ", text);
}).on("binary", (bytes, ws) => {
    console.info("收到二进制消息:");
    console.info("hex: ", bytes.hex());
    console.info("base64: ", bytes.base64());
    console.info("md5: ", bytes.md5());
    console.info("size: ", bytes.size());
    console.info("bytes: ", bytes.toByteArray());
}).on("closed", (code, reason, ws) => {
    log("WebSocket已关闭: code = %d, reason = %s", code, reason);
});

// 发送文本消息
log("发送消息: Hello, WebSocket!");
ws.send("Hello, WebSocket!");
setTimeout(() => {
    // 两秒后发送二进制消息
    log("发送二进制消息: 5piO5aSp5L2g6IO96ICDMTAw5YiG44CC");
    ws.send(web.ByteString.decodeBase64("5piO5aSp5L2g6IO96ICDMTAw5YiG44CC"));
}, 2000);
setTimeout(() => {
    // 8秒后断开WebSocket
    log("断开WebSocket");
    // 1000表示正常关闭
    ws.close(1000, null);
}, 8000);
setTimeout(() => {
    log("退出程序");
}, 12000)