/*
 * @Author: 大柒
 * @QQ: 531310591@qq.com
 * @Date: 2019-12-04 22:44:24
 * @Version: Auto.Js Pro
 * @Description: 
 * @LastEditors: 大柒
 * @LastEditTime: 2019-12-06 16:37:14
 */
"ui";

确保dex文件存在();
loadDex();
ui.useThemestatusBarColor = false;//是否使用特殊的标题栏背景颜色
ui.useStatusBarColor = true;//是否使用状态栏文字和图标为暗色，如果状态栏采用了白色系，则需要使状态栏和图标为暗色，android6.0以上可以设置
activity.window.addFlags(View.SYSTEM_UI_FLAG_LAYOUT_HIDE_NAVIGATION)//设置全面屏 状态栏悬浮内容之上

var theme = {
    color: "#1e88e5"
}
var _h_ = device.height
var _w_ = device.width
var camera_w = parseInt(_w_ / 3 * 2);
var camera_top = parseInt((_h_ - camera_w) / 2);
var camera_left = parseInt((_w_ - camera_w) / 2);
var camera_bottom = camera_top + camera_w;

//识别内容
var QR_text = null;
var QR_img = null;

//回调方法
var MainFun = function (t, img) { };
//监听say事件
events.on("say", function (fun) {
    log("收到回调方法")
    MainFun = fun;
});

//view布局
ui.layout(
    <frame bg="#000000">
        {/**相机画布 */}
        <android.view.SurfaceView id="surface" />
        {/**透明背景画布 */}
        <ImageView id="canvas" scaleType="fitXY" alpha="0.5" />
        {/**二维码边框画布 */}
        <ImageView id="canvas_1" scaleType="fitXY" />
        {/**标题 */}
        <toolbar id="toolbar" h="auto" marginTop="10" title="扫一扫" />
        {/**二维码区域控件 */}
        <frame id="camera_bg" w="{{camera_w}}px" h="{{camera_w}}px" padding="1 0" layout_gravity="center">
            <img id="camera_strip" w="*" h="4" src="{{theme.color}}" scaleType="fitXY" circle="true" alpha="0.8" />
        </frame>
        {/**手电筒 */}
        <frame marginTop="{{camera_bottom}}px">
            <text h="auto" marginTop="10" text="将二维码放入框内,即可自动扫描" textSize="12sp" textColor="#ffffff" gravity="center" />
            <vertical w="auto" h="auto" id="camera" layout_gravity="center">
                <img w="24" h="24" id="camera_src" src="@drawable/ic_flash_off_black_48dp" tint="#ffffff" layout_gravity="center" />
                <text w="auto" id="camera_text" text="轻触照亮" textSize="12sp" textColor="#ffffff" />
            </vertical>
        </frame>
    </frame>
);
//绑定相机构造函数
var camePreview = new CamePreview(ui.surface);

activity.setSupportActionBar(ui.toolbar);
//开启左上角返回键
activity.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
//创建选项菜单
ui.emitter.on("create_options_menu", menu => {
    menu.add("从相册选择二维码");
});

//监听选项菜单点击
ui.emitter.on("options_item_selected", (e, item) => {
    //监听左上角返回键
    if (item.getItemId() == android.R.id.home) {
        exit();
        return
    }
    e.consumed = true;
});


//手电筒按钮点击事件
ui.camera.click((v) => {
    let viewSrc = ui.camera_src
    let view = ui.camera_text
    if (view.text() == "轻触照亮") {
        camePreview.setIsOpenFlashMode(true, () => {
            view.setText("轻触关闭");
            setTextColor(view, theme.color);
            viewSrc.attr("src", "@drawable/ic_flash_on_black_48dp");
            viewSrc.attr("tint", theme.color);
        })
    } else {
        camePreview.setIsOpenFlashMode(false, () => {
            view.setText("轻触照亮");
            setTextColor(view, "#ffffff");
            viewSrc.attr("src", "@drawable/ic_flash_off_black_48dp");
            viewSrc.attr("tint", "#ffffff");
        })
    }
});

//双击缩放相机
var cameraZoom = false;
ui.camera_bg.click(() => {
    if (cameraZoom) {
        cameraZoom = false;
        camePreview.setZoom();
    } else {
        cameraZoom = true;
        setTimeout(() => {
            cameraZoom = false;
        }, 500);
    };
})



//dp2px
const scale = context.getResources().getDisplayMetrics().density;
var dp2px = function (dp) { return Math.floor(dp * scale + 0.5); };
var px2dp = function (px) { return Math.floor(px / scale + 0.5); };

//动画
importClass(android.animation.ObjectAnimator);
importClass(android.animation.AnimatorSet);
importClass(android.view.animation.BounceInterpolator);
var animation = ObjectAnimator.ofFloat(ui.camera_strip, "translationY", -dp2px(4), camera_w);
animation.repeatCount = android.view.animation.Animation.INFINITE;
animation.setDuration(3000);
animation.start();




//画布
importClass(android.graphics.PorterDuffXfermode)
importClass(android.graphics.PorterDuff)
//绘制背景
var ADK = new CustomDrawable(ui.canvas);
ADK.setDraw(function (canvas) {
    paint = new Paint()
    paint.setColor(Color("#000000"));
    paint.setStyle(Paint.Style.FILL);
    canvas.drawRect(0, 0, _w_, _h_, paint)
    xfermode = new PorterDuffXfermode(PorterDuff.Mode.XOR);
    paint.setXfermode(xfermode);
    paint.setColor(Color("#ffffff"));
    canvas.drawRect(camera_left, camera_top, camera_left + camera_w, camera_top + camera_w, paint);
});
ADK.Draw();

//绘制边框
var ADK1 = new CustomDrawable(ui.canvas_1);
ADK1.setDraw(function (canvas) {
    paint = new Paint()
    paint.setStrokeWidth(2);
    paint.setColor(Color("#ffffff"));
    paint.setStyle(Paint.Style.STROKE);
    canvas.drawRect(camera_left - 1, camera_top - 1, camera_left + camera_w + 1, camera_top + camera_w + 1, paint);
    paint.setStrokeWidth(10);
    paint.setColor(Color(theme.color));
    //左上角
    canvas.drawLine(camera_left - 15, camera_top + 30, camera_left - 15, camera_top - 20, paint);
    canvas.drawLine(camera_left - 20, camera_top - 15, camera_left + 30, camera_top - 15, paint);
    //右上角
    camera_right = camera_left + camera_w;
    canvas.drawLine(camera_right + 15, camera_top + 30, camera_right + 15, camera_top - 15, paint);
    canvas.drawLine(camera_right + 20, camera_top - 15, camera_right - 30, camera_top - 15, paint);
    //左下角
    canvas.drawLine(camera_left - 15, camera_bottom + 20, camera_left - 15, camera_bottom - 30, paint);
    canvas.drawLine(camera_left - 20, camera_bottom + 15, camera_left + 30, camera_bottom + 15, paint);
    //左下角
    canvas.drawLine(camera_right + 15, camera_bottom + 20, camera_right + 15, camera_bottom - 30, paint);
    canvas.drawLine(camera_right + 20, camera_bottom + 15, camera_right - 30, camera_bottom + 15, paint);
});
ADK1.Draw();

/**
 * 扫一扫画布
 * 参考 生僻字大佬的方法
 * @param {*} view 
 */
function CustomDrawable(view) {
    if (view.accessibilityClassName != "android.widget.ImageView") {
        throw "我报错";
    };
    this.width = _w_;
    this.height = _h_;
    this.bitmap = android.graphics.Bitmap.createBitmap(this.width || 1, this.height || 1, android.graphics.Bitmap.Config.ARGB_8888);
    this.canvas = new android.graphics.Canvas(this.bitmap);
    this.matrix = new android.graphics.Matrix();
    this.getDraw = function () { };
    this.Draw = function () {
        this.getDraw(this.canvas);
        ui.run(() => {
            view.setImageBitmap(this.bitmap);
        });
    };
    this.setDraw = function (fun) {
        if (typeof fun == "function") {
            this.getDraw = fun;
        };
    };
}



/**
 * 相机函数
 * 参考 家大佬的二维码识别
 * @param {*} surface surface视图
 */
function CamePreview(surface) {
    var mCamera = null
    var getPreview = false;
    var mImage = null;
    var mZoom = 0;
    var threadId

    importClass(android.content.pm.PackageManager);

    var FGH = {
        Camera: android.hardware.Camera,
        SurfaceView: android.view.SurfaceView,
        SurfaceHolder: android.view.SurfaceHolder,
        Bitmap: android.graphics.Bitmap,
        BitmapFactory: android.graphics.BitmapFactory,
        Matrix: android.graphics.Matrix,
        View: android.view.View,
        Environment: android.os.Environment
    };
    //设置闪光灯模式
    this.setIsOpenFlashMode = function (ve, fun) {
        if (mCamera == null) { return };
        ve ? str = FGH.Camera.Parameters.FLASH_MODE_TORCH : str = FGH.Camera.Parameters.FLASH_MODE_OFF
        mParameters = mCamera.getParameters();
        mParameters.setFlashMode(str);
        mCamera.setParameters(mParameters);

        fun();
    };
    //获取预览帧图片
    this.getPreViewImage = function () {
        return mImage
    };
    //获取预览帧图片
    this.getPreViewImage1 = function (fun) {
        getPreview = true;
        let _id_ = setInterval(() => {
            if (mImage != null) {
                clearInterval(_id_);
                fun(mImage);
            };
        }, 50);
    };
    //设置相机缩放
    this.setZoom = function () {
        var parameters = mCamera.getParameters();
        if (!parameters.isZoomSupported()) return;
        mZoom == 0 ? mZoom = 50 : mZoom = 0;
        parameters.setZoom(mZoom);
        mCamera.setParameters(parameters);
    };
    this.threadId = () => { return threadId }

    //定时器每秒获取一张预览帧
    this.intervalID = setInterval(() => {
        getPreview = true;
    }, 1000)
    //****************** */
    //相机权限检测
    pm = context.getPackageManager();
    permission = (PackageManager.PERMISSION_GRANTED == pm.checkPermission("android.permission.CAMERA", context.getPackageName()));
    if (permission) {
        //权限检测通过
        open()//开启相机
    } else {
        //申请相机权限
        importClass("androidx.core.app.ActivityCompat")
        ActivityCompat.requestPermissions(activity, ["android.permission.CAMERA"], 100);
    };

    //****************** */
    //开启相机
    function open() {
        if (!checkCameraHardware(context)) {
            throw "没有摄像头";
        }
        var holder = surface.getHolder();
        //添加控件的回调事件。回调的意思是。当什么什么情况下，怎么怎么做？
        holder.addCallback(
            new FGH.SurfaceHolder.Callback({
                surfaceCreated: function (holder) {
                    //SurfaceView&SurfaceHolder的创建完成回调
                    try {
                        //打开第1个(默认第1个)摄像头。
                        // log("打开摄像头");
                        mCamera = FGH.Camera.open();

                        //开启相机预览
                        PreviewCallback()

                        setTimeout(() => {
                            threadId = QR_Code(mCamera);
                        }, 2000);

                        //自动对焦
                        parameters = mCamera.getParameters();
                        if (parameters.getSupportedFocusModes().contains(android.hardware.Camera.Parameters.FOCUS_MODE_CONTINUOUS_PICTURE)) {
                            parameters.setFocusMode(android.hardware.Camera.Parameters.FOCUS_MODE_CONTINUOUS_PICTURE);// 连续对焦模式
                        }
                        mCamera.setParameters(parameters);
                        //log(focusModes);

                        //添加错误的回调。
                        mCamera.setErrorCallback(function (mCamera) {
                            toastLog("有错误发生");
                        });
                    } catch (e) {
                        mCamera.release();
                        throw e + " 打开摄像头失败，可能没有权限请手动到应用权限里面打开";
                    }
                    mCamera.setPreviewDisplay(holder);
                    mCamera.setDisplayOrientation(90);
                    mCamera.startPreview();
                },
                surfaceChanged: function (holder, format, width, height) {
                    // 如果允许预览可以更改或旋转，可以在这里处理这些事件
                    mCamera.startPreview();
                    mCamera.autoFocus(null);

                    log("surfaceChanged");
                    // this.surfaceCreated(holder);
                },
                surfaceDestroyed: function (holder) {
                    //结束。//切换到其他软件页面也会运行此回调。
                    if (mCamera) {
                        try {
                            mCamera.setPreviewCallback(null);
                            mCamera.stopPreview();
                            mCamera.release();
                            mCamera = null;
                        } catch (e) {
                            log("surfaceDestroyed 发生错误");
                            log(e);
                        }
                    }
                }
            })
        );
        function checkCameraHardware(context) {
            if (context.getPackageManager().hasSystemFeature(PackageManager.FEATURE_CAMERA)) {
                // this device has a camera
                return true;
            } else {
                // no camera on this device
                return false;
            }
        }
        function isSupportZoom(mCamera) {
            var isSuppport = true;
            if (mCamera.getParameters().isSmoothZoomSupported()) {
                isSuppport = false;
            }
            return isSuppport;
        }
    }

    //设置相机预览回调
    function PreviewCallback() {
        importClass(java.io.ByteArrayOutputStream);
        importClass(android.graphics.Rect);
        importClass(android.graphics.YuvImage);
        importClass(android.graphics.ImageFormat);
        mCamera.setPreviewCallback(new FGH.Camera.PreviewCallback({
            onPreviewFrame: function (data, camera) {
                //当开关为真时,截取一帧预览图
                if (getPreview) {
                    getPreview = false;
                    var size = camera.getParameters().getPreviewSize();
                    try {
                        image = new YuvImage(data, ImageFormat.NV21, size.width, size.height, null);
                        if (image != null) {
                            /**
                             * ui线程处理图片会造成卡顿
                             * 解决方法:扔到线程中处理
                             */
                            threads.start(function () {
                                stream = new ByteArrayOutputStream();
                                var sizeH = size.width / _h_;
                                var _x_ = parseInt(camera_top * sizeH)
                                var _x_1 = parseInt((camera_top + camera_w) * sizeH)
                                var er = new Rect(_x_, camera_left, _x_1, camera_left + camera_w)
                                image.compressToJpeg(er, 50, stream);
                                bmp = FGH.BitmapFactory.decodeByteArray(stream.toByteArray(), 0, stream.size());
                                //**********************
                                //因为图片会放生旋转，因此要对图片进行旋转到和手机在一个方向上
                                rotateMyBitmap(bmp);
                                //**********************************
                            });
                        };
                    } catch (ex) {
                        log("Error:" + ex);
                    };
                };
            }
        }));


        //图片旋转函数
        function rotateMyBitmap(bmp) {
            //*****旋转一下
            var matrix = new FGH.Matrix();
            matrix.postRotate(90);
            //bitmap = FGH.Bitmap.createBitmap(bmp.getWidth(), bmp.getHeight(), FGH.Bitmap.Config.ARGB_8888);
            mImage = FGH.Bitmap.createBitmap(bmp, 0, 0, bmp.getWidth(), bmp.getHeight(), matrix, true);
        };;
    };
}


/**
 * 二维码识别
 */
function QR_Code(mCamera) {

    if (!mCamera) {
        return;
    };
    var threadId = threads.start(function () {
        while (true) {
            //获取一帧相机预览图
            var bmp = camePreview.getPreViewImage()
            try {
                var pixels = util.java.array('int', bmp.getWidth() * bmp.getHeight()) // 通过位图的大小创建像素点数组
                bmp.getPixels(pixels, 0, bmp.getWidth(), 0, 0, bmp.getWidth(), bmp.getHeight());

                var binaryBitmap = new BinaryBitmap(new HybridBinarizer(new RGBLuminanceSource(bmp.getWidth(), bmp.getHeight(), pixels)));
                var qrCodeResult = new MultiFormatReader().decode(binaryBitmap);
                QR_text = qrCodeResult.getText();;
                QR_img = bmp;
                toastLog("识别内容为\n" + QR_text)
                exit()
            } catch (e) {
                log("请对准二维码");
            }
            sleep(2000);
        }
    });
    return threadId;
}



//脚本exit事件
events.on('exit', function () {
    MainFun(QR_text, QR_img);
});

function setTextColor(v, c) {
    v.setTextColor(colors.parseColor(c));
}

function Color(c) {
    let r = colors.red(c);
    let g = colors.green(c);
    let b = colors.blue(c);
    let a = colors.alpha(c);
    return colors.argb(a, r, g, b);
}


function loadDex() {
    runtime.loadDex(files.join(files.getSdcardPath(), "qrcode.dex"));
    importPackage(com.google.zxing);
    importPackage(com.google.zxing.common);
    importPackage(com.google.zxing.client.j2se);

    importClass(java.io.File);
    importClass(java.io.FileOutputStream);
    importClass(android.graphics.BitmapFactory);
    importClass(android.graphics.YuvImage);
    importClass(java.io.ByteArrayOutputStream);
    importClass(android.graphics.Rect);
    importClass(android.graphics.ImageFormat);
    importClass(android.graphics.Bitmap);
    importClass(android.widget.LinearLayout);
    importClass(java.io.File);
    importClass(java.io.FileOutputStream);
    importClass(android.view.View);
}

//动态申请权限回调
ui.emitter.on("request_permission_result", function () {
    switch (arguments[0]) {
        case 100:
            arguments[2][0] != -1 ? (alert("请重新启动扫一扫"), exit()) : toastLog("没有相机权限");
            break;
    };
});


function 确保dex文件存在() {
    threads.start(function () {
        var dexFileUrl = "https://autojs-qrcode.oss-cn-beijing.aliyuncs.com/qrcode.dex";
        dexFilePath = files.join(files.getSdcardPath(), "qrcode.dex");
        if (!files.exists(dexFilePath)) {
            files.writeBytes(dexFilePath, http.get(dexFileUrl).body.bytes());
            toast("模块下载成功!,请重新打开扫一扫")
        }
    });
}









