/*
 * Decompiled with CFR 0.152.
 */
package com.stericson.RootTools.internal;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Environment;
import android.os.StatFs;
import android.util.Log;
import com.stericson.RootTools.RootTools;
import com.stericson.RootTools.containers.Mount;
import com.stericson.RootTools.containers.Permissions;
import com.stericson.RootTools.containers.Symlink;
import com.stericson.RootTools.execution.Command;
import com.stericson.RootTools.execution.CommandCapture;
import com.stericson.RootTools.execution.Shell;
import com.stericson.RootTools.internal.Installer;
import com.stericson.RootTools.internal.InternalVariables;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;

public final class RootToolsInternalMethods {
    protected RootToolsInternalMethods() {
    }

    public static void getInstance() {
        RootTools.setRim(new RootToolsInternalMethods());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Symlink> getSymLinks() throws IOException {
        BufferedReader lnr = null;
        FileReader fr = null;
        try {
            String line;
            fr = new FileReader("/data/local/symlinks.txt");
            lnr = new LineNumberReader(fr);
            ArrayList<Symlink> symlink = new ArrayList<Symlink>();
            while ((line = ((LineNumberReader)lnr).readLine()) != null) {
                RootTools.log(line);
                String[] fields = line.split(" ");
                symlink.add(new Symlink(new File(fields[fields.length - 3]), new File(fields[fields.length - 1])));
            }
            ArrayList<Symlink> arrayList = symlink;
            return arrayList;
        }
        finally {
            try {
                fr.close();
            }
            catch (Exception e) {}
            try {
                lnr.close();
            }
            catch (Exception e) {}
        }
    }

    public Permissions getPermissions(String line) {
        String[] lineArray = line.split(" ");
        String rawPermissions = lineArray[0];
        if (!(rawPermissions.length() != 10 || rawPermissions.charAt(0) != '-' && rawPermissions.charAt(0) != 'd' && rawPermissions.charAt(0) != 'l' || rawPermissions.charAt(1) != '-' && rawPermissions.charAt(1) != 'r' || rawPermissions.charAt(2) != '-' && rawPermissions.charAt(2) != 'w')) {
            RootTools.log(rawPermissions);
            Permissions permissions = new Permissions();
            permissions.setType(rawPermissions.substring(0, 1));
            RootTools.log(permissions.getType());
            permissions.setUserPermissions(rawPermissions.substring(1, 4));
            RootTools.log(permissions.getUserPermissions());
            permissions.setGroupPermissions(rawPermissions.substring(4, 7));
            RootTools.log(permissions.getGroupPermissions());
            permissions.setOtherPermissions(rawPermissions.substring(7, 10));
            RootTools.log(permissions.getOtherPermissions());
            StringBuilder finalPermissions = new StringBuilder();
            finalPermissions.append(this.parseSpecialPermissions(rawPermissions));
            finalPermissions.append(this.parsePermissions(permissions.getUserPermissions()));
            finalPermissions.append(this.parsePermissions(permissions.getGroupPermissions()));
            finalPermissions.append(this.parsePermissions(permissions.getOtherPermissions()));
            permissions.setPermissions(Integer.parseInt(finalPermissions.toString()));
            return permissions;
        }
        return null;
    }

    public int parsePermissions(String permission) {
        int tmp = permission.charAt(0) == 'r' ? 4 : 0;
        RootTools.log("permission " + tmp);
        RootTools.log("character " + permission.charAt(0));
        tmp = permission.charAt(1) == 'w' ? (tmp += 2) : (tmp += 0);
        RootTools.log("permission " + tmp);
        RootTools.log("character " + permission.charAt(1));
        tmp = permission.charAt(2) == 'x' ? ++tmp : (tmp += 0);
        RootTools.log("permission " + tmp);
        RootTools.log("character " + permission.charAt(2));
        return tmp;
    }

    public int parseSpecialPermissions(String permission) {
        int tmp = 0;
        if (permission.charAt(2) == 's') {
            tmp += 4;
        }
        if (permission.charAt(5) == 's') {
            tmp += 2;
        }
        if (permission.charAt(8) == 't') {
            ++tmp;
        }
        RootTools.log("special permissions " + tmp);
        return tmp;
    }

    public boolean copyFile(String source, String destination, boolean remountAsRw, boolean preserveFileAttributes) {
        Command command = null;
        boolean result = true;
        try {
            if (remountAsRw) {
                RootTools.remount(destination, "RW");
            }
            if (this.checkUtil("cp")) {
                RootTools.log("cp command is available!");
                if (preserveFileAttributes) {
                    command = new CommandCapture(0, false, "cp -fp " + source + " " + destination);
                    Shell.startRootShell().add(command);
                    this.commandWait(command);
                    result = command.getExitCode() == 0;
                } else {
                    command = new CommandCapture(0, false, "cp -f " + source + " " + destination);
                    Shell.startRootShell().add(command);
                    this.commandWait(command);
                    result = command.getExitCode() == 0;
                }
            } else if (this.checkUtil("busybox") && this.hasUtil("cp", "busybox")) {
                RootTools.log("busybox cp command is available!");
                if (preserveFileAttributes) {
                    command = new CommandCapture(0, false, "busybox cp -fp " + source + " " + destination);
                    Shell.startRootShell().add(command);
                    this.commandWait(command);
                } else {
                    command = new CommandCapture(0, false, "busybox cp -f " + source + " " + destination);
                    Shell.startRootShell().add(command);
                    this.commandWait(command);
                }
            } else if (this.checkUtil("cat")) {
                RootTools.log("cp is not available, use cat!");
                int filePermission = -1;
                if (preserveFileAttributes) {
                    Permissions permissions = this.getFilePermissionsSymlinks(source);
                    filePermission = permissions.getPermissions();
                }
                command = new CommandCapture(0, false, "cat " + source + " > " + destination);
                Shell.startRootShell().add(command);
                this.commandWait(command);
                if (preserveFileAttributes) {
                    command = new CommandCapture(0, false, "chmod " + filePermission + " " + destination);
                    Shell.startRootShell().add(command);
                    this.commandWait(command);
                }
            } else {
                result = false;
            }
            if (remountAsRw) {
                RootTools.remount(destination, "RO");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            result = false;
        }
        if (command != null) {
            result = command.getExitCode() == 0;
        }
        return result;
    }

    public boolean checkUtil(String util) {
        if (RootTools.findBinary(util)) {
            ArrayList<String> binaryPaths = new ArrayList<String>();
            binaryPaths.addAll(RootTools.lastFoundBinaryPaths);
            for (String path : binaryPaths) {
                String permission;
                Permissions permissions = RootTools.getFilePermissionsSymlinks(path + "/" + util);
                if (permissions == null || !(permission = Integer.toString(permissions.getPermissions()).length() > 3 ? Integer.toString(permissions.getPermissions()).substring(1) : Integer.toString(permissions.getPermissions())).equals("755") && !permission.equals("777") && !permission.equals("775")) continue;
                RootTools.utilPath = path + "/" + util;
                return true;
            }
        }
        return false;
    }

    public boolean deleteFileOrDirectory(String target, boolean remountAsRw) {
        boolean result = true;
        try {
            if (remountAsRw) {
                RootTools.remount(target, "RW");
            }
            if (this.hasUtil("rm", "toolbox")) {
                RootTools.log("rm command is available!");
                CommandCapture command = new CommandCapture(0, false, "rm -r " + target);
                Shell.startRootShell().add(command);
                this.commandWait(command);
                if (command.getExitCode() != 0) {
                    RootTools.log("target not exist or unable to delete file");
                    result = false;
                }
            } else if (this.checkUtil("busybox") && this.hasUtil("rm", "busybox")) {
                RootTools.log("busybox cp command is available!");
                CommandCapture command = new CommandCapture(0, false, "busybox rm -rf " + target);
                Shell.startRootShell().add(command);
                this.commandWait(command);
                if (command.getExitCode() != 0) {
                    RootTools.log("target not exist or unable to delete file");
                    result = false;
                }
            }
            if (remountAsRw) {
                RootTools.remount(target, "RO");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            result = false;
        }
        return result;
    }

    public boolean exists(String file) {
        final ArrayList result = new ArrayList();
        CommandCapture command = new CommandCapture(0, false, new String[]{"ls " + file}){

            @Override
            public void output(int arg0, String arg1) {
                RootTools.log(arg1);
                result.add(arg1);
            }
        };
        try {
            if (!Shell.isAnyShellOpen()) {
                Shell.startShell().add(command);
                this.commandWait(command);
            } else {
                Shell.getOpenShell().add(command);
                this.commandWait(command);
            }
        }
        catch (Exception e) {
            return false;
        }
        for (String line : result) {
            if (!line.trim().equals(file)) continue;
            return true;
        }
        try {
            RootTools.closeShell(false);
        }
        catch (Exception e) {
            // empty catch block
        }
        result.clear();
        try {
            Shell.startRootShell().add(command);
            this.commandWait(command);
        }
        catch (Exception e) {
            return false;
        }
        ArrayList final_result = new ArrayList();
        final_result.addAll(result);
        for (String line : final_result) {
            if (!line.trim().equals(file)) continue;
            return true;
        }
        return false;
    }

    public void fixUtil(String util, String utilPath) {
        try {
            RootTools.remount("/system", "rw");
            if (RootTools.findBinary(util)) {
                ArrayList<String> paths = new ArrayList<String>();
                paths.addAll(RootTools.lastFoundBinaryPaths);
                for (String path : paths) {
                    CommandCapture command = new CommandCapture(0, false, utilPath + " rm " + path + "/" + util);
                    Shell.startRootShell().add(command);
                    this.commandWait(command);
                }
                CommandCapture command = new CommandCapture(0, false, utilPath + " ln -s " + utilPath + " /system/bin/" + util, utilPath + " chmod 0755 /system/bin/" + util);
                Shell.startRootShell().add(command);
                this.commandWait(command);
            }
            RootTools.remount("/system", "ro");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean fixUtils(String[] utils) throws Exception {
        for (String util : utils) {
            if (this.checkUtil(util)) continue;
            if (this.checkUtil("busybox")) {
                if (!this.hasUtil(util, "busybox")) continue;
                this.fixUtil(util, RootTools.utilPath);
                continue;
            }
            if (this.checkUtil("toolbox")) {
                if (!this.hasUtil(util, "toolbox")) continue;
                this.fixUtil(util, RootTools.utilPath);
                continue;
            }
            return false;
        }
        return true;
    }

    public boolean findBinary(final String binaryName) {
        boolean found = false;
        RootTools.lastFoundBinaryPaths.clear();
        final ArrayList<String> list = new ArrayList<String>();
        String[] places = new String[]{"/sbin/", "/system/bin/", "/system/xbin/", "/data/local/xbin/", "/data/local/bin/", "/system/sd/xbin/", "/system/bin/failsafe/", "/data/local/"};
        RootTools.log("Checking for " + binaryName);
        try {
            for (final String path : places) {
                CommandCapture cc = new CommandCapture(0, false, new String[]{"stat " + path + binaryName}){

                    @Override
                    public void commandOutput(int id, String line) {
                        if (line.contains("File: ") && line.contains(binaryName)) {
                            list.add(path);
                            RootTools.log(binaryName + " was found here: " + path);
                        }
                        RootTools.log(line);
                    }
                };
                RootTools.getShell(false).add(cc);
                this.commandWait(cc);
            }
            found = !list.isEmpty();
        }
        catch (Exception e) {
            RootTools.log(binaryName + " was not found, more information MAY be available with Debugging on.");
        }
        if (!found) {
            RootTools.log("Trying second method");
            for (String where : places) {
                if (RootTools.exists(where + binaryName)) {
                    RootTools.log(binaryName + " was found here: " + where);
                    list.add(where);
                    found = true;
                    continue;
                }
                RootTools.log(binaryName + " was NOT found here: " + where);
            }
        }
        if (!found) {
            RootTools.log("Trying third method");
            try {
                List<String> paths = RootTools.getPath();
                if (paths != null) {
                    for (String path : paths) {
                        if (RootTools.exists(path + "/" + binaryName)) {
                            RootTools.log(binaryName + " was found here: " + path);
                            list.add(path);
                            found = true;
                            continue;
                        }
                        RootTools.log(binaryName + " was NOT found here: " + path);
                    }
                }
            }
            catch (Exception e) {
                RootTools.log(binaryName + " was not found, more information MAY be available with Debugging on.");
            }
        }
        Collections.reverse(list);
        RootTools.lastFoundBinaryPaths.addAll(list);
        return found;
    }

    public List<String> getBusyBoxApplets(String path) throws Exception {
        if (path != null && !path.endsWith("/") && !path.equals("")) {
            path = path + "/";
        } else if (path == null) {
            throw new Exception("Path is null, please specifiy a path");
        }
        final ArrayList<String> results = new ArrayList<String>();
        CommandCapture command = new CommandCapture(3, false, new String[]{path + "busybox --list"}){

            @Override
            public void output(int id, String line) {
                if (id == 3 && !line.trim().equals("") && !line.trim().contains("not found")) {
                    results.add(line);
                }
            }
        };
        Shell.startRootShell().add(command);
        this.commandWait(command);
        return results;
    }

    public String getBusyBoxVersion(String path) {
        if (!path.equals("") && !path.endsWith("/")) {
            path = path + "/";
        }
        RootTools.log("Getting BusyBox Version");
        InternalVariables.busyboxVersion = "";
        try {
            CommandCapture command = new CommandCapture(4, false, new String[]{path + "busybox"}){

                @Override
                public void output(int id, String line) {
                    if (id == 4 && line.startsWith("BusyBox") && InternalVariables.busyboxVersion.equals("")) {
                        String[] temp = line.split(" ");
                        InternalVariables.busyboxVersion = temp[1];
                    }
                }
            };
            Shell.startRootShell().add(command);
            this.commandWait(command);
        }
        catch (Exception e) {
            RootTools.log("BusyBox was not found, more information MAY be available with Debugging on.");
            return "";
        }
        return InternalVariables.busyboxVersion;
    }

    public long getConvertedSpace(String spaceStr) {
        try {
            double multiplier = 1.0;
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < spaceStr.length(); ++i) {
                char c = spaceStr.charAt(i);
                if (!Character.isDigit(c) && c != '.') {
                    if (c == 'm' || c == 'M') {
                        multiplier = 1024.0;
                        break;
                    }
                    if (c != 'g' && c != 'G') break;
                    multiplier = 1048576.0;
                    break;
                }
                sb.append(spaceStr.charAt(i));
            }
            return (long)Math.ceil(Double.valueOf(sb.toString()) * multiplier);
        }
        catch (Exception e) {
            return -1L;
        }
    }

    public String getInode(String file) {
        try {
            CommandCapture command = new CommandCapture(5, false, new String[]{"/data/local/ls -i " + file}){

                @Override
                public void output(int id, String line) {
                    if (id == 5 && !line.trim().equals("") && Character.isDigit(line.trim().substring(0, 1).toCharArray()[0])) {
                        InternalVariables.inode = line.trim().split(" ")[0];
                    }
                }
            };
            Shell.startRootShell().add(command);
            this.commandWait(command);
            return InternalVariables.inode;
        }
        catch (Exception ignore) {
            return "";
        }
    }

    public boolean isAccessGiven() {
        try {
            RootTools.log("Checking for Root access");
            InternalVariables.accessGiven = false;
            CommandCapture command = new CommandCapture(2, false, new String[]{"id"}){

                @Override
                public void output(int id, String line) {
                    if (id == 2) {
                        HashSet<String> ID = new HashSet<String>(Arrays.asList(line.split(" ")));
                        for (String userid : ID) {
                            RootTools.log(userid);
                            if (!userid.toLowerCase().contains("uid=0")) continue;
                            InternalVariables.accessGiven = true;
                            RootTools.log("Access Given");
                            break;
                        }
                        if (!InternalVariables.accessGiven) {
                            RootTools.log("Access Denied?");
                        }
                    }
                }
            };
            Shell.startRootShell().add(command);
            this.commandWait(command);
            return InternalVariables.accessGiven;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isNativeToolsReady(int nativeToolsId, Context context) {
        Installer installer;
        RootTools.log("Preparing Native Tools");
        InternalVariables.nativeToolsReady = false;
        try {
            installer = new Installer(context);
        }
        catch (IOException ex) {
            if (RootTools.debugMode) {
                ex.printStackTrace();
            }
            return false;
        }
        InternalVariables.nativeToolsReady = installer.isBinaryInstalled("nativetools") ? true : installer.installBinary(nativeToolsId, "nativetools", "700");
        return InternalVariables.nativeToolsReady;
    }

    public Permissions getFilePermissionsSymlinks(String file) {
        RootTools.log("Checking permissions for " + file);
        if (RootTools.exists(file)) {
            RootTools.log(file + " was found.");
            try {
                CommandCapture command = new CommandCapture(1, false, new String[]{"ls -l " + file, "busybox ls -l " + file, "/system/bin/failsafe/toolbox ls -l " + file, "toolbox ls -l " + file}){

                    @Override
                    public void output(int id, String line) {
                        if (id == 1) {
                            String symlink_final = "";
                            String[] lineArray = line.split(" ");
                            if (lineArray[0].length() != 10) {
                                return;
                            }
                            RootTools.log("Line " + line);
                            try {
                                String[] symlink = line.split(" ");
                                if (symlink[symlink.length - 2].equals("->")) {
                                    RootTools.log("Symlink found.");
                                    symlink_final = symlink[symlink.length - 1];
                                }
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            try {
                                InternalVariables.permissions = RootToolsInternalMethods.this.getPermissions(line);
                                if (InternalVariables.permissions != null) {
                                    InternalVariables.permissions.setSymlink(symlink_final);
                                }
                            }
                            catch (Exception e) {
                                RootTools.log(e.getMessage());
                            }
                        }
                    }
                };
                Shell.startRootShell().add(command);
                this.commandWait(command);
                return InternalVariables.permissions;
            }
            catch (Exception e) {
                RootTools.log(e.getMessage());
                return null;
            }
        }
        return null;
    }

    public ArrayList<Mount> getMounts() throws Exception {
        Shell shell = RootTools.getShell(true);
        CommandCapture cmd = new CommandCapture(0, false, "cat /proc/mounts > /data/local/RootToolsMounts", "chmod 0777 /data/local/RootToolsMounts");
        shell.add(cmd);
        this.commandWait(cmd);
        BufferedReader lnr = null;
        FileReader fr = null;
        try {
            String line;
            fr = new FileReader("/data/local/RootToolsMounts");
            lnr = new LineNumberReader(fr);
            ArrayList<Mount> mounts = new ArrayList<Mount>();
            while ((line = ((LineNumberReader)lnr).readLine()) != null) {
                RootTools.log(line);
                String[] fields = line.split(" ");
                mounts.add(new Mount(new File(fields[0]), new File(fields[1]), fields[2], fields[3]));
            }
            InternalVariables.mounts = mounts;
            if (InternalVariables.mounts != null) {
                ArrayList<Mount> arrayList = InternalVariables.mounts;
                return arrayList;
            }
            throw new Exception();
        }
        finally {
            try {
                fr.close();
                fr = null;
            }
            catch (Exception e) {}
            try {
                lnr.close();
                lnr = null;
            }
            catch (Exception e) {}
        }
    }

    public String getMountedAs(String path) throws Exception {
        InternalVariables.mounts = this.getMounts();
        if (InternalVariables.mounts != null) {
            for (Mount mount : InternalVariables.mounts) {
                String mp = mount.getMountPoint().getAbsolutePath();
                if (mp.equals("/")) {
                    if (!path.equals("/")) continue;
                    return (String)mount.getFlags().toArray()[0];
                }
                if (!path.equals(mp) && !path.startsWith(mp + "/")) continue;
                RootTools.log((String)mount.getFlags().toArray()[0]);
                return (String)mount.getFlags().toArray()[0];
            }
            throw new Exception();
        }
        throw new Exception();
    }

    public long getSpace(String path) {
        InternalVariables.getSpaceFor = path;
        boolean found = false;
        RootTools.log("Looking for Space");
        try {
            CommandCapture command = new CommandCapture(6, false, new String[]{"df " + path}){

                @Override
                public void output(int id, String line) {
                    if (id == 6 && line.contains(InternalVariables.getSpaceFor.trim())) {
                        InternalVariables.space = line.split(" ");
                    }
                }
            };
            Shell.startRootShell().add(command);
            this.commandWait(command);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (InternalVariables.space != null) {
            RootTools.log("First Method");
            for (String spaceSearch : InternalVariables.space) {
                RootTools.log(spaceSearch);
                if (found) {
                    return this.getConvertedSpace(spaceSearch);
                }
                if (!spaceSearch.equals("used,")) continue;
                found = true;
            }
            int count = 0;
            int targetCount = 3;
            RootTools.log("Second Method");
            if (InternalVariables.space[0].length() <= 5) {
                targetCount = 2;
            }
            for (String spaceSearch : InternalVariables.space) {
                RootTools.log(spaceSearch);
                if (spaceSearch.length() <= 0) continue;
                RootTools.log(spaceSearch + "Valid");
                if (count == targetCount) {
                    return this.getConvertedSpace(spaceSearch);
                }
                ++count;
            }
        }
        RootTools.log("Returning -1, space could not be determined.");
        return -1L;
    }

    public String getSymlink(String file) {
        block5: {
            RootTools.log("Looking for Symlink for " + file);
            try {
                final ArrayList results = new ArrayList();
                CommandCapture command = new CommandCapture(7, false, new String[]{"ls -l " + file}){

                    @Override
                    public void output(int id, String line) {
                        if (id == 7 && !line.trim().equals("")) {
                            results.add(line);
                        }
                    }
                };
                Shell.startRootShell().add(command);
                this.commandWait(command);
                String[] symlink = ((String)results.get(0)).split(" ");
                if (symlink.length > 2 && symlink[symlink.length - 2].equals("->")) {
                    RootTools.log("Symlink found.");
                    String final_symlink = "";
                    if (!symlink[symlink.length - 1].equals("") && !symlink[symlink.length - 1].contains("/")) {
                        this.findBinary(symlink[symlink.length - 1]);
                        final_symlink = RootTools.lastFoundBinaryPaths.size() > 0 ? RootTools.lastFoundBinaryPaths.get(0) + "/" + symlink[symlink.length - 1] : symlink[symlink.length - 1];
                    } else {
                        final_symlink = symlink[symlink.length - 1];
                    }
                    return final_symlink;
                }
            }
            catch (Exception e) {
                if (!RootTools.debugMode) break block5;
                e.printStackTrace();
            }
        }
        RootTools.log("Symlink not found");
        return "";
    }

    public ArrayList<Symlink> getSymlinks(String path) throws Exception {
        if (!this.checkUtil("find")) {
            throw new Exception();
        }
        CommandCapture command = new CommandCapture(0, false, "dd if=/dev/zero of=/data/local/symlinks.txt bs=1024 count=1", "chmod 0777 /data/local/symlinks.txt");
        Shell.startRootShell().add(command);
        this.commandWait(command);
        command = new CommandCapture(0, false, "find " + path + " -type l -exec ls -l {} \\; > /data/local/symlinks.txt");
        Shell.startRootShell().add(command);
        this.commandWait(command);
        InternalVariables.symlinks = this.getSymLinks();
        if (InternalVariables.symlinks != null) {
            return InternalVariables.symlinks;
        }
        throw new Exception();
    }

    public String getWorkingToolbox() {
        if (RootTools.checkUtil("busybox")) {
            return "busybox";
        }
        if (RootTools.checkUtil("toolbox")) {
            return "toolbox";
        }
        return "";
    }

    public boolean hasEnoughSpaceOnSdCard(long updateSize) {
        RootTools.log("Checking SDcard size and that it is mounted as RW");
        String status = Environment.getExternalStorageState();
        if (!status.equals("mounted")) {
            return false;
        }
        File path = Environment.getExternalStorageDirectory();
        StatFs stat = new StatFs(path.getPath());
        long blockSize = stat.getBlockSize();
        long availableBlocks = stat.getAvailableBlocks();
        return updateSize < availableBlocks * blockSize;
    }

    public boolean hasUtil(final String util, final String box) {
        InternalVariables.found = false;
        if (!box.endsWith("toolbox") && !box.endsWith("busybox")) {
            return false;
        }
        try {
            CommandCapture command = new CommandCapture(0, false, new String[]{box.endsWith("toolbox") ? box + " " + util : box + " --list"}){

                @Override
                public void output(int id, String line) {
                    if (box.endsWith("toolbox")) {
                        if (!line.contains("no such tool")) {
                            InternalVariables.found = true;
                        }
                    } else if (box.endsWith("busybox") && line.contains(util)) {
                        RootTools.log("Found util!");
                        InternalVariables.found = true;
                    }
                }
            };
            RootTools.getShell(true).add(command);
            this.commandWait(command);
            if (InternalVariables.found) {
                RootTools.log("Box contains " + util + " util!");
                return true;
            }
            RootTools.log("Box does not contain " + util + " util!");
            return false;
        }
        catch (Exception e) {
            RootTools.log(e.getMessage());
            return false;
        }
    }

    public boolean installBinary(Context context, int sourceId, String destName, String mode) {
        Installer installer;
        try {
            installer = new Installer(context);
        }
        catch (IOException ex) {
            if (RootTools.debugMode) {
                ex.printStackTrace();
            }
            return false;
        }
        return installer.installBinary(sourceId, destName, mode);
    }

    public boolean isBinaryAvailable(Context context, String binaryName) {
        Installer installer;
        try {
            installer = new Installer(context);
        }
        catch (IOException ex) {
            if (RootTools.debugMode) {
                ex.printStackTrace();
            }
            return false;
        }
        return installer.isBinaryInstalled(binaryName);
    }

    public boolean isAppletAvailable(String applet, String binaryPath) {
        try {
            for (String aplet : this.getBusyBoxApplets(binaryPath)) {
                if (!aplet.equals(applet)) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            RootTools.log(e.toString());
            return false;
        }
    }

    public boolean isProcessRunning(final String processName) {
        RootTools.log("Checks if process is running: " + processName);
        InternalVariables.processRunning = false;
        try {
            CommandCapture command = new CommandCapture(0, false, new String[]{"ps"}){

                @Override
                public void output(int id, String line) {
                    if (line.contains(processName)) {
                        InternalVariables.processRunning = true;
                    }
                }
            };
            RootTools.getShell(true).add(command);
            this.commandWait(command);
        }
        catch (Exception e) {
            RootTools.log(e.getMessage());
        }
        return InternalVariables.processRunning;
    }

    public boolean killProcess(final String processName) {
        block5: {
            RootTools.log("Killing process " + processName);
            InternalVariables.pid_list = "";
            InternalVariables.processRunning = true;
            try {
                CommandCapture command = new CommandCapture(0, false, new String[]{"ps"}){

                    @Override
                    public void output(int id, String line) {
                        if (line.contains(processName)) {
                            Matcher psMatcher = InternalVariables.psPattern.matcher(line);
                            try {
                                if (psMatcher.find()) {
                                    String pid = psMatcher.group(1);
                                    InternalVariables.pid_list = InternalVariables.pid_list + " " + pid;
                                    InternalVariables.pid_list = InternalVariables.pid_list.trim();
                                    RootTools.log("Found pid: " + pid);
                                } else {
                                    RootTools.log("Matching in ps command failed!");
                                }
                            }
                            catch (Exception e) {
                                RootTools.log("Error with regex!");
                                e.printStackTrace();
                            }
                        }
                    }
                };
                RootTools.getShell(true).add(command);
                this.commandWait(command);
                String pids = InternalVariables.pid_list;
                if (!pids.equals("")) {
                    try {
                        command = new CommandCapture(0, false, "kill -9 " + pids);
                        RootTools.getShell(true).add(command);
                        this.commandWait(command);
                        return true;
                    }
                    catch (Exception e) {
                        RootTools.log(e.getMessage());
                        break block5;
                    }
                }
                return true;
            }
            catch (Exception e) {
                RootTools.log(e.getMessage());
            }
        }
        return false;
    }

    public void offerBusyBox(Activity activity) {
        RootTools.log("Launching Market for BusyBox");
        Intent i = new Intent("android.intent.action.VIEW", Uri.parse((String)"market://details?id=stericson.busybox"));
        activity.startActivity(i);
    }

    public Intent offerBusyBox(Activity activity, int requestCode) {
        RootTools.log("Launching Market for BusyBox");
        Intent i = new Intent("android.intent.action.VIEW", Uri.parse((String)"market://details?id=stericson.busybox"));
        activity.startActivityForResult(i, requestCode);
        return i;
    }

    public void offerSuperUser(Activity activity) {
        RootTools.log("Launching Market for SuperUser");
        Intent i = new Intent("android.intent.action.VIEW", Uri.parse((String)"market://details?id=com.noshufou.android.su"));
        activity.startActivity(i);
    }

    public Intent offerSuperUser(Activity activity, int requestCode) {
        RootTools.log("Launching Market for SuperUser");
        Intent i = new Intent("android.intent.action.VIEW", Uri.parse((String)"market://details?id=com.noshufou.android.su"));
        activity.startActivityForResult(i, requestCode);
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commandWait(Command cmd) throws Exception {
        while (!cmd.isFinished()) {
            Exception e;
            RootTools.log("RootTools v3.4", Shell.getOpenShell().getCommandQueuePositionString(cmd));
            Command command = cmd;
            synchronized (command) {
                try {
                    if (!cmd.isFinished()) {
                        cmd.wait(2000L);
                    }
                }
                catch (InterruptedException e2) {
                    e2.printStackTrace();
                }
            }
            if (cmd.isExecuting() || cmd.isFinished()) continue;
            if (!Shell.isExecuting && !Shell.isReading) {
                Log.e((String)"RootTools v3.4", (String)("Waiting for a command to be executed in a shell that is not executing and not reading! \n\n Command: " + cmd.getCommand()));
                e = new Exception();
                e.setStackTrace(Thread.currentThread().getStackTrace());
                e.printStackTrace();
                continue;
            }
            if (Shell.isExecuting && !Shell.isReading) {
                Log.e((String)"RootTools v3.4", (String)("Waiting for a command to be executed in a shell that is executing but not reading! \n\n Command: " + cmd.getCommand()));
                e = new Exception();
                e.setStackTrace(Thread.currentThread().getStackTrace());
                e.printStackTrace();
                continue;
            }
            Log.e((String)"RootTools v3.4", (String)("Waiting for a command to be executed in a shell that is not reading! \n\n Command: " + cmd.getCommand()));
            e = new Exception();
            e.setStackTrace(Thread.currentThread().getStackTrace());
            e.printStackTrace();
        }
    }
}

