/*
 * Decompiled with CFR 0.152.
 */
package com.stericson.RootTools.internal;

import android.content.Context;
import android.util.Log;
import com.stericson.RootTools.RootTools;
import com.stericson.RootTools.execution.Command;
import com.stericson.RootTools.execution.CommandCapture;
import com.stericson.RootTools.execution.Shell;
import java.io.IOException;

public class Runner
extends Thread {
    private static final String LOG_TAG = "RootTools::Runner";
    Context context;
    String binaryName;
    String parameter;

    public Runner(Context context, String binaryName, String parameter) {
        this.context = context;
        this.binaryName = binaryName;
        this.parameter = parameter;
    }

    @Override
    public void run() {
        String privateFilesPath = null;
        try {
            privateFilesPath = this.context.getFilesDir().getCanonicalPath();
        }
        catch (IOException e) {
            if (RootTools.debugMode) {
                Log.e((String)LOG_TAG, (String)"Problem occured while trying to locate private files directory!");
            }
            e.printStackTrace();
        }
        if (privateFilesPath != null) {
            try {
                CommandCapture command = new CommandCapture(0, false, privateFilesPath + "/" + this.binaryName + " " + this.parameter);
                Shell.startRootShell().add(command);
                this.commandWait(command);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commandWait(Command cmd) {
        Command command = cmd;
        synchronized (command) {
            try {
                if (!cmd.isFinished()) {
                    cmd.wait(2000L);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

