/*
 * Decompiled with CFR 0.152.
 */
package com.stericson.RootTools.execution;

import android.content.Context;
import com.stericson.RootTools.RootTools;
import com.stericson.RootTools.exceptions.RootDeniedException;
import com.stericson.RootTools.execution.Command;
import com.stericson.RootTools.execution.CommandCapture;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeoutException;

public class Shell {
    private final Process proc;
    private final BufferedReader in;
    private final OutputStreamWriter out;
    private final List<Command> commands = new ArrayList<Command>();
    private boolean close = false;
    private static String error = "";
    private static final String token = "F*D^W@#FGF";
    private static Shell rootShell = null;
    private static Shell shell = null;
    private static Shell customShell = null;
    private static int shellTimeout = 25000;
    public static boolean isExecuting = false;
    public static boolean isReading = false;
    private int maxCommands = 1000;
    private int read = 0;
    private int write = 0;
    private int totalExecuted = 0;
    private int totalRead = 0;
    private boolean isCleaning = false;
    private Runnable input = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (true) {
                    List list = Shell.this.commands;
                    synchronized (list) {
                        while (!Shell.this.close && Shell.this.write >= Shell.this.commands.size()) {
                            isExecuting = false;
                            Shell.this.commands.wait();
                        }
                    }
                    if (Shell.this.write >= Shell.this.maxCommands) {
                        while (Shell.this.read != Shell.this.write) {
                            RootTools.log("Waiting for read and write to catch up before cleanup.");
                        }
                        Shell.this.cleanCommands();
                    }
                    if (Shell.this.write < Shell.this.commands.size()) {
                        isExecuting = true;
                        Command cmd = (Command)Shell.this.commands.get(Shell.this.write);
                        cmd.startExecution();
                        RootTools.log("Executing: " + cmd.getCommand());
                        Shell.this.out.write(cmd.getCommand());
                        String line = "\necho F*D^W@#FGF " + Shell.this.totalExecuted + " $?\n";
                        Shell.this.out.write(line);
                        Shell.this.out.flush();
                        Shell.this.write++;
                        Shell.this.totalExecuted++;
                        continue;
                    }
                    if (Shell.this.close) break;
                }
                isExecuting = false;
                Shell.this.out.write("\nexit 0\n");
                Shell.this.out.flush();
                RootTools.log("Closing shell");
                return;
            }
            catch (IOException e) {
                RootTools.log(e.getMessage(), 2, e);
            }
            catch (InterruptedException e) {
                RootTools.log(e.getMessage(), 2, e);
            }
            finally {
                Shell.this.write = 0;
                Shell.this.closeQuietly(Shell.this.out);
            }
        }
    };
    private Runnable output = new Runnable(){

        @Override
        public void run() {
            try {
                Command command = null;
                while (!Shell.this.close) {
                    String[] fields;
                    int pos;
                    isReading = false;
                    String line = Shell.this.in.readLine();
                    isReading = true;
                    if (line == null) break;
                    if (command == null) {
                        if (Shell.this.read >= Shell.this.commands.size()) {
                            if (!Shell.this.close) continue;
                            break;
                        }
                        command = (Command)Shell.this.commands.get(Shell.this.read);
                    }
                    if ((pos = line.indexOf(Shell.token)) == -1) {
                        command.output(command.id, line);
                    }
                    if (pos > 0) {
                        command.output(command.id, line.substring(0, pos));
                    }
                    if (pos < 0 || (fields = (line = line.substring(pos)).split(" ")).length < 2 || fields[1] == null) continue;
                    int id = 0;
                    try {
                        id = Integer.parseInt(fields[1]);
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                    int exitCode = -1;
                    try {
                        exitCode = Integer.parseInt(fields[2]);
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                    if (id != Shell.this.totalRead) continue;
                    command.setExitCode(exitCode);
                    command.commandFinished();
                    command = null;
                    Shell.this.read++;
                    Shell.this.totalRead++;
                }
                RootTools.log("Read all output");
                try {
                    Shell.this.proc.waitFor();
                    Shell.this.proc.destroy();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Shell.this.closeQuietly(Shell.this.out);
                Shell.this.closeQuietly(Shell.this.in);
                RootTools.log("Shell destroyed");
                while (Shell.this.read < Shell.this.commands.size()) {
                    if (command == null) {
                        command = (Command)Shell.this.commands.get(Shell.this.read);
                    }
                    command.terminated("Unexpected Termination.");
                    command = null;
                    Shell.this.read++;
                }
                Shell.this.read = 0;
            }
            catch (IOException e) {
                RootTools.log(e.getMessage(), 2, e);
            }
        }
    };

    private Shell(String cmd) throws IOException, TimeoutException, RootDeniedException {
        RootTools.log("Starting shell: " + cmd);
        this.proc = new ProcessBuilder(cmd).redirectErrorStream(true).start();
        this.in = new BufferedReader(new InputStreamReader(this.proc.getInputStream(), "UTF-8"));
        this.out = new OutputStreamWriter(this.proc.getOutputStream(), "UTF-8");
        Worker worker = new Worker(this.proc, this.in, this.out);
        worker.start();
        try {
            worker.join(shellTimeout);
            if (worker.exit == -911) {
                try {
                    this.proc.destroy();
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.closeQuietly(this.in);
                this.closeQuietly(this.out);
                throw new TimeoutException(error);
            }
            if (worker.exit == -42) {
                try {
                    this.proc.destroy();
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.closeQuietly(this.in);
                this.closeQuietly(this.out);
                throw new RootDeniedException("Root Access Denied");
            }
            Thread si = new Thread(this.input, "Shell Input");
            si.setPriority(5);
            si.start();
            Thread so = new Thread(this.output, "Shell Output");
            so.setPriority(5);
            so.start();
        }
        catch (InterruptedException ex) {
            worker.interrupt();
            Thread.currentThread().interrupt();
            throw new TimeoutException();
        }
    }

    public Command add(Command command) throws IOException {
        if (this.close) {
            throw new IllegalStateException("Unable to add commands to a closed shell");
        }
        while (this.isCleaning) {
        }
        this.commands.add(command);
        this.notifyThreads();
        return command;
    }

    public void useCWD(Context context) throws IOException, TimeoutException, RootDeniedException {
        this.add(new CommandCapture(-1, false, "cd " + context.getApplicationInfo().dataDir));
    }

    private void cleanCommands() {
        this.isCleaning = true;
        int toClean = Math.abs(this.maxCommands - this.maxCommands / 4);
        RootTools.log("Cleaning up: " + toClean);
        for (int i = 0; i < toClean; ++i) {
            this.commands.remove(0);
        }
        this.read = this.commands.size() - 1;
        this.write = this.commands.size() - 1;
        this.isCleaning = false;
    }

    private void closeQuietly(Reader input) {
        try {
            if (input != null) {
                input.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void closeQuietly(Writer output) {
        try {
            if (output != null) {
                output.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this == rootShell) {
            rootShell = null;
        } else if (this == shell) {
            shell = null;
        } else if (this == customShell) {
            customShell = null;
        }
        List<Command> list = this.commands;
        synchronized (list) {
            this.close = true;
            this.notifyThreads();
        }
    }

    public static void closeCustomShell() throws IOException {
        if (customShell == null) {
            return;
        }
        customShell.close();
    }

    public static void closeRootShell() throws IOException {
        if (rootShell == null) {
            return;
        }
        rootShell.close();
    }

    public static void closeShell() throws IOException {
        if (shell == null) {
            return;
        }
        shell.close();
    }

    public static void closeAll() throws IOException {
        Shell.closeShell();
        Shell.closeRootShell();
        Shell.closeCustomShell();
    }

    public int getCommandQueuePosition(Command cmd) {
        return this.commands.indexOf(cmd);
    }

    public String getCommandQueuePositionString(Command cmd) {
        return "Command is in position " + this.getCommandQueuePosition(cmd) + " currently executing command at position " + this.write;
    }

    public static Shell getOpenShell() {
        if (customShell != null) {
            return customShell;
        }
        if (rootShell != null) {
            return rootShell;
        }
        return shell;
    }

    public static boolean isShellOpen() {
        return shell != null;
    }

    public static boolean isCustomShellOpen() {
        return customShell != null;
    }

    public static boolean isRootShellOpen() {
        return rootShell != null;
    }

    public static boolean isAnyShellOpen() {
        if (shell != null) {
            return true;
        }
        if (rootShell != null) {
            return true;
        }
        return customShell != null;
    }

    protected void notifyThreads() {
        Thread t = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                List list = Shell.this.commands;
                synchronized (list) {
                    Shell.this.commands.notifyAll();
                }
            }
        };
        t.start();
    }

    public static void runRootCommand(Command command) throws IOException, TimeoutException, RootDeniedException {
        Shell.startRootShell().add(command);
    }

    public static void runCommand(Command command) throws IOException, TimeoutException {
        Shell.startShell().add(command);
    }

    public static Shell startRootShell() throws IOException, TimeoutException, RootDeniedException {
        return Shell.startRootShell(20000, 3);
    }

    public static Shell startRootShell(int timeout) throws IOException, TimeoutException, RootDeniedException {
        return Shell.startRootShell(timeout, 3);
    }

    public static Shell startRootShell(int timeout, int retry) throws IOException, TimeoutException, RootDeniedException {
        shellTimeout = timeout;
        if (rootShell == null) {
            RootTools.log("Starting Root Shell!");
            String cmd = "su";
            int retries = 0;
            while (rootShell == null) {
                try {
                    rootShell = new Shell(cmd);
                }
                catch (IOException e) {
                    if (retries++ < retry) continue;
                    RootTools.log("IOException, could not start shell");
                    throw e;
                }
            }
        } else {
            RootTools.log("Using Existing Root Shell!");
        }
        return rootShell;
    }

    public static Shell startCustomShell(String shellPath) throws IOException, TimeoutException, RootDeniedException {
        return Shell.startCustomShell(shellPath, 20000);
    }

    public static Shell startCustomShell(String shellPath, int timeout) throws IOException, TimeoutException, RootDeniedException {
        shellTimeout = timeout;
        if (customShell == null) {
            RootTools.log("Starting Custom Shell!");
            customShell = new Shell(shellPath);
        } else {
            RootTools.log("Using Existing Custom Shell!");
        }
        return customShell;
    }

    public static Shell startShell() throws IOException, TimeoutException {
        return Shell.startShell(20000);
    }

    public static Shell startShell(int timeout) throws IOException, TimeoutException {
        shellTimeout = timeout;
        try {
            if (shell == null) {
                RootTools.log("Starting Shell!");
                shell = new Shell("/system/bin/sh");
            } else {
                RootTools.log("Using Existing Shell!");
            }
            return shell;
        }
        catch (RootDeniedException e) {
            throw new IOException();
        }
    }

    protected static class Worker
    extends Thread {
        public int exit = -911;
        public Process proc;
        public BufferedReader in;
        public OutputStreamWriter out;

        private Worker(Process proc, BufferedReader in, OutputStreamWriter out) {
            this.proc = proc;
            this.in = in;
            this.out = out;
        }

        @Override
        public void run() {
            try {
                this.out.write("echo Started\n");
                this.out.flush();
                while (true) {
                    String line;
                    if ((line = this.in.readLine()) == null) {
                        throw new EOFException();
                    }
                    if ("".equals(line)) continue;
                    if ("Started".equals(line)) {
                        this.exit = 1;
                        this.setShellOom();
                        break;
                    }
                    error = "unkown error occured.";
                }
            }
            catch (IOException e) {
                this.exit = -42;
                if (e.getMessage() != null) {
                    error = e.getMessage();
                }
                error = "RootAccess denied?.";
            }
        }

        private void setShellOom() {
            try {
                Class<?> processClass = this.proc.getClass();
                Field field = null;
                try {
                    field = processClass.getDeclaredField("pid");
                }
                catch (NoSuchFieldException e) {
                    field = processClass.getDeclaredField("id");
                }
                field.setAccessible(true);
                int pid = (Integer)field.get(this.proc);
                this.out.write("(echo -17 > /proc/" + pid + "/oom_adj) &> /dev/null\n");
                this.out.write("(echo -17 > /proc/$$/oom_adj) &> /dev/null\n");
                this.out.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

