var FeaturesCache = require("./common/FeaturesCache.js");

var {
    ThreadPoolManager,
    BaseTaskHandler,
    MultiThreadExecutor
} = require("./common/MultiThreadTask.js")

// 图像识别任务处理器
function ImageRecognitionTaskHandler(options, featuresCache) {
    BaseTaskHandler.call(this);
    this.options = options || {};
    this.extension = this.options.extension || "png";
    this.screenshot = null;
    this.screenshotFeatures = null;
    this.featuresCache = featuresCache;

    this.beforeAll = function() {
        this.screenshot = captureScreen();
        if (!this.screenshot) {
            throw new Error("截图失败");
        }

        this.featuresCache.set("截图", this.screenshot, this.options);
        this.screenshotFeatures = this.featuresCache.get("截图");
        if (!this.screenshotFeatures) {
            throw new Error("图像特征提取失败");
        }
    };

    this.processTask = function(task, index) {
        var name = task;
        var matchParam = {
            matcher: this.options.matcher || "FLANNBASED",
            thredshold: this.options.thredshold || 0.7
        };

        if (this.options.draw === true) {
            var dir = "./matches/";
            matchParam.drawMatches = dir + name + "." + this.extension;
            files.ensureDir(dir);
        }

        var features = this.featuresCache.get(name, this.extension, this.options);
        if (!features) {
            console.log("未找到特征：" + name);
            return null;
        }

        var result = $images.matchFeatures(this.screenshotFeatures, features, matchParam);
        if (result) {
            return {
                name: name,
                point: result
            };
        }
        return null;
    };

    this.shouldContinue = function(results) {
        // 如果不需要多匹配，找到第一个就停止
        return !!this.options.multiMatch;
    };

    this.afterAll = function() {
        // 清理资源
        //this.featuresCache.clear();
    };
}

// 使用示例
function imageRecognitionExample(featuresCache) {
    var taskNames = ["1", "2", "3", "4", "5", "6", "7", "8", "9", "10"];

    var options = {
        thredshold: 0.8,
        multiMatch: false, // 返回所有符合条件的匹配
        draw: false, // 是否绘制
        extension: 'jpg' // 要计算图片的扩展名
    };

    var executor = new MultiThreadExecutor("SIFT_POOL");
    var handler = new ImageRecognitionTaskHandler(options, featuresCache);

    var results = executor.execute(taskNames, handler);
    results.forEach(function(r) {
        console.log("匹配到 " + r.name);
    });
    return results
}

// 另一个任务类型的示例处理器
function SimpleCalculationTaskHandler() {
    BaseTaskHandler.call(this);
    this.processTask = function(task, index) {
        log(123465)
        // 模拟一个耗时计算任务
        var result = 0;
        for (var i = 0; i < 1000000; i++) {
            result += Math.sqrt(i);
        }
        log(callback)
        if (typeof callback == "function") {
            callback({
                taskId: task.id,
                result: result,
                index: index
            })
        }
    };
}


requestScreenCapture();
sleep(2000);
var time = Date.now()
var featuresCache = new FeaturesCache("./images");
// 执行图像识别示例
log(imageRecognitionExample(featuresCache).length)

log(imageRecognitionExample(featuresCache).length)

log(imageRecognitionExample(featuresCache).length)
console.log("所有任务完成，耗时：" + (Date.now() - time) + "ms");