function FeaturesCache(dir, maxMemory) {
    this._featuresCache = {};
    this._accessTime = {};
    this.dir = dir || files.join(files.cwd(), "images");
    this._maxMemory = maxMemory || 200 * 1024 * 1024; // 最大允许占用内存（单位：字节）
}
//获取特征
FeaturesCache.prototype.get = function(k, extension, options) {
    extension = extension || "png";
    options = options || {}
    var features = this._featuresCache[k]
    this._accessTime[k] = Date.now(); // 每次访问或设置后记录时间
    if (features && !features.recycled) {
        return features
    }
    var path = files.join(this.dir, k + "." + extension)

    if (!files.exists(path)) {
        throw "图片不存在"
    }
    var imgObj = images.read(path)
    if (!imgObj) {
        throw "读取图片失败"
    }
    features = images.detectAndComputeFeatures(imgObj, options)
    imgObj.recycle()
    this._featuresCache[k] = features
    //this._ensureMemory(); // 在缓存插入后调用
    return features
}
//设置特征
FeaturesCache.prototype.set = function(k, v, options) {
    options = options || {}
    var featuresCache = this._featuresCache
    if (/^Image/.test(v.toString()) && v != featuresCache[k]) {
        this._accessTime[k] = Date.now(); // 每次访问或设置后记录时间
        if(featuresCache[k] && !featuresCache[k].recycled){
            featuresCache[k].recycle()
        }
        featuresCache[k] = images.detectAndComputeFeatures(v, options)
        //this._ensureMemory(); // 在缓存插入后调用
        return true
    }
    return false
}
//删除特征
FeaturesCache.prototype.delete = function(k) {
    if (this._featuresCache[k]) {
        this._featuresCache[k].recycle()
        delete this._featuresCache[k]
        delete this._accessTime[k]
        return true
    } else {
        return false
    }
}
//清空特征
FeaturesCache.prototype.clear = function() {
    var featuresCache = this._featuresCache
    for (k in featuresCache) {
        if (!featuresCache[k].recycled) {
            featuresCache[k].recycle()
        }
    }
    this._featuresCache = {}
    this._accessTime = {}
    return true
}
//重新读取特征
FeaturesCache.prototype.reread = function(k, extension, options) {
    extension = extension || "png";
    options = options || {}
    var path = files.join(this.dir, k + "." + extension)
    if (!files.exists(path)) {
        throw "图片不存在"
    }
    if (this._featuresCache[k]) {
        this._featuresCache[k].recycle()
        delete this._featuresCache[k]
    }
    var imgObj = images.read(path)
    if (!imgObj) {
        throw "读取图片失败"
    }
    features = images.detectAndComputeFeatures(imgObj, options)
    imgObj.recycle()
    this._featuresCache[k] = features
    this._accessTime[k] = Date.now(); // 每次访问或设置后记录时间
    //this._ensureMemory(); // 在缓存插入后调用
    return features
}
//获取所有特征是否被回收
FeaturesCache.prototype.stats = function() {
    var arr = []
    var featuresCache = this._featuresCache
    for (var k in featuresCache) {
        arr.push({
            name: k,
            recycled: featuresCache[k].recycled
        })
    }
    return arr
}
// 特征存在吗
FeaturesCache.prototype.has = function(k) {
    if (k) {
        var features = this._featuresCache[k]
        if (features) {
            return {
                name: k,
                recycled: features.recycled
            }
        }
        return null
    }
    throw "请输入图片名"
}

// 特征缓存数量
FeaturesCache.prototype.size = function() {
    return Object.keys(this._featuresCache).length;
}

module.exports = FeaturesCache