importClass(android.graphics.drawable.GradientDrawable);
importPackage(android.graphics);
importClass(android.animation.ObjectAnimator);
importClass(android.animation.AnimatorSet);
importClass(android.view.MotionEvent);

var utils = require(files.join(files.cwd(), "utils.js"));
var dialogsFloaty = require("./dialogsFloaty.js")
var 状态栏h = utils.状态栏高度();
var 按键栏h = utils.getNavigationBarHeight();
var dpi = utils.getdeviceDpi().density;
utils.屏幕旋转(); // 初始化方向监听

// 最小宽高和拖拽热点半径
var MIN_SIZE = 10 * dpi;
var HANDLE = 10 * dpi;

// 性能优化：预计算常量
var HANDLE_SQUARED = HANDLE * HANDLE;
var MIN_SIZE_HALF = MIN_SIZE * 0.5;
var TOUCH_SLOP = 2;
var TOUCH_SLOP_SQUARED = TOUCH_SLOP * TOUCH_SLOP;

// 双指缩放和平移变量
var imgScale = 1,
    imgTransX = 0,
    imgTransY = 0;
var lastDist = 0,
    lastCenterX = 0,
    lastCenterY = 0,
    twoFinger = false;
var isTouchingMulti = false; // 防止多指操作后单指误触

// 可调开关：虚线和缩放背景
var USE_DASH = false; // 虚线边框开关（默认关，性能更好）
var DRAW_DASH_ON_UP = true; // 若开虚线，建议仅在抬手后画
var USE_SCALED_BG = false; // 将背景缩放为窗口大小的一份缓存（低端机建议开）

// 存储每个窗口的菜单动画状态
var menuStates = new WeakMap();

// 复用对象避免重复创建
var tempRect = {
    x1: 0,
    y1: 0,
    x2: 0,
    y2: 0
};

function resetScaleParams() {
    // 重置缩放和平移参数（每次打开都从原始状态开始）
    imgScale = 1;
    imgTransX = 0;
    imgTransY = 0;
    twoFinger = false;
    isTouchingMulti = false;
}

function selectImg(config, img) {

    if (!config) throw new Error("请传入设备信息对象");
    if (!utils.requestScreenCapture()) {
        throw new Error("请求截图失败，可能是权限被拒绝");
    }
    resetScaleParams()
    img = img || captureScreen();

    var w = config.width,
        h = config.height;
    // 计算正方形边长，取屏幕宽高中较小值的三分之一
    var rect = setRect(config.rect[0], config.rect[1], config.rect[0] + config.rect[2], config.rect[1] + config.rect[3]);

    function setRect(x1, y1, x2, y2) {
        if (x2 > x1 && y2 > y1) {
            return {
                x1: x1,
                y1: y1,
                x2: x2,
                y2: y2
            };
        }
        var side = Math.min(w, h) / 8;
        // 计算左右上下留白，让正方形居中
        var x1 = (w - side) / 2;
        var y1 = (h - side) / 2;
        // 构造正方形 rect
        return {
            x1: x1,
            y1: y1,
            x2: x1 + side,
            y2: y1 + side
        };
    }

    // 状态
    var mode, downX = 0,
        downY = 0,
        origin = null;
    var tapTime = 0,
        tapX = 0,
        tapY = 0;
    var lastInfo = {
        W: -1,
        H: -1,
        x1: -1,
        y1: -1,
        x2: -1,
        y2: -1
    };
    var needsRepaint = false,
        repaintScheduled = false;
    var infoUpdateTimer = null;
    var dashEnabledNow = USE_DASH && !DRAW_DASH_ON_UP ? true : false;

    // 缓存的对象和常量
    var L = Math.round(20 * dpi);
    var mtx = new Matrix();
    var maskPaint = new Paint();
    maskPaint.setStyle(Paint.Style.FILL);
    maskPaint.setARGB(150, 0, 0, 0);

    var borderPaint = new Paint();
    borderPaint.setStyle(Paint.Style.STROKE);
    borderPaint.setARGB(255, 255, 255, 255);
    borderPaint.setStrokeWidth(1 * dpi);
    if (USE_DASH && !DRAW_DASH_ON_UP) {
        borderPaint.setPathEffect(new android.graphics.DashPathEffect([10 * dpi, 6 * dpi], 0));
    }

    var cornerPaint = new Paint();
    cornerPaint.setStyle(Paint.Style.STROKE);
    cornerPaint.setARGB(255, 255, 255, 255);
    cornerPaint.setStrokeWidth(2 * dpi);

    var bmpPaint = new Paint();
    bmpPaint.setFilterBitmap(true); // 更平滑的缩放/采样

    // 创建悬浮窗
    var win = createWindow(config);
    var cv = win.board;

    // 降帧：空闲时不刷新，交互时 30fps
    cv.setMaxFps(60);

    // 背景位图（可选缩放）
    var bg = img;
    var bgMatrix = mtx;
    if (USE_SCALED_BG) {
        // 生成与窗口大小一致且已缩放的一张缓存图，减少每帧缩放/采样成本
        var scaled = images.resize(img, [w, h]);
        bg = scaled;
        bgMatrix = null; // 不需要 Matrix
    }

    // 优化重绘请求 - 使用requestAnimationFrame概念
    var repaintFrame = null;

    function requestRepaint() {
        if (repaintFrame) return;

        repaintFrame = ui.post(function() {
            repaintFrame = null;
            cv.invalidate();
        }, 16); // 60fps限制
    }

    // 优化节流函数 - 使用防抖而非节流，减少不必要的UI更新
    function scheduleInfoUpdate() {
        if (infoUpdateTimer) {
            clearTimeout(infoUpdateTimer);
        }
        infoUpdateTimer = setTimeout(function() {
            infoUpdateTimer = null;
            var W = (rect.x2 - rect.x1) | 0; // 位运算取整
            var H = (rect.y2 - rect.y1) | 0;

            // 只有真的变化时才更新UI
            if (W !== lastInfo.W || H !== lastInfo.H ||
                rect.x1 !== lastInfo.x1 || rect.y1 !== lastInfo.y1 ||
                rect.x2 !== lastInfo.x2 || rect.y2 !== lastInfo.y2) {

                ui.post(function() {
                    win.Area.setText("[ " + W + " × " + H + " ]");
                    win.coordinate.setText("『" + (rect.x1 | 0) + "," + (rect.y1 | 0) +
                        "—" + (rect.x2 | 0) + "," + (rect.y2 | 0) + "』");
                });

                lastInfo.W = W;
                lastInfo.H = H;
                lastInfo.x1 = rect.x1;
                lastInfo.y1 = rect.y1;
                lastInfo.x2 = rect.x2;
                lastInfo.y2 = rect.y2;
            }
        }, 50); // 50ms防抖延迟
    }
    scheduleInfoUpdate();

    // 进一步优化绘制函数
    cv.on("draw", function(canvas) {
        // 使用更高效的清空方式
        canvas.drawColor(android.graphics.Color.WHITE); // 白色背景，避免透明

        // 背景绘制优化
        // 背景绘制优化（支持双指缩放和平移）
        canvas.save();
        canvas.translate(imgTransX, imgTransY);
        canvas.scale(imgScale, imgScale);
        if (bgMatrix) {
            canvas.drawImage(bg, bgMatrix, bmpPaint);
        } else {
            canvas.drawImage(bg, null, bmpPaint);
        }
        canvas.restore();

        // 蒙版优化：使用整数坐标
        var x1 = rect.x1 | 0,
            y1 = rect.y1 | 0,
            x2 = rect.x2 | 0,
            y2 = rect.y2 | 0;

        canvas.save();
        canvas.clipRect(x1, y1, x2, y2, Region.Op.DIFFERENCE);
        canvas.drawPaint(maskPaint);
        canvas.restore();

        // 边框绘制
        if (dashEnabledNow) {
            canvas.drawRect(x1, y1, x2, y2, borderPaint);
        } else {
            canvas.drawRect(x1, y1, x2, y2, borderPaint);
        }

        // 四角线条 - 动态调整长度避免穿透
        var currentW = x2 - x1;
        var currentH = y2 - y1;

        // 动态计算线条长度，避免穿透
        var cornerL = Math.min(L, currentW / 3, currentH / 3);

        // 只有当选择框足够大时才绘制角线
        if (cornerL > 5 * dpi) {
            // 左上
            canvas.drawLine(x1, y1, x1 + cornerL, y1, cornerPaint);
            canvas.drawLine(x1, y1, x1, y1 + cornerL, cornerPaint);
            // 右上
            canvas.drawLine(x2, y1, x2 - cornerL, y1, cornerPaint);
            canvas.drawLine(x2, y1, x2, y1 + cornerL, cornerPaint);
            // 右下
            canvas.drawLine(x2, y2, x2 - cornerL, y2, cornerPaint);
            canvas.drawLine(x2, y2, x2, y2 - cornerL, cornerPaint);
            // 左下
            canvas.drawLine(x1, y2, x1 + cornerL, y2, cornerPaint);
            canvas.drawLine(x1, y2, x1, y2 - cornerL, cornerPaint);
        }
    });

    // 优化的hitTest函数
    function hitTest(x, y) {
        var lx = rect.x1,
            rx = rect.x2,
            ty = rect.y1,
            by = rect.y2;

        // 快速边界检查
        if (x < lx - HANDLE || x > rx + HANDLE || y < ty - HANDLE || y > by + HANDLE) {
            return 'move';
        }

        // 内联距离平方计算，避免函数调用开销
        var dx, dy;

        // 左上角
        dx = x - lx;
        dy = y - ty;
        if (dx * dx + dy * dy <= HANDLE_SQUARED) return "lt";

        // 右上角
        dx = x - rx;
        dy = y - ty;
        if (dx * dx + dy * dy <= HANDLE_SQUARED) return "rt";

        // 右下角
        dx = x - rx;
        dy = y - by;
        if (dx * dx + dy * dy <= HANDLE_SQUARED) return "rb";

        // 左下角
        dx = x - lx;
        dy = y - by;
        if (dx * dx + dy * dy <= HANDLE_SQUARED) return "lb";

        return "move";
    }

    var moveTime = 0; // ms

    // 触摸分发（抖动过滤 + 合并重绘 + 节流 UI 更新）
    cv.setOnTouchListener(function(view, ev) {
        var x = ev.getRawX(),
            y = ev.getRawY();

        // 双指缩放和平移处理
        var pointerCount = ev.getPointerCount ? ev.getPointerCount() : 1;

        if (pointerCount >= 2) {
            isTouchingMulti = true; // 标记多指操作中
            var x1 = ev.getX(0),
                y1 = ev.getY(0);
            var x2 = ev.getX(1),
                y2 = ev.getY(1);
            var dist = Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
            var centerX = (x1 + x2) / 2,
                centerY = (y1 + y2) / 2;

            var actionMasked = ev.getActionMasked ? ev.getActionMasked() : ev.getAction();
            if (actionMasked === MotionEvent.ACTION_POINTER_DOWN) {
                twoFinger = true;
                lastDist = dist;
                lastCenterX = centerX;
                lastCenterY = centerY;
                return true;
            } else if (actionMasked === MotionEvent.ACTION_MOVE && twoFinger) {
                if (lastDist > 0) {
                    var scaleDelta = dist / lastDist;
                    var newScale = imgScale * scaleDelta;
                    newScale = Math.max(0.5, Math.min(newScale, 5));

                    // 关键修复：以双指中心点为缩放中心
                    // 公式：newTrans = center + (oldTrans - center) * (newScale / oldScale)
                    var scaleRatio = newScale / imgScale;
                    imgTransX = centerX + (imgTransX - centerX) * scaleRatio;
                    imgTransY = centerY + (imgTransY - centerY) * scaleRatio;
                    imgScale = newScale;
                }

                // 平移（双指中心的移动）
                imgTransX += centerX - lastCenterX;
                imgTransY += centerY - lastCenterY;

                lastDist = dist;
                lastCenterX = centerX;
                lastCenterY = centerY;
                requestRepaint();
                return true;
            } else if (actionMasked === MotionEvent.ACTION_POINTER_UP) {
                twoFinger = false;
                return true;
            }
            return true;
        }

        // 如果刚结束多指操作，在下一个ACTION_DOWN前都忽略单指事件
        if (isTouchingMulti && ev.getAction() !== MotionEvent.ACTION_DOWN) {
            return true;
        }
        if (ev.getAction() === MotionEvent.ACTION_DOWN) {
            isTouchingMulti = false;
        }

        switch (ev.getAction()) {
            case MotionEvent.ACTION_DOWN:
                tapTime = Date.now();
                tapX = x;
                tapY = y;
                mode = hitTest(x, y);
                downX = x;
                downY = y;
                origin = {
                    x1: rect.x1,
                    y1: rect.y1,
                    x2: rect.x2,
                    y2: rect.y2
                };
                animation_menu(win, "hide");
                break;
            case MotionEvent.ACTION_MOVE:
                if (!mode) return true;

                var dx = x - downX,
                    dy = y - downY;

                // 使用平方距离避免Math.sqrt
                if (dx * dx + dy * dy < TOUCH_SLOP_SQUARED) {
                    return true; // 微动过滤
                }

                // 复用tempRect对象，避免重复创建
                tempRect.x1 = rect.x1;
                tempRect.y1 = rect.y1;
                tempRect.x2 = rect.x2;
                tempRect.y2 = rect.y2;

                // 使用字符串查找优化分支判断
                var isLeft = mode.indexOf("l") !== -1;
                var isRight = mode.indexOf("r") !== -1;
                var isTop = mode.indexOf("t") !== -1;
                var isBottom = mode.indexOf("b") !== -1;

                if (mode !== "move") {
                    // 角拖动的统一处理逻辑
                    if (isLeft) {
                        tempRect.x1 = origin.x1 + dx;
                        // 最小尺寸约束
                        if (origin.x2 - tempRect.x1 < MIN_SIZE) {
                            tempRect.x1 = origin.x2 - MIN_SIZE;
                        }
                        // 边界约束
                        tempRect.x1 = Math.max(0, tempRect.x1);
                    }

                    if (isRight) {
                        tempRect.x2 = origin.x2 + dx;
                        // 最小尺寸约束
                        if (tempRect.x2 - origin.x1 < MIN_SIZE) {
                            tempRect.x2 = origin.x1 + MIN_SIZE;
                        }
                        // 边界约束
                        tempRect.x2 = Math.min(w, tempRect.x2);
                    }

                    if (isTop) {
                        tempRect.y1 = origin.y1 + dy;
                        // 最小尺寸约束
                        if (origin.y2 - tempRect.y1 < MIN_SIZE) {
                            tempRect.y1 = origin.y2 - MIN_SIZE;
                        }
                        // 边界约束
                        tempRect.y1 = Math.max(0, tempRect.y1);
                    }

                    if (isBottom) {
                        tempRect.y2 = origin.y2 + dy;
                        // 最小尺寸约束
                        if (tempRect.y2 - origin.y1 < MIN_SIZE) {
                            tempRect.y2 = origin.y1 + MIN_SIZE;
                        }
                        // 边界约束
                        tempRect.y2 = Math.min(h, tempRect.y2);
                    }
                } else {
                    // 移动模式 - 预计算避免重复
                    var ww = origin.x2 - origin.x1;
                    var hh2 = origin.y2 - origin.y1;
                    var newX1 = origin.x1 + dx;
                    var newY1 = origin.y1 + dy;

                    // 单次边界约束计算
                    newX1 = Math.max(0, Math.min(newX1, w - ww));
                    newY1 = Math.max(0, Math.min(newY1, h - hh2));

                    tempRect.x1 = newX1;
                    tempRect.y1 = newY1;
                    tempRect.x2 = newX1 + ww;
                    tempRect.y2 = newY1 + hh2;
                }

                // 检查是否真的有变化，避免无意义重绘
                if (tempRect.x1 !== rect.x1 || tempRect.y1 !== rect.y1 ||
                    tempRect.x2 !== rect.x2 || tempRect.y2 !== rect.y2) {

                    // 应用新坐标（使用位运算优化四舍五入）
                    rect.x1 = (tempRect.x1 + 0.5) | 0;
                    rect.y1 = (tempRect.y1 + 0.5) | 0;
                    rect.x2 = (tempRect.x2 + 0.5) | 0;
                    rect.y2 = (tempRect.y2 + 0.5) | 0;

                    // 降低更新频率到合适的帧率
                    var now = Date.now();
                    if (now - moveTime > 33) { // 30fps限制，移动时降低刷新率
                        scheduleInfoUpdate();
                        requestRepaint();
                        moveTime = now;
                    }
                }
                break;
            case MotionEvent.ACTION_UP:
                var dt = Date.now() - tapTime;
                //if (dt < 300 && Math.abs(x - tapX) < 10 && Math.abs(y - tapY) < 10) {
                animation_menu(win, "show");
                //}
                // 若只在抬手后画虚线：切换画笔效果并重绘一次
                if (USE_DASH && DRAW_DASH_ON_UP) {
                    dashEnabledNow = true;
                    borderPaint.setPathEffect(new android.graphics.DashPathEffect([10 * dpi, 6 * dpi], 0));
                    requestRepaint();
                }
                break;
        }
        return true;
    });

    // 手动输入
    win.input_btn.on("click", function() {
        utils.弹窗输入框(function(data) {
            if (!data || !data.trim()) {
                return; // 用户取消或输入为空
            }

            try {
                var coords = data.split(',').map(function(x) {
                    var num = parseFloat(x.trim());
                    return isNaN(num) ? 0 : Math.round(num);
                });

                if (coords.length !== 4) {
                    toast("请输入4个坐标值，格式：x1,y1,x2,y2");
                    return;
                }

                var newX1 = coords[0],
                    newY1 = coords[1],
                    newX2 = coords[2],
                    newY2 = coords[3];

                // 验证坐标合法性
                if (newX1 >= newX2 || newY1 >= newY2) {
                    toast("坐标无效：x2必须大于x1，y2必须大于y1");
                    return;
                }

                if (newX2 - newX1 < MIN_SIZE || newY2 - newY1 < MIN_SIZE) {
                    toast("选择框太小，最小尺寸：" + Math.round(MIN_SIZE) + "px");
                    return;
                }

                if (newX1 < 0 || newY1 < 0 || newX2 > w || newY2 > h) {
                    toast("坐标超出屏幕范围：0-" + w + " × 0-" + h);
                    return;
                }

                // 应用新坐标
                rect.x1 = newX1;
                rect.y1 = newY1;
                rect.x2 = newX2;
                rect.y2 = newY2;

                // 立即更新显示
                requestRepaint();

            } catch (e) {
                toast("输入格式错误，请使用格式：x1,y1,x2,y2");
                console.error("坐标解析错误：", e);
            }
        }, {
            title: "区域坐标",
            inputPrefill: (rect.x1 | 0) + "," + (rect.y1 | 0) + "," + (rect.x2 | 0) + "," + (rect.y2 | 0)
        });
    });
    
    // 重置缩放和平移参数
    win.reset_scale_params_btn.on("click", function () {
        resetScaleParams()
    })

    // 取消/确定
    win.cancel.on('click', function() {
        win.close();
        events.removeListener("屏幕旋转", 屏幕旋转);
        typeof config.callback == "function" && config.callback(null)
    });
    win.confirm.on('click', function() {
        var result = {}
        if (config.type == "img") {
            var name = "temporary"
            // 将屏幕坐标转换为原始图片坐标（反向变换）
            var origX1 = (rect.x1 - imgTransX) / imgScale;
            var origY1 = (rect.y1 - imgTransY) / imgScale;
            var origX2 = (rect.x2 - imgTransX) / imgScale;
            var origY2 = (rect.y2 - imgTransY) / imgScale;

            // 确保坐标在图片范围内
            origX1 = Math.max(0, Math.min(origX1, img.getWidth()));
            origY1 = Math.max(0, Math.min(origY1, img.getHeight()));
            origX2 = Math.max(0, Math.min(origX2, img.getWidth()));
            origY2 = Math.max(0, Math.min(origY2, img.getHeight()));

            var clip = images.clip(
                img,
                Math.round(origX1),
                Math.round(origY1),
                Math.round(origX2 - origX1),
                Math.round(origY2 - origY1)
            );
            var path = files.join(config.saveDir, name + ".png")
            files.ensureDir(path)
            images.save(clip, path);
            clip.recycle();
            result.name = name
            result.ext = ".png"
        }
        // 回收缩放背景
        if (USE_SCALED_BG && bg && bg !== img) {
            bg.recycle();
        }
        win.cancel.click(); // 关闭悬浮窗
        result.rect = [
            Math.round(rect.x1),
            Math.round(rect.y1),
            Math.round(rect.x2 - rect.x1),
            Math.round(rect.y2 - rect.y1)
        ]
        result.type = config.type
        typeof config.callback == "function" && config.callback(result)
    });

    setupRotationListener(win, config, function(data) {
        // 方向与尺寸变更
        w = data.width;
        h = data.height;
        // 重新准备背景（避免持续缩放）
        if (USE_SCALED_BG) {
            if (bg && bg !== img) bg.recycle();
            img = captureScreen();
            var scaled = images.resize(img, [w, h]);
            bg = scaled;
            bgMatrix = null;
        } else {
            // img = captureScreen();
            // bg = img;
            // bgMatrix = mtx;
        }
        requestRepaint();
    });
}

function createWindow(config) {
    var paddingBottomHight = config.direction ? 按键栏h : 0
    var win = dialogsFloaty(
        <frame id="container" w="*" h="*">
            <canvas id="board" w="*" h="*" />
            <frame id="title" w="*" h="auto" paddingTop={状态栏h+"px"} layout_gravity="top" bg="#88000000">
                <text layout_weight="1" gravity="center" h="40dp" text="请拖动选择框选取范围" textColor="#FFFFFF" textSize="12dp" gravity="center" />
                <text layout_gravity="right" id="reset_scale_params_btn" w="60dp" h="40dp" text="重置" textColor="#008BFF" textSize="16dp" gravity="center" />
            </frame>
            <horizontal id="menu" w="*" h="auto" paddingBottom={paddingBottomHight+"px"} layout_gravity="bottom" bg="#88000000">
                <button id="cancel" layout_weight="1" text="取消" textColor="#FF65A9" textSize="16dp" gravity="center" />
                <vertical id="input_btn" layout_weight="3" gravity="center">
                    <text id="Area" text="选取范围" textColor="#FFFFFF" textSize="12dp" gravity="center" />
                    <text id="coordinate" text="[]" textColor="#FFFFFF" textSize="12dp" gravity="center" />
                </vertical>
                <button id="confirm" layout_weight="1" text="确定" textColor="#008BFF" textSize="16dp" gravity="center" />
            </horizontal>
        </frame>
    );
    win.hide()
    win.setPosition(0, 0);
    win.setSize(config.width, config.height);
    win.setBG("#00000000")
    win.setDimBehind(false)
    win.closed = function() {
        win.cancel.click()
    }
    var drawable = new GradientDrawable();
    drawable.setShape(GradientDrawable.RECTANGLE);
    drawable.setColor(Color.TRANSPARENT); // 背景透明
    //drawable.setStroke(2, Color.parseColor("#008BFF")); // 边框颜色和宽度
    drawable.setCornerRadius(8); // 圆角可选
    win.confirm.setBackground(drawable);
    win.cancel.setBackground(drawable);
    win.show()
    return win;
}

function animation_menu(win, flag) {
    var state = menuStates.get(win);

    if (!state) {
        state = {
            animating: false,
            expanded: true
        };
        menuStates.set(win, state);
    } else {
        if (flag == "show" && state.expanded == true) return
        if (flag == "hide" && state.expanded == false) return

    }
    if (state.animating) return;
    state.animating = true;

    var anims = [];
    if (state.expanded) {
        anims[0] = ObjectAnimator.ofFloat(win.menu, "translationY", 0, win.menu.getHeight());
        anims[1] = ObjectAnimator.ofFloat(win.title, "translationY", 0, -win.title.getHeight());
    } else {
        anims[0] = ObjectAnimator.ofFloat(win.menu, "translationY", win.menu.getHeight(), 0);
        anims[1] = ObjectAnimator.ofFloat(win.title, "translationY", -win.title.getHeight(), 0);
    }

    var set = new AnimatorSet();
    set.playTogether(anims);
    set.setDuration(300);
    set.start();

    setTimeout(function() {
        state.animating = false;
        state.expanded = !state.expanded;
    }, 300);
}

function 屏幕旋转处理(d, win, config, onRotate) {
    var screenSize = utils.getScreenSize();
    var data = {
        direction: d == "v" ? 1 : 0,
        width: screenSize.width,
        height: screenSize.height
    };
    config.direction = data.direction;
    config.width = data.width;
    config.height = data.height;
    ui.post(function() {
        win.setSize(data.width, data.height);
        win.container.attr("w", data.width + "px")
        win.container.attr("h", data.height + "px");
        win.title.attr("h", Math.round((data.direction ? 1 : 0.5) * 状态栏h / dpi) + 20);
        win.menu.attr("h", Math.round((data.direction ? 1 : 0.3) * 按键栏h / dpi) + 30);
    }, 16);
    // 旋转后延迟重新截图/重建背景，避免系统动画期卡顿
    setTimeout(function() {
        if (typeof onRotate === "function") onRotate(data);
    }, 120);
}

function setupRotationListener(win, config, onRotate) {
    屏幕旋转.param = {
        win,
        config,
        onRotate
    }
    events.on("屏幕旋转", 屏幕旋转);
}

function 屏幕旋转(d) {
    var param = 屏幕旋转.param
    ui.run(() => {
        param.win.cancel.click()
    })
    //屏幕旋转处理(d, param.win, param.config, param.onRotate);
}

module.exports = {
    selectImg: selectImg
};