importClass(android.graphics.drawable.GradientDrawable);
importPackage(android.graphics);

var xml =
    <vertical id="root_view">
    
    <frame w="*" h="60" padding="12">
        <button h="50" layout_gravity="right|center" id="test_btn" text="预览"
        style="Widget.AppCompat.Button.Colored" w="auto" backgroundTint="#EAEAEA" textColor="#333333"/>
    </frame>
    
    <frame w="*" h="*">
        <vertical padding="12 0 12 60" h="auto">
            <androidx.core.widget.NestedScrollView id="scrollView" h="auto">
                <vertical id="filter_list">
                    
                </vertical>
            </androidx.core.widget.NestedScrollView>
            <button id="filter_add_btn" layout_gravity="right|center" text="添加滤镜" style="Widget.AppCompat.Button.Colored" w="auto" backgroundTint="#EAEAEA" textColor="#333333"/>
        </vertical>
        <vertical w="*" h="50" layout_gravity="bottom" >
            <text w="*" h="1px" bg="#333333" />
            <horizontal h="*" layout_gravity="center">
                <text layout_weight="1" id="cancel_btn" text="取消"
                w="0" h="*" gravity="center" backgroundTint="#EAEAEA" textColor="#333333"/>
                <text w="1px" h="*" bg="#333333" />
                <text layout_weight="1" id="confirm_btn" text="确认"
                w="0" h="*" gravity="center" backgroundTint="#EAEAEA" textColor="#333333"/>
            </horizontal>
        </vertical>
    </frame>
    
</vertical>

var utils = require(files.join(files.cwd(), "utils.js"))
var 滤镜图片 = require("./滤镜图片.js");
var dialogsFloaty = require("./dialogsFloaty.js");
var 滤镜 = require("./滤镜.js");
var bladeMenu = require("./bladeMenu.js");
var dropUpMenu = require("./dropUpMenu.js");
var filterFun = require("../js/filterFun.js");

var singArr = []
var mappingF = {}
var callback = {}
var redrawFun = {}
var filterList = []

var storageClip = storages.create("clip")
var cacheFile = files.join(files.cwd(), "cache/")

// 单个按钮的高度（用于计算最大高度）
var maxScrollHeight = 0

var 设置Ui = function(title, data) {
    var rw = dialogsFloaty(xml)
    // 悬浮窗关闭处理事件
    rw.closed = function() {
        // 先执行回调
        callbackHandle(title, "cancel", null)

        cleanup(title)
    }
    rw.hide()
    rw.setRadius(25)
    init(rw, title, data)
    return rw
}

// 清理资源函数
function cleanup(title) {
    if (redrawFun[title]) {
        events.removeListener("屏幕旋转", redrawFun[title])
        delete redrawFun[title]
    }

    let index = singArr.indexOf(title)
    if (index !== -1) {
        singArr.splice(index, 1)
    }

    delete mappingF[title]
    delete callback[title]
}

// 修复后的 ui居中 函数
function ui居中(title) {
    var rw = mappingF[title]
    if (!rw) return

    var screen = utils.getScreenSize()
    var width = screen.width
    var height = screen.height

    ui.run(() => {
        // 按屏幕比例算宽高
        var newW = Math.floor(width * 0.8)
        var newH = Math.floor(height * 0.8)

        // 最小限制
        var minW = 400
        var minH = 400
        if (newW < minW) newW = minW
        if (newH < minH) newH = minH

        // 最大限制
        var maxW = 1000
        var maxH = 1000
        if (newW > maxW) newW = maxW

        // ✅ 强制重新测量，获取准确高度
        rw.root_view.measure(0, 0)
        var measuredHeight = rw.root_view.getMeasuredHeight()

        var fH = measuredHeight

        // ✅ 限制最大高度
        if (fH > newH) {
            fH = newH
        }
        if (fH > maxH) {
            fH = maxH
        }

        rw.setSize(newW, fH)
        rw.center()
        rw.show()
    }) // 延迟确保布局完成
}

function init(rw, title, data) {
    //查看效果
    rw.test_btn.on("click", () => {
        if (filterList.length == 0) {
            toast("没有滤镜")
            return
        }
        var screenSize = utils.getScreenSize();
        var filterImg = null
        var img_select_config = {
            direction: utils.屏幕方向() == "v" ? 1 : 0,
            width: screenSize.width,
            height: screenSize.height,
            type: "filter_img",
            callback: function(data) {
                try {
                    rw.show()
                } catch (e) {} finally {
                    ui.post(() => {
                        if (filterImg) {
                            filterImg.recycle()
                        }
                    })
                }
            }
        }
        rw.hide()
        setTimeout(() => {
            try {
                if (!filterFun.滤镜流水线) {
                    throw "函数不存在"
                }
                var img = captureScreen()
                filterImg = filterFun.滤镜流水线(img, filterList, "img")
                滤镜图片(img_select_config, filterImg)
            } catch (e) {
                rw.show()
            }
        }, 250)
    })

    // 取消
    rw.cancel_btn.on("click", () => {
        callbackHandle(title, "cancel", null)
        try {
            rw.close()
        } catch (e) {
            console.error("关闭悬浮窗失败:", e)
            cleanup(title)
        }
    })

    // 确认
    rw.confirm_btn.on("click", () => {
        callbackHandle(title, "confirm", filterList)
        try {
            rw.close()
        } catch (e) {
            console.error("关闭悬浮窗失败:", e)
            cleanup(title)
        }
    })

    //添加滤镜
    rw.filter_add_btn.on("click", function() {
        rw.hide()
        滤镜.create("滤镜", {
            callback(type, data) {
                ui.post(() => {
                    if (mappingF[title]) {
                        rw.show()
                    }
                },16)
                if (type == "confirm"){
                    filterList.push(data)
                }
                renderFilterList(rw, title, true)
            }
        })
    })

    // 长按滤镜添加
    rw.filter_add_btn.on("long_click", (event, view) => {
        event.consumed = true
        var arr = [{
            name: "粘贴",
            event: function() {
                var clipJson = storageClip.get("clip")
                try {
                    var clip = JSON.parse(clipJson)
                    if (clip.type != "filter") throw "no filter"
                    filterList.push(clip.content)
                    renderFilterList(rw, title, true)
                } catch (e) {
                    toast("不符合")
                }
            }
        }]
        bladeMenu.create(view, arr)
    })
}

var drawable = new GradientDrawable();
drawable.setShape(GradientDrawable.RECTANGLE);
drawable.setColor(android.graphics.Color.parseColor("#ff008c8c"));
drawable.setCornerRadius(5);

function renderFilterList(rw, title, after) {
    rw.filter_list.removeAllViews();

    filterList.forEach((e, i) => {
        let xml = `<button h="auto" gravity="center" w="168" text="${e.name}" color="#ffffff" id="filter${i}" style="" padding="0 5" margin="0 2" />`;
        let view = ui.inflate(xml, rw.filter_list);

        view.setBackground(drawable);
        view.on("click", () => {
            let currentIndex = filterList.findIndex(item => item === e);
            if (currentIndex === -1) return;

            rw.hide();
            滤镜.create("滤镜", {
                name: filterList[currentIndex].name,
                config: filterList[currentIndex].config,
                callback(type, data) {
                    ui.post(() => {
                        try {
                            rw.show();
                        } catch (e) {}
                    });
                    if (type == "cancel") return;
                    filterList[currentIndex] = data;
                    renderFilterList(rw, title, false);
                }
            });
        });

        view.on("long_click", (event, view) => {
            event.consumed = true;
            let currentIndex = filterList.findIndex(item => item === e);
            if (currentIndex === -1) return;

            var arr = [{
                name: "复制",
                event: function() {
                    storageClip.put("clip", JSON.stringify({
                        type: "filter",
                        content: filterList[currentIndex]
                    }));
                    toast("已复制")
                }
            }, {
                name: "粘贴",
                event: function() {
                    var clipJson = storageClip.get("clip");
                    try {
                        var clip = JSON.parse(clipJson);
                        if (clip.type != "filter") throw "no filter";
                        filterList[currentIndex] = clip.content;
                        renderFilterList(rw, title, false);
                    } catch (e) {
                        toast("不符合");
                    }
                }
            }, {
                name: "删除",
                event: function() {
                    filterList.splice(currentIndex, 1);
                    renderFilterList(rw, title, false);
                }
            }];
            bladeMenu.create(view, arr);
        });

        rw.filter_list.addView(view);
    });

    // ✅ 修复：延迟布局调整，限制最大显示5个按钮的高度
    ui.post(() => {
        var count = rw.filter_list.getChildCount();

        // 强制测量整个列表
        rw.filter_list.measure(0, 0)
        var listHeight = rw.filter_list.getMeasuredHeight()

        // ✅ 计算5个按钮的最大高度
        if (count == 5) {
            maxScrollHeight = listHeight
        }
        if (count > 5) {
            // 超过5个，限制高度为5个按钮的高度
            rw.scrollView.attr("h", maxScrollHeight + "px");
        } else if (count > 0) {
            // 不超过5个，自适应高度
            rw.scrollView.attr("h", "auto");
        } else {
            // 没有子项
            rw.scrollView.attr("h", "auto");
        }

        // 再次强制测量整个视图
        ui.post(() => {
            rw.root_view.measure(0, 0);
            let measuredHeight = rw.root_view.getMeasuredHeight();
            rw.setSize(rw.getWidth(), measuredHeight);

            if (after) {
                rw.scrollView.fullScroll(android.view.View.FOCUS_DOWN);
            }
        },16)
    },16); // 增加延迟时间确保测量准确
}

function create(title, data) {
    var singI = singArr.indexOf(title)
    if (singI != -1 || !data) return

    var rw = 设置Ui(title, data)
    singArr.push(title)
    mappingF[title] = rw
    callback[title] = data.callback

    // 如果有初始数据，先设置
    if (data.filterList) {
        filterList = data.filterList.slice() // 复制数组避免引用问题
    } else {
        filterList = []
    }

    // ✅ 修复：先渲染列表，再居中显示
    ui.post(() => {
        renderFilterList(rw, title, false)
        // 渲染完成后再居中
        ui.post(() => {
            ui居中(title)
        }) // 确保渲染完成
    })

    // 屏幕旋转处理
    redrawFun[title] = function() {
        if (mappingF[title]) {
            try {
                mappingF[title].close()
            } catch (e) {
                console.error("屏幕旋转关闭失败:", e)
                cleanup(title)
            }
        }
    }

    events.on("屏幕旋转", redrawFun[title])
    return rw
}

function callbackHandle(title, eventType, data) {
    if (typeof callback[title] != "function") {
        return
    }
    callback[title](eventType, data)
}

function close(title) {
    if (mappingF[title]) {
        try {
            mappingF[title].close()
        } catch (e) {
            console.error("关闭失败:", e)
            cleanup(title)
        }
    }
}

/*
//utils.requestScreenCapture()
var r = create("图片详情", {
    filterList: [
        {name: "滤镜1", config: {}},
        {name: "滤镜2", config: {}},
        {name: "滤镜3", config: {}},
        {name: "滤镜4", config: {}},
        {name: "滤镜5", config: {}},
        {name: "滤镜6", config: {}},
        {name: "滤镜7", config: {}}
    ],
    callback(type, data){
        if(type == "cancel") return
        log(data)
    }
})
*/

module.exports = {
    create,
    close,
    center: ui居中
}
