// 完整脚本：去掉选中区域蒙层版

importClass(android.graphics.drawable.GradientDrawable);
importPackage(android.graphics);
importClass(android.animation.ObjectAnimator);
importClass(android.animation.AnimatorSet);
importClass(android.view.MotionEvent);

var utils = require(files.join(files.cwd(), "utils.js"));
var dialogsFloaty = require("./dialogsFloaty.js")
var 状态栏h = utils.状态栏高度();
var 按键栏h = utils.getNavigationBarHeight();
var dpi = utils.getdeviceDpi().density;
utils.屏幕旋转(); // 初始化方向监听

var menuStates = new WeakMap();

function selectImg(config, img) {
    // });

    img = img || captureScreen();
    var w = config.width,
        h = config.height;

    // 绘制工具
    var L = Math.round(20 * dpi);
    var mtx = new Matrix();

    var bmpPaint = new Paint();
    bmpPaint.setFilterBitmap(true);

    // 创建悬浮窗
    var win = createWindow(config);
    var cv = win.board;
    cv.setMaxFps(60);

    // 背景处理
    var bg = img,
        bgMatrix = mtx;


    var repaintFrame = null;

    function requestRepaint() {
        if (repaintFrame) return;
        repaintFrame = ui.post(function() {
            repaintFrame = null;
            cv.invalidate();
        }, 16);
    }
    requestRepaint()
    cv.on("draw", function(canvas) {
        canvas.drawColor(0, PorterDuff.Mode.CLEAR);

        // 背景
        if (bgMatrix) {
            canvas.drawImage(bg, bgMatrix, bmpPaint);
        } else {
            canvas.drawImage(bg, null, bmpPaint);
        }
    });

    cv.setOnTouchListener(function(view, ev) {
        if (ev.getAction() === MotionEvent.ACTION_UP) {
            animation_menu(win);
        }
        return true;
    });

    win.cancel.on("click", function() {
        win.close();
        events.removeListener("屏幕旋转", 屏幕旋转);
        typeof config.callback === "function" && config.callback(null);
    });

    win.confirm.on("click", function() {
        win.cancel.click();
        typeof config.callback === "function" && config.callback();
    });

    setupRotationListener(win, config, function(data) {
        w = data.width;
        h = data.height;

        if (bg && bg !== img) bg.recycle();
        img = captureScreen();
        bg = images.resize(img, [w, h]);
        bgMatrix = null;
        requestRepaint();
    });
}

function createWindow(config) {
    var titleH = Math.round((config.direction ? 1 : 0.5) * 状态栏h / dpi) + 20;
    var menuH = Math.round((config.direction ? 1 : 0.3) * 按键栏h / dpi) + 30;
    var paddingBottomHight = config.direction ? 按键栏h : 0
    var win = dialogsFloaty(
        <frame id="container" w="*" h="*">
            <canvas id="board" w="*" h="*" />
            <horizontal paddingBottom={paddingBottomHight+"px"} id="menu" w="*" h="auto" layout_gravity="bottom" bg="#88000000">
                <button id="cancel" layout_weight="1" text="取消" textColor="#FF65A9" textSize="16dp"/>
                <text layout_weight="3" text="" textColor="#008BFF" textSize="16dp"/>
                <button id="confirm" layout_weight="1" text="确定" textColor="#008BFF" textSize="16dp"/>
            </horizontal>
        </frame>
    );
    win.hide()
    win.setPosition(0, 0);
    win.setSize(config.width, config.height);
    win.setBG("#00000000")
    win.setDimBehind(false)
    win.closed = function() {
        win.cancel.click()
    }
    var drawable = new GradientDrawable();
    drawable.setShape(GradientDrawable.RECTANGLE);
    drawable.setColor(Color.TRANSPARENT);
    drawable.setCornerRadius(8);
    win.confirm.setBackground(drawable);
    win.cancel.setBackground(drawable);
    win.show()
    return win;
}

function animation_menu(win) {
    var state = menuStates.get(win) || {
        animating: false,
        expanded: true
    };
    if (state.animating) return;
    state.animating = true;
    menuStates.set(win, state);
    var anims = [];
    if (state.expanded) {
        anims[0] = ObjectAnimator.ofFloat(win.menu, "translationY", 0, win.menu.getHeight());
    } else {
        anims[0] = ObjectAnimator.ofFloat(win.menu, "translationY", win.menu.getHeight(), 0);
    }
    var set = new AnimatorSet();
    set.playTogether(anims);
    set.setDuration(300);
    set.start();
    setTimeout(function() {
        state.animating = false;
        state.expanded = !state.expanded;
    }, 300);
}

function 屏幕旋转处理(d, win, config, onRotate) {
    var screenSize = utils.getScreenSize();
    var data = {
        direction: d === "v" ? 1 : 0,
        width: screenSize.width,
        height: screenSize.height
    };
    config.direction = data.direction;
    config.width = data.width;
    config.height = data.height;
    ui.post(function() {
        win.setSize(data.width, data.height);
        win.container.attr("w", data.width + "px");
        win.container.attr("h", data.height + "px");
        win.title.attr("h", Math.round((data.direction ? 1 : 0.5) * 状态栏h / dpi) + 20);
        win.menu.attr("h", Math.round((data.direction ? 1 : 0.3) * 按键栏h / dpi) + 30);
    }, 16);
    setTimeout(function() {
        onRotate && onRotate(data);
    }, 120);
}

function setupRotationListener(win, config, onRotate) {
    屏幕旋转.param = {
        win,
        config,
        onRotate
    };
    events.on("屏幕旋转", 屏幕旋转);
}

function 屏幕旋转(d) {
    var p = 屏幕旋转.param;
    // 旋转时关闭并重建
    p.win.cancel.click();
    // 如果要保持重绘可注释上行并启用以下行
    // 屏幕旋转处理(d, p.win, p.config, p.onRotate);
}
/*
// 使用示例
var config = {
    width: 1080,
    height: 2374,
    type: "img",
};
var coordinatesArray = [{
        coords: [100, 200, 300, 400],
        similarity: 90
    },
    {
        coords: [500, 600, 700, 800],
        similarity: 80
    },
    {
        coords: [200, 900, 400, 1100],

    }
];
utils.requestScreenCapture()
sleep(1000)
selectImg(config, null, coordinatesArray);
*/

module.exports = selectImg