importClass(android.graphics.drawable.GradientDrawable);
importPackage(android.graphics);

var xml =
    <frame id="root_view">
    <vertical>
        <frame w="*" h="60" padding="12">
            <button h="50" layout_gravity="left|center" id="filter_type_btn" text="黑白滤镜"
            style="Widget.AppCompat.Button.Colored" w="auto" backgroundTint="#EAEAEA" textColor="#333333"/>
            
            <button h="50" layout_gravity="right|center" id="test_btn" text="预览"
            style="Widget.AppCompat.Button.Colored" w="auto" backgroundTint="#EAEAEA" textColor="#333333"/>
        </frame>
        
        <frame w="*" h="auto">
            <vertical padding="12 0 12 50" h="auto">
                <androidx.core.widget.NestedScrollView id="scrollView">
                    <vertical id="filter_edit">
                        
                    </vertical>
                </androidx.core.widget.NestedScrollView>
            </vertical>
            <vertical w="*" h="50" layout_gravity="bottom" >
                <text w="*" h="1px" bg="#333333" />
                <horizontal h="*" gravity="center">
                    <text layout_weight="1" id="cancel_btn" text="取消"
                    w="0" h="*" gravity="center" backgroundTint="#EAEAEA" textColor="#333333"/>
                    <text w="1px" h="*" bg="#333333" />
                    <text layout_weight="1" id="confirm_btn" text="确认"
                    w="0" h="*" gravity="center" backgroundTint="#EAEAEA" textColor="#333333"/>
                </horizontal>
            </vertical>
        </frame>
        
    </vertical>
</frame>

var utils = require(files.join(files.cwd(), "utils.js"))
var dialogsFloaty = require("./dialogsFloaty.js");
var 滤镜图片 = require("./滤镜图片.js");
var 颜色替换 = require("./颜色替换.js")
var 取色盘 = require("./取色盘.js")
var bladeMenu = require("./bladeMenu.js");
var dropUpMenu = require("./dropUpMenu.js");
var filterFun = require("../js/filterFun.js");
var singArr = []
var mappingF = {}
var callback = {}
var redrawFun = {}

var filterEdit = null

var storageClip = storages.create("clip")
var cacheFile = files.join(files.cwd(), "cache/")

var 设置Ui = function(title, data) {
    var rw = dialogsFloaty(xml)
    // 悬浮窗关闭处理事件
    rw.closed = function() {
        // 先执行回调
        callbackHandle(title, "cancel", null)

        cleanup(title)
    }
    rw.hide()
    rw.setRadius(25)
    //rw.setOverflowHide(true)
    init(rw, title, data)
    return rw
}

function ui居中(title) {
    var rw = mappingF[title]
    var screen = utils.getScreenSize()
    var width = screen.width
    var height = screen.height
    ui.post(() => {
        // 按屏幕比例算宽高
        var newW = Math.floor(width * 0.8)
        var newH = Math.floor(height * 0.8)

        // 最小限制
        var minW = 400
        var minH = 400
        if (newW < minW) newW = minW
        if (newH < minH) newH = minH

        // 最大限制
        var maxW = 1000
        var maxH = 1000
        if (newW > maxW) newW = maxW
        //if (newH > maxH) newH = maxH
        var fH = rw.getSize().height
        if (fH > newH) {
            //fH = newH
        }
        rw.setSize(newW, fH)

        // 居中
        // var x = Math.floor((width - newW) / 2)
        // var y = Math.floor((height - fH) / 2)
        // rw.setPosition(x, y)
        rw.center()
        rw.show()
    })
}

// 清理资源的统一函数
function cleanup(title) {
    // 移除屏幕旋转监听
    if (redrawFun[title]) {
        events.removeListener("屏幕旋转", redrawFun[title])
        delete redrawFun[title]
    }

    // 从数组中移除
    let index = singArr.indexOf(title)
    if (index !== -1) {
        singArr.splice(index, 1)
    }

    // 清理映射
    delete mappingF[title]
    delete callback[title]
}

function init(rw, title, data) {
    //滤镜类型
    rw.filter_type_btn.on("click", (view) => {
        var items = filterFun.获取滤镜列表().map((name) => {
            return {
                name: name,
                event: filterTypeChange
            }
        })
        dropUpMenu.create(view, items)
    })

    //预览
    rw.test_btn.on("click", () => {
        var screenSize = utils.getScreenSize();
        var filterImg = null
        var img_select_config = {
            direction: utils.屏幕方向() == "v" ? 1 : 0,
            width: screenSize.width,
            height: screenSize.height,
            type: "filter_img",
            callback: function(data) {
                try {
                    // 悬浮窗显示
                    rw.show()
                } catch (e) {} finally {
                    ui.post(() => {
                        if (filterImg) {
                            filterImg.recycle()
                        }
                    })
                }
            }
        }
        // 悬浮窗隐藏
        rw.hide()
        setTimeout(() => {
            try {
                if (!filterFun.应用预设) {
                    throw "函数不存在"
                }
                var img = captureScreen()
                filterImg = filterFun.滤镜流水线(img, filterEdit)
                滤镜图片(img_select_config, filterImg)
            } catch (e) {
                //悬浮窗显示
                rw.show()
            }
        }, 250)
    })

    // 取消
    rw.cancel_btn.on("click", () => {
        // 先执行回调
        callbackHandle(title, "cancel", null)

        // 再关闭悬浮窗（这会触发 closed 事件，从而调用 cleanup）
        try {
            rw.close()
        } catch (e) {
            console.error("关闭悬浮窗失败:", e)
            // 如果关闭失败，手动清理
            cleanup(title)
        }
    })

    // 确认
    rw.confirm_btn.on("click", () => {
        // 先执行回调
        callbackHandle(title, "confirm", filterEdit)

        // 再关闭悬浮窗
        try {
            rw.close()
        } catch (e) {
            console.error("关闭悬浮窗失败:", e)
            cleanup(title)
        }
    })

    // 滤镜切换
    function filterTypeChange(type) {
        rw.filter_type_btn.attr("text", type)
        if (!xmls[type]) {
            toast("xml还没有实现")
            rw.filter_edit.removeAllViews()
            filterEdit.name = type
            filterEdit.config = filterFun.获取滤镜配置(type)
            return
        }
        xmls[type](rw, true)
    }
}

var xmls = {
    // 自适应二值化
    自适应二值化(rw, resetFilter) {
        if (resetFilter || filterEdit.config.blockSize === undefined) {
            filterEdit = {
                name: "自适应二值化",
                config: {
                    blockSize: 11,
                    C: 2
                }
            }
        }

        var blockSizeProgress = Math.floor((Math.max(3, filterEdit.config.blockSize) - 3) / 2);
        var cProgress = Math.max(0, Math.min(50, filterEdit.config.C || 0));



        var xml =
            <vertical>
                <horizontal gravity="left|center" h="60">
                    <text text="块大小" textColor="#333333"/>
                    <seekbar max="51" progress={blockSizeProgress} id="blockSize_seekbar" layout_weight="1" />
                    <text gravity="center" id="blockSize_input" w="50" text={filterEdit.config.blockSize} textColor="#333333"/>
                </horizontal>
                <horizontal gravity="left|center" h="60">
                    <text text="偏移值C" textColor="#333333"/>
                    <seekbar max="50" progress={cProgress} id="c_seekbar" layout_weight="1" />
                    <text gravity="center" id="c_input" w="50" text={filterEdit.config.C} textColor="#333333"/>
                </horizontal>
            </vertical>

        rw.filter_edit.removeAllViews();
        ui.inflate(xml, rw.filter_edit, true)

        ui.post(() => {
            rw.setSize(rw.getWidth(), -2);

            rw.blockSize_seekbar.setOnSeekBarChangeListener({
                onProgressChanged: (seekbar, progress, fromUser) => {
                    var value = progress * 2 + 3;
                    rw.blockSize_input.attr("text", value)
                    filterEdit.config.blockSize = value
                },
            });

            rw.c_seekbar.setOnSeekBarChangeListener({
                onProgressChanged: (seekbar, progress, fromUser) => {
                    rw.c_input.attr("text", progress)
                    filterEdit.config.C = progress
                },
            });

            rw.blockSize_input.on("click", () => {
                utils.弹窗输入框(function(value) {
                    if (/[^\d]/g.test(value)) {
                        toast("请输入纯数字")
                        return
                    }
                    value = parseInt(value);
                    if (value < 3) value = 3;
                    if (value > 105) value = 105;
                    if (value % 2 === 0) value++;
                    rw.blockSize_input.attr("text", value)
                    rw.blockSize_seekbar.attr("progress", Math.floor((value - 3) / 2))
                    filterEdit.config.blockSize = value
                }, {
                    title: "输入块大小",
                    inputHint: "3-105(奇数)"
                })
            })

            rw.c_input.on("click", () => {
                utils.弹窗输入框(function(value) {
                    if (/[^\d]/g.test(value)) {
                        toast("请输入纯数字")
                        return
                    }
                    value = parseInt(value);
                    if (value > 50) value = 50;
                    if (value < 0) value = 0;
                    rw.c_input.attr("text", value)
                    rw.c_seekbar.attr("progress", value)
                    filterEdit.config.C = value
                }, {
                    title: "输入偏移值",
                    inputHint: "0-50"
                })
            })
        });
    },

    // 灰度滤镜
    灰度滤镜(rw, resetFilter) {
        if (resetFilter) {
            filterEdit = {
                name: "灰度滤镜",
                config: {}
            }
        }

        var xml =
            <vertical gravity="center_horizontal" h="auto" w="*" padding="15">
                <text text="灰度滤镜无需调整参数" textColor="#666666" textSize="14sp" gravity="center"/>
            </vertical>

        rw.filter_edit.removeAllViews();
        ui.inflate(xml, rw.filter_edit, true)

        ui.post(() => {
            rw.setSize(rw.getWidth(), -2);
        });
    },

    // 黑白滤镜
    黑白滤镜(rw, resetFilter) {
        if (resetFilter) {
            filterEdit = {
                name: "黑白滤镜",
                config: {
                    threshold: 127
                }
            }
        }

        var thresholdProgress = Math.max(0, Math.min(255, filterEdit.config.threshold || 127));

        var xml =
            <horizontal gravity="left|center" h="60">
                <text text="阈值" textColor="#333333"/>
                <seekbar max="255" progress={thresholdProgress} id="threshold_seekbar" layout_weight="1" />
                <text gravity="center" id="threshold_input" w="35" text={thresholdProgress} textColor="#333333"/>
            </horizontal>

        rw.filter_edit.removeAllViews();
        ui.inflate(xml, rw.filter_edit, true)

        ui.post(() => {
            rw.setSize(rw.getWidth(), -2);

            rw.threshold_seekbar.setOnSeekBarChangeListener({
                onProgressChanged: (seekbar, progress, fromUser) => {
                    rw.threshold_input.attr("text", progress)
                    filterEdit.config.threshold = progress
                },
            });

            rw.threshold_input.on("click", () => {
                utils.弹窗输入框(function(value) {
                    if (/[^\d]/g.test(value)) {
                        toast("请输入纯数字")
                        return
                    }
                    value = parseInt(value);
                    if (value > 255) value = 255;
                    if (value < 0) value = 0;
                    rw.threshold_input.attr("text", value)
                    rw.threshold_seekbar.attr("progress", value)
                    filterEdit.config.threshold = value
                }, {
                    title: "输入阈值",
                    inputHint: "0-255"
                })
            })
        });
    },

    // 轮廓滤镜
    轮廓滤镜(rw, resetFilter) {
        if (resetFilter) {
            filterEdit = {
                name: "轮廓滤镜",
                config: {
                    threshold1: 50,
                    threshold2: 150
                }
            }
        }

        var t1Progress = Math.max(0, Math.min(255, filterEdit.config.threshold1 || 50));
        var t2Progress = Math.max(0, Math.min(255, filterEdit.config.threshold2 || 150));

        var xml =
            <vertical>
                <horizontal gravity="left|center" h="60">
                    <text text="弱阈值" textColor="#333333"/>
                    <seekbar max="255" progress={t1Progress} id="threshold_seekbar1" layout_weight="1" />
                    <text gravity="center" id="threshold_input1" w="35" text={t1Progress} textColor="#333333"/>
                </horizontal>
                <horizontal gravity="left|center" h="60">
                    <text text="强阈值" textColor="#333333"/>
                    <seekbar max="255" progress={t2Progress} id="threshold_seekbar2" layout_weight="1" />
                    <text gravity="center" id="threshold_input2" w="35" text={t2Progress} textColor="#333333"/>
                </horizontal>
            </vertical>

        rw.filter_edit.removeAllViews();
        ui.inflate(xml, rw.filter_edit, true)

        ui.post(() => {
            rw.setSize(rw.getWidth(), -2);

            rw.threshold_seekbar1.setOnSeekBarChangeListener({
                onProgressChanged: (seekbar, progress, fromUser) => {
                    rw.threshold_input1.attr("text", progress)
                    filterEdit.config.threshold1 = progress
                },
            });

            rw.threshold_seekbar2.setOnSeekBarChangeListener({
                onProgressChanged: (seekbar, progress, fromUser) => {
                    rw.threshold_input2.attr("text", progress)
                    filterEdit.config.threshold2 = progress
                },
            });

            rw.threshold_input1.on("click", () => {
                utils.弹窗输入框(function(value) {
                    if (/[^\d]/g.test(value)) {
                        toast("请输入纯数字")
                        return
                    }
                    value = parseInt(value);
                    if (value > 255) value = 255;
                    if (value < 0) value = 0;
                    rw.threshold_input1.attr("text", value)
                    rw.threshold_seekbar1.attr("progress", value)
                    filterEdit.config.threshold1 = value
                }, {
                    title: "输入弱阈值",
                    inputHint: "0-255"
                })
            })

            rw.threshold_input2.on("click", () => {
                utils.弹窗输入框(function(value) {
                    if (/[^\d]/g.test(value)) {
                        toast("请输入纯数字")
                        return
                    }
                    value = parseInt(value);
                    if (value > 255) value = 255;
                    if (value < 0) value = 0;
                    rw.threshold_input2.attr("text", value)
                    rw.threshold_seekbar2.attr("progress", value)
                    filterEdit.config.threshold2 = value
                }, {
                    title: "输入强阈值",
                    inputHint: "0-255"
                })
            })
        });
    },

    // 高斯模糊
    高斯模糊(rw, resetFilter) {
        if (resetFilter) {
            filterEdit = {
                name: "高斯模糊",
                config: {
                    kernelSize: 15,
                    sigmaX: 0,
                    sigmaY: 0
                }
            }
        }

        var kernelProgress = Math.floor((Math.max(1, filterEdit.config.kernelSize) - 1) / 2);
        var sigmaXProgress = Math.max(0, Math.min(100, filterEdit.config.sigmaX || 0));
        var sigmaYProgress = Math.max(0, Math.min(100, filterEdit.config.sigmaY || 0));

        var xml =
            <vertical>
                <horizontal gravity="left|center" h="60">
                    <text text="模糊半径" textColor="#333333"/>
                    <seekbar max="51" progress={kernelProgress} id="kernel_seekbar1" layout_weight="1" />
                    <text gravity="center" id="kernel_input1" w="50" text={filterEdit.config.kernelSize} textColor="#333333"/>
                </horizontal>
                <horizontal gravity="left|center" h="60">
                    <text text="标准差X" textColor="#333333"/>
                    <seekbar max="100" progress={sigmaXProgress} id="sigmaX_seekbar1" layout_weight="1" />
                    <text gravity="center" id="sigmaX_input1" w="50" text={sigmaXProgress} textColor="#333333"/>
                </horizontal>
                <horizontal gravity="left|center" h="60">
                    <text text="标准差Y" textColor="#333333"/>
                    <seekbar max="100" progress={sigmaYProgress} id="sigmaY_seekbar1" layout_weight="1" />
                    <text gravity="center" id="sigmaY_input1" w="50" text={sigmaYProgress} textColor="#333333"/>
                </horizontal>
            </vertical>

        rw.filter_edit.removeAllViews();
        ui.inflate(xml, rw.filter_edit, true)

        ui.post(() => {
            rw.setSize(rw.getWidth(), -2);

            rw.kernel_seekbar1.setOnSeekBarChangeListener({
                onProgressChanged: (seekbar, progress, fromUser) => {
                    var value = progress * 2 + 1;
                    rw.kernel_input1.attr("text", value)
                    filterEdit.config.kernelSize = value
                },
            });

            rw.sigmaX_seekbar1.setOnSeekBarChangeListener({
                onProgressChanged: (seekbar, progress, fromUser) => {
                    rw.sigmaX_input1.attr("text", progress)
                    filterEdit.config.sigmaX = progress
                },
            });

            rw.sigmaY_seekbar1.setOnSeekBarChangeListener({
                onProgressChanged: (seekbar, progress, fromUser) => {
                    rw.sigmaY_input1.attr("text", progress)
                    filterEdit.config.sigmaY = progress
                },
            });

            rw.kernel_input1.on("click", () => {
                utils.弹窗输入框(function(value) {
                    if (/[^\d]/g.test(value)) {
                        toast("请输入纯数字")
                        return
                    }
                    value = parseInt(value);
                    if (value < 1) value = 1;
                    if (value > 101) value = 101;
                    if (value % 2 === 0) value++;
                    rw.kernel_input1.attr("text", value)
                    rw.kernel_seekbar1.attr("progress", Math.floor((value - 1) / 2))
                    filterEdit.config.kernelSize = value
                }, {
                    title: "输入模糊半径",
                    inputHint: "1-101(奇数)"
                })
            })

            rw.sigmaX_input1.on("click", () => {
                utils.弹窗输入框(function(value) {
                    if (/[^\d]/g.test(value)) {
                        toast("请输入数字")
                        return
                    }
                    value = parseInt(value);
                    if (value > 100) value = 100;
                    if (value < 0) value = 0;
                    rw.sigmaX_input1.attr("text", value)
                    rw.sigmaX_seekbar1.attr("progress", value)
                    filterEdit.config.sigmaX = value
                }, {
                    title: "输入标准差X",
                    inputHint: "0-100"
                })
            })

            rw.sigmaY_input1.on("click", () => {
                utils.弹窗输入框(function(value) {
                    if (/[^\d]/g.test(value)) {
                        toast("请输入数字")
                        return
                    }
                    value = parseInt(value);
                    if (value > 100) value = 100;
                    if (value < 0) value = 0;
                    rw.sigmaY_input1.attr("text", value)
                    rw.sigmaY_seekbar1.attr("progress", value)
                    filterEdit.config.sigmaY = value
                }, {
                    title: "输入标准差Y",
                    inputHint: "0-100"
                })
            })
        });
    },

    // 均值模糊
    均值模糊(rw, resetFilter) {
        if (resetFilter) {
            filterEdit = {
                name: "均值模糊",
                config: {
                    kernelSize: 15
                }
            }
        }

        var kernelProgress = Math.floor((Math.max(1, filterEdit.config.kernelSize) - 1) / 2);

        var xml =
            <horizontal gravity="left|center" h="60">
                <text text="模糊半径" textColor="#333333"/>
                <seekbar max="51" progress={kernelProgress} id="kernel_seekbar2" layout_weight="1" />
                <text gravity="center" id="kernel_input2" w="50" text={filterEdit.config.kernelSize} textColor="#333333"/>
            </horizontal>

        rw.filter_edit.removeAllViews();
        ui.inflate(xml, rw.filter_edit, true)

        ui.post(() => {
            rw.setSize(rw.getWidth(), -2);

            rw.kernel_seekbar2.setOnSeekBarChangeListener({
                onProgressChanged: (seekbar, progress, fromUser) => {
                    var value = progress * 2 + 1;
                    rw.kernel_input2.attr("text", value)
                    filterEdit.config.kernelSize = value
                },
            });

            rw.kernel_input2.on("click", () => {
                utils.弹窗输入框(function(value) {
                    if (/[^\d]/g.test(value)) {
                        toast("请输入纯数字")
                        return
                    }
                    value = parseInt(value);
                    if (value < 1) value = 1;
                    if (value > 101) value = 101;
                    if (value % 2 === 0) value++;
                    rw.kernel_input2.attr("text", value)
                    rw.kernel_seekbar2.attr("progress", Math.floor((value - 1) / 2))
                    filterEdit.config.kernelSize = value
                }, {
                    title: "输入模糊半径",
                    inputHint: "1-101(奇数)"
                })
            })
        });
    },

    // 中值模糊
    中值模糊(rw, resetFilter) {
        if (resetFilter) {
            filterEdit = {
                name: "中值模糊",
                config: {
                    kernelSize: 15
                }
            }
        }

        var kernelProgress = Math.floor((Math.max(1, filterEdit.config.kernelSize) - 1) / 2);

        var xml =
            <horizontal gravity="left|center" h="60">
                <text text="模糊半径" textColor="#333333"/>
                <seekbar max="51" progress={kernelProgress} id="kernel_seekbar3" layout_weight="1" />
                <text gravity="center" id="kernel_input3" w="50" text={filterEdit.config.kernelSize} textColor="#333333"/>
            </horizontal>

        rw.filter_edit.removeAllViews();
        ui.inflate(xml, rw.filter_edit, true)

        ui.post(() => {
            rw.setSize(rw.getWidth(), -2);

            rw.kernel_seekbar3.setOnSeekBarChangeListener({
                onProgressChanged: (seekbar, progress, fromUser) => {
                    var value = progress * 2 + 1;
                    rw.kernel_input3.attr("text", value)
                    filterEdit.config.kernelSize = value
                },
            });

            rw.kernel_input3.on("click", () => {
                utils.弹窗输入框(function(value) {
                    if (/[^\d]/g.test(value)) {
                        toast("请输入纯数字")
                        return
                    }
                    value = parseInt(value);
                    if (value < 1) value = 1;
                    if (value > 101) value = 101;
                    if (value % 2 === 0) value++;
                    rw.kernel_input3.attr("text", value)
                    rw.kernel_seekbar3.attr("progress", Math.floor((value - 1) / 2))
                    filterEdit.config.kernelSize = value
                }, {
                    title: "输入模糊半径",
                    inputHint: "1-101(奇数)"
                })
            })
        });
    },

    // 高对比度
    高对比度(rw, resetFilter) {
        if (resetFilter) {
            filterEdit = {
                name: "高对比度",
                config: {
                    alpha: 130,
                    beta: 0
                }
            }
        }

        var alphaProgress = Math.max(0, Math.min(300, filterEdit.config.alpha || 130));
        var betaProgress = Math.max(0, Math.min(100, (filterEdit.config.beta || 0) + 50));

        var xml =
            <vertical>
                <horizontal gravity="left|center" h="60">
                    <text text="对比度" textColor="#333333"/>
                    <seekbar max="300" progress={alphaProgress} id="alpha_seekbar1" layout_weight="1" />
                    <text gravity="center" id="alpha_input1" w="50" text={(alphaProgress / 100).toFixed(2)} textColor="#333333"/>
                </horizontal>
                <horizontal gravity="left|center" h="60">
                    <text text="亮度" textColor="#333333"/>
                    <seekbar max="100" progress={betaProgress} id="beta_seekbar1" layout_weight="1" />
                    <text gravity="center" id="beta_input1" w="50" text={betaProgress - 50} textColor="#333333"/>
                </horizontal>
            </vertical>

        rw.filter_edit.removeAllViews();
        ui.inflate(xml, rw.filter_edit, true)

        ui.post(() => {
            rw.setSize(rw.getWidth(), -2);

            rw.alpha_seekbar1.setOnSeekBarChangeListener({
                onProgressChanged: (seekbar, progress, fromUser) => {
                    rw.alpha_input1.attr("text", (progress / 100).toFixed(2))
                    filterEdit.config.alpha = progress
                },
            });

            rw.beta_seekbar1.setOnSeekBarChangeListener({
                onProgressChanged: (seekbar, progress, fromUser) => {
                    var value = progress - 50;
                    rw.beta_input1.attr("text", value)
                    filterEdit.config.beta = value
                },
            });

            rw.alpha_input1.on("click", () => {
                utils.弹窗输入框(function(value) {
                    if (/[^\d\.]/g.test(value)) {
                        toast("请输入数字")
                        return
                    }
                    value = parseFloat(value) * 100;
                    if (value > 300) value = 300;
                    if (value < 0) value = 0;
                    rw.alpha_input1.attr("text", (value / 100).toFixed(2))
                    rw.alpha_seekbar1.attr("progress", value)
                    filterEdit.config.alpha = value
                }, {
                    title: "输入对比度",
                    inputHint: "0-3.0"
                })
            })

            rw.beta_input1.on("click", () => {
                utils.弹窗输入框(function(value) {
                    if (/[^\d\-]/g.test(value)) {
                        toast("请输入数字")
                        return
                    }
                    value = parseInt(value);
                    if (value > 50) value = 50;
                    if (value < -50) value = -50;
                    rw.beta_input1.attr("text", value)
                    rw.beta_seekbar1.attr("progress", value + 50)
                    filterEdit.config.beta = value
                }, {
                    title: "输入亮度",
                    inputHint: "-50-50"
                })
            })
        });
    },

    // 亮度调整
    亮度调整(rw, resetFilter) {
        if (resetFilter) {
            filterEdit = {
                name: "亮度调整",
                config: {
                    value: 30
                }
            }
        }

        var valueProgress = Math.max(0, Math.min(100, (filterEdit.config.value || 30) + 50));

        var xml =
            <horizontal gravity="left|center" h="60">
                <text text="亮度" textColor="#333333"/>
                <seekbar max="100" progress={valueProgress} id="value_seekbar" layout_weight="1" />
                <text gravity="center" id="value_input" w="50" text={valueProgress - 50} textColor="#333333"/>
            </horizontal>

        rw.filter_edit.removeAllViews();
        ui.inflate(xml, rw.filter_edit, true)

        ui.post(() => {
            rw.setSize(rw.getWidth(), -2);

            rw.value_seekbar.setOnSeekBarChangeListener({
                onProgressChanged: (seekbar, progress, fromUser) => {
                    var value = progress - 50;
                    rw.value_input.attr("text", value)
                    filterEdit.config.value = value
                },
            });

            rw.value_input.on("click", () => {
                utils.弹窗输入框(function(value) {
                    if (/[^\d\-]/g.test(value)) {
                        toast("请输入数字")
                        return
                    }
                    value = parseInt(value);
                    if (value > 50) value = 50;
                    if (value < -50) value = -50;
                    rw.value_input.attr("text", value)
                    rw.value_seekbar.attr("progress", value + 50)
                    filterEdit.config.value = value
                }, {
                    title: "输入亮度值",
                    inputHint: "-50-50"
                })
            })
        });
    },

    // 素描效果
    素描效果(rw, resetFilter) {
        if (resetFilter) {
            filterEdit = {
                name: "素描效果",
                config: {}
            }
        }

        var xml =
            <vertical gravity="center_horizontal" h="auto" w="*" padding="15">
                <text text="素描效果无需调整参数" textColor="#666666" textSize="14sp" gravity="center"/>
            </vertical>

        rw.filter_edit.removeAllViews();
        ui.inflate(xml, rw.filter_edit, true)

        ui.post(() => {
            rw.setSize(rw.getWidth(), -2);
        });
    },

    // 腐蚀
    腐蚀(rw, resetFilter) {
        if (resetFilter) {
            filterEdit = {
                name: "腐蚀",
                config: {
                    kernelSize: 5,
                    iterations: 1
                }
            }
        }

        var kernelProgress = Math.floor((Math.max(3, filterEdit.config.kernelSize) - 3) / 2);
        var iterationsProgress = Math.max(1, Math.min(10, filterEdit.config.iterations || 1));

        var xml =
            <vertical>
                <horizontal gravity="left|center" h="60">
                    <text text="核大小" textColor="#333333"/>
                    <seekbar max="10" progress={kernelProgress} id="kernel_seekbar4" layout_weight="1" />
                    <text gravity="center" id="kernel_input4" w="50" text={filterEdit.config.kernelSize} textColor="#333333"/>
                </horizontal>
                <horizontal gravity="left|center" h="60">
                    <text text="迭代次数" textColor="#333333"/>
                    <seekbar max="10" progress={iterationsProgress} id="iterations_seekbar4" layout_weight="1" />
                    <text gravity="center" id="iterations_input4" w="50" text={iterationsProgress} textColor="#333333"/>
                </horizontal>
            </vertical>

        rw.filter_edit.removeAllViews();
        ui.inflate(xml, rw.filter_edit, true)

        ui.post(() => {
            rw.setSize(rw.getWidth(), -2);

            rw.kernel_seekbar4.setOnSeekBarChangeListener({
                onProgressChanged: (seekbar, progress, fromUser) => {
                    var value = progress * 2 + 3;
                    rw.kernel_input4.attr("text", value)
                    filterEdit.config.kernelSize = value
                },
            });

            rw.iterations_seekbar4.setOnSeekBarChangeListener({
                onProgressChanged: (seekbar, progress, fromUser) => {
                    rw.iterations_input4.attr("text", progress)
                    filterEdit.config.iterations = progress
                },
            });

            rw.kernel_input4.on("click", () => {
                utils.弹窗输入框(function(value) {
                    if (/[^\d]/g.test(value)) {
                        toast("请输入纯数字")
                        return
                    }
                    value = parseInt(value);
                    if (value < 3) value = 3;
                    if (value > 21) value = 21;
                    if (value % 2 === 0) value++;
                    rw.kernel_input4.attr("text", value)
                    rw.kernel_seekbar4.attr("progress", (value - 3) / 2)
                    filterEdit.config.kernelSize = value
                }, {
                    title: "输入核大小",
                    inputHint: "3-21(奇数)"
                })
            })

            rw.iterations_input4.on("click", () => {
                utils.弹窗输入框(function(value) {
                    if (/[^\d]/g.test(value)) {
                        toast("请输入纯数字")
                        return
                    }
                    value = parseInt(value);
                    if (value > 10) value = 10;
                    if (value < 1) value = 1;
                    rw.iterations_input4.attr("text", value)
                    rw.iterations_seekbar4.attr("progress", value)
                    filterEdit.config.iterations = value
                }, {
                    title: "输入迭代次数",
                    inputHint: "1-10"
                })
            })
        });
    },

    // 膨胀
    膨胀(rw, resetFilter) {
        if (resetFilter) {
            filterEdit = {
                name: "膨胀",
                config: {
                    kernelSize: 5,
                    iterations: 1
                }
            }
        }

        var kernelProgress = Math.floor((Math.max(3, filterEdit.config.kernelSize) - 3) / 2);
        var iterationsProgress = Math.max(1, Math.min(10, filterEdit.config.iterations || 1));

        var xml =
            <vertical>
                <horizontal gravity="left|center" h="60">
                    <text text="核大小" textColor="#333333"/>
                    <seekbar max="10" progress={kernelProgress} id="kernel_seekbar5" layout_weight="1" />
                    <text gravity="center" id="kernel_input5" w="50" text={filterEdit.config.kernelSize} textColor="#333333"/>
                </horizontal>
                <horizontal gravity="left|center" h="60">
                    <text text="迭代次数" textColor="#333333"/>
                    <seekbar max="10" progress={iterationsProgress} id="iterations_seekbar5" layout_weight="1" />
                    <text gravity="center" id="iterations_input5" w="50" text={iterationsProgress} textColor="#333333"/>
                </horizontal>
            </vertical>

        rw.filter_edit.removeAllViews();
        ui.inflate(xml, rw.filter_edit, true)

        ui.post(() => {
            rw.setSize(rw.getWidth(), -2);

            rw.kernel_seekbar5.setOnSeekBarChangeListener({
                onProgressChanged: (seekbar, progress, fromUser) => {
                    var value = progress * 2 + 3;
                    rw.kernel_input5.attr("text", value)
                    filterEdit.config.kernelSize = value
                },
            });

            rw.iterations_seekbar5.setOnSeekBarChangeListener({
                onProgressChanged: (seekbar, progress, fromUser) => {
                    rw.iterations_input5.attr("text", progress)
                    filterEdit.config.iterations = progress
                },
            });

            rw.kernel_input5.on("click", () => {
                utils.弹窗输入框(function(value) {
                    if (/[^\d]/g.test(value)) {
                        toast("请输入纯数字")
                        return
                    }
                    value = parseInt(value);
                    if (value < 3) value = 3;
                    if (value > 21) value = 21;
                    if (value % 2 === 0) value++;
                    rw.kernel_input5.attr("text", value)
                    rw.kernel_seekbar5.attr("progress", (value - 3) / 2)
                    filterEdit.config.kernelSize = value
                }, {
                    title: "输入核大小",
                    inputHint: "3-21(奇数)"
                })
            })

            rw.iterations_input5.on("click", () => {
                utils.弹窗输入框(function(value) {
                    if (/[^\d]/g.test(value)) {
                        toast("请输入纯数字")
                        return
                    }
                    value = parseInt(value);
                    if (value > 10) value = 10;
                    if (value < 1) value = 1;
                    rw.iterations_input5.attr("text", value)
                    rw.iterations_seekbar5.attr("progress", value)
                    filterEdit.config.iterations = value
                }, {
                    title: "输入迭代次数",
                    inputHint: "1-10"
                })
            })
        });
    },

    // 开运算
    开运算(rw, resetFilter) {
        if (resetFilter) {
            filterEdit = {
                name: "开运算",
                config: {
                    kernelSize: 5,
                    iterations: 1
                }
            }
        }

        var kernelProgress = Math.floor((Math.max(3, filterEdit.config.kernelSize) - 3) / 2);
        var iterationsProgress = Math.max(1, Math.min(10, filterEdit.config.iterations || 1));

        var xml =
            <vertical>
                <horizontal gravity="left|center" h="60">
                    <text text="核大小" textColor="#333333"/>
                    <seekbar max="10" progress={kernelProgress} id="kernel_seekbar6" layout_weight="1" />
                    <text gravity="center" id="kernel_input6" w="50" text={filterEdit.config.kernelSize} textColor="#333333"/>
                </horizontal>
                <horizontal gravity="left|center" h="60">
                    <text text="迭代次数" textColor="#333333"/>
                    <seekbar max="10" progress={iterationsProgress} id="iterations_seekbar6" layout_weight="1" />
                    <text gravity="center" id="iterations_input6" w="50" text={iterationsProgress} textColor="#333333"/>
                </horizontal>
            </vertical>

        rw.filter_edit.removeAllViews();
        ui.inflate(xml, rw.filter_edit, true)

        ui.post(() => {
            rw.setSize(rw.getWidth(), -2);

            rw.kernel_seekbar6.setOnSeekBarChangeListener({
                onProgressChanged: (seekbar, progress, fromUser) => {
                    var value = progress * 2 + 3;
                    rw.kernel_input6.attr("text", value)
                    filterEdit.config.kernelSize = value
                },
            });

            rw.iterations_seekbar6.setOnSeekBarChangeListener({
                onProgressChanged: (seekbar, progress, fromUser) => {
                    rw.iterations_input6.attr("text", progress)
                    filterEdit.config.iterations = progress
                },
            });

            rw.kernel_input6.on("click", () => {
                utils.弹窗输入框(function(value) {
                    if (/[^\d]/g.test(value)) {
                        toast("请输入纯数字")
                        return
                    }
                    value = parseInt(value);
                    if (value < 3) value = 3;
                    if (value > 21) value = 21;
                    if (value % 2 === 0) value++;
                    rw.kernel_input6.attr("text", value)
                    rw.kernel_seekbar6.attr("progress", (value - 3) / 2)
                    filterEdit.config.kernelSize = value
                }, {
                    title: "输入核大小",
                    inputHint: "3-21(奇数)"
                })
            })

            rw.iterations_input6.on("click", () => {
                utils.弹窗输入框(function(value) {
                    if (/[^\d]/g.test(value)) {
                        toast("请输入纯数字")
                        return
                    }
                    value = parseInt(value);
                    if (value > 10) value = 10;
                    if (value < 1) value = 1;
                    rw.iterations_input6.attr("text", value)
                    rw.iterations_seekbar6.attr("progress", value)
                    filterEdit.config.iterations = value
                }, {
                    title: "输入迭代次数",
                    inputHint: "1-10"
                })
            })
        });
    },

    // 闭运算
    闭运算(rw, resetFilter) {
        if (resetFilter) {
            filterEdit = {
                name: "闭运算",
                config: {
                    kernelSize: 5,
                    iterations: 1
                }
            }
        }

        var kernelProgress = Math.floor((Math.max(3, filterEdit.config.kernelSize) - 3) / 2);
        var iterationsProgress = Math.max(1, Math.min(10, filterEdit.config.iterations || 1));

        var xml =
            <vertical>
                <horizontal gravity="left|center" h="60">
                    <text text="核大小" textColor="#333333"/>
                    <seekbar max="10" progress={kernelProgress} id="kernel_seekbar7" layout_weight="1" />
                    <text gravity="center" id="kernel_input7" w="50" text={filterEdit.config.kernelSize} textColor="#333333"/>
                </horizontal>
                <horizontal gravity="left|center" h="60">
                    <text text="迭代次数" textColor="#333333"/>
                    <seekbar max="10" progress={iterationsProgress} id="iterations_seekbar7" layout_weight="1" />
                    <text gravity="center" id="iterations_input7" w="50" text={iterationsProgress} textColor="#333333"/>
                </horizontal>
            </vertical>

        rw.filter_edit.removeAllViews();
        ui.inflate(xml, rw.filter_edit, true)

        ui.post(() => {
            rw.setSize(rw.getWidth(), -2);

            rw.kernel_seekbar7.setOnSeekBarChangeListener({
                onProgressChanged: (seekbar, progress, fromUser) => {
                    var value = progress * 2 + 3;
                    rw.kernel_input7.attr("text", value)
                    filterEdit.config.kernelSize = value
                },
            });

            rw.iterations_seekbar7.setOnSeekBarChangeListener({
                onProgressChanged: (seekbar, progress, fromUser) => {
                    rw.iterations_input7.attr("text", progress)
                    filterEdit.config.iterations = progress
                },
            });

            rw.kernel_input7.on("click", () => {
                utils.弹窗输入框(function(value) {
                    if (/[^\d]/g.test(value)) {
                        toast("请输入纯数字")
                        return
                    }
                    value = parseInt(value);
                    if (value < 3) value = 3;
                    if (value > 21) value = 21;
                    if (value % 2 === 0) value++;
                    rw.kernel_input7.attr("text", value)
                    rw.kernel_seekbar7.attr("progress", (value - 3) / 2)
                    filterEdit.config.kernelSize = value
                }, {
                    title: "输入核大小",
                    inputHint: "3-21(奇数)"
                })
            })

            rw.iterations_input7.on("click", () => {
                utils.弹窗输入框(function(value) {
                    if (/[^\d]/g.test(value)) {
                        toast("请输入纯数字")
                        return
                    }
                    value = parseInt(value);
                    if (value > 10) value = 10;
                    if (value < 1) value = 1;
                    rw.iterations_input7.attr("text", value)
                    rw.iterations_seekbar7.attr("progress", value)
                    filterEdit.config.iterations = value
                }, {
                    title: "输入迭代次数",
                    inputHint: "1-10"
                })
            })
        });
    },

    // 颜色替换
    颜色替换(rw, resetFilter) {
        if (resetFilter) {
            filterEdit = {
                name: "颜色替换",
                config: {
                    colors: [],
                    other: ""
                }
            }
        }

        var xml =
            <frame w="*" h="*" padding="0 0 0 40px">
                <vertical w="*" h="*">
                    <androidx.core.widget.NestedScrollView id="scrollView" h="auto">
                        <vertical id="filter_list">
                            
                        </vertical>
                    </androidx.core.widget.NestedScrollView>
                </vertical>
                <button id="filter_add_btn" layout_gravity="right|bottom" text="添加颜色" style="Widget.AppCompat.Button.Colored" w="auto" h="auto" backgroundTint="#EAEAEA" textColor="#333333"/>
            </frame>
        rw.filter_edit.removeAllViews();
        ui.inflate(xml, rw.filter_edit, true)
        var drawable = new GradientDrawable();
        drawable.setShape(GradientDrawable.RECTANGLE);
        drawable.setColor(android.graphics.Color.parseColor("#ff008c8c"));
        drawable.setCornerRadius(5);

        function renderFilterList(rw, title, after) {
            rw.filter_list.removeAllViews();
            var filterList = filterEdit.config.colors

            filterList.forEach((e, i) => {
                let xml = `<button h="auto" gravity="center" w="168" text="颜色${i+1}" color="#ffffff" id="filter${i}" style="" padding="0 5" margin="0 2" />`;
                let view = ui.inflate(xml, rw.filter_list);

                view.setBackground(drawable);
                view.on("click", () => {
                    let currentIndex = filterList.findIndex(item => item === e);
                    if (currentIndex === -1) return;

                    rw.hide();
                    颜色替换.create("颜色替换", {
                        find: filterList[currentIndex].find,
                        change: filterList[currentIndex].change,
                        similarity: filterList[currentIndex].similarity,
                        callback(type, data) {
                            ui.post(() => {
                                try {
                                    rw.show();
                                } catch (e) {}
                            });
                            if (type == "cancel") return;
                            filterList[currentIndex] = data;
                            renderFilterList(rw, "颜色替换", false);
                        }
                    });
                });



                view.on("long_click", (event, view) => {
                    event.consumed = true;
                    let currentIndex = filterList.findIndex(item => item === e);
                    if (currentIndex === -1) return;

                    var arr = [{
                        name: "复制",
                        event: function() {
                            storageClip.put("clip", JSON.stringify({
                                type: "change_color_item",
                                content: filterList[currentIndex]
                            }));
                            toast("已复制")
                        }
                    }, {
                        name: "粘贴",
                        event: function() {
                            var clipJson = storageClip.get("clip");
                            try {
                                var clip = JSON.parse(clipJson);
                                if (clip.type != "change_color_item") throw "change_color_item";
                                filterList[currentIndex] = clip.content;
                                renderFilterList(rw, title, false);
                            } catch (e) {
                                toast("不符合");
                            }
                        }
                    }, {
                        name: "删除",
                        event: function() {
                            filterList.splice(currentIndex, 1);
                            renderFilterList(rw, title, false);
                        }
                    }];
                    bladeMenu.create(view, arr);
                });

                rw.filter_list.addView(view);
            });

            if (filterList && filterList.length > 0) {
                let xml = `<button h="auto" gravity="center" w="168" text="其它颜色" color="#ffffff" style="" padding="0 5" margin="0 2" />`;
                let view = ui.inflate(xml, rw.filter_list);

                view.setBackground(drawable);
                view.on("click", () => {
                    rw.hide()
                    取色盘.create("取色盘", {
                        callback(type, data) {
                            rw.show()
                            if (type == "confirm" && data) {
                                filterEdit.config.other = data
                            }
                        }
                    })
                })
                view.on("long_click", () => {
                    bladeMenu.create(view, [{
                        name: "清除",
                        event: function() {
                            filterEdit.config.other = ""
                        }
                    }]);
                })
                rw.filter_list.addView(view);
            }

            // ✅ 修复：延迟布局调整，限制最大显示5个按钮的高度
            ui.post(() => {
                var count = rw.filter_list.getChildCount();

                // 强制测量整个列表
                rw.filter_list.measure(0, 0)
                var listHeight = rw.filter_list.getMeasuredHeight()

                // ✅ 计算5个按钮的最大高度
                if (count == 5) {
                    maxScrollHeight = listHeight
                }
                if (count > 5) {
                    // 超过5个，限制高度为5个按钮的高度
                    rw.scrollView.attr("h", maxScrollHeight + "px");
                } else if (count > 0) {
                    // 不超过5个，自适应高度
                    rw.scrollView.attr("h", "auto");
                } else {
                    // 没有子项
                    rw.scrollView.attr("h", "auto");
                }

                // 再次强制测量整个视图
                ui.post(() => {
                    rw.root_view.measure(0, 0);
                    let measuredHeight = rw.root_view.getMeasuredHeight();
                    rw.setSize(rw.getWidth(), measuredHeight);
                    if (after) {
                        rw.scrollView.fullScroll(android.view.View.FOCUS_DOWN);
                    }
                }, 16)
            }, 16); // 增加延迟时间确保测量准确
        }
        ui.post(() => {
            rw.setSize(rw.getWidth(), -2);
            //添加颜色
            rw.filter_add_btn.on("click", function() {
                rw.hide()
                颜色替换.create("颜色替换", {
                    callback(type, data) {
                        if (type == "confirm" && data) {
                            log(data)
                            filterEdit.config.colors.push(data)
                            renderFilterList(rw, "替换颜色", true)
                        }
                        rw.show()
                    }
                })
            })
            renderFilterList(rw, "替换颜色", false)
        });
    },

}

function create(title, data) {
    var singI = singArr.indexOf(title)
    if (singI != -1 || !data) return

    var rw = 设置Ui(title, data)

    // 初始化 filterEdit
    filterEdit = {
        name: data.name || "自适应二值化",
        config: data.config || {}
    }

    singArr.push(title)
    mappingF[title] = rw
    callback[title] = data.callback

    ui居中(title)

    ui.post(() => {
        rw.filter_type_btn.attr("text", filterEdit.name)

        if (xmls[filterEdit.name]) {
            xmls[filterEdit.name](rw, false);
        } else {
            rw.filter_edit.removeAllViews();
        }
    })

    // 屏幕旋转处理函数 - 只关闭窗口，不重新创建
    redrawFun[title] = function() {
        if (mappingF[title]) {
            try {
                mappingF[title].close()
            } catch (e) {
                console.error("屏幕旋转关闭悬浮窗失败:", e)
                cleanup(title)
            }
        }
    }

    events.on("屏幕旋转", redrawFun[title])
    return rw
}

function callbackHandle(title, eventType, data) {
    if (typeof callback[title] != "function") {
        return
    }
    callback[title](eventType, data)
}

function close(title) {
    if (mappingF[title]) {
        try {
            mappingF[title].close()
        } catch (e) {
            console.error("关闭悬浮窗失败:", e)
            cleanup(title)
        }
    }
}

/*
utils.requestScreenCapture()
var r = create("滤镜", {
    name: "颜色替换",
    config: {
        colors: [],
        other: "",
    },
    callback(type, data) {
        log(data)
    }
})
*/

module.exports = {
    create,
    close,
    center: ui居中
}