importClass(android.graphics.PorterDuff);
importClass(android.graphics.Color);
importClass(android.graphics.Paint);
importClass(android.graphics.RadialGradient);
importClass(android.graphics.SweepGradient);
importClass(android.graphics.LinearGradient);
importClass(android.graphics.Shader);

function getXML() {
    var 方向 = utils.屏幕方向()
    var orientation = "vertical"
    var w = "*"
    var h = "*"
    if (方向 == "h") {
        orientation = "horizontal"
        w = "250dp"
        h = "250dp"
    }
    var xml =
        `<frame id="root_view">
        <vertical>
            <linear layout_gravity="center" gravity="center" orientation="${orientation}" w="*" h="${h}">
                <frame w="${w}" h="200dp" margin="10">
                    <canvas id="canvas" w="*" h="*" />
                </frame>
                <vertical w="${w}" >
                    <card w="*" h="wrap_content" cardCornerRadius="8" cardElevation="4" margin="10" bg="#ffffff">
                        <vertical padding="16">
                            <text text="当前颜色" textSize="16sp" textColor="#333333" textStyle="bold"/>
                            <linear gravity="center_vertical" marginTop="8">
                                <frame id="preview" w="40dp" h="40dp" bg="#000000" circle="true"/>
                                <vertical marginLeft="12" w="*">
                                    <input id="colorHex" text="#000000" textSize="18sp" textColor="#000000" typeface="monospace" inputType="textCapCharacters"/>
                                    <text id="colorDetails" text="H:0° S:0% V:0%" textSize="12sp" textColor="#888888" marginTop="4"/>
                                </vertical>
                            </linear>
                        </vertical>
                    </card>
                    
                    <card w="*" h="wrap_content" cardCornerRadius="8" cardElevation="4" margin="10" bg="#ffffff">
                        <vertical padding="16">
                            <text text="亮度 (Value)" textSize="14sp" textColor="#333333"/>
                            <seekbar id="vBar" max="100" progress="100" marginTop="8"/>
                        </vertical>
                    </card>
                </vertical>
            </linear>
            
            <frame w="*" h="auto">
                <vertical w="*" h="50" layout_gravity="bottom" >
                    <text w="*" h="1px" bg="#333333" />
                    <horizontal h="*" gravity="center">
                        <text layout_weight="1" id="cancel_btn" text="取消"
                        w="0" h="*" gravity="center" backgroundTint="#EAEAEA" textColor="#333333"/>
                        <text w="1px" h="*" bg="#333333" />
                        <text layout_weight="1" id="confirm_btn" text="确认"
                        w="0" h="*" gravity="center" backgroundTint="#EAEAEA" textColor="#333333"/>
                    </horizontal>
                </vertical>
            </frame>
            
        </vertical>
    </frame>`
    return xml
}
var utils = require(files.join(files.cwd(), "utils.js"))
var dialogsFloaty = require("./dialogsFloaty.js");
var 滤镜图片 = require("./滤镜图片.js");
var bladeMenu = require("./bladeMenu.js");
var dropUpMenu = require("./dropUpMenu.js");
var filterFun = require("../js/filterFun.js");
var singArr = []
var mappingF = {}
var callback = {}
var redrawFun = {}

var storageClip = storages.create("clip")
var cacheFile = files.join(files.cwd(), "cache/")

var 设置Ui = function(title, data) {
    var rw = dialogsFloaty(getXML())
    // 悬浮窗关闭处理事件
    rw.closed = function() {
        // 先执行回调
        callbackHandle(title, "cancel", null)

        cleanup(title)
    }
    rw.setRadius(25)
    //rw.setOverflowHide(true)
    init(rw, title, data)
    return rw
}

function ui居中(title) {
    var rw = mappingF[title]
    var screen = utils.getScreenSize()
    var width = screen.width
    var height = screen.height

    ui.post(() => {
        // 按屏幕比例算宽高
        var newW = Math.floor(width * 0.8)
        var newH = Math.floor(height * 0.9)

        // 最小限制
        var minW = 400
        var minH = 400
        if (newW < minW) newW = minW
        if (newH < minH) newH = minH

        // 最大限制
        var maxW = newW
        var maxH = 1000
        if (newW > maxW) newW = maxW
        //if (newH > maxH) newH = maxH
        var fH = rw.getSize().height
        if (fH > newH) {
            fH = newH
        }
        rw.setSize(newW, fH)
        rw.center()
        rw.show()
    })
}

// 清理资源的统一函数
function cleanup(title) {
    // 移除屏幕旋转监听
    if (redrawFun[title]) {
        events.removeListener("屏幕旋转", redrawFun[title])
        delete redrawFun[title]
    }

    // 从数组中移除
    let index = singArr.indexOf(title)
    if (index !== -1) {
        singArr.splice(index, 1)
    }

    // 清理映射
    delete mappingF[title]
    delete callback[title]
}

function init(rw, title, data) {

    function newJavaIntArray(arr) {
        var javaArr = java.lang.reflect.Array.newInstance(java.lang.Integer.TYPE, arr.length);
        for (var i = 0; i < arr.length; i++) {
            java.lang.reflect.Array.setInt(javaArr, i, arr[i]);
        }
        return javaArr;
    }

    var currentH = 0,
        currentS = 0.0,
        currentV = 1.0;
    var isUpdatingFromTouch = false;

    var paint = new Paint();
    paint.setAntiAlias(true);

    rw.canvas.on("draw", function(canvas) {
        canvas.drawColor(0, PorterDuff.Mode.CLEAR);
        var w = canvas.getWidth(),
            h = canvas.getHeight();
        if (w <= 0 || h <= 0) return;

        var cx = w / 2,
            cy = h / 2,
            r = Math.min(cx, cy) * 0.9;

        // 1. 色相环
        var hueColorsArr = [
            Color.HSVToColor([0, 1, currentV]),
            Color.HSVToColor([300, 1, currentV]),
            Color.HSVToColor([240, 1, currentV]),
            Color.HSVToColor([180, 1, currentV]),
            Color.HSVToColor([120, 1, currentV]),
            Color.HSVToColor([60, 1, currentV]),
            Color.HSVToColor([0, 1, currentV])
        ];
        var hueColors = newJavaIntArray(hueColorsArr);
        var sweepGradient = new SweepGradient(cx, cy, hueColors, null);
        paint.setShader(sweepGradient);
        canvas.drawCircle(cx, cy, r, paint);

        // 2. 中心饱和度
        var centerColor = Color.HSVToColor([0, 0, currentV]);
        var satColors = newJavaIntArray([centerColor, Color.TRANSPARENT]);
        var radialGradient = new RadialGradient(cx, cy, r, satColors, null, Shader.TileMode.CLAMP);
        paint.setShader(radialGradient);
        canvas.drawCircle(cx, cy, r, paint);

        // 3. 指示器
        paint.setShader(null);
        var angleRad = -currentH * Math.PI / 180;
        var dx = r * currentS * Math.cos(angleRad);
        var dy = r * currentS * Math.sin(angleRad);

        paint.setColor(Color.WHITE);
        paint.setStrokeWidth(5);
        paint.setStyle(Paint.Style.STROKE);
        canvas.drawCircle(cx + dx, cy + dy, 12, paint);

        paint.setStrokeWidth(2);
        paint.setColor(Color.BLACK);
        canvas.drawCircle(cx + dx, cy + dy, 12, paint);

        paint.setStyle(Paint.Style.FILL);
    });

    // 更新颜色显示 (触摸引起)
    function updateColorFromTouch() {
        isUpdatingFromTouch = true;
        var colorInt = Color.HSVToColor([currentH, currentS, currentV]);
        var hex = "#" + ("000000" + (colorInt >>> 0).toString(16)).slice(-6).toUpperCase();

        ui.run(() => {
            rw.preview.setBackgroundColor(colorInt);
            rw.colorHex.setText(hex);
            rw.colorDetails.setText(`H:${Math.round(currentH)}° S:${Math.round(currentS*100)}% V:${Math.round(currentV*100)}%`);
            rw.colorHex.setSelection(hex.length);
        });

        ui.post(() => {
            isUpdatingFromTouch = false;
        }, 50);
    }

    // 监听输入框变化 (手动输入引起)
    rw.colorHex.addTextChangedListener(new android.text.TextWatcher({
        beforeTextChanged: function(s, start, count, after) {
            // 文本改变前的回调
        },

        onTextChanged: function(s, start, before, count) {
            // 文本改变中的回调
        },

        afterTextChanged: function(editable) {
            if (isUpdatingFromTouch) return;

            var hexStr = editable.toString().trim();
            if (!hexStr.startsWith("#")) {
                return;
            }

            if (/^#([0-9A-Fa-f]{6}|[0-9A-Fa-f]{8})$/.test(hexStr)) {
                try {
                    var colorInt = Color.parseColor(hexStr);

                    // 创建Java float数组
                    var hsv = java.lang.reflect.Array.newInstance(java.lang.Float.TYPE, 3);
                    Color.colorToHSV(colorInt, hsv);

                    // 从Java数组读取值
                    currentH = java.lang.reflect.Array.getFloat(hsv, 0);
                    currentS = java.lang.reflect.Array.getFloat(hsv, 1);
                    currentV = java.lang.reflect.Array.getFloat(hsv, 2);

                    // 更新 UI (除输入框外)
                    rw.preview.setBackgroundColor(colorInt);
                    rw.colorDetails.setText(`H:${Math.round(currentH)}° S:${Math.round(currentS*100)}% V:${Math.round(currentV*100)}%`);
                    rw.vBar.setProgress(Math.round(currentV * 100));

                    // 重绘色盘指示器位置
                    rw.canvas.invalidate();
                } catch (e) {
                    // 解析失败忽略
                }
            }
        }
    }));

    rw.vBar.setOnSeekBarChangeListener({
        onProgressChanged: function(bar, progress, fromUser) {
            if (fromUser) {
                currentV = progress / 100.0;
                updateColorFromTouch();
                rw.canvas.invalidate();
            }
        }
    });

    rw.canvas.setOnTouchListener(function(view, event) {
        if (event.getAction() === 0 || event.getAction() === 2) {
            var x = event.getX(),
                y = event.getY();
            var cx = view.getWidth() / 2,
                cy = view.getHeight() / 2;
            var r = Math.min(cx, cy) * 0.9;

            var dx = x - cx,
                dy = y - cy;
            var dist = Math.sqrt(dx * dx + dy * dy);

            if (dist <= r || event.getAction() === 2) {
                var angle = Math.atan2(dy, dx) * 180 / Math.PI;
                currentH = -angle;
                if (currentH < 0) currentH += 360;
                currentS = Math.max(0, Math.min(1, dist / r));

                updateColorFromTouch();
                rw.canvas.invalidate();
            }
            return true;
        }
        return true;
    });

    ui.post(function() {
        updateColorFromTouch();
    });

    // 取消
    rw.cancel_btn.on("click", () => {
        // 先执行回调
        callbackHandle(title, "cancel", null)

        // 再关闭悬浮窗（这会触发 closed 事件，从而调用 cleanup）
        try {
            rw.close()
        } catch (e) {
            console.error("关闭悬浮窗失败:", e)
            // 如果关闭失败，手动清理
            cleanup(title)
        }
    })

    // 确认
    rw.confirm_btn.on("click", () => {
        // 先执行回调
        callbackHandle(title, "confirm", rw.colorHex.text())

        // 再关闭悬浮窗
        try {
            rw.close()
        } catch (e) {
            console.error("关闭悬浮窗失败:", e)
            cleanup(title)
        }
    })


}

function create(title, data) {
    var singI = singArr.indexOf(title)
    if (singI != -1 || !data) return

    var rw = 设置Ui(title, data)

    singArr.push(title)
    mappingF[title] = rw
    callback[title] = data.callback

    ui居中(title)

    ui.post(() => {

    })

    // 屏幕旋转处理函数 - 只关闭窗口，不重新创建
    redrawFun[title] = function() {
        if (mappingF[title]) {
            try {
                mappingF[title].close()
            } catch (e) {
                console.error("屏幕旋转关闭悬浮窗失败:", e)
                cleanup(title)
            }
        }
    }

    events.on("屏幕旋转", redrawFun[title])
    return rw
}

function callbackHandle(title, eventType, data) {
    if (typeof callback[title] != "function") {
        return
    }
    callback[title](eventType, data)
}

function close(title) {
    if (mappingF[title]) {
        try {
            mappingF[title].close()
        } catch (e) {
            console.error("关闭悬浮窗失败:", e)
            cleanup(title)
        }
    }
}

/*
var r = create("取色盘", {
    callback(type, data) {
        if (type == "confirm") {
            log(data)
        }
    }
})
*/

module.exports = {
    create,
    close,
    center: ui居中
}
