var dialogsFloaty = require("./dialogsFloaty.js")
var utils = require(files.join(files.cwd(), "utils.js"));

function showToast(msg, duration) {
    duration = duration || 1000;

    var w = dialogsFloaty(
        <card id="root_view" alpha="0" cardCornerRadius="10">
            <text id="txt" text="提示信息" textColor="#FFFFFF" textSize="16sp"
                bg="#CC333333"
                padding="10"
                shadowColor="#55000000"
                shadowDx="2"
                shadowDy="2"/>
        </card>
    );

    w.setTouchable(false);
    w.setDimBehind(false);
    w.setBG("#00000000", 25);

    ui.run(() => {
        w.txt.setText(msg.toString());
        w.show();
    });

    ui.post(() => {
        var { width, height } = utils.getScreenSize();
        
        var fw = w.root_view.getWidth();
        var fh = w.root_view.getHeight();

        var x = Math.floor((width - fw) / 2);
        var targetY = Math.floor(height * 0.9 - fh);
        var offset = 60; // 上下移动距离(px)

        var startY = targetY + offset;

        // 初始位置（在下面）
        w.setPosition(x, startY);
        // ===== 从下面上来 + 淡入 =====
        threads.start(function () {
            for (var i = 0; i <= 10; i++) {
                var p = i / 10;
                ui.run(() => {
                    w.root_view.setAlpha(p);
                    w.setPosition(x, startY - offset * p);
                });
                sleep(10);
            }
        });

        // ===== 延迟后向上消失 + 淡出 =====
        setTimeout(() => {
            threads.start(function () {
                for (var i = 10; i >= 0; i--) {
                    var p = i / 10;
                    ui.run(() => {
                        w.root_view.setAlpha(p);
                        w.setPosition(x, targetY - offset * (1 - p));
                    });
                    sleep(10);
                }
                w.close();
            });
        }, duration);
    });
}

module.exports = showToast;