importClass(android.graphics.drawable.GradientDrawable);
importPackage(android.graphics);
var utils = require(files.join(files.cwd(), "utils.js"));
var dialogsFloaty = require("./dialogsFloaty.js");

function createUI(arr) {
    var xml = generateXML(arr)
    if (!xml) return
    return dialogsFloaty(xml);
}

function init(w, x, y, arr) {
    w.setPosition(0, 0)
    var drawable = new GradientDrawable();
    drawable.setShape(GradientDrawable.RECTANGLE);
    drawable.setColor(Color.TRANSPARENT); // 背景透明
    //drawable.setStroke(2, Color.parseColor("#008BFF")); // 边框颜色和宽度
    drawable.setCornerRadius(8); // 圆角可选
    arr.forEach((e, i) => {
        w["btn" + i].setBackground(drawable);
        w["btn" + i].on("click", function() {
            arr[i].event(arr[i].name)
            closeUi(w)
        })
    })
    w.card.setBackground(createRoundedDrawable("#4B4C4D", 15));
    w.root_view.on("click", function() {
        closeUi(w)
    })
    ui.post(() => {
        var screen = utils.getScreenSize()
        w.setSize(screen.width, screen.height)
        var cardW = w.card.getWidth()
        var containerH = w.container.getHeight()

        // 容器偏移
        var containerX = x - cardW / 2
        // 往上
        //var containerY = y - containerH
        // 往下
        var containerY = y
        // 边界判断
        var exceedX = containerX + cardW - screen.width
        if (containerX < 0) {
            containerX = 0
        } else if (exceedX > 0) {
            containerX -= exceedX
        }
        if (containerY < 0) {
            containerY = 0
        } else if(containerY+containerH>screen.height){
            var h = containerH-(containerH + containerY - screen.height+100)
            w.scroll_view.attr("h", h+"px")
        }
        w.container.setTranslationX(containerX)
        w.container.setTranslationY(containerY)

        //小三角偏移
        // 悬浮窗显示
        w.show()
    })
}

function closeUi(w) {
    w.close()
}

function createRoundedDrawable(color, radius) {
    let drawable = GradientDrawable();
    drawable.setColor(colors.parseColor(color));
    drawable.setCornerRadius(radius);
    return drawable;
}

function generateXML(arr) {
    if (!arr || !arr.length) return
    var btns = ""
    for (var i = 0; i < arr.length; i++) {
        btns += `<button padding="5 0" w="auto" h="30" id="btn${i}" layout_weight="1" text="${arr[i].name}" textColor="#DBDBDB" textSize="16dp" layout_gravity="center" gravity="center" />`
        if (i < arr.length - 1) {
            btns += `<View bg="#666666" w="*" h="1" />`
        }
    }
    var width = device.width
    var height = device.height
    var xml = `
    <vertical id="root_view" w="*" h="*">
    <vertical id="container">
        <androidx.core.widget.NestedScrollView w="auto" id="scroll_view" >
        <card id="card" w="auto" h="auto" cardCornerRadius="5dp" cardElevation = "1dp" gravity = "center_vertical" >
            <vertical>
            ${btns}
            </vertical>
        </card>
        </androidx.core.widget.NestedScrollView>
    </vertical>
    </vertical>
    `
    return xml
}

function create(view, arr) {
    var point = view.getLocationOnScreen()
    var viewW = view.getWidth()
    var viewH = view.getHeight()
    var x = point[0] + viewW / 2,
        y = point[1];
    var w = createUI(arr)
    if (!w) return
    w.show()
    w.setSize(-1, -1)
    w.hide()
    w.setBG("#00000000")
    w.setDimBehind(false)
    // 往上
    //init(w, x, y, arr)
    // 往下
    init(w, x, y + viewH, arr)
}

/*
create(505.5, 1086, [{
    name: "删除",
    event: function() {
        log("删除")
    }
}, {
    name: "复制",
    event: function() {
        log("复制")
    }
}])
*/


module.exports = {
    create
}