importClass(android.app.Dialog);
importClass(android.os.Build);
importClass(android.view.WindowManager);
importClass(android.view.View);
importClass(android.graphics.Color);
importClass(android.graphics.drawable.ColorDrawable);
importClass(android.view.ViewGroup);
importClass(android.view.Gravity);
importClass(android.content.DialogInterface);


var utils = require(files.join(files.cwd(), "utils.js"));
var dialogArr = []

fullDialogs.closeAll = function() {
    dialogArr.forEach(dialog => {
        dialog && dialog.close()
    })
    dialogArr = []
}

function fullDialogs(xml) {
    if (!floaty.checkPermission() && !auto.service) {
        throw "请给予无障碍或悬浮窗权限!"
    }

    var _context = auto.service || context
    var result = null;
    var kl = utils.mSetInterval(() => {}, 1000); // 保持脚本运行
    var isFocus = true;
    // 缓存的尺寸
    var cacheSize = null

    ui.run(() => {
        var dialog = new Dialog(_context);
        dialog.requestWindowFeature(1); // FEATURE_NO_TITLE

        var layout = ui.inflate(
            <vertical id="__root__">
                    </vertical>,
            null,
            false
        );

        ui.inflate(xml, layout, true);

        // 根视图填满
        layout.__root__.setLayoutParams(new ViewGroup.LayoutParams(
            ViewGroup.LayoutParams.MATCH_PARENT,
            ViewGroup.LayoutParams.MATCH_PARENT
        ));
        layout.__root__.setPadding(0, 0, 0, 0);
        layout.__root__.setBackgroundColor(Color.parseColor("#FFFFFF"));
        // 启用硬件层
        layout.__root__.setLayerType(android.view.View.LAYER_TYPE_HARDWARE, null);


        dialog.setContentView(layout);

        var window = dialog.getWindow();
        if (window) {
            // 基础布局
            var lp = window.getAttributes();
            lp.gravity = Gravity.LEFT | Gravity.TOP;
            window.setAttributes(lp);
            window.setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));

            // 设置窗口类型
            var type;
            if (auto.service != null) {
                // 有无障碍服务，优先使用无障碍覆盖层
                type = WindowManager.LayoutParams.TYPE_ACCESSIBILITY_OVERLAY;
            } else if (Build.VERSION.SDK_INT >= 26) {
                // Android 8.0+ 使用应用覆盖层
                type = WindowManager.LayoutParams.TYPE_APPLICATION_OVERLAY;
            } else {
                // Android 8.0 以下使用电话窗口
                type = WindowManager.LayoutParams.TYPE_PHONE;
            }

            try {
                window.setType(type);
            } catch (e) {
                log("设置窗口类型失败: " + e);
            }

            // 系统栏透明
            if (Build.VERSION.SDK_INT >= 21) {
                window.addFlags(WindowManager.LayoutParams.FLAG_DRAWS_SYSTEM_BAR_BACKGROUNDS);
                window.setStatusBarColor(Color.TRANSPARENT);
            }

            // 窗口置顶
            window.addFlags(WindowManager.LayoutParams.FLAG_SHOW_WHEN_LOCKED);

            // 禁用窗口动画
            window.setWindowAnimations(0);

            // decor 设置沉浸式
            var decor = window.getDecorView();
            var uiOptions = View.SYSTEM_UI_FLAG_LAYOUT_STABLE |
                View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN |
                View.SYSTEM_UI_FLAG_LAYOUT_HIDE_NAVIGATION |
                View.SYSTEM_UI_FLAG_IMMERSIVE_STICKY;
            decor.setSystemUiVisibility(uiOptions);
            if (Build.VERSION.SDK_INT >= 30) {
                decor.setOnApplyWindowInsetsListener(new android.view.View.OnApplyWindowInsetsListener({
                    onApplyWindowInsets: function(v, insets) {
                        return insets.consumeSystemWindowInsets();
                    }
                }));
            }
            decor.setPadding(0, 0, 0, 0);
            try {
                layout.__root__.setFitsSystemWindows(false);
            } catch (e) {}

            window.setLayout(
                ViewGroup.LayoutParams.WRAP_CONTENT,
                ViewGroup.LayoutParams.WRAP_CONTENT
            );

            // 去除背景暗影和阴影
            try {
                window.clearFlags(WindowManager.LayoutParams.FLAG_DIM_BEHIND);
                lp = window.getAttributes();
                lp.dimAmount = 0.0;
                lp.windowAnimations = 0;
                window.setAttributes(lp);

                window.setElevation(0);
                decor.setElevation(0);
                layout.__root__.setElevation(0);
            } catch (e) {}

            // 尝试保持硬件加速
            try {
                window.addFlags(WindowManager.LayoutParams.FLAG_HARDWARE_ACCELERATED);
                //window.setFlags(WindowManager.LayoutParams.FLAG_HARDWARE_ACCELERATED, 0);
            } catch (e) {
                log("硬件加速设置失败: " + e);
            }

            // 额外：禁用 HW Overlays（模拟系统设置，提高 Overlay 响应）
            // 注意：这需系统权限，或仅在代码中模拟效果
            if (Build.VERSION.SDK_INT >= 21) {
                window.addFlags(WindowManager.LayoutParams.FLAG_LAYOUT_NO_LIMITS);
            }
            try {
                window.setPreferMinimalPostProcessing(true);
            } catch (e) {}
            // 点击外部不关闭
            dialog.setCanceledOnTouchOutside(false);
        }

        // === 公共方法 ===

        // 新增:动态切换M3主题
        layout.applyM3Theme = function(themeId) {
            try {
                var themedContext = new ContextThemeWrapper(_context, themeId);
                log("动态应用M3主题: " + themeId);
                // 注意：动态切换主题需要重新inflate布局才能完全生效
                toast("主题已更新，部分效果需要重新创建窗口");
            } catch (e) {
                log("动态应用主题失败: " + e);
            }
        };

        // 设置圆角
        layout.setRadius = function(radius) {
            ui.run(() => {
                try {
                    var shape = new android.graphics.drawable.GradientDrawable();
                    shape.setShape(android.graphics.drawable.GradientDrawable.RECTANGLE);
                    var currentColor = Color.WHITE;
                    try {
                        var currentDrawable = layout.__root__.getBackground();
                        if (currentDrawable instanceof ColorDrawable) {
                            currentColor = currentDrawable.getColor();
                        }
                    } catch (e) {}
                    shape.setColor(currentColor);

                    if (typeof radius === 'number') {
                        shape.setCornerRadius(radius);
                    } else if (Array.isArray(radius) && radius.length === 4) {
                        var radii = new Array(8);
                        for (var i = 0; i < 4; i++) {
                            radii[i * 2] = radius[i];
                            radii[i * 2 + 1] = radius[i];
                        }
                        shape.setCornerRadii(radii);
                    }
                    layout.__root__.setBackground(shape);
                } catch (e) {
                    log("设置圆角失败: " + e);
                }
            });
        };

        // 设置背景颜色（支持圆角）
        layout.setBG = function(hex, radius) {
            ui.run(() => {
                try {
                    var color = Color.parseColor(hex);
                    if (radius !== undefined && radius !== null) {
                        var shape = new android.graphics.drawable.GradientDrawable();
                        shape.setShape(android.graphics.drawable.GradientDrawable.RECTANGLE);
                        shape.setColor(color);

                        if (typeof radius === 'number') {
                            shape.setCornerRadius(radius);
                        } else if (Array.isArray(radius) && radius.length === 4) {
                            var radii = new Array(8);
                            for (var i = 0; i < 4; i++) {
                                radii[i * 2] = radius[i];
                                radii[i * 2 + 1] = radius[i];
                            }
                            shape.setCornerRadii(radii);
                        }
                        layout.__root__.setBackground(shape);
                    } else {
                        layout.__root__.setBackgroundColor(color);
                    }
                } catch (e) {
                    log("设置背景失败: " + e);
                }
            });
        };

        // 关闭
        layout.close = function() {
            if (!dialog) return
            dialog.dismiss();
            var i = dialogArr.indexOf(layout)
            if (i != -1) dialogArr[i] = null;
            dialog = null
        };

        // 显示
        layout.show = function() {
            if (dialog) {
                ui.run(() => {
                    dialog.show();
                });
            }
        };

        // 隐藏
        layout.hide = function() {
            if (dialog && dialog.isShowing()) {
                ui.run(() => {
                    dialog.hide();
                });
            }
        };

        // 设置宽高
        layout.setSize = function(width, height) {
            ui.run(() => {
                try {
                    if (width === -1) width = WindowManager.LayoutParams.MATCH_PARENT;
                    if (height === -1) height = WindowManager.LayoutParams.MATCH_PARENT;
                    if (width === -2) width = WindowManager.LayoutParams.WRAP_CONTENT;
                    if (height === -2) height = WindowManager.LayoutParams.WRAP_CONTENT;
                    var lp = window.getAttributes();
                    lp.width = width;
                    lp.height = height;
                    window.setAttributes(lp);
                    cacheSize = {
                        width,
                        height
                    }
                } catch (e) {
                    log("setSize error: " + e);
                }
            });
        };

        // 获取宽高
        layout.getSize = function() {
            try {
                var lp = window.getAttributes();
                // 若为 WRAP_CONTENT(-2) 或 MATCH_PARENT(-1)，则尝试强制测量一次
                var width = lp.width;
                var height = lp.height;

                if (width < 0 || height < 0) {
                    return cacheSize
                }

                return {
                    width: width,
                    height: height
                };
            } catch (e) {
                log("getSize error: " + e);
                return {
                    width: 0,
                    height: 0
                };
            }
        };

        // 设置坐标
        layout.setPosition = function(x, y) {
            ui.run(() => {
                var lp = window.getAttributes();
                lp.gravity = Gravity.LEFT | Gravity.TOP;
                lp.x = x;
                lp.y = y;
                window.setAttributes(lp);
            });
        };

        // 获取坐标
        layout.getPosition = function() {
            var lp = window.getAttributes();
            return {
                x: lp.x,
                y: lp.y
            };
        };


        // 居中
        layout.center = function() {
            ui.run(() => {
                var lp = window.getAttributes();
                lp.gravity = Gravity.CENTER | Gravity.CENTER;
                lp.x = 0;
                lp.y = 0;
                window.setAttributes(lp);
            });
        };

        // 内容溢出裁剪
        layout.setOverflowHide = function(enable) {
            ui.run(() => {
                try {
                    layout.__root__.setClipChildren(enable);
                    if (Build.VERSION.SDK_INT >= 21) {
                        layout.__root__.setClipToOutline(enable);
                    }
                } catch (e) {
                    log("设置溢出隐藏失败: " + e);
                }
            });
        };

        // 点击外部关闭
        layout.setCanceledOnTouchOutside = function(enable) {
            layout.setTouchModal(false);
            dialog.setCanceledOnTouchOutside(enable);
        };

        // 返回键关闭（按键穿透）
        layout.setCancelable = function(enable, penetrate) {
            dialog.setCancelable(enable);
            if (penetrate === false) {
                var lp = window.getAttributes();
                lp.flags |= WindowManager.LayoutParams.FLAG_NOT_FOCUSABLE;
                ui.run(() => window.setAttributes(lp));
                isFocus = false;

                var handlingKey = false;
                dialog.setOnKeyListener(new android.content.DialogInterface.OnKeyListener({
                    onKey: function(d, keyCode, event) {
                        if (handlingKey) return true;
                        handlingKey = true;
                        result.unfocus();
                        handlingKey = false;
                        return true;
                    }
                }));
            }
        };
        // 获取dialog对象
        layout.getDialog = function() {
            return dialog
        }

        // 是否可触摸
        layout.setTouchable = function(enable) {
            ui.run(() => {
                var lp = window.getAttributes();
                if (!enable) {
                    lp.flags |= WindowManager.LayoutParams.FLAG_NOT_FOCUSABLE;
                    lp.flags |= WindowManager.LayoutParams.FLAG_NOT_TOUCHABLE;
                    isFocus = false;
                } else {
                    //lp.flags &= ~WindowManager.LayoutParams.FLAG_NOT_FOCUSABLE;
                    lp.flags &= ~WindowManager.LayoutParams.FLAG_NOT_TOUCHABLE;
                    isFocus = true;
                }
                window.setAttributes(lp);
            });
        };

        // 外部穿透
        layout.setTouchModal = function(enable) {
            ui.run(() => {
                var lp = window.getAttributes();
                if (enable) lp.flags |= WindowManager.LayoutParams.FLAG_NOT_TOUCH_MODAL;
                else lp.flags &= ~WindowManager.LayoutParams.FLAG_NOT_TOUCH_MODAL;
                window.setAttributes(lp);
            });
        };

        // 外部遮罩
        layout.setDimBehind = function(enable, amount) {
            ui.run(() => {
                var lp = window.getAttributes();
                if (enable) {
                    window.addFlags(WindowManager.LayoutParams.FLAG_DIM_BEHIND);
                    lp.dimAmount = (amount !== undefined) ? amount : 0.5;
                } else {
                    window.clearFlags(WindowManager.LayoutParams.FLAG_DIM_BEHIND);
                    lp.dimAmount = 0.0;
                }
                window.setAttributes(lp);
            });
        };

        // 聚焦
        layout.focus = function() {
            if (isFocus) return;
            window.clearFlags(WindowManager.LayoutParams.FLAG_NOT_FOCUSABLE);
            isFocus = true;
        };

        // 失焦
        layout.unfocus = function() {
            if (!isFocus) return;
            window.addFlags(WindowManager.LayoutParams.FLAG_NOT_FOCUSABLE);
            isFocus = false;
        };

        // 设置是否允许占满屏幕并突破刘海区域
        layout.setFullScreen = function(enable) {
            ui.run(() => {
                try {
                    var lp = window.getAttributes();
                    if (enable) {
                        var flags = WindowManager.LayoutParams.FLAG_LAYOUT_IN_SCREEN |
                            WindowManager.LayoutParams.FLAG_LAYOUT_NO_LIMITS;
                        window.setFlags(flags, flags);

                        if (Build.VERSION.SDK_INT >= 28) {
                            lp.layoutInDisplayCutoutMode =
                                WindowManager.LayoutParams.LAYOUT_IN_DISPLAY_CUTOUT_MODE_SHORT_EDGES;
                        }

                        if (Build.VERSION.SDK_INT >= 19) { // API 19+
                            var decorView = window.getDecorView();
                            decorView.setSystemUiVisibility(
                                View.SYSTEM_UI_FLAG_LAYOUT_STABLE |
                                View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN |
                                View.SYSTEM_UI_FLAG_LAYOUT_HIDE_NAVIGATION
                            );
                        }
                    } else {
                        window.clearFlags(WindowManager.LayoutParams.FLAG_LAYOUT_NO_LIMITS);
                        lp.layoutInDisplayCutoutMode =
                            WindowManager.LayoutParams.LAYOUT_IN_DISPLAY_CUTOUT_MODE_DEFAULT;

                        if (Build.VERSION.SDK_INT >= 19) {
                            var decorView = window.getDecorView();
                            decorView.setSystemUiVisibility(View.SYSTEM_UI_FLAG_VISIBLE);
                        }
                    }
                    window.setAttributes(lp);
                } catch (e) {
                    log("setFullScreen error: " + e);
                }
            });
        };
        // 监听关闭事件
        var exitListener = () => {
            result.close();
        };
        events.on("exit", exitListener);
        dialog.setOnDismissListener(function() {
            kl.stop();
            events.removeListener("exit", exitListener);
            typeof layout.closed === "function" && layout.closed();
        });

        layout.setDimBehind(true);
        layout.setTouchModal(false);
        layout.setFullScreen(true)
        //layout.show();
        ui.post(() => {
            decor.measure(
                android.view.View.MeasureSpec.makeMeasureSpec(0, android.view.View.MeasureSpec.UNSPECIFIED),
                android.view.View.MeasureSpec.makeMeasureSpec(0, android.view.View.MeasureSpec.UNSPECIFIED)
            );
            var width = decor.getMeasuredWidth();
            var height = decor.getMeasuredHeight();
            cacheSize = {
                width,
                height
            }
        })

        result = layout;
    });

    dialogArr.push(result);
    kl.start();

    return result;
}

module.exports = fullDialogs;