importClass(android.animation.ValueAnimator);
importClass(android.animation.AnimatorSet);
importClass(android.view.animation.AccelerateDecelerateInterpolator);

var utils = require(files.join(files.cwd(), "utils.js"))
var 获取图片 = require(files.join(files.cwd(), "/ui/获取图片.js"));
utils.setDevelopmentSize(1080, 2376)
utils.requestScreenCapture()
utils.屏幕旋转()
toast = require("./ui/showToast.js")
var dialogsFloaty = require("./ui/dialogsFloaty.js")
var baseFile = "/sdcard/图色工具/"
var icons = {
    listShow: "@drawable/ic_keyboard_arrow_down_black_48dp",
    listHide: "@drawable/ic_keyboard_capslock_black_48dp",
    settings: "@drawable/ic_settings_black_48dp",
    exit: "@drawable/ic_clear_black_48dp",
    add: "@drawable/ic_add_black_48dp",
    search: "@drawable/ic_search_black_48dp",
    point: "@drawable/ic_flare_black_48dp",
    img: "@drawable/ic_insert_photo_black_48dp",
    area: "@drawable/ic_crop_free_black_48dp",
    colors: "@drawable/ic_color_lens_black_48dp",
    tint: "#ffffff"
}
// 选择文件
var selectFile = require("./ui/selectFile.js")
var copyCode = require(files.join(files.cwd(), "./js/copyCode.js"))

var storage = storages.create("图色工具")
var config = {
    iconSize: 28,
    statusBarHeight: utils.状态栏高度(),
    width: device.width,
    height: device.height,
    textColor: "#ffffff",
    h: "106",
    unit: "px",
    listVisibility: "visible",
    saveDir: storage.get("saveDir") || "",
}
var items = [];
var listContent = ""
try {
    listContent = files.read(baseFile + config.saveDir + "list").replace(/,$/, "")
    items = JSON.parse("[" + listContent + "]");
} catch (e) {
    if (!files.isDir(files.join(baseFile, config.saveDir))) {
        config.saveDir = ""
    }
    if (config.saveDir && listContent) {
        throw "数据错误"
    } else if (!config.saveDir) {
        toast("先选择项目")
    }
}

var rw = dialogsFloaty(
    <vertical id="root_view">
        <card bg="#008c8c" w={utils.autoScale(540, 320, 960)+"px"} h="auto">
            <vertical>
                <horizontal gravity="center" id="control" w="*" h={utils.autoScale(config.h, 55, 85)+config.unit}>
                    <horizontal layout_weight="1">
                        <img contentPadding={utils.autoScale(10, 8, 14)+"px 0"} w={utils.autoScale(config.iconSize, 28, 52)} id="control_list" src={config.listVisibility == "gone"? icons.listHide : icons.listShow } tint={icons.tint} />
                        <text
                        id="name"
                        w="*"
                        h="*"
                        text={config.saveDir.replace("/","")||"未选择"}
                        textColor="#FFFFFF"
                        gravity="left|center"
                        singleLine="true"
                        ellipsize="end"
                        focusable="true"
                        focusableInTouchMode="true"
                        marqueeRepeatLimit="marquee_forever"
                        selected="true"
                        textSize={utils.autoScale(15, 13, 20)}
                        />
                    </horizontal>
                    <horizontal>
                        <img margin={utils.autoScale(10, 8, 14)+"px 0"} w={utils.autoScale(config.iconSize-4, 24, 48)} id="control_search" src={icons.search} tint={icons.tint} />
                        <img margin={utils.autoScale(10, 8, 14)+"px 0"} w={utils.autoScale(config.iconSize-6, 22, 46)} id="control_settings" src={icons.settings} tint={icons.tint} />
                        <img margin={utils.autoScale(10, 8, 14)+"px 0"} w={utils.autoScale(config.iconSize-2, 26, 50)} id="control_exit" src={icons.exit} tint={icons.tint} />
                    </horizontal>
                </horizontal>
                <vertical id="listVisibility" visibility={config.listVisibility}>
                    <text w="*" h="2px" bg="#999999" />
                    <list h="{{获取列表高度()}}" id="list">
                        <vertical w="*">
                            <horizontal padding={utils.autoScale(20, 16, 28)+"px 0"} h={utils.autoScale(config.h - 1, 50, 85) +config.unit} >
                                <img h="*" gravity="center" contentPadding={utils.autoScale(15, 10, 20)+"px"} w={utils.autoScale(config.iconSize-4, 24, 48)} src="{{icons[type]}}" tint={icons.tint} />
                                
                                <text h="*" gravity="left|center" textColor={config.textColor} textSize={utils.autoScale(15, 13, 20)} text="{{name}}" />
                            </horizontal>
                            <text w="*" h="1px" bg="#999999" />
                        </vertical>
                    </list>
                    <text id="br" visibility={items.length>0?"visible":"gone"} w="*" h="2px" bg="#999999" />
                        <vertical id="move_floor" gravity="center">
                            <horizontal w="auto" h="*" gravity="center" id="move_container">
                                <img id="add_img" h={utils.autoScale(config.h, 55, 85)+config.unit} gravity="center" margin={utils.autoScale(15, 10, 20)+"px 0"} w={utils.autoScale(config.iconSize-4, 24, 48)} src={icons.img} tint={icons.tint} />
                                <img id="add_color" h={utils.autoScale(config.h, 55, 85)+config.unit} gravity="center" margin={utils.autoScale(15, 10, 20)+"px 0"} w={utils.autoScale(config.iconSize-4, 24, 48)} src={icons.colors} tint={icons.tint} />
                                <img id="add_area" h={utils.autoScale(config.h, 55, 85)+config.unit} gravity="center" margin={utils.autoScale(15, 10, 20)+"px 0"} w={utils.autoScale(config.iconSize-4, 24, 48)} src={icons.area} tint={icons.tint} />
                                <img id="add_point" h={utils.autoScale(config.h, 55, 85)+config.unit} gravity="center" margin={utils.autoScale(15, 10, 20)+"px 0"} w={utils.autoScale(config.iconSize-4, 24, 48)} src={icons.point} tint={icons.tint} />
                            </horizontal>
                        </vertical>
                    </vertical>
                </vertical>
            </card>
        </vertical>
)

// 设置悬浮窗特性
rw.setCancelable(false, false)
rw.setDimBehind(false)
rw.setBG("#00000000", 25)
rw.setOverflowHide(true)

var 模板列表 = require("./ui/模板列表.js")
var 图片详情 = require("./ui/图片详情.js")
var 颜色详情 = require("./ui/颜色详情.js")

var {
    selectColor
} = require("./ui/获取颜色.js")
//退出悬浮窗
setTouchClick(rw.control_exit, () => {
    dialogsFloaty.closeAll()
    exit()
})

// 点击设置
setTouchClick(rw.control_settings, () => {
    模板列表.create("设置", [{
            name: "创建项目",
            event: () => {
                utils.弹窗输入框((value) => {
                    config.saveDir = value.replace("/", "") + "/";
                    if (config.saveDir == "/") {
                        toast("名字不符合要求")
                        return
                    }
                    rw.name.attr("text", value)
                    模板列表.close("设置")
                    try {
                        $files.ensureDir(files.join(baseFile, config.saveDir, "images/test.txt"))
                        storage.put("saveDir", config.saveDir)
                        更新项目数据()
                    } catch (e) {
                        alert(e.message)
                    }
                }, {
                    title: "添加项目",
                    inputHint: "项目名"
                })
            }
        },
        {
            name: "选择项目",
            event: () => {
                var arr = files.listDir(baseFile, (e) => {
                    return files.isDir(files.join(baseFile, e))
                })

                function handle(item) {
                    config.saveDir = item.name + "/"
                    rw.name.attr("text", item.name)
                    storage.put("saveDir", config.saveDir)
                    模板列表.close("选择项目")
                    toast("切换为：" + item.name)
                    更新项目数据()
                }
                arr = arr.map(e => {
                    return {
                        name: e,
                        event: handle
                    }
                })
                模板列表.close("设置")
                模板列表.create("选择项目", arr)
            }
        },
        {
            name: "删除项目",
            event: () => {
                var arr = files.listDir(baseFile, (e) => {
                    return files.isDir(files.join(baseFile, e))
                })

                function handle(item, i, viwe, list, callback) {
                    utils.弹窗输入框((value) => {
                        if (value !== "1") return
                        var name = item.name + "/"
                        if (config.saveDir == name) {
                            config.saveDir = ""
                            rw.name.attr("text", "未选择")
                            storage.put("saveDir", null)
                        }
                        files.removeDir(files.join(baseFile, item.name))
                        toast("已删除")
                        // 删除数据
                        arr.splice(i, 1);
                        // 手动通知列表在该位置有一条数据删除
                        list.adapter.notifyItemRemoved(i);
                        更新项目数据()
                        typeof callback == "function" && callback()
                    }, {
                        title: "删除确认",
                        inputHint: "输入1删除, 不可恢复"
                    })

                }
                arr = arr.map(e => {
                    return {
                        name: e,
                        event: handle
                    }
                })
                模板列表.close("设置")
                模板列表.create("删除项目", arr)

            }
        },
        {
            name: "导出图片目录",
            event: () => {
                if (!config.saveDir || config.saveDir == "/") {
                    return toast("请先选择项目")
                }
                selectFile.create((type, path) => {
                    if (type == "confirm") {
                        var dir = files.join(baseFile, config.saveDir, "images")
                        var toDir = files.join(path, "images")
                        files.ensureDir(toDir)
                        var fileArr = files.listDir(dir)
                        fileArr.forEach(file => {
                            files.copy(files.join(dir, file), files.join(toDir, file))
                        })
                        toast("导出" + fileArr.length + "张")
                    }
                }, {
                    file: false
                })
            }
        },
    ])
})

var controlWH = {}

// 控制展开/收起动画
function toggleControl(show) {
    var view = rw
    var targetW, targetH, endAlpha

    if (show) {
        targetW = controlWH.width
        targetH = controlWH.height
        endAlpha = "1"
    } else {
        controlWH.width = view.getWidth()
        controlWH.height = view.getHeight()
        targetW = rw.control_list.getWidth()
        targetH = rw.control_list.getHeight()
        endAlpha = "0.25"
    }

    var widthAnim = ValueAnimator.ofInt(view.getWidth(), targetW)
    widthAnim.addUpdateListener(anim => {
        var lp = view.getLayoutParams()
        lp.width = anim.getAnimatedValue()
        view.setLayoutParams(lp)
    })

    var heightAnim = ValueAnimator.ofInt(view.getHeight(), targetH)
    heightAnim.addUpdateListener(anim => {
        var lp = view.getLayoutParams()
        lp.height = anim.getAnimatedValue()
        view.setLayoutParams(lp)
    })

    var set = new AnimatorSet()
    set.playTogether(widthAnim, heightAnim)
    set.setDuration(200)
    set.setInterpolator(new AccelerateDecelerateInterpolator())
    set.addListener(new android.animation.AnimatorListenerAdapter({
        onAnimationEnd: function() {
            view.attr("alpha", endAlpha)
            controlWH.start = false
            if (show) {
                ui.post(() => {
                    view.attr("w", -2)
                    view.attr("h", -2)
                }, 16)
            }
        }
    }))
    controlWH.start = true
    set.start()
}

//显示/隐藏列表
rw.control_list.on("click", () => {
    if (controlWH.start) return
    if (rw.control_list.attr("src").includes("ic_keyboard_capslock_black_48dp")) {
        rw.control_list.attr("src", icons.listShow)
        //rw.listVisibility.attr("visibility", "visible")
        //rw.listVisibility.attr("h", "auto")
        toggleControl(true)
    } else {
        rw.control_list.attr("src", icons.listHide)
        //rw.listVisibility.attr("visibility", "invisible")
        //rw.listVisibility.attr("h", 0)
        toggleControl(false)
    }
})

// 点击列表
rw.list.on("item_click", function(item, i, itemView, listView) {
    // 悬浮窗隐藏
    rw.hide()
    //图片数据
    if (item.type == "img") {
        var r = 图片详情.create("数据详情", {
            path: files.join(baseFile, config.saveDir, "images", item.name + item.ext),
            rect: item.rect,
            identifyArea: item.identifyArea,
            similarity: item.similarity,
            name: item.name,
            ext: item.ext,
            type: item.type,
            filters: item.filters,
            callback: function(type, data) {
                if (type != "cancel") {
                    图片详情.close("数据详情")
                }
                if (type == "updata" && data.type == "img") {
                    if (files.exists(data.imgPath)) {
                        var path = files.join(baseFile, config.saveDir, "images", data.name + data.ext)
                        files.copy(data.imgPath, path)
                    }
                    delete data["imgPath"]
                    items[i] = data
                    listView.adapter.notifyItemChanged(i);
                    savedData()
                }
                //悬浮窗显示
                rw.show()
            }
        })
    } else if (item.type == "colors") {
        var r = 颜色详情.create("数据详情", {
            identifyArea: item.identifyArea,
            similarity: item.similarity,
            name: item.name,
            type: item.type,
            colors: item.colors,
            filters: item.filters,
            callback: function(type, data) {
                if (type != "cancel") {
                    颜色详情.close("数据详情")
                }
                if (type == "updata" && data.type == "colors") {
                    items[i] = data
                    listView.adapter.notifyItemChanged(i);
                    savedData()
                }
                //悬浮窗显示
                rw.show()
            }
        })
    }
});

// 生成处理
function generateHandle(name, data) {
    var result = copyCode[data.type][name](data)
    模板列表.close("生成")
}

// 长按列表
rw.list.on("item_long_click", function(event, item, i, itemView, listView) {
    event.consumed = true
    var 列表 = [{
            name: "重命名",
            event: function() {
                utils.弹窗输入框(function(value) {
                    if (!value) return
                    var oldName = items[i].name
                    items[i].name = value
                    listView.adapter.notifyItemChanged(i);
                    savedData()
                    if (item.type == "img") {
                        files.renameWithoutExtension(files.join(baseFile, config.saveDir, "images/", oldName + item.ext), value)
                    }
                    模板列表.close(oldName)
                }, {
                    title: "输入新的名字"
                })
            }
        },
        {
            name: "删除",
            event: function() {
                模板列表.close(item.name)
                deleteItem(item)
            }
        }
    ]

    列表.push({
        name: "生成",
        event: function() {
            var arr = Object.keys(copyCode[item.type])
            arr = arr.map(e => {
                return {
                    name: e,
                    event: function(itemEvent) {
                        var data = utils.deepClone(item)
                        if (item.type == "img") {
                            data.imgPath = files.join(baseFile, config.saveDir, "images", item.name + item.ext)
                        }
                        generateHandle(itemEvent.name, data)
                    }
                }
            })
            模板列表.create("生成", arr)
        }
    })
    
    模板列表.create(item.name, 列表)
});

var 屏幕旋转 = utils.生成屏幕旋转(rw, storage.get("w"), storage.get("h"), function(dx, dy, w, h) {
    storage.put("dx", dx)
    storage.put("dy", dy)
    storage.put("w", w)
    storage.put("h", h)
})

events.on("屏幕旋转", (d) => {
    屏幕旋转()
})

function 更新项目数据() {
    try {
        len = items.length
        items.splice(0, len)
        rw.list.adapter.notifyItemRangeRemoved(0, len);
        Array.prototype.push.apply(items, JSON.parse("[" + (files.read(baseFile + config.saveDir + "list").replace(/,$/, "") + "]")))
        rw.list.adapter.notifyItemRangeInserted(0, items.length);
        更新列表高度()
    } catch (e) {
        len = items.length
        items.splice(0, len)
        rw.list.adapter.notifyItemRangeRemoved(0, len);
        更新列表高度()
    }
}

var x = storage.get("dx") || 0
var y = storage.get("dy") || 0

// 悬浮窗拖拽
var 悬浮窗拖拽 = utils.生成悬浮窗拖拽(x, y, function(type, dx, dy) {
    if (type == "up" && dx && dy) {
        storage.put("dx", dx)
        storage.put("dy", dy)
    }
})

var firstTouchView = null

// 双击显示名字
var clickNameTime = 0
rw.name.setOnTouchListener(function(view, ev) {
    if (ev.getAction() === MotionEvent.ACTION_DOWN) {
        firstTouchView = view
    } else if (ev.getAction() === MotionEvent.ACTION_UP) {
        if (Date.now() - clickNameTime < 300) {
            toast(rw.name.attr("text"))
            clickNameTime = 0
        }
        clickNameTime = Date.now()
        firstTouchView = null
    }
    return false;
})

// 悬浮窗顶部拖拽
rw.control.setOnTouchListener(function(view, event) {
    if (firstTouchView && firstTouchView != view) {
        firstTouchView.dispatchTouchEvent(event)
    }
    return 悬浮窗拖拽(rw, event)
});
// 悬浮窗底部拖拽
rw.move_floor.setOnTouchListener(function(view, event) {
    if (firstTouchView && firstTouchView != view) {
        firstTouchView.dispatchTouchEvent(event)
    }
    return 悬浮窗拖拽(rw, event)
});
// 搜索
setTouchClick(rw.control_search, () => {
    toast("未实现")
})

function 获取列表高度() {
    var len = items.length
    if (len >= 5) len = 5;
    return len * utils.autoScale(config.h - 4, 50, 85) + config.unit
}

function 更新列表高度() {
    rw.list.attr("h", 获取列表高度())
    if (items.length) {
        rw.br.attr("visibility", "visible")
    } else {
        rw.br.attr("visibility", "gone")
    }
}

//截图图片处理
function handleImg(type, obj) {
    switch (type) {
        case 'add':
            files.append(baseFile + config.saveDir + "list", JSON.stringify(obj) + ",")
            var len = items.length
            items.push(obj)
            rw.list.adapter.notifyItemRangeInserted(len, len + 1);
            更新列表高度()
            break;
        case 'update':
            break;
        default:
            // code
    }
}

//取色处理
function handleColors(type, obj) {
    switch (type) {
        case 'add':
            files.append(baseFile + config.saveDir + "list", JSON.stringify(obj) + ",")
            var len = items.length
            items.push(obj)
            rw.list.adapter.notifyItemRangeInserted(len, len + 1);
            更新列表高度()
            break;
        case 'update':
            break;
        default:
            // code
    }
}

function 设置区域(rw) {
    var screenSize = utils.getScreenSize();
    var img_select_config = {
        direction: utils.屏幕方向() == "v" ? 1 : 0,
        width: screenSize.width,
        height: screenSize.height,
        type: "area",
        rect: [],
        callback: function(data) {
            try {
                //悬浮窗显示
                rw.show()
                if (data) {
                    setClip(JSON.stringify(data.rect))
                    toast("已复制区域")
                }
            } catch (e) {}
        }
    }
    //悬浮窗隐藏
    rw.hide()
    setTimeout(() => {
        获取图片.selectImg(img_select_config)
    }, 250)
}
// 添加处理函数
var addFun = {
    img() {
        if (!config.saveDir || config.saveDir == "/") {
            return toast("请先选择项目")
        }
        模板列表.close("添加数据")
        //悬浮窗隐藏
        rw.hide()
        图片详情.create("数据详情", {
            type: "img",
            callback: function(type, data) {
                if (type != "cancel") {
                    图片详情.close("数据详情")
                }
                if (type == "create" && data.type == "img") {
                    if (files.exists(data.imgPath)) {
                        var path = files.join(baseFile, config.saveDir, "images", data.name + data.ext)
                        files.copy(data.imgPath, path)
                        delete data["imgPath"]
                        handleImg("add", data)
                        rw.list.smoothScrollToPosition(items.length - 1);
                    }
                }
                //悬浮窗显示
                rw.show()
            }
        })
    },
    color() {
        if (!config.saveDir || config.saveDir == "/") {
            return toast("请先选择项目")
        }
        模板列表.close("添加数据")
        //悬浮窗隐藏
        rw.hide()
        颜色详情.create("数据详情", {
            type: "colors",
            callback: function(type, data) {
                if (type != "cancel") {
                    颜色详情.close("数据详情")
                }
                if (type == "create" && data.type == "colors") {
                    handleColors("add", data)
                    rw.list.smoothScrollToPosition(items.length - 1);
                }
                //悬浮窗显示
                rw.show()
            }
        })
    },
    area() {
        if (!config.saveDir || config.saveDir == "/") {
            return toast("请先选择项目")
        }
        设置区域(rw)
    },
    point() {
        if (!config.saveDir || config.saveDir == "/") {
            return toast("请先选择项目")
        }
        toast("未实现")
    }
}
// 添加列表数据
var addItem = () => {
    if (!config.saveDir || config.saveDir == "/") {
        return toast("请先选择项目")
    }
    模板列表.create("添加数据", [{
        name: "取图",
        event: addFun.img
    }, {
        name: "取色",
        event: addFun.color
    }, {
        name: "坐标",
        event: addFun.area
    }, {
        name: "区域",
        event: addFun.point
    }, ])
}
//rw.move_container.on("click", addItem)

// 设置父拖拽子点击事件
function setTouchClick(view, onClick) {
    var touchX, touchY;
    var moved = false;

    view.setOnTouchListener(function(v, ev) {
        switch (ev.getAction()) {
            case MotionEvent.ACTION_DOWN:
                touchX = ev.getX();
                touchY = ev.getY();
                moved = false;
                firstTouchView = view;
                break;

            case MotionEvent.ACTION_MOVE:
                if (moved) break;
                if (Math.abs(ev.getX() - touchX) > 10 || Math.abs(ev.getY() - touchY) > 10) {
                    moved = true;
                }
                break;

            case MotionEvent.ACTION_UP:
                if (!moved && typeof onClick === "function") {
                    onClick(v);
                }
                firstTouchView = null;
                break;
        }
        return false; // 不阻止父容器事件
    });
}
setTouchClick(rw.add_img, addFun.img)
setTouchClick(rw.add_color, addFun.color)
setTouchClick(rw.add_area, addFun.area)
setTouchClick(rw.add_point, addFun.point)

//删除item
function deleteItem(target) {
    var index = items.findIndex(e => {
        return e.name == target.name
    })
    if (index != -1) {
        items.splice(index, 1);
        rw.list.adapter.notifyItemRangeRemoved(index, 1);
        更新列表高度()
        savedData()
        if (target.type == "img") {
            files.remove(files.join(baseFile, config.saveDir, "images/", target.name + target.ext))
        }
    }
}



//保存数据列表
function savedData() {
    var txt = JSON.stringify(items)
    txt = txt.substr(1, txt.length - 2)
    if (txt) {
        txt += ","
    }
    files.write(baseFile + config.saveDir + "list", txt)
}

// 设置列表数据
ui.post(() => {
    rw.list.setDataSource(items, false);
}, 16)
ui.run(() => {
    //复位显示
    屏幕旋转(true)
})
ui.post(() => {
    rw.show()
}, 16)